/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder;

import android.content.DialogInterface;
import android.view.View;
import android.widget.TextView;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.holder.chat.SimpleChatHolder;
import com.gensee.fastsdk.ui.portrait.PublishActivity;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.room.RTRoom;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;

public class UserOperateHolder
extends BaseHolder {
    private TextView tv_user_name;
    private TextView tv_user_chat;
    private View tv_user_eject;
    private View user_blank_area;
    private View tv_cancel_btm_view;
    private UserInfo selectUserInfo;
    private SimpleChatHolder simpleChatHolder;
    private View tv_user_chat_line;

    public UserOperateHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {
    }

    public void selectUser(UserInfo userInfo) {
        if (null == userInfo) {
            return;
        }
        this.tv_user_name.setText((CharSequence)GenseeUtils.formatText(userInfo.getName(), 12));
        this.selectUserInfo = userInfo;
        if (userInfo.IsPresentor() || userInfo.IsPanelist()) {
            this.tv_user_chat.setVisibility(8);
            this.tv_user_chat_line.setVisibility(8);
        } else {
            this.tv_user_chat.setVisibility(0);
            this.tv_user_chat_line.setVisibility(0);
        }
        if (this.selectUserInfo.IsChatMute()) {
            this.tv_user_chat.setText((CharSequence)this.getContext().getResources().getString(ResManager.getStringId("gs_user_enable_chat")));
        } else {
            this.tv_user_chat.setText((CharSequence)this.getContext().getResources().getString(ResManager.getStringId("gs_user_disable_chat")));
        }
        this.show(true);
    }

    @Override
    protected void initComp(Object value) {
        this.tv_user_name = (TextView)this.findViewById(ResManager.getId("gs_tv_user_name"));
        this.tv_user_chat = (TextView)this.findViewById(ResManager.getId("gs_tv_user_chat"));
        this.tv_user_chat_line = this.findViewById(ResManager.getId("gs_tv_user_chat_line"));
        this.tv_user_chat.setOnClickListener((View.OnClickListener)this);
        this.tv_user_eject = this.findViewById(ResManager.getId("gs_tv_user_eject"));
        this.tv_user_eject.setOnClickListener((View.OnClickListener)this);
        this.user_blank_area = this.findViewById(ResManager.getId("gs_user_blank_area"));
        this.user_blank_area.setOnClickListener((View.OnClickListener)this);
        this.tv_cancel_btm_view = this.findViewById(ResManager.getId("gs_tv_cancel_btm_view"));
        this.tv_cancel_btm_view.setOnClickListener((View.OnClickListener)this);
    }

    public void onClick(View v) {
        this.simpleChatHolder = ((PublishActivity)this.getContext()).getSimpleChatHolder();
        if (v.getId() == ResManager.getId("gs_tv_user_chat")) {
            if (this.selectUserInfo.IsChatMute()) {
                this.chatControl(true);
            } else {
                ((PublishActivity)this.getContext()).showDialog("", this.getString(ResManager.getStringId("gs_disable_somebody_chat")), this.getString(ResManager.getStringId("gs_cancel")), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        dialog.dismiss();
                    }
                }, this.getString(ResManager.getStringId("gs_sure_1")), new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int i) {
                        dialog.dismiss();
                        UserOperateHolder.this.chatControl(false);
                    }
                }, null);
            }
            this.show(false);
        } else if (v.getId() == ResManager.getId("gs_tv_user_eject")) {
            ((PublishActivity)this.getContext()).showDialog("", this.getString(ResManager.getStringId("gs_remove_somebody")), this.getString(ResManager.getStringId("gs_cancel")), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i) {
                    dialog.dismiss();
                }
            }, this.getString(ResManager.getStringId("gs_sure_1")), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int i) {
                    dialog.dismiss();
                    UserOperateHolder.this.ejectControl();
                }
            }, null);
            this.show(false);
        } else if (v.getId() == ResManager.getId("gs_user_blank_area") || v.getId() == ResManager.getId("gs_tv_cancel_btm_view")) {
            this.show(false);
        }
    }

    private void ejectControl() {
        RTLive.getIns().getRtSdk().roomEjectUser(this.selectUserInfo.getId(), false, new OnTaskRet(){

            public void onTaskRet(boolean b, int i, String s) {
                if (b && null != UserOperateHolder.this.simpleChatHolder) {
                    String msg = GenseeUtils.formatText(UserOperateHolder.this.selectUserInfo.getName(), 12) + UserOperateHolder.this.getString(ResManager.getStringId("gs_chat_is_kicked_out"));
                    RTLive.getIns().getRtSdk().roomNotifyBroadcastMsg(msg, true, null);
                }
            }
        });
    }

    private void chatControl(boolean flag) {
        RTRoom.getIns().getRoutine().chatEnable(this.selectUserInfo.getId(), flag, new OnTaskRet(){

            public void onTaskRet(boolean b, int i, String s) {
                if (b && null != UserOperateHolder.this.simpleChatHolder) {
                    String msg = "";
                    msg = UserOperateHolder.this.selectUserInfo.IsChatMute() ? GenseeUtils.formatText(UserOperateHolder.this.selectUserInfo.getName(), 12) + UserOperateHolder.this.getString(ResManager.getStringId("gs_chat_is_alowed_to_chat")) : GenseeUtils.formatText(UserOperateHolder.this.selectUserInfo.getName(), 12) + UserOperateHolder.this.getString(ResManager.getStringId("gs_chat_is_disable_to_chat"));
                    RTLive.getIns().getRtSdk().roomNotifyBroadcastMsg(msg, true, null);
                }
            }
        });
    }
}

