/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.card;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.holder.card.impl.CardImpl;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;
import com.gensee.view.VoteProgressBar;
import com.gensee.vote.VotePlayerAnswer;
import com.gensee.vote.VotePlayerGroup;
import com.gensee.vote.VotePlayerQuestion;
import java.util.ArrayList;
import java.util.List;

public class CardHolder
extends BaseHolder
implements CardImpl.OnCardHolderListener {
    private static final String TAG = "CardHolder";
    private CardImpl cardImpl;
    private TextView tvCardExpand;
    private ImageView ivClose;
    private ImageView ivSojin;
    private LinearLayout lyCardPublish;
    private LinearLayout lyCardPublishOption;
    private Button btnCardCommit;
    private LinearLayout lyCardResult;
    private TextView tvCardResultTeach;
    private ImageView ivCardResultTeach;
    private LinearLayout lyCardResultTeach;
    private TextView tvCardResultMy;
    private ImageView ivCardResultMy;
    private TextView tvCardAllSubmitted;
    private LinearLayout lyCardResultOptions;
    private ImageView ivCardResultCount;
    private TextView tvCardResultTip;
    private LinearLayout lyCareResultTip;
    private List<Integer> selectItemList;
    private boolean bHaveCommited = false;
    private VotePlayerGroup votePlayerGroup;
    private boolean isSingleType;

    public CardHolder(View rootView, Object value) {
        super(rootView, value);
        this.cardImpl = (CardImpl)value;
        this.cardImpl.setOnCardHolderListener(this);
        this.selectItemList = new ArrayList<Integer>();
    }

    public void setTvCardExpand(TextView tvCardExpand) {
        this.tvCardExpand = tvCardExpand;
        if (null != this.tvCardExpand) {
            this.tvCardExpand.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CardHolder.this.tvCardExpand.setVisibility(8);
                    CardHolder.this.rootView.setVisibility(0);
                }
            });
        }
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("card_publish_commit_btn")) {
            this.commit();
        } else if (v.getId() == ResManager.getId("card_page_close_iv")) {
            this.close();
        } else if (v.getId() == ResManager.getId("card_page_suojin_iv")) {
            this.sojin();
        }
    }

    private void sojin() {
        if (null != this.tvCardExpand) {
            this.tvCardExpand.setVisibility(0);
        }
        this.close();
    }

    private void close() {
        if (this.rootView.getVisibility() != 8) {
            this.rootView.setVisibility(8);
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.ivClose = (ImageView)this.findViewById(ResManager.getId("card_page_close_iv"));
        this.ivClose.setOnClickListener((View.OnClickListener)this);
        this.ivSojin = (ImageView)this.findViewById(ResManager.getId("card_page_suojin_iv"));
        this.ivSojin.setOnClickListener((View.OnClickListener)this);
        this.lyCardPublish = (LinearLayout)this.findViewById(ResManager.getId("card_publish_ly"));
        this.lyCardPublishOption = (LinearLayout)this.findViewById(ResManager.getId("card_publish_option_ly"));
        this.btnCardCommit = (Button)this.findViewById(ResManager.getId("card_publish_commit_btn"));
        this.btnCardCommit.setOnClickListener((View.OnClickListener)this);
        this.lyCardResult = (LinearLayout)this.findViewById(ResManager.getId("card_result_publish_ly"));
        this.lyCardResultOptions = (LinearLayout)this.findViewById(ResManager.getId("card_result_publish_options_ly"));
        this.tvCardResultTeach = (TextView)this.findViewById(ResManager.getId("card_result_publish_teach_tv"));
        this.ivCardResultTeach = (ImageView)this.findViewById(ResManager.getId("card_result_publish_teach_iv"));
        this.lyCardResultTeach = (LinearLayout)this.findViewById(ResManager.getId("card_result_publish_teach_ly"));
        this.tvCardResultMy = (TextView)this.findViewById(ResManager.getId("card_result_publish_my_tv"));
        this.ivCardResultMy = (ImageView)this.findViewById(ResManager.getId("card_result_publish_my_iv"));
        this.tvCardAllSubmitted = (TextView)this.findViewById(ResManager.getId("card_result_publish_total_tv"));
        this.ivCardResultCount = (ImageView)this.findViewById(ResManager.getId("card_result_publish_bottom_iv"));
        this.tvCardResultTip = (TextView)this.findViewById(ResManager.getId("card_result_publish_bottom_tv"));
        this.lyCareResultTip = (LinearLayout)this.findViewById(ResManager.getId("card_result_publish_bottom_tip_ly"));
    }

    private void commit() {
        List answerList = ((VotePlayerQuestion)this.votePlayerGroup.getM_questions().get(0)).getM_answers();
        for (int j = 0; j < answerList.size(); ++j) {
            boolean isChoosed = false;
            for (int k = 0; k < this.selectItemList.size(); ++k) {
                if (this.selectItemList.get(k) != j + 1) continue;
                isChoosed = true;
                break;
            }
            ((VotePlayerAnswer)answerList.get(j)).setM_bChoose(isChoosed);
        }
        this.bHaveCommited = true;
        PlayerLive.getIns().voteSubmit(this.votePlayerGroup);
        this.close();
    }

    private void cardOptionsSelect(int itemId) {
        int nCount = this.lyCardPublishOption.getChildCount();
        if (this.isSingleType) {
            this.selectItemList.clear();
            this.selectItemList.add(itemId);
        } else if (this.selectItemList.contains(itemId)) {
            this.selectItemList.remove((Object)itemId);
        } else {
            this.selectItemList.add(itemId);
        }
        for (int i = 0; i < nCount; ++i) {
            TextView tv = (TextView)this.lyCardPublishOption.getChildAt(i);
            if (this.selectItemList.contains(tv.getTag())) {
                tv.setSelected(true);
                continue;
            }
            tv.setSelected(false);
        }
        this.checkCommitStatus();
    }

    private void cardEnd() {
        this.close();
        if (null != this.tvCardExpand) {
            this.tvCardExpand.setVisibility(8);
        }
    }

    private void checkCommitStatus() {
        if (this.selectItemList.isEmpty()) {
            this.btnCardCommit.getBackground().setAlpha(100);
            this.btnCardCommit.setEnabled(false);
        } else {
            this.btnCardCommit.getBackground().setAlpha(255);
            this.btnCardCommit.setEnabled(true);
        }
    }

    private void cardPublish(VotePlayerGroup votePlayerGroup) {
        this.votePlayerGroup = votePlayerGroup;
        this.isSingleType = ((VotePlayerQuestion)votePlayerGroup.getM_questions().get(0)).getM_strType() == "single";
        int nSize = ((VotePlayerQuestion)votePlayerGroup.getM_questions().get(0)).getM_answers().size();
        GenseeLog.i((String)("cardPublish isSingleType:" + this.isSingleType + ",nSize:" + nSize));
        List answerList = ((VotePlayerQuestion)votePlayerGroup.getM_questions().get(0)).getM_answers();
        int[] itemIds = new int[answerList.size()];
        for (int i = 0; i < answerList.size(); ++i) {
            itemIds[i] = i + 1;
        }
        this.bHaveCommited = false;
        this.selectItemList.clear();
        this.checkCommitStatus();
        if (this.rootView.getVisibility() != 0) {
            this.rootView.setVisibility(0);
        }
        this.lyCardPublish.setVisibility(0);
        this.lyCardResult.setVisibility(8);
        this.ivClose.setVisibility(8);
        this.ivSojin.setVisibility(0);
        this.lyCardPublishOption.removeAllViews();
        if (this.isSingleType && nSize == 2) {
            View view = LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("card_single_judgment_layout"), null);
            final TextView tvSuccess = (TextView)view.findViewById(ResManager.getId("card_judgment_sure_tv"));
            final TextView tvError = (TextView)view.findViewById(ResManager.getId("card_judgment_error_tv"));
            final int itemId = itemIds[0];
            final int itemId1 = itemIds[1];
            tvSuccess.setTag((Object)itemId);
            tvError.setTag((Object)itemId1);
            tvSuccess.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    tvSuccess.setSelected(!tvSuccess.isSelected());
                    tvError.setSelected(false);
                    CardHolder.this.selectItemList.clear();
                    CardHolder.this.selectItemList.add(itemId);
                    CardHolder.this.checkCommitStatus();
                }
            });
            tvError.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CardHolder.this.selectItemList.clear();
                    CardHolder.this.selectItemList.add(itemId1);
                    tvError.setSelected(!tvError.isSelected());
                    tvSuccess.setSelected(false);
                    CardHolder.this.checkCommitStatus();
                }
            });
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
            this.lyCardPublishOption.addView(view, (ViewGroup.LayoutParams)lp);
        } else {
            int nValue = 65;
            int i = 0;
            for (final int itemId : itemIds) {
                TextView tv = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("card_publish_tv"), null);
                tv.setBackgroundResource(this.isSingleType ? ResManager.getDrawableId("selector_card_single_iv") : ResManager.getDrawableId("selector_card_multi_iv"));
                tv.setTag((Object)itemId);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
                tv.setText((CharSequence)((char)(nValue + i) + ""));
                if (i > 0) {
                    lp.leftMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("card_page_publish_option_item"));
                }
                this.lyCardPublishOption.addView((View)tv, (ViewGroup.LayoutParams)lp);
                tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        CardHolder.this.cardOptionsSelect(itemId);
                    }
                });
                ++i;
            }
        }
    }

    @Override
    public void onCardPublish(final VotePlayerGroup votePlayerGroup) {
        this.post(new Runnable(){

            @Override
            public void run() {
                CardHolder.this.cardPublish(votePlayerGroup);
            }
        });
    }

    @Override
    public void onCardEnd() {
        this.post(new Runnable(){

            @Override
            public void run() {
                CardHolder.this.cardEnd();
            }
        });
    }

    @Override
    public void onCardResultPublish(final VotePlayerGroup votePlayerGroup) {
        this.post(new Runnable(){

            @Override
            public void run() {
                CardHolder.this.cardResultPublish(votePlayerGroup);
            }
        });
    }

    private void cardResultPublish(VotePlayerGroup votePlayerGroup) {
        boolean bMyHaveResult;
        int i;
        this.votePlayerGroup = votePlayerGroup;
        boolean isSingle = ((VotePlayerQuestion)votePlayerGroup.getM_questions().get(0)).getM_strType() == "single";
        int totalSubmitted = ((VotePlayerQuestion)votePlayerGroup.getM_questions().get(0)).getTotal();
        int answerSize = ((VotePlayerQuestion)votePlayerGroup.getM_questions().get(0)).getM_answers().size();
        int[] itemSubmitted = new int[answerSize];
        int[] itemOptions = new int[answerSize];
        for (i = 0; i < answerSize; ++i) {
            List answerList = ((VotePlayerQuestion)votePlayerGroup.getM_questions().get(0)).getM_answers();
            itemSubmitted[i] = ((VotePlayerAnswer)answerList.get(i)).getTotal();
            itemOptions[i] = ((VotePlayerAnswer)answerList.get(i)).isM_bCorrect() ? 1 : 0;
        }
        GenseeLog.i((String)TAG, (String)("isSingle:" + isSingle + ",totalSubmitted:" + totalSubmitted + ",selectItemList:" + this.selectItemList));
        for (i = 0; i < itemSubmitted.length; ++i) {
            GenseeLog.i((String)TAG, (String)("itemSubmitted[" + i + "]:" + itemSubmitted[i]));
        }
        for (i = 0; i < itemOptions.length; ++i) {
            GenseeLog.i((String)TAG, (String)("itemOptions[" + i + "]:" + itemOptions[i]));
        }
        if (!this.bHaveCommited) {
            this.selectItemList.clear();
        }
        if (this.rootView.getVisibility() != 0) {
            this.rootView.setVisibility(0);
        }
        this.lyCardPublish.setVisibility(8);
        this.lyCardResult.setVisibility(0);
        this.ivClose.setVisibility(0);
        this.ivSojin.setVisibility(8);
        if (null != this.tvCardExpand) {
            this.tvCardExpand.setVisibility(8);
        }
        int nOptionsSize = itemOptions.length;
        int nValue = 65;
        this.tvCardAllSubmitted.setText((CharSequence)String.format(this.getString(ResManager.getStringId("card_attent_count")), totalSubmitted));
        boolean bl = bMyHaveResult = this.selectItemList.size() > 0;
        if (bMyHaveResult) {
            this.tvCardResultMy.setVisibility(0);
            if (isSingle && nOptionsSize <= 2) {
                this.ivCardResultMy.setVisibility(0);
                this.tvCardResultMy.setText((CharSequence)(this.getString(ResManager.getStringId("card_result_publish_my")) + " "));
                this.ivCardResultMy.setSelected(this.selectItemList.get(0) == 1);
            } else {
                this.ivCardResultMy.setVisibility(8);
                String mySuccess = "";
                Object object = this.selectItemList.iterator();
                while (object.hasNext()) {
                    int id = (Integer)object.next();
                    mySuccess = mySuccess + (char)(nValue + id - 1);
                }
                this.tvCardResultMy.setText((CharSequence)(this.getString(ResManager.getStringId("card_result_publish_my")) + " " + mySuccess));
            }
        } else {
            this.tvCardResultMy.setVisibility(8);
            this.ivCardResultMy.setVisibility(8);
        }
        boolean bTeachHaveSuccess = false;
        for (int item : itemOptions) {
            if (item <= 0) continue;
            bTeachHaveSuccess = true;
            break;
        }
        if (bTeachHaveSuccess) {
            this.lyCardResultTeach.setVisibility(0);
            this.tvCardResultTeach.setVisibility(0);
            if (isSingle && nOptionsSize <= 2) {
                this.ivCardResultTeach.setVisibility(0);
                this.tvCardResultTeach.setText((CharSequence)(this.getString(ResManager.getStringId("card_result_publish_teach")) + " "));
                if (itemOptions[0] > 0) {
                    this.ivCardResultTeach.setSelected(true);
                }
                if (itemOptions[1] > 0) {
                    this.ivCardResultTeach.setSelected(false);
                }
            } else {
                this.ivCardResultTeach.setVisibility(8);
                String teachSuccess = "";
                for (int i2 = 0; i2 < nOptionsSize; ++i2) {
                    if (itemOptions[i2] <= 0) continue;
                    teachSuccess = teachSuccess + (char)(nValue + i2);
                }
                this.tvCardResultTeach.setText((CharSequence)(this.getString(ResManager.getStringId("card_result_publish_teach")) + " " + teachSuccess));
            }
        } else {
            this.lyCardResultTeach.setVisibility(8);
            this.tvCardResultTeach.setVisibility(8);
            this.ivCardResultTeach.setVisibility(8);
        }
        this.lyCareResultTip.setVisibility(bTeachHaveSuccess && this.selectItemList.size() > 0 ? 0 : 8);
        if (bTeachHaveSuccess && this.selectItemList.size() > 0) {
            int nSelectSize = this.selectItemList.size();
            boolean bTrue = true;
            if (nSelectSize <= 0) {
                bTrue = false;
            } else {
                for (int selectId : this.selectItemList) {
                    if (itemOptions[selectId - 1] >= 1) continue;
                    bTrue = false;
                    break;
                }
                if (bTrue) {
                    for (int i3 = 0; i3 < nOptionsSize; ++i3) {
                        if (itemOptions[i3] <= 0 || this.selectItemList.contains(i3 + 1)) continue;
                        bTrue = false;
                        break;
                    }
                }
            }
            this.ivCardResultCount.setSelected(bTrue);
            this.tvCardResultTip.setText((CharSequence)(bTrue ? this.getString(ResManager.getStringId("card_result_success")) : this.getString(ResManager.getStringId("vote_count_failure"))));
            this.tvCardResultTip.setTextColor(bTrue ? this.getContext().getResources().getColor(ResManager.getColorId("card_page_result_success")) : this.getContext().getResources().getColor(ResManager.getColorId("card_page_result_failure")));
        }
        this.lyCardResultOptions.removeAllViews();
        for (int i4 = 0; i4 < nOptionsSize; ++i4) {
            View view = LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("card_result_publish_item_layout"), null);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
            if (i4 > 0) {
                lp.topMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("card_page_result_publish_item_top"));
            }
            this.lyCardResultOptions.addView(view, (ViewGroup.LayoutParams)lp);
            ImageView ivSuccess = (ImageView)view.findViewById(ResManager.getId("card_result_success_iv"));
            if (bTeachHaveSuccess) {
                ivSuccess.setVisibility(itemOptions[i4] > 0 ? 0 : 4);
            } else {
                ivSuccess.setVisibility(8);
            }
            TextView tvOptions = (TextView)view.findViewById(ResManager.getId("card_result_options_tv"));
            ImageView ivOptions = (ImageView)view.findViewById(ResManager.getId("card_result_options_iv"));
            if (isSingle && nOptionsSize <= 2) {
                ivOptions.setVisibility(0);
                tvOptions.setVisibility(8);
                ivOptions.setSelected(i4 < 1);
            } else {
                ivOptions.setVisibility(8);
                tvOptions.setVisibility(0);
                tvOptions.setText((CharSequence)((char)(nValue + i4) + ""));
            }
            VoteProgressBar pbOptions = (VoteProgressBar)view.findViewById(ResManager.getId("card_result_pb"));
            int nMax = totalSubmitted;
            if (nMax <= 0) {
                nMax = 100;
            }
            pbOptions.setMax(nMax);
            pbOptions.setProgress(itemSubmitted[i4]);
            TextView tvOptionCount = (TextView)view.findViewById(ResManager.getId("card_result_count_tv"));
            int nPersent = 0;
            nPersent = totalSubmitted <= 0 ? 0 : itemSubmitted[i4] * 100 / totalSubmitted;
            tvOptionCount.setText((CharSequence)(itemSubmitted[i4] + " (" + nPersent + "%)"));
        }
    }
}

