/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.Html;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.InputBottomHolder;
import com.gensee.fastsdk.ui.holder.chat.ChatHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.routine.UserInfo;
import com.gensee.utils.ThreadPool;
import com.gensee.view.MyTextViewEx;
import java.util.ArrayList;
import java.util.List;

public class PrivateChatHolder
extends ChatHolder
implements InputBottomHolder.OnPrivateChatBottomListener,
MsgQueue.OnPrivateChatHolderListener,
PlayerLive.OnUserJoinLeaveListener,
AdapterView.OnItemLongClickListener,
View.OnTouchListener {
    private UserInfo toUser;
    private TextView tvTitle;
    private ImageView ivClose;
    private LinearLayout lyToChat;
    private InputBottomHolder mInputBottomHolder;
    private int nowRawX;
    private int nowRawY;

    public void setInputBottomHolder(InputBottomHolder mInputBottomHolder) {
        this.mInputBottomHolder = mInputBottomHolder;
        if (null != this.mInputBottomHolder) {
            this.mInputBottomHolder.setOnPrivateChatBottomListener(this);
        }
    }

    public PrivateChatHolder(View rootView, Object value) {
        super(rootView, value);
        MsgQueue.getIns().setOnPrivateChatHolderListener((MsgQueue.OnPrivateChatHolderListener)this);
    }

    @Override
    public void onMessage(int what, Object obj, Bundle bundle) {
        long ownerId = bundle.getLong("OWNERID");
        if (null == this.toUser || ownerId == -1L || this.toUser.getId() != ownerId) {
            return;
        }
        super.onMessage(what, obj, bundle);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("private_chat_close")) {
            this.close();
        }
    }

    private void close() {
        if (null != this.mInputBottomHolder) {
            this.mInputBottomHolder.setCurSelectIndex(0);
            if (null != this.chatImpl) {
                this.mInputBottomHolder.onChatMode(this.chatImpl.getChatMode());
            }
        }
        if (null != this.lyToChat) {
            this.lyToChat.setVisibility(8);
        }
        MsgQueue.getIns().resetToUserList();
        PlayerLive.getIns().setOnUserLeaveListener(null);
        this.toUser = null;
        this.mInputBottomHolder.showChatEdt();
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.adapter = new PrivateChatAdapter();
        this.lvChat.setAdapter((ListAdapter)this.adapter);
        this.lvChat.setOnItemLongClickListener(this);
        this.lvChat.setOnTouchListener(this);
        this.tvTitle = (TextView)this.findViewById(ResManager.getId("private_chat_to_title_tv"));
        this.ivClose = (ImageView)this.findViewById(ResManager.getId("private_chat_close"));
        this.ivClose.setOnClickListener((View.OnClickListener)this);
        this.lyToChat = (LinearLayout)this.findViewById(ResManager.getId("private_chat_ly"));
        this.lyToChat.setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("private_chat_bg")));
        this.findViewById(ResManager.getId("private_chat_line")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("private_chat_title_sep")));
    }

    public void setToUser(UserInfo userInfo) {
        if (null == userInfo) {
            return;
        }
        if (null != this.mInputBottomHolder) {
            this.mInputBottomHolder.setCurSelectIndex(1);
            if (null != this.chatImpl) {
                this.mInputBottomHolder.onChatMode(this.chatImpl.getChatMode());
            }
        }
        PlayerLive.getIns().setOnUserLeaveListener(this);
        this.toUser = userInfo;
        this.lyToChat.setVisibility(0);
        if (null != this.tvTitle && null != this.toUser) {
            this.onlineTitle();
        }
        this.notifyData(new ArrayList<AbsChatMessage>());
        this.setLvBottom(true);
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                UserInfo self = PlayerLive.getIns().getSelf();
                if (null != self && null != PrivateChatHolder.this.toUser) {
                    MsgQueue.getIns().getPrivateLatestMsg(self.getId(), PrivateChatHolder.this.toUser.getId());
                }
            }
        });
    }

    @Override
    public void sendPrivateMsg(String text, String rich) {
        if (null != this.chatImpl && null != this.toUser) {
            this.chatImpl.sendPrivateMsg(text, rich, this.toUser);
        }
        if (!this.getLvBottom() || !MsgQueue.getIns().isPrivateLatest()) {
            this.setLvBottom(true);
            final UserInfo self = PlayerLive.getIns().getSelf();
            if (null != self && null != this.toUser) {
                ThreadPool.getInstance().execute(new Runnable(){

                    @Override
                    public void run() {
                        MsgQueue.getIns().getPrivateLatestMsg(self.getId(), PrivateChatHolder.this.toUser.getId());
                    }
                });
            }
        }
    }

    @Override
    public boolean isLvBottom() {
        return this.getLvBottom();
    }

    public void refreshMsg(List<AbsChatMessage> msgList, boolean bLatest, long ownerId) {
        this.refreshMsg(30000, msgList, bLatest, ownerId);
    }

    public void onPullMsg(List<AbsChatMessage> msgList, boolean bLatest, long ownerId) {
        this.refreshMsg(30002, msgList, bLatest, ownerId);
    }

    public void onLoadMsg(List<AbsChatMessage> msgList, boolean bLatest, long ownerId) {
        this.refreshMsg(30003, msgList, bLatest, ownerId);
    }

    private void refreshMsg(int what, List<AbsChatMessage> msgList, boolean bLatest, long ownerId) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("LATEST", bLatest);
        bundle.putLong("OWNERID", ownerId);
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                long ownerId = null == PrivateChatHolder.this.toUser ? -1L : PrivateChatHolder.this.toUser.getId();
                UserInfo self = PlayerLive.getIns().getSelf();
                long selfId = null == self ? -1L : self.getId();
                MsgQueue.getIns().onPrivateMessageFresh(selfId, ownerId);
            }
        });
    }

    @Override
    public void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                long ownerId = null == PrivateChatHolder.this.toUser ? -1L : PrivateChatHolder.this.toUser.getId();
                UserInfo self = PlayerLive.getIns().getSelf();
                long selfId = null == self ? -1L : self.getId();
                MsgQueue.getIns().onPrivateMessageLoadMore(selfId, ownerId);
            }
        });
    }

    @Override
    public void onUserLeave(UserInfo userInfo) {
        if (null != this.toUser && this.toUser.getId() == userInfo.getId()) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    PrivateChatHolder.this.offlineTitle();
                }
            });
        }
    }

    @Override
    public void onUserJoin(UserInfo userInfo) {
        if (null != this.toUser && this.toUser.getId() == userInfo.getId()) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    PrivateChatHolder.this.onlineTitle();
                }
            });
        }
    }

    private void offlineTitle() {
        if (null != this.tvTitle && null != this.toUser) {
            String sTitle = GenseeUtils.filterNickName(this.toUser.getName()) + this.getContext().getResources().getString(ResManager.getStringId("user_offline"));
            this.tvTitle.setText((CharSequence)sTitle);
            this.tvTitle.setTextColor(this.getContext().getResources().getColor(ResManager.getColorId("private_chat_offline_title")));
            this.tvTitle.setTextSize(0, (float)this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("private_chat_title_offline_text")));
        }
    }

    private void onlineTitle() {
        if (null != this.tvTitle && null != this.toUser) {
            String sTitle = String.format(this.getString(ResManager.getStringId("chat_to_user_tip")), GenseeUtils.filterNickName(this.toUser.getName()));
            this.tvTitle.setText((CharSequence)sTitle);
            this.tvTitle.setTextColor(this.getContext().getResources().getColor(ResManager.getColorId("private_chat_title")));
            this.tvTitle.setTextSize(0, (float)this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("private_chat_title_text")));
        }
    }

    @Override
    public long getToUserId() {
        if (null != this.toUser) {
            return this.toUser.getId();
        }
        return -1L;
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
        PrivateMessage privateMessage = (PrivateMessage)this.adapter.getItem(position - 1);
        String pureText = privateMessage.getText();
        if (TextUtils.isEmpty((CharSequence)pureText)) {
            return false;
        }
        if ((pureText = Html.fromHtml((String)pureText).toString()).startsWith("<span>") && pureText.endsWith("</span>")) {
            pureText = pureText.substring(6, pureText.length() - 7);
        }
        View anchor = null;
        UserInfo self = PlayerLive.getIns().getSelf();
        if (null != self) {
            anchor = self.getId() == privateMessage.getSendUserId() ? view.findViewById(ResManager.getId("private_chat_me_content_tv")) : view.findViewById(ResManager.getId("private_chat_to_content_tv"));
            this.showCopyPopupWindow(anchor, false, this.nowRawX, this.nowRawY, pureText);
        }
        return false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.nowRawX = (int)event.getRawX();
        this.nowRawY = (int)event.getRawY();
        return false;
    }

    private class PrivateChatAdapter
    extends AbstractAdapter {
        private PrivateChatAdapter() {
        }

        protected View createView(Context context) {
            return LayoutInflater.from((Context)PrivateChatHolder.this.getContext()).inflate(ResManager.getLayoutId("private_chat_item_layout"), null);
        }

        protected AbstractViewHolder createViewHolder(View view) {
            return new PrivateChatViewHolder(view);
        }

        private class PrivateChatViewHolder
        extends AbstractViewHolder {
            private LinearLayout lyChatTo;
            private TextView tvChatToName;
            private TextView tvChatToTime;
            private MyTextViewEx tvChatToContent;
            private LinearLayout lyChatMe;
            private TextView tvChatMeName;
            private TextView tvChatMeTime;
            private MyTextViewEx tvChatMeContent;

            public PrivateChatViewHolder(View view) {
                super(view);
            }

            public void initView(View view) {
                this.lyChatTo = (LinearLayout)view.findViewById(ResManager.getId("private_chat_to_lay"));
                this.tvChatToName = (TextView)view.findViewById(ResManager.getId("privat_chat_to_name_tv"));
                this.tvChatToName.setTextColor(PrivateChatHolder.this.getContext().getResources().getColor(ResManager.getColorId("private_time")));
                this.tvChatToTime = (TextView)view.findViewById(ResManager.getId("private_chat_to_time_tv"));
                this.tvChatToTime.setTextColor(PrivateChatHolder.this.getContext().getResources().getColor(ResManager.getColorId("private_time")));
                this.tvChatToContent = (MyTextViewEx)view.findViewById(ResManager.getId("private_chat_to_content_tv"));
                this.tvChatToContent.setTextColor(PrivateChatHolder.this.getContext().getResources().getColor(ResManager.getColorId("private_content")));
                this.lyChatMe = (LinearLayout)view.findViewById(ResManager.getId("private_chat_me_lay"));
                this.tvChatMeName = (TextView)view.findViewById(ResManager.getId("privat_chat_me_name_tv"));
                this.tvChatMeName.setTextColor(PrivateChatHolder.this.getContext().getResources().getColor(ResManager.getColorId("private_time")));
                this.tvChatMeTime = (TextView)view.findViewById(ResManager.getId("private_chat_me_time_tv"));
                this.tvChatMeTime.setTextColor(PrivateChatHolder.this.getContext().getResources().getColor(ResManager.getColorId("private_time")));
                this.tvChatMeContent = (MyTextViewEx)view.findViewById(ResManager.getId("private_chat_me_content_tv"));
                view.findViewById(ResManager.getId("private_item_title_iv")).setBackground(PrivateChatHolder.this.getContext().getResources().getDrawable(ResManager.getDrawableId("private_gray")));
                view.findViewById(ResManager.getId("private_chat_to_content_ly")).setBackground(PrivateChatHolder.this.getContext().getResources().getDrawable(ResManager.getDrawableId("privat_me_bg")));
                ((TextView)view.findViewById(ResManager.getId("private_chat_me_content_tv"))).setTextColor(PrivateChatHolder.this.getContext().getResources().getColor(ResManager.getColorId("private_me_content")));
            }

            public void initValue(int positon) {
                PrivateMessage privateMessage = (PrivateMessage)PrivateChatAdapter.this.getItem(positon);
                long mCurrentTime = privateMessage.getTime() / 1000L;
                String sTime = String.format("%02d", (mCurrentTime / 3600L % 24L + 8L) % 24L) + ":" + String.format("%02d", mCurrentTime % 3600L / 60L) + ":" + String.format("%02d", mCurrentTime % 3600L % 60L);
                UserInfo self = PlayerLive.getIns().getSelf();
                if (null != self) {
                    if (self.getId() == privateMessage.getSendUserId()) {
                        this.lyChatMe.setVisibility(0);
                        this.lyChatTo.setVisibility(8);
                        this.tvChatMeName.setText(ResManager.getStringId("gs_chat_me"));
                        this.tvChatMeTime.setText((CharSequence)sTime);
                        this.tvChatMeContent.setChatContent(privateMessage.getText(), privateMessage.getRich());
                    } else {
                        this.lyChatMe.setVisibility(8);
                        this.lyChatTo.setVisibility(0);
                        this.tvChatToName.setText((CharSequence)GenseeUtils.filterNickName(privateMessage.getSendUserName()));
                        this.tvChatToTime.setText((CharSequence)sTime);
                        this.tvChatToContent.setChatContent(privateMessage.getText(), privateMessage.getRich());
                    }
                }
            }
        }
    }
}

