/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat;

import android.os.Bundle;
import android.os.Message;
import android.text.Html;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.HongbaoMessage;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.InputBottomHolder;
import com.gensee.fastsdk.ui.holder.bottom.QcInputBottomHolder;
import com.gensee.fastsdk.ui.holder.chat.ChatHolder;
import com.gensee.fastsdk.ui.holder.chat.NewMsgHolder;
import com.gensee.fastsdk.ui.holder.chat.PrivateChatHolder;
import com.gensee.fastsdk.ui.holder.chat.PublicChatSelfHolder;
import com.gensee.fastsdk.ui.holder.chat.impl.PublicChatAdapter;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.routine.UserInfo;
import com.gensee.utils.ThreadPool;
import java.util.Calendar;
import java.util.List;

public class PublicChatHolder
extends ChatHolder
implements MsgQueue.OnPublicChatHolderListener,
InputBottomHolder.OnPublicChatBottomListener,
PublicChatSelfHolder.OnChatSelfHolderListener,
AdapterView.OnItemLongClickListener,
View.OnTouchListener,
NewMsgHolder.OnNewMsgListener {
    private PrivateChatHolder privateChatHolder;
    private QcInputBottomHolder mInputBottomHolder;
    private RelativeLayout lyPublicChat;
    private PublicChatSelfHolder mSelfLvHolder;
    private int nowRawX;
    private int nowRawY;
    private NewMsgHolder mNewMsgHolder;

    public PublicChatHolder(View rootView, Object value) {
        super(rootView, value);
        MsgQueue.getIns().setOnPublicChatHolderListener((MsgQueue.OnPublicChatHolderListener)this);
    }

    public void setQcInputBottomHolder(QcInputBottomHolder bottomHolder) {
        this.mInputBottomHolder = bottomHolder;
        if (null != this.mInputBottomHolder) {
            this.mInputBottomHolder.setOnPublicChatBottomListener(this);
        }
    }

    public void onClick(View v) {
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.lyPublicChat = (RelativeLayout)this.findViewById(ResManager.getId("public_chat_ly"));
        this.findViewById(ResManager.getId("public_chat_view_root")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("chat_bg")));
        super.initComp(value);
        this.lvChat.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                UserInfo userInfo = PublicChatHolder.this.onChatItemClick(position, id);
                PublicChatHolder.this.privateToUser(userInfo);
            }
        });
        this.adapter = new PublicChatAdapter();
        this.lvChat.setAdapter((ListAdapter)this.adapter);
        this.lvChat.setOnItemLongClickListener(this);
        this.lvChat.setOnTouchListener(this);
        this.mSelfLvHolder = new PublicChatSelfHolder(this.findViewById(ResManager.getId("public_chat_my_ly")), value);
        this.mSelfLvHolder.setOnChatSelfHolderListener(this);
        this.mNewMsgHolder = new NewMsgHolder(this.findViewById(ResManager.getId("new_msg_ly")), null);
        this.mNewMsgHolder.setOnNewMsgListener(this);
    }

    @Override
    public boolean isLvBottom() {
        return this.getLvBottom();
    }

    public void onCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10001, msgList, bLatest);
    }

    public void refreshMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10000, msgList, bLatest);
    }

    public void onPullMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10002, msgList, bLatest);
    }

    public void onLoadMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.refreshMsg(10003, msgList, bLatest);
        if (bLatest) {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    MsgQueue.getIns().updateRtChatMsgReadFlag(Calendar.getInstance().getTimeInMillis());
                }
            });
        }
    }

    private void refreshMsg(int what, List<AbsChatMessage> msgList, boolean bLatest) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("LATEST", bLatest);
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public void querySelfMsg(boolean bSelected) {
        if (null != this.mSelfLvHolder) {
            this.mSelfLvHolder.show(bSelected);
        }
        if (bSelected) {
            this.showChatNewMsgs(false, 0);
            final UserInfo self = PlayerLive.getIns().getSelf();
            if (null != self) {
                ThreadPool.getInstance().execute(new Runnable(){

                    @Override
                    public void run() {
                        MsgQueue.getIns().getSelfLatestMsg(self.getId());
                    }
                });
            }
        } else {
            this.showChatNewMsgs(true, MsgQueue.getIns().getMsgCount());
            MsgQueue.getIns().getMsgList();
            MsgQueue.getIns().resetSelfList();
        }
    }

    @Override
    public void sendPublicMsg(String text, String rich) {
        if (null != this.chatImpl) {
            this.chatImpl.sendPublicMsg(text, rich);
        }
        if (null == this.mInputBottomHolder) {
            return;
        }
        if (this.mInputBottomHolder.isSelfSelected()) {
            UserInfo self;
            if (!(null == this.mSelfLvHolder || this.isSelfLvBottom() && MsgQueue.getIns().isSelfLatest() || null == (self = PlayerLive.getIns().getSelf()))) {
                ThreadPool.getInstance().execute(new Runnable(){

                    @Override
                    public void run() {
                        PublicChatHolder.this.mSelfLvHolder.resetLvBottom(true);
                        MsgQueue.getIns().getSelfLatestMsg(self.getId());
                    }
                });
            }
        } else if (!this.getLvBottom() || !MsgQueue.getIns().isPublicLatest()) {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    PublicChatHolder.this.setLvBottom(true);
                    MsgQueue.getIns().getLatestMsgsList();
                }
            });
        }
    }

    @Override
    public int getChatMode() {
        return this.chatImpl.getChatMode();
    }

    public void refreshSelfMsg(final List<AbsChatMessage> msgList, boolean bLatest) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (msgList.size() <= 0 && null != PublicChatHolder.this.mInputBottomHolder) {
                    PublicChatHolder.this.mInputBottomHolder.onlyMeMsg(PublicChatHolder.this.getString(ResManager.getStringId("gs_chat_only_me")));
                }
            }
        });
        if (null != this.mSelfLvHolder) {
            this.mSelfLvHolder.refreshMsg(10004, msgList, bLatest);
        }
    }

    public void onPullSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        if (null != this.mSelfLvHolder) {
            this.mSelfLvHolder.refreshMsg(10005, msgList, bLatest);
        }
    }

    public void onLoadSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        if (null != this.mSelfLvHolder) {
            this.mSelfLvHolder.refreshMsg(10006, msgList, bLatest);
        }
    }

    public void onSelfCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
        this.mSelfLvHolder.refreshMsg(10007, msgList, bLatest);
    }

    @Override
    public void show(boolean isShow) {
        this.lyPublicChat.setVisibility(isShow ? 0 : 8);
    }

    @Override
    public boolean isSelfLvBottom() {
        return null != this.mSelfLvHolder && this.mSelfLvHolder.getLvBottom();
    }

    @Override
    protected void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MsgQueue.getIns().onMessageFresh();
            }
        });
    }

    @Override
    protected void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                MsgQueue.getIns().onMessageLoadMore();
            }
        });
    }

    @Override
    public void privateToUser(UserInfo userInfo) {
        if (null == userInfo) {
            return;
        }
        if (null == this.privateChatHolder) {
            this.privateChatHolder = new PrivateChatHolder(this.rootView.findViewById(ResManager.getId("private_chat_ly")), this.chatImpl);
            this.privateChatHolder.setInputBottomHolder(this.mInputBottomHolder);
        }
        this.privateChatHolder.setToUser(userInfo);
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
        AbsChatMessage chatMessage = (AbsChatMessage)this.adapter.getItem(position - 1);
        String pureText = chatMessage.getText();
        if (TextUtils.isEmpty((CharSequence)pureText)) {
            return true;
        }
        if ((pureText = Html.fromHtml((String)pureText).toString()).startsWith("<span>") && pureText.endsWith("</span>")) {
            pureText = pureText.substring(6, pureText.length() - 7);
        }
        View anchor = null;
        boolean isHongbaoItem = false;
        if (chatMessage instanceof HongbaoMessage) {
            isHongbaoItem = true;
            anchor = view.findViewById(ResManager.getId("hb_msg_tv"));
        } else {
            isHongbaoItem = false;
            anchor = view.findViewById(ResManager.getId("content_tv"));
        }
        this.showCopyPopupWindow(anchor, isHongbaoItem, this.nowRawX, this.nowRawY, pureText);
        return true;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.nowRawX = (int)event.getRawX();
        this.nowRawY = (int)event.getRawY();
        return false;
    }

    @Override
    protected void onScrollToBottom(boolean bScroolBottom) {
        super.onScrollToBottom(bScroolBottom);
        if (bScroolBottom && MsgQueue.getIns().isPublicLatest() && MsgQueue.getIns().getMsgCount() != 0) {
            MsgQueue.getIns().setMsgCount(0);
            this.showChatNewMsgs(false, 0);
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    MsgQueue.getIns().updateRtChatMsgReadFlag(Calendar.getInstance().getTimeInMillis());
                }
            });
        }
    }

    public void showChatNewMsgs(boolean bShow, int nMsgCount) {
        this.mNewMsgHolder.setNewMsg(bShow, nMsgCount);
    }

    public void onNewMsgCount(int nMsgCount) {
        this.showChatNewMsgs(true, nMsgCount);
    }

    @Override
    public void onNewMsgClick() {
        this.setLvBottom(true);
        MsgQueue.getIns().getLatestMsgsList();
    }
}

