/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat.impl;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.common.RoleType;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.entity.chat.TipMessage;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.holder.chat.AbsChatImpl;
import com.gensee.fastsdk.ui.holder.chat.impl.PlayerChatImpl;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;
import com.gensee.view.MyTextViewEx;

public class PlayerChatAdapter
extends AbstractAdapter {
    private Context context;
    private PlayerChatImpl playerChatImpl;
    private long selfId = 0L;
    private int paddingH;
    private int paddingV;

    protected View createView(Context context) {
        this.context = context;
        this.paddingH = (int)TypedValue.applyDimension((int)1, (float)8.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        this.paddingV = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)context.getResources().getDisplayMetrics());
        AbsChatImpl abs = ((BaseWatchActivity)context).getChatImpl();
        if (null != abs) {
            this.playerChatImpl = (PlayerChatImpl)abs;
            this.selfId = this.playerChatImpl.getSelfId();
        }
        return LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("gs_public_chat_item"), null);
    }

    protected AbstractViewHolder createViewHolder(View view) {
        return new PublicChatViewHolder(view);
    }

    private class PublicChatViewHolder
    extends AbstractViewHolder {
        private MyTextViewEx tv_msg_content;

        public PublicChatViewHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.tv_msg_content = (MyTextViewEx)view.findViewById(ResManager.getId("gs_tv_msg_content"));
        }

        public void initValue(int positon) {
            AbsChatMessage chatMessage = (AbsChatMessage)PlayerChatAdapter.this.getItem(positon);
            String msgRole = "";
            String msg = chatMessage.getRich();
            String color2 = "#ffe661";
            this.tv_msg_content.setBackgroundColor(PlayerChatAdapter.this.context.getResources().getColor(17170445));
            this.tv_msg_content.setPadding(0, 0, 0, 0);
            if (chatMessage instanceof TipMessage) {
                msgRole = "";
                this.tv_msg_content.setBackgroundResource(ResManager.getDrawableId("gs_pure_video_chat_item_bg"));
                this.tv_msg_content.setPadding(PlayerChatAdapter.this.paddingH, PlayerChatAdapter.this.paddingV, PlayerChatAdapter.this.paddingH, PlayerChatAdapter.this.paddingV);
            } else if (chatMessage instanceof SysMessage) {
                color2 = "#fe526e";
                msgRole = PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_sys"));
            } else if (chatMessage instanceof PublicMessage) {
                msgRole = GenseeUtils.formatText(chatMessage.getSendUserName(), 12);
                if (RoleType.isHost((int)chatMessage.getSenderRole())) {
                    color2 = "#a071fc";
                }
                if (PlayerChatAdapter.this.selfId == chatMessage.getSendUserId()) {
                    msgRole = PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_me"));
                }
            } else if (chatMessage instanceof PrivateMessage) {
                String sTitle = "";
                if (chatMessage.getSendUserId() == PlayerChatAdapter.this.selfId) {
                    sTitle = PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_me")) + " ";
                    sTitle = sTitle + PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_to")) + " ";
                    sTitle = sTitle + GenseeUtils.formatText(chatMessage.getSendUserName(), 12) + " ";
                    sTitle = sTitle + PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_say")) + " ";
                } else {
                    sTitle = GenseeUtils.formatText(chatMessage.getSendUserName(), 12) + " ";
                    sTitle = sTitle + PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_to")) + " ";
                    sTitle = sTitle + PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_me")) + " ";
                    sTitle = sTitle + PlayerChatAdapter.this.context.getResources().getString(ResManager.getStringId("gs_chat_say")) + " ";
                }
                msgRole = sTitle;
            } else {
                GenseeLog.d((String)"PlayerChatAdapter", (String)("privatemsg error = " + chatMessage));
            }
            if (chatMessage instanceof PublicMessage && msg.equals(chatMessage.getText()) && (msg.startsWith("<span>") && msg.endsWith("</span>") || msg.startsWith("<SPAN>") && msg.endsWith("</SPAN>"))) {
                msg = msg.substring(6, msg.length() - 7);
            }
            if (!TextUtils.isEmpty((CharSequence)msgRole)) {
                msgRole = "<font color=\"" + color2 + "\">" + msgRole + " " + "</font>";
            }
            String rich = "<font color=\"white\">" + msg + "</font>";
            this.tv_msg_content.setRichText(msgRole + rich);
        }
    }
}

