/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.chat.impl;

import android.content.Context;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.entity.chat.TipMessage;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.TopMsgTipHolder;
import com.gensee.fastsdk.ui.holder.chat.AbsChatImpl;
import com.gensee.fastsdk.ui.holder.chat.impl.RTChatImpl;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.chat.impl.AbstractChatImpl;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.player.IPlayerChat;
import com.gensee.player.IPlayerModule;
import com.gensee.player.OnChatListener;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.ThreadPool;
import java.util.Calendar;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class PlayerChatImpl
extends AbstractChatImpl
implements OnChatListener,
AbsChatImpl {
    public static final int CHAT_MODE_DENY = 0;
    public static final int CHAT_MODE_ALLOW_ALL = 1;
    private static final String TAG = "PlayerChatImpl";
    private AtomicBoolean bChatEnable = new AtomicBoolean(true);
    private AtomicInteger nChatMode = new AtomicInteger(1);
    private IPlayerChat mChatHandle;
    private RTChatImpl.OnChatModeChangeListener onChatModeChangeListener;
    private Context context;
    private TopMsgTipHolder topMsgTipHolder;
    private OnMsgBottomListener onMsgBottomListener;
    private OnPublicChatMsgListener onPublicChatMsgListener;

    public void setTopMsgTipHolder(TopMsgTipHolder topMsgTipHolder) {
        this.topMsgTipHolder = topMsgTipHolder;
    }

    public IPlayerChat getmChatHandle() {
        return this.mChatHandle;
    }

    public void setOnMsgBottomListener(OnMsgBottomListener onMsgBottomListener) {
        this.onMsgBottomListener = onMsgBottomListener;
    }

    public void setOnPublicChatMsgListener(OnPublicChatMsgListener onPublicChatMsgListener) {
        this.onPublicChatMsgListener = onPublicChatMsgListener;
    }

    @Override
    public void setOnChatModeChangeListener(RTChatImpl.OnChatModeChangeListener onChatModeChangeListener) {
        this.onChatModeChangeListener = onChatModeChangeListener;
    }

    @Override
    public boolean getChatEnable() {
        return this.bChatEnable.get();
    }

    @Override
    public void sendPrivateMsg(final String text, final String rich, final UserInfo receiveUserInfo) {
        GenseeLog.i((String)TAG, (String)("sendPrivateMsg text:" + text + ",rich:" + rich));
        final long receiverUserId = receiveUserInfo.getId();
        final String receiverUserName = receiveUserInfo.getName();
        String msgId = UUID.randomUUID().toString();
        UserInfo selfInfo = PlayerLive.getIns().getSelf();
        if (0L != receiverUserId && this.bChatEnable.get() && (this.getChatEnable() || receiveUserInfo.IsHost() || receiveUserInfo.IsPanelist())) {
            ChatMsg msg = new ChatMsg(text, rich, 2, msgId);
            msg.setSender(selfInfo.getName());
            msg.setSenderId(selfInfo.getUserId());
            msg.setSenderRole(selfInfo.getRole());
            msg.setChatId(receiveUserInfo.getChatId());
            this.mChatHandle.chatToPersion(msg, new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                    if (ret) {
                        PlayerChatImpl.this.onChatToPerson(receiverUserId, receiverUserName, text, rich, receiveUserInfo.getChatId());
                    }
                }
            });
        } else {
            PrivateMessage message = new PrivateMessage();
            message.setText(text);
            message.setRich(rich);
            message.setTime(Calendar.getInstance().getTimeInMillis());
            message.setReceiveUserId(receiverUserId);
            message.setReceiveName(receiverUserName);
            message.setSendUserId(null == selfInfo ? -1L : selfInfo.getId());
            message.setSendUserName(null == selfInfo ? "" : selfInfo.getName());
            this.updateMessage((AbsChatMessage)message);
        }
    }

    public void onChatToPerson(long receiveUserId, String sReceiveName, String text, String rich, int chatId) {
        UserInfo self = this.mChatHandle.getSelfInfo();
        if (null != self) {
            GenseeLog.d((String)TAG, (String)("OnChatToPerson receiveUserId = " + receiveUserId + " sReceiveName = " + sReceiveName + " rich = " + rich + " text = " + text + ",chatid:" + chatId));
            PrivateMessage privateMessage = new PrivateMessage();
            privateMessage.setReceiveName(sReceiveName);
            privateMessage.setReceiveUserId(receiveUserId);
            privateMessage.setRich(rich);
            privateMessage.setText(text);
            privateMessage.setSendUserId(self.getUserId());
            privateMessage.setSendUserName(self.getName());
            privateMessage.setTime(Calendar.getInstance().getTimeInMillis());
            privateMessage.setSenderRole(self.getRole());
            privateMessage.setChatId(chatId);
            this.updateMessage((AbsChatMessage)privateMessage);
        } else {
            GenseeLog.d((String)"GSChatView OnChatWithPersion getselfIno is null");
        }
    }

    @Override
    public int getChatMode() {
        return this.nChatMode.get();
    }

    public long getSelfId() {
        UserInfo self;
        UserInfo userInfo = self = this.mChatHandle == null ? null : this.mChatHandle.getSelfInfo();
        if (null != self) {
            return self.getUserId();
        }
        return -1L;
    }

    public PlayerChatImpl(Context context) {
        this.context = context;
    }

    public void onSysMsg(String sSysMsg) {
        SysMessage sysMessage = new SysMessage();
        sysMessage.setTime(Calendar.getInstance().getTimeInMillis());
        sysMessage.setSendUserId(-1L);
        sysMessage.setRich(sSysMsg);
        sysMessage.setText(sSysMsg);
        this.updateMessage((AbsChatMessage)sysMessage);
        if (null != this.topMsgTipHolder) {
            this.topMsgTipHolder.onBraodcastMsg(sSysMsg);
        }
    }

    public void addTipMessage(String msg) {
        TipMessage message = new TipMessage();
        message.setText(msg);
        message.setRich(msg);
        message.setTime(Calendar.getInstance().getTimeInMillis());
        message.setReceiveUserId(-1L);
        this.updateMessage((AbsChatMessage)message);
    }

    public void onChatWithPerson(ChatMsg msg) {
        UserInfo self = this.mChatHandle.getSelfInfo();
        if (null != self) {
            long userId = msg.getSenderId();
            String sSendName = msg.getSender();
            int senderRole = msg.getSenderRole();
            String text = msg.getContent();
            String rich = msg.getRichText();
            int onChatID = msg.getChatId();
            GenseeLog.d((String)TAG, (String)("OnChatWithPersion userId = " + userId + " sSendName = " + sSendName + " rich = " + rich + " text = " + text));
            PrivateMessage privateMessage = new PrivateMessage();
            privateMessage.setReceiveName(self.getName());
            privateMessage.setReceiveUserId(self.getUserId());
            privateMessage.setRich(rich);
            privateMessage.setText(text);
            privateMessage.setSendUserId(userId);
            privateMessage.setSendUserName(sSendName);
            privateMessage.setSenderRole(senderRole);
            privateMessage.setTime(Calendar.getInstance().getTimeInMillis());
            privateMessage.setId(msg.getId());
            privateMessage.setChatId(msg.getChatId());
            this.updateMessage((AbsChatMessage)privateMessage);
            if (null != this.onMsgBottomListener) {
                UserInfo info = new UserInfo();
                info.setId(userId);
                info.setName(sSendName);
                this.onMsgBottomListener.onPrivateMsg(info);
            }
        } else {
            GenseeLog.d((String)TAG, (String)"OnChatWithPersion getselfIno is null");
        }
    }

    public void onChatWithPublic(ChatMsg msg) {
        long userId = msg.getSenderId();
        String sSendName = msg.getSender();
        int senderRole = msg.getSenderRole();
        String text = msg.getContent();
        String rich = msg.getRichText();
        int onChatID = msg.getChatId();
        UserInfo self = this.mChatHandle.getSelfInfo();
        if (null != self) {
            GenseeLog.d((String)TAG, (String)("OnChatWithPublic userId = " + userId + " sSendName = " + sSendName + " rich = " + rich + " text = " + text));
            PublicMessage publicMessage = new PublicMessage();
            publicMessage.setRich(rich);
            publicMessage.setText(text);
            publicMessage.setSendUserId(userId);
            publicMessage.setSendUserName(sSendName);
            publicMessage.setTime(Calendar.getInstance().getTimeInMillis());
            publicMessage.setSenderRole(senderRole);
            publicMessage.setChatId(onChatID);
            publicMessage.setId(msg.getId());
            this.updateMessage((AbsChatMessage)publicMessage);
        } else {
            GenseeLog.d((String)TAG, (String)"OnChatWithPersion getselfIno is null");
        }
        if (null != this.onPublicChatMsgListener) {
            this.onPublicChatMsgListener.onPublicChatMsg(msg);
        }
    }

    public boolean isSelfSend(ChatMsg msg) {
        long sendUserId = msg.getSenderId();
        UserInfo self = this.mChatHandle.getSelfInfo();
        return null != self && self.getUserId() == sendUserId;
    }

    public void onMute(boolean isMute) {
        GenseeLog.i((String)TAG, (String)("onMute isMute:" + isMute));
        this.bChatEnable.set(!isMute);
        if (null != this.onChatModeChangeListener) {
            this.onChatModeChangeListener.onSelfChatEnable(!isMute);
        }
    }

    public void onRoomMute(boolean isMute) {
        int chatMode;
        GenseeLog.i((String)TAG, (String)("onRoomMute isMute:" + isMute));
        int n = chatMode = isMute ? 0 : 1;
        if (this.nChatMode.get() != chatMode) {
            this.nChatMode.set(chatMode);
            String tip = "";
            tip = isMute ? this.context.getResources().getString(ResManager.getStringId("gs_chat_publicchat_close")) : this.context.getResources().getString(ResManager.getStringId("gs_chat_publicchat_open"));
            this.onSysMsg(tip);
            if (null != this.onChatModeChangeListener) {
                this.onChatModeChangeListener.onChatModeChage(this.nChatMode.get());
            }
        }
    }

    public void onReconnection() {
    }

    public void onPublish(boolean isPlaying) {
    }

    public void setModuleHandle(IPlayerModule chatHandle) {
        this.mChatHandle = (IPlayerChat)chatHandle;
    }

    @Override
    public void sendPublicMsg(String content, String rich) {
        IPlayerChat handle = this.mChatHandle;
        if (handle == null) {
            GenseeLog.d((String)TAG, (String)"sendPublicMsg fail, handle==null");
            return;
        }
        UserInfo selfInfo = handle.getSelfInfo();
        if (null == selfInfo) {
            GenseeLog.e((String)TAG, (String)"sendPublicMsg fail, selfInfo==null");
            return;
        }
        long senderId = selfInfo.getUserId();
        String senderName = selfInfo.getName();
        int chatId = selfInfo.getChatId();
        int role = selfInfo.getRole();
        String msgId = UUID.randomUUID().toString();
        final ChatMsg msg = new ChatMsg(content, rich, 0, msgId);
        msg.setSender(senderName);
        msg.setSenderId(senderId);
        msg.setSenderRole(role);
        msg.setChatId(chatId);
        if (this.nChatMode.get() == 1) {
            if (this.bChatEnable.get()) {
                handle.chatToPublic(msg, new OnTaskRet(){

                    public void onTaskRet(boolean ret, int id, String desc) {
                        if (ret) {
                            PlayerChatImpl.this.onChatWithPublic(msg);
                        }
                    }
                });
            } else {
                PublicMessage message = new PublicMessage();
                message.setRich(rich);
                message.setText(content);
                message.setSendUserId(null == PlayerLive.getIns().getSelf() ? 0L : PlayerLive.getIns().getSelf().getId());
                message.setTime(Calendar.getInstance().getTimeInMillis());
                message.setSendUserName(null == PlayerLive.getIns().getSelf() ? "" : PlayerLive.getIns().getSelf().getName());
                message.setReceiveUserId(-1L);
                this.updateMessage((AbsChatMessage)message);
            }
        }
    }

    public void onChatcensor(final String type, final String id) {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if ("user".equals(type)) {
                        MsgQueue.getIns().removeMsg(Long.parseLong(id), "");
                    } else {
                        MsgQueue.getIns().removeMsg(0L, id);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static interface OnMsgBottomListener {
        public void onPrivateMsg(UserInfo var1);
    }

    public static interface OnPublicChatMsgListener {
        public void onPublicChatMsg(ChatMsg var1);
    }
}

