/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.doc;

import android.app.Activity;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.doc.AbstractLiveDocHolder;
import com.gensee.fastsdk.ui.holder.vdbar.ReceiverVDBarHolder;
import com.gensee.fastsdk.ui.view.PipViewTouchHolder;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.pdu.IGSDocView;

public class ReceiverLiveDocHolder
extends AbstractLiveDocHolder
implements ReceiverVDBarHolder.OnVdBarListener,
PlayerLive.OnDocListener,
PipViewTouchHolder.OnPipFullScreenSmallListener {
    private ReceiverVDBarHolder mVdBarHolder;
    private PipViewTouchHolder mPipViewTouchHolder;
    private View mFullScreenSmall;
    private ImageView mPipSwitch;
    private View tvDef;
    private View docTemp;

    public ReceiverLiveDocHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.mVdBarHolder = new ReceiverVDBarHolder(this.getRootView(), null);
        this.mVdBarHolder.setOnVdBarListener(this);
        ((BaseWatchActivity)this.getContext()).setDocView(this.docViewGx);
        this.mVdBarHolder.setFloatRightBtnsVisible(false);
        this.mFullScreenSmall = this.findViewById(ResManager.getId("doc_full_screen_small_rl"));
        this.mPipViewTouchHolder = new PipViewTouchHolder(this.rootView, value);
        this.mPipViewTouchHolder.setOnPadFullScreenSmallListener(this);
        this.mFullScreenSmall.setOnTouchListener((View.OnTouchListener)this.mPipViewTouchHolder);
        this.mPipSwitch = (ImageView)this.findViewById(ResManager.getId("iv_pip_switch"));
        this.mPipSwitch.setOnClickListener((View.OnClickListener)this);
        this.findViewById(ResManager.getId("relDef")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("doc_default_bg")));
        this.tvDef = this.findViewById(ResManager.getId("tvDef"));
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == ResManager.getId("iv_pip_switch")) {
            this.listener.onFullContentSwitch(2);
        }
    }

    @Override
    public void onSwitchToFullScreen() {
        this.listener.onSwitchToFull(2);
    }

    @Override
    public void onHandClick() {
    }

    @Override
    public void onRewardClick() {
    }

    @Override
    public void onShowInputDialog() {
        ((LiveActivity)this.getContext()).showInputDialog();
    }

    @Override
    public void onShowFloatTitle(int visibility) {
        this.listener.onFloatBtnShow(2, visibility);
    }

    @Override
    public void onRoomJoinSuccess() {
        this.cancelDocSwitchButtons();
    }

    public void cancelDocSwitchButtons() {
        this.mVdBarHolder.showImageFullScreen(true);
        this.findViewById(ResManager.getId("tvDef")).setSelected(false);
    }

    @Override
    public void showFullScreen() {
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        if (this.getContext().getResources().getConfiguration().orientation == 1) {
            this.showPortraitDocFullScreen();
        } else {
            this.showLandScapeDocFullScreen();
        }
        this.mFullScreenSmall.setVisibility(8);
    }

    public void showNormalScreen() {
        this.mFullScreenSmall.setVisibility(8);
    }

    public void removeDelayRunnable() {
        this.mVdBarHolder.removeRunnable();
    }

    @Override
    public void showPortraitDocNorScreen() {
        this.docViewGx.showAdaptViewWidthAlignTop();
    }

    @Override
    public void showPortraitDocFullScreen() {
        this.docViewGx.showAdaptViewWidthAlignTop();
    }

    @Override
    public void showLandScapeDocFullScreen() {
        this.docViewGx.showAdaptViewHeightAlignLeft();
    }

    public void setFloatRightBtnsVisible(boolean isShow) {
        this.mVdBarHolder.setFloatRightBtnsVisible(isShow);
    }

    @Override
    public boolean onSingleClicked(IGSDocView arg0) {
        boolean isFullScreen;
        boolean bl = isFullScreen = (((LiveActivity)this.getContext()).getUIMode() & 1) == 1;
        if (isFullScreen) {
            this.mVdBarHolder.showFloatBtns();
        }
        return super.onSingleClicked(arg0);
    }

    @Override
    public void show(boolean isShow) {
        if (!PlayerLive.getIns().isShowDoc()) {
            isShow = false;
        } else {
            int uiMode = ((LiveActivity)this.getContext()).getUIMode();
            this.tvDef.setVisibility(0);
            if ((uiMode & 1) == 1 && PlayerLive.getIns().isShowPIP() && (uiMode & 2) == 2) {
                isShow = true;
                this.showPIPDocSmallView();
                this.tvDef.setVisibility(8);
                this.docViewGx.showAdaptView();
            }
        }
        this.docViewGx.setVisibility(isShow ? 0 : 8);
        super.show(isShow);
    }

    private void showPIPDocSmallView() {
        View videoView;
        int videoViewIndex;
        RelativeLayout relRoot = (RelativeLayout)this.rootView.getParent();
        int docViewIndex = relRoot.indexOfChild(this.rootView);
        if (docViewIndex <= (videoViewIndex = relRoot.indexOfChild(videoView = relRoot.findViewById(ResManager.getId("videoLayout"))))) {
            relRoot.removeView(videoView);
            relRoot.addView(videoView, docViewIndex);
        }
        DisplayMetrics mDisplayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(mDisplayMetrics);
        int nScreenWidth = mDisplayMetrics.widthPixels >= mDisplayMetrics.heightPixels ? mDisplayMetrics.widthPixels : mDisplayMetrics.heightPixels;
        int nScreenHeight = mDisplayMetrics.widthPixels >= mDisplayMetrics.heightPixels ? mDisplayMetrics.heightPixels : mDisplayMetrics.widthPixels;
        int nViewWidth = (int)((double)nScreenWidth * 0.3);
        int nViewHeight = nViewWidth * 9 / 16;
        RelativeLayout.LayoutParams mNormalLayoutParam = new RelativeLayout.LayoutParams(-1, -1);
        mNormalLayoutParam.width = nViewWidth;
        mNormalLayoutParam.height = nViewHeight;
        mNormalLayoutParam.leftMargin = PreferUtil.getIns().getInt("KEY_PIP_LEFT_MARGIN", -1);
        if (mNormalLayoutParam.leftMargin == -1) {
            mNormalLayoutParam.leftMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("pip_left_margin"));
        }
        mNormalLayoutParam.topMargin = PreferUtil.getIns().getInt("KEY_PIP_TOP_MARGIN", -1);
        Activity act = (Activity)this.getContext();
        if (act.getRequestedOrientation() == 1) {
            nScreenHeight = mDisplayMetrics.heightPixels;
        }
        if (mNormalLayoutParam.topMargin == -1) {
            mNormalLayoutParam.topMargin = nScreenHeight - this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("pip_bottom_margin")) - nViewHeight;
        }
        this.layout(mNormalLayoutParam);
        this.mPipViewTouchHolder.initPosition(mNormalLayoutParam.leftMargin, mNormalLayoutParam.topMargin);
        this.mFullScreenSmall.setVisibility(0);
        this.dismissOwnBtn();
    }

    public void setOrientation(int orientation) {
        this.show(this.rootView.getVisibility() == 0);
    }

    @Override
    public void onPageSize(int pos, int width, int height) {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveDocHolder.this.findViewById(ResManager.getId("relDef")).setVisibility(8);
            }
        });
    }

    @Override
    public void onDocSwitch(int docType, String docName) {
        if (docType == 0) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    ReceiverLiveDocHolder.this.findViewById(ResManager.getId("relDef")).setVisibility(0);
                }
            });
        }
    }

    @Override
    public void dismisssFloatBtns() {
        this.mVdBarHolder.dismisssFloatBtns();
    }

    @Override
    public void delayDismissFloatBtns() {
        this.mVdBarHolder.delayDismissFloatBtns();
    }

    @Override
    public void continueShowBtn() {
        this.mVdBarHolder.continueShowBtn();
    }

    @Override
    public void showDocFloatBtn(int type) {
    }

    @Override
    public void dismissOwnBtn() {
        this.mVdBarHolder.dismissOwnBtn();
    }

    @Override
    public void setImageHandVisible(boolean visible) {
        this.mVdBarHolder.setImageHandVisible(visible);
    }

    public void showRewardBtn(boolean isShow) {
        this.mVdBarHolder.showRewardBtn(isShow);
    }

    @Override
    public void updateHand(String sValue, boolean visible) {
        this.mVdBarHolder.updateHand(sValue, visible);
    }

    @Override
    public void dismissVideoFloatButtons() {
    }

    @Override
    public boolean isMove() {
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        return (uiMode & 1) == 1 && (uiMode & 2) == 2;
    }

    @Override
    public void onFullScreenSmallMoveTo(int left, int top) {
        RelativeLayout.LayoutParams mNormalLayoutParam = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
        mNormalLayoutParam.leftMargin = left;
        mNormalLayoutParam.topMargin = top;
        mNormalLayoutParam.rightMargin = 0;
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)mNormalLayoutParam);
        PreferUtil.getIns().putInt("KEY_PIP_TOP_MARGIN", mNormalLayoutParam.topMargin);
        PreferUtil.getIns().putInt("KEY_PIP_LEFT_MARGIN", mNormalLayoutParam.leftMargin);
    }
}

