/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.idc;

import android.graphics.Color;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gensee.fastsdk.core.GSLive;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.core.RTLive;
import com.gensee.fastsdk.ui.holder.idc.IdcBaseHolder;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;
import java.util.List;

public class IdcWhiteHolder
extends IdcBaseHolder {
    private static final long DURAION = 300L;
    private LinearLayout lyIdcContent;
    private LinearLayout lyIdcNoData;
    private String selectIdc = "";
    private View tvCancel;
    private View idcBlankArea;
    private LinearLayout idcAllContent;
    private List<FastIdc> idcs;

    public IdcWhiteHolder(View rootView, Object value) {
        super(rootView, value, new Object[0]);
    }

    @Override
    public void onClick(View v) {
        if (v.getId() == ResManager.getId("gs_tv_cancel_btm_view") || v.getId() == ResManager.getId("gs_idc_blank_area")) {
            this.show(false);
        }
    }

    private void sure() {
        if (!"".equals(this.selectIdc) && !this.selectIdc.equals(GSLive.getIns().roomIDCGetCurrent())) {
            UserInfo self = RTLive.getIns().getSelf();
            if (null != self && self.IsHost()) {
                RTLive.getIns().getRtSdk().roomNotifyBroadcastMsg(GenseeUtils.formatText(self.getName(), 12) + this.getString(ResManager.getStringId("gs_chat_host_leave")), true, null);
            }
            GSLive.getIns().roomIDCSetCurrent(this.selectIdc);
        }
        this.show(false);
    }

    @Override
    public void selectIdc() {
        this.idcs = PlayerLive.getIns().getIdcList();
        this.lyIdcContent.removeAllViews();
        if (null == this.idcs || this.idcs.size() <= 0) {
            this.lyIdcNoData.setVisibility(0);
        } else {
            this.lyIdcNoData.setVisibility(8);
            String sCurIdc = GSLive.getIns().roomIDCGetCurrent();
            this.selectIdc = null == sCurIdc ? "" : sCurIdc;
            int nsize = this.idcs.size();
            for (int i = 0; i < nsize; ++i) {
                TextView tv = new TextView(this.getContext());
                tv.setGravity(17);
                tv.setTextSize(0, (float)this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("gs_idc_item_text_size")));
                tv.setSingleLine();
                tv.setEllipsize(TextUtils.TruncateAt.END);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("gs_idc_item_height")));
                tv.setText((CharSequence)this.idcs.get((int)i).name);
                if (!"".equals(this.selectIdc) && this.selectIdc.equals(this.idcs.get((int)i).id)) {
                    tv.setTextColor(Color.parseColor((String)"#e43e36"));
                } else {
                    tv.setTextColor(-16777216);
                }
                final int nItemIndex = i;
                tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        IdcWhiteHolder.this.selectIdc = ((FastIdc)((IdcWhiteHolder)IdcWhiteHolder.this).idcs.get((int)nItemIndex)).id;
                        IdcWhiteHolder.this.sure();
                    }
                });
                if (i != 0) {
                    View line = new View(this.getContext());
                    line.setBackgroundResource(ResManager.getColorId("gs_idc_line_color"));
                    LinearLayout.LayoutParams lineLp = new LinearLayout.LayoutParams(-1, 2);
                    this.lyIdcContent.addView(line, (ViewGroup.LayoutParams)lineLp);
                }
                this.lyIdcContent.addView((View)tv, (ViewGroup.LayoutParams)lp);
            }
            if (nsize > 4) {
                int oneItemHeight = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("gs_idc_item_height")) + 2;
                RelativeLayout.LayoutParams lp = new RelativeLayout.LayoutParams(-1, oneItemHeight * 5);
                this.idcAllContent.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
        this.show(true);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.tvCancel = this.findViewById(ResManager.getId("gs_tv_cancel_btm_view"));
        this.tvCancel.setOnClickListener((View.OnClickListener)this);
        this.lyIdcContent = (LinearLayout)this.findViewById(ResManager.getId("gs_idc_content_ly"));
        this.lyIdcNoData = (LinearLayout)this.findViewById(ResManager.getId("idc_no_data_ly"));
        this.idcBlankArea = this.findViewById(ResManager.getId("gs_idc_blank_area"));
        this.idcBlankArea.setOnClickListener((View.OnClickListener)this);
        this.idcAllContent = (LinearLayout)this.findViewById(ResManager.getId("gs_idc_all_content"));
    }

    public static void fromUpToBottom(final View view) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)view.getHeight());
        animation.setDuration(300L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }
        });
        view.startAnimation((Animation)animation);
    }

    public static void fromBottomToUp(final View view) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, (float)view.getHeight(), 0.0f);
        animation.setDuration(300L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(0);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        view.startAnimation((Animation)animation);
    }

    public static class FastIdc {
        public String name;
        public String id;
    }
}

