/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.midtab;

import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;

public class MidTabsHolder
extends BaseHolder {
    public static final byte ACTIVE_TAB1 = 1;
    public static final byte ACTIVE_TAB2 = 2;
    public static final byte ACTIVE_TAB3 = 3;
    public static final byte ACTIVE_TAB4 = 4;
    private static final String ACTIVE_ID = "activeid_key";
    protected Button tab1;
    protected Button tab2;
    protected Button tab3;
    protected Button tab4;
    protected RelativeLayout lyTab1;
    protected RelativeLayout lyTab2;
    protected RelativeLayout lyTab3;
    protected RelativeLayout lyTab4;
    protected View.OnClickListener mListener;
    protected int activeTabId;

    public MidTabsHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public MidTabsHolder(LayoutInflater inflater, int layoutID, Object value) {
        super(inflater, layoutID, value);
    }

    public void onClick(View v) {
        if (this.mListener != null) {
            this.mListener.onClick(v);
        }
        this.activeTabId = v.getId();
        this.activeTab(v);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        if (value instanceof View.OnClickListener) {
            this.mListener = (View.OnClickListener)value;
        }
        this.tab1 = (Button)this.findViewById(ResManager.getId("btnTab1"));
        this.tab2 = (Button)this.findViewById(ResManager.getId("btnTab2"));
        this.tab3 = (Button)this.findViewById(ResManager.getId("btnTab3"));
        this.tab4 = (Button)this.findViewById(ResManager.getId("btnTab4"));
        this.lyTab1 = (RelativeLayout)this.findViewById(ResManager.getId("lyTab1"));
        this.lyTab2 = (RelativeLayout)this.findViewById(ResManager.getId("lyTab2"));
        this.lyTab3 = (RelativeLayout)this.findViewById(ResManager.getId("lyTab3"));
        this.lyTab4 = (RelativeLayout)this.findViewById(ResManager.getId("lyTab4"));
        this.lyTab1.setOnClickListener((View.OnClickListener)this);
        this.lyTab2.setOnClickListener((View.OnClickListener)this);
        this.lyTab3.setOnClickListener((View.OnClickListener)this);
        this.lyTab4.setOnClickListener((View.OnClickListener)this);
        this.findViewById(ResManager.getId("midTabs")).setBackground(this.getContext().getResources().getDrawable(ResManager.getDrawableId("tab_nor_bg")));
    }

    public void showTab4(boolean show) {
        this.lyTab4.setVisibility(show ? 0 : 8);
    }

    @Override
    public void layout(Bundle saveInstance) {
        if (saveInstance == null) {
            if (PlayerLive.getIns().isShowDoc()) {
                this.activeTabId = ResManager.getId("lyTab1");
                this.activeTab(1, this.getString(ResManager.getStringId("doc")));
            } else if (PlayerLive.getIns().isShowChat()) {
                this.activeTabId = ResManager.getId("lyTab2");
                this.activeTab(2, this.getString(ResManager.getStringId("chat")));
            } else if (PlayerLive.getIns().isShowQa()) {
                this.activeTabId = ResManager.getId("lyTab3");
                this.activeTab(3, this.getString(ResManager.getStringId("qa")));
            } else if (PlayerLive.getIns().isShowIntro()) {
                this.activeTabId = ResManager.getId("lyTab4");
                this.activeTab(4, this.getString(ResManager.getStringId("introdution")));
            }
        } else {
            this.activeTabId = saveInstance.getInt(ACTIVE_ID, ResManager.getId("lyTab1"));
            if (this.activeTabId == ResManager.getId("lyTab1")) {
                this.activeTab(1, this.getString(ResManager.getStringId("doc")));
            } else if (this.activeTabId == ResManager.getId("lyTab2")) {
                this.activeTab(2, null);
            } else if (this.activeTabId == ResManager.getId("lyTab3")) {
                this.activeTab(3, null);
            } else if (this.activeTabId == ResManager.getId("lyTab4")) {
                this.activeTab(4, null);
            }
        }
    }

    @Override
    public void onSaveInstence(Bundle outState) {
        outState.putInt(ACTIVE_ID, this.activeTabId);
    }

    public void updateTabText(int index, String text) {
        switch (index) {
            case 1: {
                this.tab1.setText((CharSequence)text);
                break;
            }
            case 2: {
                this.tab1.setText((CharSequence)text);
                break;
            }
            case 3: {
                this.tab1.setText((CharSequence)text);
                break;
            }
            case 4: {
                this.tab1.setText((CharSequence)text);
                break;
            }
        }
        this.cancelAnimation();
    }

    protected void activeTab(int activeTab, String text) {
        if (activeTab == 1) {
            this.activeTab((View)this.lyTab1);
            if (text != null && !"".equals(text)) {
                this.tab1.setText((CharSequence)text);
            }
        } else if (activeTab == 2) {
            this.activeTab((View)this.lyTab2);
            if (text != null && !"".equals(text)) {
                this.tab2.setText((CharSequence)text);
            }
        } else if (activeTab == 3) {
            if (text != null && !"".equals(text)) {
                this.tab3.setText((CharSequence)text);
            }
            this.activeTab((View)this.lyTab3);
        } else if (activeTab == 4) {
            if (text != null && !"".equals(text)) {
                this.tab4.setText((CharSequence)text);
            }
            this.activeTab((View)this.lyTab4);
        }
    }

    protected void activeTab(View activeTab) {
        this.cancelAnimation();
        this.activeTab(activeTab, this.lyTab1);
        this.activeTab(activeTab, this.lyTab2);
        this.activeTab(activeTab, this.lyTab3);
        this.activeTab(activeTab, this.lyTab4);
    }

    protected void activeTab(View activeTab, RelativeLayout loopTab) {
        int fromColor = this.getContext().getResources().getColor(ResManager.getColorId("mid_tab_text_nor"));
        int toColor = this.getContext().getResources().getColor(ResManager.getColorId("gs_tab_white"));
        loopTab.getChildAt(1).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("gs_tab_white")));
        if (activeTab.equals(loopTab)) {
            if (!loopTab.isSelected()) {
                loopTab.setSelected(true);
                ((Button)loopTab.getChildAt(0)).setTextColor(toColor);
                loopTab.getChildAt(1).setVisibility(0);
            }
        } else {
            loopTab.setSelected(false);
            ((Button)loopTab.getChildAt(0)).setTextColor(fromColor);
            loopTab.getChildAt(1).setVisibility(8);
        }
    }

    public void setTabsDefault() {
        this.lyTab1.setSelected(false);
        this.lyTab2.setSelected(false);
        this.lyTab3.setSelected(false);
    }

    @Override
    public void show(boolean b) {
        this.rootView.setVisibility(b ? 0 : 8);
    }

    public int getAcitiveId() {
        return this.activeTabId;
    }

    protected void cancelAnimation() {
    }

    public void showTabs() {
        boolean bShowDoc = PlayerLive.getIns().isShowDoc();
        boolean bShowQa = PlayerLive.getIns().isShowQa();
        boolean bShowChat = PlayerLive.getIns().isShowChat();
        boolean bShowIntro = PlayerLive.getIns().isShowIntro();
        GenseeLog.i((String)("showTabs bShowDoc = " + bShowDoc + " bShowQa = " + bShowQa + " bShowChat = " + bShowChat + " bShowIntro = " + bShowIntro));
        this.lyTab1.setVisibility(bShowDoc ? 0 : 8);
        this.lyTab2.setVisibility(bShowChat ? 0 : 8);
        this.lyTab3.setVisibility(bShowQa ? 0 : 8);
        this.lyTab4.setVisibility(bShowIntro ? 0 : 8);
        if (!bShowDoc) {
            if (bShowChat) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.lyTab2.getLayoutParams();
                lp.leftMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("midtabs_first_margin_left"));
                this.lyTab2.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (bShowQa) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.lyTab3.getLayoutParams();
                lp.leftMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("midtabs_first_margin_left"));
                this.lyTab3.setLayoutParams((ViewGroup.LayoutParams)lp);
            } else if (bShowIntro) {
                LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.lyTab4.getLayoutParams();
                lp.leftMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("midtabs_first_margin_left"));
                this.lyTab4.setLayoutParams((ViewGroup.LayoutParams)lp);
            }
        }
        this.show(PlayerLive.getIns().isShowDoc() || PlayerLive.getIns().isShowChat() || PlayerLive.getIns().isShowQa() || PlayerLive.getIns().isShowIntro());
    }
}

