/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.qa;

import android.os.Bundle;
import android.os.Message;
import android.text.Html;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.holder.qa.BaseQaHolder;
import com.gensee.fastsdk.ui.holder.qa.impl.QaAdapter;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.routine.UserInfo;
import com.gensee.utils.ThreadPool;
import java.util.List;

public class QaSelfHolder
extends BaseQaHolder
implements QaAdapter.OnQaAdapterListener,
AdapterView.OnItemLongClickListener,
View.OnTouchListener {
    private OnQaSelfListener onQaSelfListener;
    private int nowRawX;
    private int nowRawY;

    public void setOnQaSelfListener(OnQaSelfListener onQaSelfListener) {
        this.onQaSelfListener = onQaSelfListener;
    }

    public QaSelfHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void onClick(View v) {
    }

    public void notifyVoiceReplay() {
        if (null != this.adapter) {
            this.adapter.notifyDataSetChanged();
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.findViewById(ResManager.getId("qa_view_layout_root")).setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("chat_bg")));
        this.lvChat.setOnItemLongClickListener(this);
        this.lvChat.setOnTouchListener(this);
        View view = this.findViewById(ResManager.getId("ly_qa_empty"));
        view.setVisibility(0);
        view.setBackground(this.getContext().getResources().getDrawable(ResManager.getColorId("doc_default_bg")));
        this.lvChat.setEmptyView(view);
        this.adapter = new QaAdapter();
        this.adapter.setOnQaAdapterListener(this);
        this.lvChat.setAdapter((ListAdapter)this.adapter);
    }

    public void refreshMsg(int what, List<RtQaMsg> msgList, boolean bLatest) {
        Message message = new Message();
        message.obj = msgList;
        message.what = what;
        Bundle bundle = new Bundle();
        bundle.putBoolean("QALATEST", bLatest);
        message.setData(bundle);
        this.sendMessage(message);
    }

    @Override
    public int getLvWidth() {
        return this.lvChat.getWidth();
    }

    @Override
    public void notifyView(int position, final int nHeight) {
        if (position + 1 == this.lvChat.getLastVisiblePosition()) {
            this.postDelayed(new Runnable(){

                @Override
                public void run() {
                    QaSelfHolder.this.lvChat.smoothScrollByOffset(nHeight);
                }
            }, 200L);
        }
    }

    @Override
    public boolean isAnswerExpand(String answerId) {
        return null != this.onQaSelfListener && this.onQaSelfListener.isAnswerExpand(answerId);
    }

    @Override
    public void setAnswerExpand(String answerId, boolean isExpand) {
        if (null != this.onQaSelfListener) {
            this.onQaSelfListener.setAnswerExpand(answerId, isExpand);
        }
    }

    @Override
    public void show(boolean isShow) {
        this.rootView.setVisibility(isShow ? 0 : 8);
        if (isShow) {
            this.setLvBottom(true);
        }
    }

    @Override
    public void refresh() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                UserInfo self = PlayerLive.getIns().getSelf();
                QaMsgQueue.getIns().onSelfMessageFresh(self == null ? -1L : self.getId());
            }
        });
    }

    @Override
    public void loadMore() {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                UserInfo self = PlayerLive.getIns().getSelf();
                QaMsgQueue.getIns().onSelfMessageLoadMore(self == null ? -1L : self.getId());
            }
        });
    }

    public void resetLvBottom(boolean bTrue) {
        this.setLvBottom(bTrue);
    }

    public boolean onItemLongClick(AdapterView<?> parent, View view, int position, long id) {
        RtQaMsg rtQaMsg = (RtQaMsg)this.adapter.getItem(position - 1);
        String text = rtQaMsg.getAnswer();
        View anchor = view.findViewById(ResManager.getId("qa_answer_content_tv"));
        if (TextUtils.isEmpty((CharSequence)text)) {
            text = rtQaMsg.getQuestion();
            anchor = view.findViewById(ResManager.getId("qa_only_question_content_tv"));
        }
        text = Html.fromHtml((String)text).toString();
        this.showCopyPopupWindow(anchor, false, this.nowRawX, this.nowRawY, text);
        return false;
    }

    public boolean onTouch(View v, MotionEvent event) {
        this.nowRawX = (int)event.getRawX();
        this.nowRawY = (int)event.getRawY();
        return false;
    }

    public static interface OnQaSelfListener {
        public boolean isAnswerExpand(String var1);

        public void setAnswerExpand(String var1, boolean var2);
    }
}

