/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.qa.impl;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.qa.RtQaMsg;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;
import com.gensee.utils.DateUtil;
import com.gensee.utils.StringUtil;

public class QaAdapter
extends AbstractAdapter {
    private OnQaAdapterListener onQaAdapterListener;
    private Context context;

    public void setOnQaAdapterListener(OnQaAdapterListener onQaAdapterListener) {
        this.onQaAdapterListener = onQaAdapterListener;
    }

    protected View createView(Context context) {
        this.context = context;
        return LayoutInflater.from((Context)context).inflate(ResManager.getLayoutId("qa_item_layout"), null);
    }

    protected AbstractViewHolder createViewHolder(View view) {
        return new QaViewHolder(view);
    }

    public static interface OnQaAdapterListener {
        public int getLvWidth();

        public boolean isAnswerExpand(String var1);

        public void setAnswerExpand(String var1, boolean var2);

        public void notifyView(int var1, int var2);
    }

    private class QaViewHolder
    extends AbstractViewHolder {
        private LinearLayout lyOnlyQuestion;
        private TextView tvOnlyQuestionTip;
        private TextView tvOnlyQuestionTime;
        private TextView tvOnlyQuestionContent;
        private LinearLayout lyAnswer;
        private LinearLayout lyAnswer1;
        private LinearLayout lyAnswer2;
        private TextView tvAnswerTip;
        private TextView tvAnswerTime;
        private TextView tvAnswerContent;
        private TextView tvAnswerQuestion;
        private TextView ivAnswerQuestionExpandIv;

        public QaViewHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.lyOnlyQuestion = (LinearLayout)view.findViewById(ResManager.getId("qa_only_question_ly"));
            this.tvOnlyQuestionTip = (TextView)view.findViewById(ResManager.getId("qa_only_question_tip_tv"));
            this.tvOnlyQuestionTime = (TextView)view.findViewById(ResManager.getId("qa_only_question_time_tv"));
            this.tvOnlyQuestionContent = (TextView)view.findViewById(ResManager.getId("qa_only_question_content_tv"));
            this.lyAnswer = (LinearLayout)view.findViewById(ResManager.getId("qa_answer_ly"));
            this.lyAnswer1 = (LinearLayout)view.findViewById(ResManager.getId("qa_answer1_ly"));
            this.lyAnswer2 = (LinearLayout)view.findViewById(ResManager.getId("qa_answer2_ly"));
            this.tvAnswerTip = (TextView)view.findViewById(ResManager.getId("qa_answer_tip_tv"));
            this.tvAnswerTime = (TextView)view.findViewById(ResManager.getId("qa_answer_time_tv"));
            this.tvAnswerContent = (TextView)view.findViewById(ResManager.getId("qa_answer_content_tv"));
            this.tvAnswerQuestion = (TextView)view.findViewById(ResManager.getId("qa_answer_question_content_tv"));
            this.ivAnswerQuestionExpandIv = (TextView)view.findViewById(ResManager.getId("qa_answer_question_expand_iv"));
        }

        private String getString(int resId) {
            return this.lyOnlyQuestion.getContext().getResources().getString(resId);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void initValue(final int positon) {
            int tvWidth;
            float textWidth;
            if (null == QaAdapter.this.onQaAdapterListener) {
                return;
            }
            final RtQaMsg msg = (RtQaMsg)QaAdapter.this.getItem(positon);
            String answer = msg.getAnswer();
            this.tvOnlyQuestionTime.setTextColor(QaAdapter.this.context.getResources().getColor(ResManager.getColorId("qa_item_time")));
            this.tvAnswerTime.setTextColor(QaAdapter.this.context.getResources().getColor(ResManager.getColorId("qa_item_time")));
            this.tvOnlyQuestionTip.setTextColor(QaAdapter.this.context.getResources().getColor(ResManager.getColorId("qa_item_question_tip")));
            this.tvAnswerTip.setTextColor(QaAdapter.this.context.getResources().getColor(ResManager.getColorId("qa_item_question_tip")));
            this.tvOnlyQuestionContent.setTextColor(QaAdapter.this.context.getResources().getColor(ResManager.getColorId("qa_item_content")));
            this.tvAnswerContent.setTextColor(QaAdapter.this.context.getResources().getColor(ResManager.getColorId("qa_item_content")));
            this.tvAnswerQuestion.setTextColor(QaAdapter.this.context.getResources().getColor(ResManager.getColorId("qa_item_answer_question")));
            if (StringUtil.isEmpty((String)answer)) {
                this.lyOnlyQuestion.setVisibility(0);
                this.lyAnswer.setVisibility(8);
                UserInfo self = PlayerLive.getIns().getSelf();
                if (null != self && msg.getQuestOwnerId() == self.getId()) {
                    this.tvOnlyQuestionTip.setText((CharSequence)(this.getString(ResManager.getStringId("gs_chat_me")) + " " + this.getString(ResManager.getStringId("qa_wen"))));
                } else {
                    this.tvOnlyQuestionTip.setText((CharSequence)(GenseeUtils.filterNickName(msg.getQuestOwnerName()) + " " + this.getString(ResManager.getStringId("qa_wen"))));
                }
                long qTime = msg.getQuestTimgstamp();
                if (qTime > 0L) {
                    this.tvOnlyQuestionTime.setText((CharSequence)DateUtil.getStringDateShort((long)qTime).substring(11));
                } else {
                    this.tvOnlyQuestionTime.setText((CharSequence)"");
                }
                this.tvOnlyQuestionContent.setText((CharSequence)msg.getQuestion());
                if (null == QaAdapter.this.onQaAdapterListener) return;
            }
            this.lyOnlyQuestion.setVisibility(8);
            this.lyAnswer.setVisibility(0);
            String sOwnerName = GenseeUtils.filterNickName(msg.getQuestOwnerName());
            UserInfo self = PlayerLive.getIns().getSelf();
            if (null != self && msg.getQuestOwnerId() == self.getId()) {
                sOwnerName = this.getString(ResManager.getStringId("gs_chat_me"));
            }
            String tip = GenseeUtils.filterNickName(msg.getAnswerOwner()) + " " + this.getString(ResManager.getStringId("qa_reply")) + " " + sOwnerName;
            this.tvAnswerTip.setText((CharSequence)tip);
            long qTime = msg.getAnswerTimestamp();
            if (qTime > 0L) {
                this.tvAnswerTime.setText((CharSequence)DateUtil.getStringDateShort((long)qTime).substring(11));
            } else {
                this.tvAnswerTime.setText((CharSequence)"");
            }
            this.tvAnswerContent.setText((CharSequence)msg.getAnswer());
            String wenTip = GenseeUtils.filterNickName(msg.getQuestOwnerName()) + " " + this.getString(ResManager.getStringId("qa_wen")) + ": " + msg.getQuestion();
            if (null != self && msg.getQuestOwnerId() == self.getId()) {
                wenTip = this.getString(ResManager.getStringId("gs_chat_me")) + " " + this.getString(ResManager.getStringId("qa_wen")) + ": " + msg.getQuestion();
            }
            if ((textWidth = this.tvAnswerQuestion.getPaint().measureText(wenTip)) > (float)(tvWidth = QaAdapter.this.onQaAdapterListener.getLvWidth() - 2 * GenseeUtils.getActivityFromView((View)this.tvAnswerContent).getResources().getDimensionPixelSize(ResManager.getDimenId("qa_item_hor")) - 24)) {
                this.ivAnswerQuestionExpandIv.setVisibility(0);
            } else {
                this.ivAnswerQuestionExpandIv.setVisibility(8);
            }
            this.tvAnswerQuestion.setText((CharSequence)wenTip);
            boolean isExpand = QaAdapter.this.onQaAdapterListener.isAnswerExpand(msg.getAnswerTimestamp() + "");
            this.tvAnswerQuestion.setSingleLine(!isExpand);
            this.ivAnswerQuestionExpandIv.setSelected(isExpand);
            this.ivAnswerQuestionExpandIv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    boolean isExpand = QaAdapter.this.onQaAdapterListener.isAnswerExpand(msg.getAnswerTimestamp() + "");
                    QaViewHolder.this.ivAnswerQuestionExpandIv.setSelected(!isExpand);
                    QaViewHolder.this.tvAnswerQuestion.setSingleLine(isExpand);
                    QaAdapter.this.onQaAdapterListener.setAnswerExpand(msg.getAnswerTimestamp() + "", !isExpand);
                    QaAdapter.this.onQaAdapterListener.notifyView(positon, QaViewHolder.this.tvAnswerQuestion.getHeight());
                }
            });
        }
    }
}

