/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.topfloat;

import android.app.Activity;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.IVDClickListener;
import com.gensee.fastsdk.ui.holder.doc.AbstractLiveDocHolder;
import com.gensee.fastsdk.ui.holder.idc.IdcBaseHolder;
import com.gensee.fastsdk.ui.holder.topfloat.AbstractViewTopFloatHolder;
import com.gensee.fastsdk.ui.holder.video.AbstractLiveVideoHolder;
import com.gensee.fastsdk.ui.holder.video.ReceiverLiveVideoHolder;
import com.gensee.fastsdk.ui.view.PopMore;
import com.gensee.fastsdk.ui.view.PopQuality;
import com.gensee.fastsdk.util.AnimationUtils;
import com.gensee.fastsdk.util.GenseeToast;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;

public class LiveTopFloatHolder
extends AbstractViewTopFloatHolder
implements PopMore.OnMoreItemClick,
IVDClickListener,
PlayerLive.OnRoomHandupListener,
PopQuality.OnQualityClick {
    protected static final String TAG = "LiveTopFloatHolder";
    private TextView txtStatus;
    private PopMore popMore;
    private AbstractLiveVideoHolder mVideoHolder;
    private AbstractLiveDocHolder mdDocHolder;
    private int handCount = 0;
    private Runnable handUpdateRunnable;
    private Runnable micTimeRunnable;
    private MyRunnable micVlolumeRun;
    private IVideoDocSwitcher switcher;
    private IdcBaseHolder mIdcHolder;
    private RelativeLayout rlVideoHave;
    private ImageView ivVideoHaveClose;
    private TextView tvVideoHave;
    private boolean isHaveNewHongbao;
    private ImageView imgMic;
    private View linMicBar;
    private ImageView imgDanmaku;
    private View imgQuality;
    private PopQuality popQuality;
    private boolean isHD = true;
    private boolean bTitleBarExit = false;
    private Runnable videoHaveRunnable = new Runnable(){

        @Override
        public void run() {
            LiveTopFloatHolder.this.rlVideoHave.setVisibility(8);
        }
    };

    public LiveTopFloatHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void setVideoHolder(AbstractLiveVideoHolder holder) {
        this.mVideoHolder = holder;
        this.mVideoHolder.setVDListener(this);
    }

    public void setDocHolder(AbstractLiveDocHolder holder) {
        this.mdDocHolder = holder;
        this.mdDocHolder.setVDLisener(this);
    }

    public void setIdcHolder(IdcBaseHolder idcHolder) {
        this.mIdcHolder = idcHolder;
    }

    @Override
    public void onClick(View v) {
        super.onClick(v);
        if (v.getId() == ResManager.getId("video_have_close_iv")) {
            this.rlVideoHave.setVisibility(8);
            this.removeCallbacks(this.videoHaveRunnable);
        } else if (v.getId() == ResManager.getId("imgDanmaku")) {
            this.imgDanmaku.setSelected(!this.imgDanmaku.isSelected());
            ((LiveActivity)this.getContext()).showDanmaku(this.imgDanmaku.isSelected());
        } else if (v.getId() == ResManager.getId("imgMore")) {
            this.showMoreWindow(v);
        } else if (v.getId() == ResManager.getId("gs_imgMic")) {
            PlayerLive.getIns().acceptOpenMic(false);
        } else if (v.getId() == ResManager.getId("imgQuality")) {
            this.showQualityWindow(v);
        }
    }

    public void showQualityWindow(View v) {
        if (this.bTitleBarExit) {
            return;
        }
        this.popQuality = new PopQuality(this.getContext(), this, this.isHD);
        this.popQuality.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                LiveTopFloatHolder.this.mVideoHolder.delayDismissFloatBtns();
            }
        });
        if (!this.popQuality.isShowing()) {
            this.popQuality.showWindow(v);
            if (this.isTop(1)) {
                this.mVideoHolder.continueShowBtn();
            } else {
                this.mdDocHolder.continueShowBtn();
            }
        }
    }

    public void processSmallVideoPosition() {
        if (this.mVideoHolder instanceof ReceiverLiveVideoHolder) {
            ((ReceiverLiveVideoHolder)this.mVideoHolder).setBottomAndLeftMargin(0, 0);
        }
    }

    public void showMoreWindow(View v) {
        if (this.bTitleBarExit) {
            return;
        }
        boolean isMoreBtn = v.getId() == ResManager.getId("imgMore");
        this.popMore = new PopMore(this.getContext(), this, PlayerLive.getIns().getExtraGSMoreItems());
        this.popMore.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                LiveTopFloatHolder.this.mVideoHolder.delayDismissFloatBtns();
            }
        });
        if (!this.popMore.isShowing()) {
            this.popMore.showWindow((View)this.imgMore, true);
            if (isMoreBtn) {
                if (this.isTop(1)) {
                    this.mVideoHolder.continueShowBtn();
                } else {
                    this.mdDocHolder.continueShowBtn();
                }
            }
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.switcher = (IVideoDocSwitcher)value;
        this.titleBar = this.findViewById(ResManager.getId("titleLayout"));
        this.imgBack = (ImageView)this.titleBar.findViewById(ResManager.getId("imgBack"));
        this.imgMore = (ImageView)this.titleBar.findViewById(ResManager.getId("imgMore"));
        this.txtTitle = (TextView)this.titleBar.findViewById(ResManager.getId("gs_tv_title"));
        this.txtStatus = (TextView)this.titleBar.findViewById(ResManager.getId("gs_tv_topState"));
        this.imgBack.setOnClickListener((View.OnClickListener)this);
        this.imgMore.setOnClickListener((View.OnClickListener)this);
        this.rlVideoHave = (RelativeLayout)this.findViewById(ResManager.getId("video_have_rl"));
        this.tvVideoHave = (TextView)this.findViewById(ResManager.getId("video_have_tv"));
        this.ivVideoHaveClose = (ImageView)this.findViewById(ResManager.getId("video_have_close_iv"));
        this.ivVideoHaveClose.setOnClickListener((View.OnClickListener)this);
        this.imgDanmaku = (ImageView)this.findViewById(ResManager.getId("imgDanmaku"));
        this.imgDanmaku.setSelected(false);
        this.imgDanmaku.setOnClickListener((View.OnClickListener)this);
        boolean isShowDanmu = PlayerLive.getIns().isShowDanmuBtn() && PlayerLive.getIns().isShowChat();
        this.imgDanmaku.setVisibility(isShowDanmu ? 0 : 8);
        this.imgQuality = this.findViewById(ResManager.getId("imgQuality"));
        this.imgQuality.setOnClickListener((View.OnClickListener)this);
        PlayerLive.getIns().setOnRoomHandupListener(this);
        this.linMicBar = this.findViewById(ResManager.getId("gs_linMicBar"));
        this.imgMic = (ImageView)this.linMicBar.findViewById(ResManager.getId("gs_imgMic"));
        this.imgMic.setOnClickListener((View.OnClickListener)this);
    }

    public void updateTitle(String title) {
        if (!TextUtils.isEmpty((CharSequence)title)) {
            title = GenseeUtils.formatText(title, 8);
        }
        this.txtTitle.setText((CharSequence)title);
    }

    private void showHand() {
        this.mVideoHolder.setImageHandVisible(true);
        this.mdDocHolder.setImageHandVisible(true);
    }

    @Override
    public void showFullScreen(boolean isFull) {
        if (isFull) {
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.getFullParam());
        } else {
            this.rootView.setLayoutParams((ViewGroup.LayoutParams)this.getTopLayoutParam());
        }
        PreferUtil.getIns().putInt("KEY_PIP_TOP_MARGIN", -1);
        PreferUtil.getIns().putInt("KEY_PIP_LEFT_MARGIN", -1);
        super.showFullScreen(isFull);
    }

    public void receiveState(int state) {
        if (this.txtStatus == null) {
            this.txtStatus.setVisibility(8);
            return;
        }
        this.txtStatus.setVisibility(0);
        if (state == 0) {
            this.txtStatus.setText(ResManager.getStringId("gs_cast_status_notstart"));
        } else if (state == 1) {
            this.showHand();
            this.txtStatus.setText(ResManager.getStringId("gs_cast_status_ing"));
        } else if (state == 2) {
            this.txtStatus.setText(ResManager.getStringId("gs_cast_status_pause"));
            this.showHand();
        } else if (state == 3) {
            this.txtStatus.setText(ResManager.getStringId("gs_cast_status_end"));
        }
        if (null != this.mVideoHolder) {
            ((ReceiverLiveVideoHolder)this.mVideoHolder).updateStatus(state);
        }
    }

    public void dismissPopMore() {
        if (null != this.popMore && this.popMore.isShowing()) {
            this.popMore.dismiss();
            this.popMore = null;
        }
        if (null != this.popQuality && this.popQuality.isShowing()) {
            this.popQuality.dismiss();
            this.popQuality = null;
        }
    }

    public void showAutoCloseTip(final String msg, final boolean needAutoClose) {
        this.post(new Runnable(){

            @Override
            public void run() {
                LiveTopFloatHolder.this.removeCallbacks(LiveTopFloatHolder.this.videoHaveRunnable);
                LiveTopFloatHolder.this.tvVideoHave.setText((CharSequence)msg);
                LiveTopFloatHolder.this.rlVideoHave.setVisibility(0);
                if (needAutoClose) {
                    LiveTopFloatHolder.this.postDelayed(LiveTopFloatHolder.this.videoHaveRunnable, 5000L);
                }
                LiveTopFloatHolder.this.ivVideoHaveClose.setVisibility(needAutoClose ? 0 : 4);
            }
        });
    }

    @Override
    public void onRoomHandup(boolean onHandup) {
        this.onHandup(onHandup);
    }

    private void onHandup(boolean isHandup) {
        if (isHandup) {
            this.handCount = PreferUtil.getIns().getInt("HAND_STATUS");
            if (this.handCount <= 0) {
                this.handCount = 60;
            } else {
                PreferUtil.getIns().putInt("HAND_STATUS", -1);
            }
            this.removeCallbacks(this.handUpdateRunnable);
            this.updateHandTime(0L);
        } else {
            this.removeCallbacks(this.handUpdateRunnable);
            this.handCount = 0;
            this.mVideoHolder.updateHand("", false);
            this.mdDocHolder.updateHand("", false);
        }
    }

    private void updateHandTime(long delay) {
        if (this.handUpdateRunnable == null) {
            this.handUpdateRunnable = new Runnable(){

                @Override
                public void run() {
                    GenseeLog.d((String)LiveTopFloatHolder.TAG, (String)("updateHandTime " + LiveTopFloatHolder.this.handCount));
                    if (LiveTopFloatHolder.this.isTop(1)) {
                        LiveTopFloatHolder.this.mVideoHolder.updateHand(String.valueOf(LiveTopFloatHolder.this.handCount), true);
                    } else {
                        LiveTopFloatHolder.this.mdDocHolder.updateHand(String.valueOf(LiveTopFloatHolder.this.handCount), true);
                    }
                    if (LiveTopFloatHolder.this.handCount > 0) {
                        LiveTopFloatHolder.this.handCount--;
                        LiveTopFloatHolder.this.postDelayed(this, 1000L);
                    } else {
                        PlayerLive.getIns().roomHandlUp(false);
                    }
                }
            };
        }
        this.postDelayed(this.handUpdateRunnable, delay);
    }

    @Override
    public void layoutRestore() {
        if (null != this.mdDocHolder) {
            RelativeLayout.LayoutParams bottomParam = this.mdDocHolder.getLayoutParam();
            if ((this.uimode & 1) == 1) {
                this.mVideoHolder.showFullScreen();
                this.mVideoHolder.showVideoFloatBtn(3);
                this.mdDocHolder.showDocFloatBtn(3);
                this.mdDocHolder.showFullScreen();
                if ((this.uimode & 2) == 2) {
                    this.mVideoHolder.show(true);
                    this.mdDocHolder.show(false);
                } else {
                    this.mVideoHolder.show(false);
                    this.mdDocHolder.show(true);
                }
            } else if ((this.uimode & 4) == 4) {
                this.mVideoHolder.layout(this.getTopLayoutParam());
                this.mVideoHolder.showVideoFloatBtn(1);
                this.mdDocHolder.layout(bottomParam);
                this.mdDocHolder.showDocFloatBtn(2);
            } else {
                this.mVideoHolder.layout(bottomParam);
                this.mVideoHolder.showVideoFloatBtn(2);
                this.mdDocHolder.show(true);
                this.mdDocHolder.showDocFloatBtn(1);
                this.mdDocHolder.layout(this.getTopLayoutParam());
            }
        }
    }

    @Override
    public void onItemSendErrorMsg() {
        GenseeUtils.directSendLog(this.getContext(), false);
    }

    @Override
    public boolean isTop(int type) {
        int uimode = this.getUIMode();
        if (type == 2) {
            if ((uimode & 1) == 1) {
                return (uimode & 2) != 2;
            }
            return (uimode & 4) != 4;
        }
        if (type == 1) {
            if ((uimode & 1) == 1) {
                return (uimode & 2) == 2;
            }
            return (uimode & 4) == 4;
        }
        return false;
    }

    public boolean onBackNorScreen() {
        GenseeLog.i((String)TAG, (String)"onBackNorScreen");
        Activity act = (Activity)this.getContext();
        if ((this.uimode & 1) == 1) {
            this.uimode &= 0xFFFFFFFE;
            if (act.getRequestedOrientation() == 1) {
                ((LiveActivity)this.getContext()).showNorScreen(this.uimode);
            } else {
                act.setRequestedOrientation(1);
            }
            this.mVideoHolder.continueShowBtn();
            this.mVideoHolder.delayDismissFloatBtns();
            this.mdDocHolder.continueShowBtn();
            this.mdDocHolder.delayDismissFloatBtns();
            this.imgMore.setVisibility(0);
            return true;
        }
        return false;
    }

    @Override
    public void onQuality(boolean isHD) {
        this.isHD = isHD;
        this.imgQuality.setSelected(!isHD);
        PlayerLive.getIns().switchQuality(isHD);
    }

    @Override
    public void onSelectIdc() {
        if (null != this.mIdcHolder) {
            this.mIdcHolder.selectIdc();
        }
    }

    @Override
    public void onSelectCloseVideo(View v) {
        if (null != this.mVideoHolder) {
            this.mVideoHolder.onSelectCloseVideo(v);
        }
    }

    @Override
    public void onFloatBtnShow(int type, int visibility) {
        if (this.isTop(type)) {
            if (visibility == 0) {
                this.bTitleBarExit = false;
                this.onTitleBarShow();
            } else if (this.titleBar.getVisibility() != 8) {
                this.bTitleBarExit = true;
                AnimationUtils.enterBottom2Up(this.titleBar);
            }
        }
    }

    private void onTitleBarShow() {
        if (this.titleBar.getVisibility() != 0) {
            this.titleBar.setVisibility(0);
            AnimationUtils.enterUp2Bottom(this.titleBar);
        }
    }

    @Override
    public void onFullContentSwitch(int type) {
        int uimode = this.getUIMode();
        if ((uimode & 2) == 2) {
            this.updateUIMode(2, false);
            this.mVideoHolder.show(false);
            this.mdDocHolder.updateHand("" + this.handCount, this.handCount != 0);
            this.mdDocHolder.showFullScreen();
            this.mdDocHolder.show(true);
            this.mdDocHolder.continueShowBtn();
            this.mdDocHolder.delayDismissFloatBtns();
        } else {
            this.updateUIMode(2, true);
            this.mdDocHolder.show(false);
            this.mVideoHolder.updateHand("" + this.handCount, this.handCount != 0);
            this.mVideoHolder.showFullScreen();
            this.mVideoHolder.show(true);
            this.mVideoHolder.continueShowBtn();
            this.mVideoHolder.delayDismissFloatBtns();
        }
    }

    @Override
    public void onSwitchToFull(int type) {
        GenseeLog.i((String)TAG, (String)("onSwitchToFull type:" + type + ",uimode:" + this.uimode));
        if ((this.uimode & 1) == 1) {
            this.onBackNorScreen();
            return;
        }
        this.updateUIMode(2, type == 1);
        if (type == 1) {
            this.mVideoHolder.updateHand("" + this.handCount, this.handCount != 0);
        } else {
            this.mdDocHolder.updateHand("" + this.handCount, this.handCount != 0);
        }
        if (this.mCurrentOrient == 1) {
            ((LiveActivity)this.getContext()).showFullScreen(this.getUIMode());
            ((LiveActivity)this.getContext()).showNorScreen(this.getUIMode());
        } else {
            ((Activity)this.getContext()).setRequestedOrientation(0);
        }
    }

    public void onAudioMicOpen() {
        this.post(new Runnable(){

            @Override
            public void run() {
                GenseeToast.showToast(LiveTopFloatHolder.this.getContext(), LiveTopFloatHolder.this.getString(ResManager.getStringId("gs_audio_opened")), true, ResManager.getDrawableId("gs_warming_bg"), 0);
                LiveTopFloatHolder.this.mVideoHolder.onMicOpen();
                LiveTopFloatHolder.this.linMicBar.setVisibility(0);
            }
        });
    }

    public void onAudioMicClose() {
        this.post(new Runnable(){

            @Override
            public void run() {
                LiveTopFloatHolder.this.linMicBar.setVisibility(8);
                GenseeToast.showToast(LiveTopFloatHolder.this.getContext(), LiveTopFloatHolder.this.getString(ResManager.getStringId("gs_audio_closed")), true, ResManager.getDrawableId("gs_warming_bg"), 0);
            }
        });
    }

    public void onAudioMicInvite(final boolean bOpen) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (bOpen) {
                    ((BaseActivity)LiveTopFloatHolder.this.getContext()).showDialog("", LiveTopFloatHolder.this.getString(ResManager.getStringId("gs_reminder_open_mic_normal")), LiveTopFloatHolder.this.getString(ResManager.getStringId("gs_accept_mic_refuse")), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PlayerLive.getIns().micControl(false);
                            PlayerLive.getIns().restoreVideoCameraInvite();
                        }
                    }, LiveTopFloatHolder.this.getString(ResManager.getStringId("gs_accept_mic_open")), new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                            dialog.dismiss();
                            PlayerLive.getIns().micControl(true);
                            PlayerLive.getIns().restoreVideoCameraInvite();
                        }
                    }, null);
                } else {
                    ((BaseActivity)LiveTopFloatHolder.this.getContext()).cancelCustomDialog();
                    PlayerLive.getIns().restoreVideoCameraInvite();
                }
            }
        });
    }

    public static interface IVideoDocSwitcher {
        public void onVideoTop(boolean var1);
    }

    abstract class MyRunnable
    implements Runnable {
        protected int intTmp;

        MyRunnable() {
        }
    }
}

