/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.video;

import android.app.Activity;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseWatchActivity;
import com.gensee.fastsdk.ui.LiveActivity;
import com.gensee.fastsdk.ui.holder.IVDClickListener;
import com.gensee.fastsdk.ui.holder.ReceiverLocalVideoHolder;
import com.gensee.fastsdk.ui.holder.vdbar.ReceiverVDBarHolder;
import com.gensee.fastsdk.ui.holder.video.AbstractLiveVideoHolder;
import com.gensee.fastsdk.ui.holder.video.VideoViewTouchHolder;
import com.gensee.fastsdk.ui.view.PipViewTouchHolder;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.media.IVideoIndication;
import com.gensee.utils.GenseeLog;
import com.gensee.view.GSVideoViewEx;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;

public class ReceiverLiveVideoHolder
extends AbstractLiveVideoHolder
implements VideoViewTouchHolder.OnVideoViewTouchListener,
PlayerLive.OnLocalVideoListener,
ReceiverVDBarHolder.OnVdBarListener,
PipViewTouchHolder.OnPipFullScreenSmallListener,
PlayerLive.OnAudioVideoListener {
    protected static final String TAG = "ReceiverLiveVideoHolder";
    private GSVideoViewEx mVideoView;
    private View txtVideoDef;
    private ReceiverLocalVideoHolder receiverLocalVideoHolder;
    private PipViewTouchHolder mPipViewTouchHolder;
    private RelativeLayout rlActived;
    private AtomicBoolean bResume = new AtomicBoolean(false);
    private RelativeLayout mRlAllVideoView;
    private ImageView mPipSwitch;
    private ReceiverVDBarHolder mVdBarHolder;
    private boolean bReceiverAudioNotify = false;
    private boolean bReceiverVideoNotify = false;
    private boolean bReceiverAvCaching = false;
    private ImageView imgAudioDefView;
    private View defView;
    private View mPauseView;
    private boolean isPIPVideo;
    private View livePauseTv;
    private View llHaveNoVideo;
    private boolean bVideoSwitchClicke;
    private boolean isShowLoadingView;

    public ReceiverLiveVideoHolder(View rootView, Object value) {
        super(rootView, value);
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("iv_pip_switch")) {
            this.mVdBarHolder.getListener().onFullContentSwitch(1);
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        super.initComp(value);
        this.mRlAllVideoView = (RelativeLayout)this.findViewById(ResManager.getId("rlVideoView"));
        this.mPipSwitch = (ImageView)this.findViewById(ResManager.getId("iv_pip_switch"));
        this.mPipSwitch.setOnClickListener((View.OnClickListener)this);
        this.mVideoView = (GSVideoViewEx)this.findViewById(ResManager.getId("videoView"));
        ((BaseWatchActivity)this.getContext()).setVideoView((IVideoIndication)this.mVideoView);
        this.txtVideoDef = this.findViewById(ResManager.getId("txtVideoDef"));
        this.mRlAllVideoView.setLongClickable(true);
        this.showVideoDefTxt(false);
        this.mPipViewTouchHolder = new PipViewTouchHolder(this.rootView, value);
        this.mPipViewTouchHolder.setOnVideoViewTouchListener(this);
        this.mPipViewTouchHolder.setOnPadFullScreenSmallListener(this);
        this.mRlAllVideoView.setOnTouchListener((View.OnTouchListener)this.mPipViewTouchHolder);
        this.mVdBarHolder = new ReceiverVDBarHolder(this.getRootView(), null);
        this.mVdBarHolder.setOnVdBarListener(this);
        this.rlActived = (RelativeLayout)this.findViewById(ResManager.getId("actived_rl"));
        PlayerLive.getIns().setOnLocalVideoListener(this);
        this.imgAudioDefView = (ImageView)this.findViewById(ResManager.getId("ivAudioDef"));
        this.imgAudioDefView.setSelected(false);
        this.defView = this.findViewById(ResManager.getId("relDef"));
        PlayerLive.getIns().setOnAudioVideoListener(this);
        this.mPauseView = this.findViewById(ResManager.getId("live_pause_ly"));
        this.livePauseTv = this.findViewById(ResManager.getId("live_pause_tv"));
        this.llHaveNoVideo = this.findViewById(ResManager.getId("ll_have_no_video"));
        PreferUtil.getIns().putBoolean("KEY_VIDEO_CLOSED", false);
    }

    public boolean isReceiverVideoNotify() {
        return this.bReceiverVideoNotify;
    }

    public void setBottomAndLeftMargin(int bottomMargin, int leftMargin) {
        this.receiverLocalVideoHolder.setBottomAndLeftMargin(bottomMargin, leftMargin);
    }

    public void renderDefault() {
        this.mVideoView.renderDefault();
    }

    private void setImgAudoiDefViewSelect(boolean bSelect) {
        this.imgAudioDefView.setSelected(bSelect);
    }

    @Override
    public void layout(RelativeLayout.LayoutParams p) {
        super.layout(p);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this.showVideoView(true);
            }
        }, 50L);
    }

    @Override
    public IVideoIndication getVideoView() {
        return this.mVideoView;
    }

    @Override
    public void showFullScreen() {
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
        this.showVideoView(true);
        this.mVdBarHolder.selectImgFullScreen(true);
        this.mPipSwitch.setVisibility(8);
    }

    public void showNormalScreen() {
        this.mPipSwitch.setVisibility(8);
    }

    @Override
    public void show(boolean isShow) {
        GenseeLog.d((String)TAG, (String)("show isShow = " + isShow));
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        this.imgAudioDefView.setSelected(true);
        this.isPIPVideo = false;
        this.livePauseTv.setVisibility(0);
        if ((uiMode & 1) == 1 && PlayerLive.getIns().isShowPIP() && PlayerLive.getIns().isShowDoc() && (uiMode & 2) != 2) {
            isShow = true;
            this.isPIPVideo = true;
            this.showPIPVideoSmallView();
            this.imgAudioDefView.setSelected(false);
            this.livePauseTv.setVisibility(8);
        }
        this.showVideoView(isShow);
        super.show(isShow);
    }

    private void showPIPVideoSmallView() {
        View docView;
        int docViewIndex;
        RelativeLayout relRoot = (RelativeLayout)this.rootView.getParent();
        int videoViewIndex = relRoot.indexOfChild(this.rootView);
        if (videoViewIndex <= (docViewIndex = relRoot.indexOfChild(docView = relRoot.findViewById(ResManager.getId("docLayout"))))) {
            relRoot.removeView(this.rootView);
            relRoot.addView(this.rootView, docViewIndex);
        }
        DisplayMetrics mDisplayMetrics = new DisplayMetrics();
        ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getMetrics(mDisplayMetrics);
        int nScreenWidth = mDisplayMetrics.widthPixels >= mDisplayMetrics.heightPixels ? mDisplayMetrics.widthPixels : mDisplayMetrics.heightPixels;
        int nScreenHeight = mDisplayMetrics.widthPixels >= mDisplayMetrics.heightPixels ? mDisplayMetrics.heightPixels : mDisplayMetrics.widthPixels;
        int nViewWidth = (int)((double)nScreenWidth * 0.3);
        int nViewHeight = nViewWidth * 9 / 16;
        RelativeLayout.LayoutParams mNormalLayoutParam = new RelativeLayout.LayoutParams(-1, -1);
        mNormalLayoutParam.width = nViewWidth;
        mNormalLayoutParam.height = nViewHeight;
        mNormalLayoutParam.leftMargin = PreferUtil.getIns().getInt("KEY_PIP_LEFT_MARGIN", -1);
        if (mNormalLayoutParam.leftMargin == -1) {
            mNormalLayoutParam.leftMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("pip_left_margin"));
        }
        mNormalLayoutParam.topMargin = PreferUtil.getIns().getInt("KEY_PIP_TOP_MARGIN", -1);
        Activity act = (Activity)this.getContext();
        if (act.getRequestedOrientation() == 1) {
            nScreenHeight = mDisplayMetrics.heightPixels;
        }
        if (mNormalLayoutParam.topMargin == -1) {
            mNormalLayoutParam.topMargin = nScreenHeight - this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("pip_bottom_margin")) - nViewHeight;
        }
        this.layout(mNormalLayoutParam);
        this.mPipViewTouchHolder.initPosition(mNormalLayoutParam.leftMargin, mNormalLayoutParam.topMargin);
        this.mPipSwitch.setVisibility(0);
        this.dismissOwnBtn();
    }

    private void showVideoDefTxt(boolean isShow) {
        this.txtVideoDef.setVisibility(8);
    }

    @Override
    public void onHandClick() {
    }

    @Override
    public void onRewardClick() {
    }

    @Override
    public void onShowFloatTitle(int visibility) {
        this.mVdBarHolder.getListener().onFloatBtnShow(1, visibility);
    }

    @Override
    public void onShowInputDialog() {
        ((LiveActivity)this.getContext()).showInputDialog();
    }

    @Override
    public void onRoomJoinSuccess() {
        this.showVideoDefTxt(true);
        this.setReceiverLocalTextureVideoView();
        this.switchVideoView(false);
        this._processHaveAudioOpen();
    }

    @Override
    public void onRoomReconnect() {
        this.showVideoDefTxt(false);
        this.showVideoSwitchBtn(false);
        this.bReceiverAudioNotify = false;
        this.bReceiverVideoNotify = false;
        this._processHaveAudioOpen();
    }

    public void onVideoStart() {
        this.showVideoView(true);
        this.renderDefault();
        this.showDefView(false);
        this._processHaveAudioOpen();
    }

    public void onVideoEnd() {
        this.bReceiverVideoNotify = false;
        this.showDefView(true);
        this.bReceiverVideoNotify = false;
        this._processHaveAudioOpen();
    }

    private void showDefView(boolean isShow) {
        this.defView.setVisibility(isShow ? 0 : 4);
    }

    @Override
    public void onMicOpen() {
    }

    private void switchVideoView(boolean bVisible) {
        this.showVideoView(!bVisible);
    }

    private void showVideoView(boolean bVisible) {
        boolean bCurVisible = bVisible;
        this.mRlAllVideoView.setVisibility(bCurVisible ? 0 : 8);
        if (this.mRlAllVideoView.getVisibility() == 0) {
            ViewGroup.LayoutParams vl = this.mRlAllVideoView.getLayoutParams();
            vl.width = this.rootView.getLayoutParams().width;
            vl.height = this.rootView.getLayoutParams().height;
            this.mRlAllVideoView.setLayoutParams(vl);
        }
    }

    @Override
    public void setOrientation(int orientation) {
        if (null != this.receiverLocalVideoHolder) {
            this.receiverLocalVideoHolder.setOrientation(orientation);
        }
        this.show(this.rootView.getVisibility() == 0);
    }

    @Override
    public void onResume() {
        this.bResume.set(true);
        if (PlayerLive.getIns().isVideoCameraOpen()) {
            this.activedSelf(false);
        } else {
            this.receiverLocalVideoHolder.restoreView();
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.receiverLocalVideoHolder.getRootView().getLayoutParams();
            lp.width = 1;
            lp.height = 1;
            this.receiverLocalVideoHolder.getRootView().setLayoutParams((ViewGroup.LayoutParams)lp);
        }
        this.bReceiverAudioNotify = false;
        this.bReceiverVideoNotify = false;
        this._processHaveAudioOpen();
    }

    public void activedSelf(boolean bSelfActived) {
        if (null != this.receiverLocalVideoHolder) {
            if (!this.bResume.get()) {
                return;
            }
            if (PlayerLive.getIns().isVideoCameraOpen()) {
                this.receiverLocalVideoHolder.show(true);
            }
            this.rlActived.removeView(this.receiverLocalVideoHolder.getRootView());
            this.receiverLocalVideoHolder.restoreView();
        }
    }

    @Override
    public void onStop() {
        this.bResume.set(false);
        this.rlActived.removeAllViews();
        this.receiverLocalVideoHolder.removeView();
    }

    @Override
    public void onDestroy() {
        if (null != this.receiverLocalVideoHolder.getlocalTextureVideoView()) {
            // empty if block
        }
    }

    public void setReceiverLocalVideoHolder(ReceiverLocalVideoHolder receiverLocalVideoHolder) {
        this.receiverLocalVideoHolder = receiverLocalVideoHolder;
    }

    private void setReceiverLocalTextureVideoView() {
        PlayerLive.getIns().setLocalTextureVideoView(null);
        if (null != this.receiverLocalVideoHolder) {
            this.receiverLocalVideoHolder.setLocalTextureVideoView();
        }
    }

    @Override
    public void onLocalVideoOpen() {
        if (!this.bResume.get()) {
            return;
        }
        this.receiverLocalVideoHolder.onVideoOpen();
    }

    @Override
    public void onLocalVideoClose() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this.receiverLocalVideoHolder.initDefaultPosition();
            }
        });
        if (!this.bResume.get()) {
            return;
        }
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this.receiverLocalVideoHolder.show(false);
            }
        });
    }

    public void initReceiverLocalPosition() {
        this.receiverLocalVideoHolder.initDefaultPosition();
    }

    @Override
    public void showVideoFloatBtn(int nValue) {
        this.mVdBarHolder.showVideoFloatBtn(nValue);
    }

    public void setFloatBottomBtnsVisible(boolean isShow) {
        this.mVdBarHolder.setFloatBottomBtnsVisible(isShow);
    }

    public void setFloatRightBtnsVisible(boolean isShow) {
        this.mVdBarHolder.setFloatRightBtnsVisible(isShow);
    }

    @Override
    public void dismisssFloatBtns() {
    }

    private void showVideoSwitchBtn(boolean bVisible) {
    }

    @Override
    public void setVDListener(IVDClickListener listener) {
        this.mVdBarHolder.setVDListener(listener);
    }

    @Override
    public void delayDismissFloatBtns() {
        this.mVdBarHolder.delayDismissFloatBtns();
    }

    @Override
    public void continueShowBtn() {
        this.mVdBarHolder.continueShowBtn();
    }

    @Override
    public void delayDismissFloatBottomBtns() {
        this.mVdBarHolder.delayDismissFloatBottomBtns();
    }

    @Override
    public void continueShowBottomBtns() {
        this.mVdBarHolder.continueShowBottomBtns();
    }

    @Override
    public void dismissOwnBtn() {
        this.mVdBarHolder.dismissOwnBtn();
    }

    @Override
    public void setImageHandVisible(boolean bVisible) {
        this.mVdBarHolder.setImageHandVisible(bVisible);
    }

    public void showRewardBtn(boolean isShow) {
        this.mVdBarHolder.showRewardBtn(isShow);
    }

    @Override
    public void updateHand(String sVaule, boolean bValue) {
        this.mVdBarHolder.updateHand(sVaule, bValue);
    }

    @Override
    public boolean isTouch() {
        if (this.mVdBarHolder.getListener() == null) {
            return false;
        }
        int uimode = this.mVdBarHolder.getListener().getUIMode();
        if ((uimode & 1) != 1) {
            return false;
        }
        return (uimode & 2) == 2;
    }

    @Override
    public void onVideoViewSingleClick() {
        if (this.isPIPVideo) {
            return;
        }
        this.mVdBarHolder.showFloatBtns();
    }

    @Override
    public void onVideoViewDoubleClick() {
        long nCurrentTime = Calendar.getInstance().getTimeInMillis();
        long l = nCurrentTime - this.mVdBarHolder.nLastTime;
        this.mVdBarHolder.getClass();
        if (l >= 500L) {
            this.onSwitchToFullScreen();
            this.mVdBarHolder.nLastTime = nCurrentTime;
        }
    }

    private void processLoadingView(boolean bTrue) {
        this.isShowLoadingView = bTrue;
        this.mVdBarHolder.showDefView(bTrue);
        ((LiveActivity)this.getContext()).showLinLoadPbView(bTrue);
    }

    public void processLoadingViewStatus(boolean bTrue) {
        this.isShowLoadingView = false;
        this.processHaveNoVideo();
    }

    @Override
    public void onSwitchToFullScreen() {
        this.mVdBarHolder.getListener().onSwitchToFull(1);
    }

    private boolean isIFrame(byte[] data) {
        int frameType = data[4] & 0x1F;
        return frameType == 7 || frameType == 8;
    }

    @Override
    public void onSelectCloseVideo(View v) {
        GenseeLog.i((String)TAG, (String)"CloseVideo button onClick");
        if (v.isSelected()) {
            v.setSelected(false);
            PlayerLive.getIns().setVideoClose(false);
        } else {
            v.setSelected(true);
            PlayerLive.getIns().setVideoClose(true);
        }
        PreferUtil.getIns().putBoolean("KEY_VIDEO_CLOSED", v.isSelected());
        this.processHaveNoVideo();
    }

    private void _processHaveAudioOpen() {
        this.processHaveNoVideo();
        boolean isNoNet = ((LiveActivity)this.getContext()).isNoNet();
        if (isNoNet) {
            return;
        }
        if (((LiveActivity)this.getContext()).getLiveStatus() == 2) {
            this.bReceiverVideoNotify = false;
            this.bReceiverVideoNotify = false;
            this.mPauseView.setVisibility(0);
            this.processLoadingView(false);
            this.mVdBarHolder.showAudioDefView(false);
            return;
        }
        this.mPauseView.setVisibility(8);
        if (!this.bResume.get()) {
            this.processLoadingView(true);
            this.mVdBarHolder.showAudioDefView(false);
            return;
        }
        if (this.bReceiverAudioNotify && !this.bReceiverVideoNotify) {
            this.processLoadingView(false);
            this.mVdBarHolder.showAudioDefView(true);
        } else if (!this.bReceiverVideoNotify && !this.bReceiverAudioNotify) {
            this.processLoadingView(true);
            this.mVdBarHolder.showAudioDefView(false);
        } else {
            this.processLoadingView(false);
            this.mVdBarHolder.showAudioDefView(false);
        }
    }

    public void processHaveNoVideo() {
        boolean isVideoClose = PreferUtil.getIns().getBoolean("KEY_VIDEO_CLOSED");
        if (PlayerLive.getIns().getLiveStatus() == 3 && !this.isShowLoadingView) {
            this.llHaveNoVideo.setVisibility(isVideoClose ? 0 : 8);
        } else {
            this.llHaveNoVideo.setVisibility(8);
        }
    }

    private void processHaveAudioOpen() {
        this.post(new Runnable(){

            @Override
            public void run() {
                ReceiverLiveVideoHolder.this._processHaveAudioOpen();
            }
        });
    }

    @Override
    public void onReceiverAudio() {
        if (!this.bReceiverAudioNotify) {
            GenseeLog.d((String)TAG, (String)(" onReceiverAudio bReceiverAudioNotify = " + this.bReceiverAudioNotify));
            this.bReceiverAudioNotify = true;
            this.processHaveAudioOpen();
        }
    }

    @Override
    public void onReceiverVideo() {
        if (!this.bReceiverVideoNotify && !this.bReceiverAvCaching) {
            GenseeLog.d((String)TAG, (String)(" onReceiverVideo bReceiverVideoNotify = " + this.bReceiverVideoNotify));
            this.bReceiverVideoNotify = true;
            this.processHaveAudioOpen();
        }
    }

    @Override
    public void onCaching(boolean isCaching) {
        GenseeLog.d((String)TAG, (String)(" onCaching isCaching = " + isCaching));
        if (isCaching) {
            this.bReceiverVideoNotify = false;
            this.bReceiverAudioNotify = false;
        }
        this.bReceiverAvCaching = isCaching;
        this.processHaveAudioOpen();
    }

    public void updateStatus(int status) {
        this.setImgAudoiDefViewSelect(status != 0);
        this._processHaveAudioOpen();
    }

    @Override
    public boolean isMove() {
        int uiMode = ((LiveActivity)this.getContext()).getUIMode();
        return (uiMode & 1) == 1 && (uiMode & 2) != 2;
    }

    @Override
    public void onFullScreenSmallMoveTo(int left, int top) {
        RelativeLayout.LayoutParams mNormalLayoutParam = (RelativeLayout.LayoutParams)this.rootView.getLayoutParams();
        mNormalLayoutParam.leftMargin = left;
        mNormalLayoutParam.topMargin = top;
        mNormalLayoutParam.rightMargin = 0;
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)mNormalLayoutParam);
        PreferUtil.getIns().putInt("KEY_PIP_TOP_MARGIN", mNormalLayoutParam.topMargin);
        PreferUtil.getIns().putInt("KEY_PIP_LEFT_MARGIN", mNormalLayoutParam.leftMargin);
    }
}

