/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.video;

import android.app.Activity;
import android.content.ContentResolver;
import android.media.AudioManager;
import android.provider.Settings;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.utils.GenseeLog;

public class VideoViewTouchHolder
extends BaseHolder
implements View.OnTouchListener {
    private GestureDetector detector;
    private GSListener gsListener;
    private LinearLayout lyBrightVolume;
    private LinearLayout lyVolume;
    private LinearLayout lyBright;
    private ImageView ivVolume;
    private TextView tvVolume;
    private TextView tvBright;
    private final int VOLUME_SCROLL_PER = 50;
    private final int BRIGHT_SCROLL_PER = 20;
    private final int MIN_SCROLL_LENGTH = 10;
    protected int nScrollState = 0;
    public static final int UNKNOWN_SCROLL = 0;
    public static final int VERTRICAL_SCROLL = 1;
    public static final int HORIZONTAL_SCROLL = 2;
    private float lastMotionX = 0.0f;
    private float lastMotinoY = 0.0f;
    protected MotionEvent downEvent;
    private float scrolY = 0.0f;
    protected OnVideoViewTouchListener mOnVideoViewTouchListener;
    private int nLastHorizontalDis = 0;

    public void setOnVideoViewTouchListener(OnVideoViewTouchListener mOnVideoViewTouchListener) {
        this.mOnVideoViewTouchListener = mOnVideoViewTouchListener;
    }

    public VideoViewTouchHolder(View rootView, Object value) {
        super(rootView, value);
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.lyBrightVolume = (LinearLayout)this.findViewById(ResManager.getId("volume_bright_ly"));
        this.lyVolume = (LinearLayout)this.findViewById(ResManager.getId("volume_ly"));
        this.ivVolume = (ImageView)this.findViewById(ResManager.getId("volume_iv"));
        this.tvVolume = (TextView)this.findViewById(ResManager.getId("volume_tv"));
        this.lyBright = (LinearLayout)this.findViewById(ResManager.getId("bright_ly"));
        this.tvBright = (TextView)this.findViewById(ResManager.getId("bright_tv"));
        if (this.detector == null) {
            this.gsListener = new GSListener();
            this.detector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)this.gsListener);
        }
    }

    public void onClick(View v) {
    }

    public boolean onTouch(View v, MotionEvent event) {
        switch (event.getAction() & 0xFF) {
            case 0: {
                this.downEvent = MotionEvent.obtain((MotionEvent)event);
                this.lastMotionX = event.getX();
                this.lastMotinoY = event.getY();
                this.nScrollState = 0;
                break;
            }
            case 2: {
                if (this.nScrollState == 0) {
                    float x = event.getX();
                    float y = event.getY();
                    float yDistance = Math.abs(y - this.lastMotinoY);
                    float xDistance = Math.abs(x - this.lastMotionX);
                    Double mDistance = Math.sqrt(Math.pow(yDistance, 2.0) + Math.pow(xDistance, 2.0));
                    if (!(mDistance >= 10.0)) break;
                    if (yDistance > xDistance) {
                        this.nScrollState = 1;
                        break;
                    }
                    this.nScrollState = 2;
                    break;
                }
                if (this.nScrollState == 1) {
                    this.vertricalScroll(event);
                    break;
                }
                int nCurHorizontalDis = (int)(event.getRawX() - this.downEvent.getRawX());
                if (Math.abs(nCurHorizontalDis - this.nLastHorizontalDis) < 60) break;
                this.horizonralScroll(event);
                this.nLastHorizontalDis = nCurHorizontalDis;
                break;
            }
            case 1: 
            case 3: {
                this.lastMotionX = 0.0f;
                if (null != this.lyBrightVolume) {
                    this.lyBrightVolume.setVisibility(8);
                }
                if (null != this.lyBright) {
                    this.lyBright.setVisibility(8);
                }
                if (null != this.lyVolume) {
                    this.lyVolume.setVisibility(8);
                }
                this.nScrollState = 0;
                this.nLastHorizontalDis = 0;
            }
        }
        this.detector.onTouchEvent(event);
        return true;
    }

    protected void horizonralScroll(MotionEvent event) {
    }

    private void vertricalScroll(MotionEvent event) {
        float x = event.getX();
        float y = event.getY();
        this.scrolY += this.lastMotinoY - y;
        if (null != this.gsListener && Math.abs(this.scrolY) >= 50.0f) {
            if (null != this.downEvent) {
                this.gsListener.compute(this.downEvent, event, x - this.lastMotionX, this.scrolY);
            }
            this.scrolY = 0.0f;
        }
        this.lastMotionX = x;
        this.lastMotinoY = y;
    }

    public static interface OnVideoViewTouchListener {
        public boolean isTouch();

        public void onVideoViewSingleClick();

        public void onVideoViewDoubleClick();
    }

    private class GSListener
    extends GestureDetector.SimpleOnGestureListener {
        private AudioManager mAudioManager = null;
        private int maxVolume = -1;
        private ContentResolver resolver;

        private GSListener() {
        }

        private AudioManager getAuidoManager() {
            if (this.mAudioManager == null) {
                this.mAudioManager = (AudioManager)VideoViewTouchHolder.this.getContext().getSystemService("audio");
                this.maxVolume = this.mAudioManager.getStreamMaxVolume(3);
            }
            return this.mAudioManager;
        }

        private int getCurVolume() {
            return this.getAuidoManager().getStreamVolume(3);
        }

        private void showBrightView() {
            VideoViewTouchHolder.this.lyBrightVolume.setVisibility(0);
            VideoViewTouchHolder.this.lyVolume.setVisibility(8);
            VideoViewTouchHolder.this.lyBright.setVisibility(0);
        }

        private void showVolumeView() {
            VideoViewTouchHolder.this.lyBrightVolume.setVisibility(0);
            VideoViewTouchHolder.this.lyVolume.setVisibility(0);
            VideoViewTouchHolder.this.lyBright.setVisibility(8);
        }

        private void muteVolume() {
            VideoViewTouchHolder.this.tvVolume.setText(ResManager.getStringId("mute_volume"));
            VideoViewTouchHolder.this.ivVolume.setSelected(true);
        }

        private void onVolume(int persent) {
            VideoViewTouchHolder.this.tvVolume.setText((CharSequence)(persent + "%"));
            VideoViewTouchHolder.this.ivVolume.setSelected(false);
        }

        private void onBright(int persent) {
            VideoViewTouchHolder.this.tvBright.setText((CharSequence)(persent + "%"));
        }

        private void setVolume(int change) {
            int cur = this.getCurVolume();
            int persent = cur * 100 / this.maxVolume;
            if (persent <= 0) {
                this.muteVolume();
            } else {
                this.onVolume(persent);
            }
            int tempVolume = cur + change;
            if (tempVolume < 0) {
                tempVolume = 0;
                if (cur == 0) {
                    return;
                }
            } else if (tempVolume > this.maxVolume) {
                tempVolume = this.maxVolume;
                if (cur == this.maxVolume) {
                    return;
                }
            }
            this.mAudioManager.setStreamVolume(3, tempVolume, 0);
        }

        public void compute(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            GenseeLog.i((String)("compute distanceY = " + distanceY));
            if (null == VideoViewTouchHolder.this.mOnVideoViewTouchListener || !VideoViewTouchHolder.this.mOnVideoViewTouchListener.isTouch()) {
                return;
            }
            float x1 = e1.getRawX();
            float x2 = e2.getRawX();
            int viewW = VideoViewTouchHolder.this.rootView.getWidth();
            float per = (float)viewW / 3.0f;
            if (x1 < per && x2 < per) {
                this.showBrightView();
                this.setBrightness((int)distanceY / 20);
            } else if (x1 > (float)viewW - per && x2 > (float)viewW - per) {
                this.showVolumeView();
                this.setVolume((int)distanceY / 50);
            }
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (null != VideoViewTouchHolder.this.mOnVideoViewTouchListener) {
                VideoViewTouchHolder.this.mOnVideoViewTouchListener.onVideoViewSingleClick();
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (null != VideoViewTouchHolder.this.mOnVideoViewTouchListener) {
                VideoViewTouchHolder.this.mOnVideoViewTouchListener.onVideoViewDoubleClick();
            }
            return true;
        }

        private void setBrightness(int change) {
            int curBrightness;
            if (this.resolver == null) {
                this.resolver = VideoViewTouchHolder.this.getContext().getContentResolver();
            }
            if ((curBrightness = this.getScreenBrightness()) < 0) {
                return;
            }
            int persent = curBrightness * 100 / 255;
            this.onBright(persent);
            int tmpBrightness = curBrightness + change;
            if (tmpBrightness < 0) {
                tmpBrightness = 0;
                if (curBrightness == 0) {
                    return;
                }
            } else if (tmpBrightness > 255) {
                tmpBrightness = 255;
                if (curBrightness == 255) {
                    return;
                }
            }
            this.saveScreenBrightness(tmpBrightness);
            this.setScreenBrightness(tmpBrightness);
        }

        private int getScreenBrightness() {
            int screenBrightness = -1;
            try {
                return Settings.System.getInt((ContentResolver)this.resolver, (String)"screen_brightness");
            }
            catch (Exception e) {
                e.printStackTrace();
                return screenBrightness;
            }
        }

        private void saveScreenBrightness(int paramInt) {
            try {
                Settings.System.putInt((ContentResolver)this.resolver, (String)"screen_brightness", (int)paramInt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void setScreenBrightness(int paramInt) {
            float f;
            Window localWindow = ((Activity)VideoViewTouchHolder.this.getContext()).getWindow();
            WindowManager.LayoutParams localLayoutParams = localWindow.getAttributes();
            localLayoutParams.screenBrightness = f = (float)paramInt / 255.0f;
            localWindow.setAttributes(localLayoutParams);
        }
    }
}

