/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.vote;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.ui.holder.BaseHolder;
import com.gensee.fastsdk.ui.holder.vote.impl.VoteImpl;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.routine.UserInfo;
import com.gensee.user.UserManager;
import com.gensee.view.VoteProgressBar;
import com.gensee.vote.VotePlayerAnswer;
import com.gensee.vote.VotePlayerGroup;
import com.gensee.vote.VotePlayerQuestion;
import java.util.List;

public class VoteReceiverHolder
extends BaseHolder
implements VoteImpl.OnVoteReceiverHolderListener {
    private VoteImpl voteImpl;
    private TextView tvVoteName;
    private ImageView ivVoteClose;
    private Button btnVoteCommit;
    private LinearLayout lyVoteCommit;
    private LinearLayout lyVoteOptions;
    private LinearLayout lyVoteForce;
    private LinearLayout lyVoteCount;
    private ImageView ivVoteCount;
    private TextView tvVoteCount;
    private VotePlayerGroup mVoteGroup;
    private boolean bVoteSubmmit = false;
    private ScrollView mVoteScrollView;

    public VoteReceiverHolder(View rootView, Object value) {
        super(rootView, value);
        this.voteImpl = (VoteImpl)value;
        this.voteImpl.setOnVoteReceiverHolderListener(this);
    }

    private void check(VotePlayerGroup mVoteGroup) {
        if (null == mVoteGroup) {
            return;
        }
        this.checkCommitStatus(mVoteGroup.haveAnswer());
    }

    private void checkCommitStatus(boolean bTrue) {
        if (!bTrue) {
            this.btnVoteCommit.getBackground().setAlpha(100);
            this.btnVoteCommit.setEnabled(false);
        } else {
            this.btnVoteCommit.getBackground().setAlpha(255);
            this.btnVoteCommit.setEnabled(true);
        }
    }

    public void onClick(View v) {
        if (v.getId() == ResManager.getId("vote_commit_btn")) {
            this.commit();
        } else if (v.getId() == ResManager.getId("vote_close_iv")) {
            this.close();
        }
    }

    private boolean isHaveCorrected() {
        boolean bTrue = false;
        List questionList = this.mVoteGroup.getM_questions();
        for (VotePlayerQuestion voteQuestion : questionList) {
            if (!"text".equals(voteQuestion.getM_strType())) {
                List answerList = voteQuestion.getM_answers();
                for (VotePlayerAnswer voteAnswer : answerList) {
                    if (!voteAnswer.isM_bCorrect()) continue;
                    bTrue = true;
                    break;
                }
            }
            if (!bTrue) continue;
            break;
        }
        return bTrue;
    }

    private void commit() {
        if (!GenseeUtils.isNetEnable(this.getContext())) {
            ((BaseActivity)this.getContext()).showCancelErrMsg(this.getString(ResManager.getStringId("gs_net_disconnect")), this.getString(ResManager.getStringId("gs_i_known")));
            return;
        }
        if (null == this.mVoteGroup || null == this.voteImpl) {
            return;
        }
        GenseeUtils.hideSoftInputmethod(this.getContext());
        if (this.mVoteGroup.isM_bForce()) {
            int nHeight = 0;
            List questionList = this.mVoteGroup.getM_questions();
            for (int i = 0; i < questionList.size(); ++i) {
                if (!((VotePlayerQuestion)questionList.get(i)).haveAnswer()) {
                    ((BaseActivity)this.getContext()).showCancelErrMsg(this.getString(ResManager.getStringId("vote_please_dawan_all")), this.getString(ResManager.getStringId("gs_i_known")));
                    this.mVoteScrollView.scrollTo(0, nHeight);
                    return;
                }
                View view = this.lyVoteOptions.getChildAt(i);
                if (null == view) continue;
                nHeight += view.getHeight();
            }
        }
        if (this.voteImpl.isVoteFinish(this.mVoteGroup.getM_strId())) {
            this.summitSuccess();
            return;
        }
        PlayerLive.getIns().voteSubmit(this.mVoteGroup);
        this.summitSuccess();
    }

    private void summitSuccess() {
        this.ivVoteClose.setVisibility(0);
        this.lyVoteForce.setVisibility(8);
        int haveCorrectCount = 0;
        int manualCorrentCount = 0;
        List questionList = this.mVoteGroup.getM_questions();
        for (VotePlayerQuestion voteQuestion : questionList) {
            if ("text".equals(voteQuestion.getM_strType())) continue;
            List answerList = voteQuestion.getM_answers();
            boolean bTrue = false;
            for (VotePlayerAnswer voteAnswer : answerList) {
                if (!voteAnswer.isM_bCorrect()) continue;
                ++haveCorrectCount;
                bTrue = true;
                break;
            }
            if (!bTrue) continue;
            bTrue = true;
            for (VotePlayerAnswer voteAnswer : answerList) {
                if ((!voteAnswer.isM_bCorrect() || voteAnswer.isM_bChoose()) && (voteAnswer.isM_bCorrect() || !voteAnswer.isM_bChoose())) continue;
                bTrue = false;
                break;
            }
            if (!bTrue) continue;
            ++manualCorrentCount;
        }
        if (haveCorrectCount > 0) {
            int percent = 100 * manualCorrentCount / haveCorrectCount;
            String percentTip = "";
            if (percent < 60) {
                percentTip = this.getString(ResManager.getStringId("vote_count_failure"));
                this.ivVoteCount.setSelected(false);
            } else if (percent < 85) {
                percentTip = this.getString(ResManager.getStringId("vote_count_success"));
                this.ivVoteCount.setSelected(true);
            } else {
                percentTip = this.getString(ResManager.getStringId("vote_count_good"));
                this.ivVoteCount.setSelected(true);
            }
            this.lyVoteCommit.setVisibility(8);
            this.lyVoteCount.setVisibility(0);
            this.tvVoteCount.setText((CharSequence)percentTip);
            this.bVoteSubmmit = true;
            this.notifyData();
        } else {
            this.close();
        }
    }

    private void close() {
        GenseeUtils.hideSoftInputmethod(this.getContext());
        this.rootView.setVisibility(8);
        if (null != this.voteImpl) {
            this.voteImpl.popNextVoteGroup(true);
        }
    }

    @Override
    protected void initData(Object value) {
    }

    @Override
    protected void initComp(Object value) {
        this.tvVoteName = (TextView)this.findViewById(ResManager.getId("vote_name_tv"));
        this.ivVoteClose = (ImageView)this.findViewById(ResManager.getId("vote_close_iv"));
        this.btnVoteCommit = (Button)this.findViewById(ResManager.getId("vote_commit_btn"));
        this.lyVoteCommit = (LinearLayout)this.findViewById(ResManager.getId("vote_bottom_commit_ly"));
        this.ivVoteClose.setOnClickListener((View.OnClickListener)this);
        this.btnVoteCommit.setOnClickListener((View.OnClickListener)this);
        this.lyVoteOptions = (LinearLayout)this.findViewById(ResManager.getId("vote_options_ly"));
        this.lyVoteForce = (LinearLayout)this.findViewById(ResManager.getId("vote_force_ly"));
        this.lyVoteCount = (LinearLayout)this.findViewById(ResManager.getId("vote_bottom_count_ly"));
        this.ivVoteCount = (ImageView)this.findViewById(ResManager.getId("vote_count_iv"));
        this.tvVoteCount = (TextView)this.findViewById(ResManager.getId("vote_count_tv"));
        this.mVoteScrollView = (ScrollView)this.findViewById(ResManager.getId("vote_scrollview_sc"));
    }

    @Override
    public void onPopVoteGroup(final VotePlayerGroup mVoteGroup) {
        this.post(new Runnable(){

            @Override
            public void run() {
                VoteReceiverHolder.this.popVoteGroup(mVoteGroup);
            }
        });
    }

    private void popVoteGroup(VotePlayerGroup mVoteGroup) {
        UserInfo self = UserManager.getIns().getMyUserInfo();
        if (null != self && self.IsHost()) {
            return;
        }
        if (this.rootView.getVisibility() != 0) {
            this.rootView.setVisibility(0);
        }
        this.checkCommitStatus(false);
        this.mVoteGroup = mVoteGroup;
        if (mVoteGroup.isM_bPublishResult() || mVoteGroup.isM_bDeadline()) {
            this.lyVoteCount.setVisibility(8);
            this.lyVoteCommit.setVisibility(8);
        } else {
            this.lyVoteCount.setVisibility(8);
            this.lyVoteCommit.setVisibility(0);
        }
        this.ivVoteClose.setVisibility(0);
        this.lyVoteForce.setVisibility(!mVoteGroup.isM_bDeadline() && !mVoteGroup.isM_bPublishResult() && mVoteGroup.isM_bForce() ? 0 : 8);
        if (!mVoteGroup.isM_bDeadline() && !mVoteGroup.isM_bPublishResult() && mVoteGroup.isM_bForce()) {
            this.ivVoteClose.setVisibility(8);
        }
        this.bVoteSubmmit = false;
        this.tvVoteName.setText((CharSequence)mVoteGroup.getM_strText());
        this.processVoteOptions();
    }

    private void processVoteOptions() {
        if (null == this.mVoteGroup) {
            return;
        }
        int nSize = this.mVoteGroup.getM_questions().size();
        this.lyVoteOptions.removeAllViews();
        for (int nQuestionIndex = 0; nQuestionIndex < nSize; ++nQuestionIndex) {
            LinearLayout lyView = new LinearLayout(this.getContext());
            lyView.setOrientation(1);
            LinearLayout.LayoutParams lp1 = new LinearLayout.LayoutParams(-1, -2);
            this.lyVoteOptions.addView((View)lyView, (ViewGroup.LayoutParams)lp1);
            View groupView = LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("vote_group_item_layout"), null);
            VoteGroupHolder groupHolder = new VoteGroupHolder(groupView);
            VotePlayerQuestion mVoteQuestion = (VotePlayerQuestion)this.mVoteGroup.getM_questions().get(nQuestionIndex);
            groupHolder.initValue(nQuestionIndex);
            int nAnswerSize = mVoteQuestion.getM_answers().size();
            groupView.setTag((Object)groupHolder);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
            if (nQuestionIndex > 0) {
                lp.topMargin = this.getContext().getResources().getDimensionPixelSize(ResManager.getDimenId("vote_group_item_padding_top"));
            }
            lyView.addView(groupView, (ViewGroup.LayoutParams)lp);
            if ("text".equals(mVoteQuestion.getM_strType())) {
                View childView = LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("vote_child_item_layout"), null);
                VoteChildHolder childHolder = new VoteChildHolder(childView);
                childHolder.initValue(nQuestionIndex, 0);
                childView.setTag((Object)childHolder);
                lyView.addView(childView, new ViewGroup.LayoutParams(-1, -2));
                continue;
            }
            for (int nAnswerIndex = 0; nAnswerIndex < nAnswerSize; ++nAnswerIndex) {
                View childView = LayoutInflater.from((Context)this.getContext()).inflate(ResManager.getLayoutId("vote_child_item_layout"), null);
                VoteChildHolder childHolder = new VoteChildHolder(childView);
                childHolder.initValue(nQuestionIndex, nAnswerIndex);
                childView.setTag((Object)childHolder);
                lyView.addView(childView, new ViewGroup.LayoutParams(-1, -2));
            }
        }
    }

    private void notifyData() {
        int nQuestionChildSize = this.lyVoteOptions.getChildCount();
        int nGroupIndex = -1;
        int nChildIndex = -1;
        for (int i = 0; i < nQuestionChildSize; ++i) {
            LinearLayout view1 = (LinearLayout)this.lyVoteOptions.getChildAt(i);
            int nChildSize = view1.getChildCount();
            for (int index = 0; index < nChildSize; ++index) {
                View view = view1.getChildAt(index);
                Object object = view.getTag();
                if (object instanceof VoteGroupHolder) {
                    nChildIndex = -1;
                    ((VoteGroupHolder)((Object)object)).initValue(++nGroupIndex);
                }
                if (!(object instanceof VoteChildHolder)) continue;
                ((VoteChildHolder)((Object)object)).initValue(nGroupIndex, ++nChildIndex);
            }
        }
    }

    private VotePlayerQuestion getGroup(int nGroupPosition) {
        return (VotePlayerQuestion)this.mVoteGroup.getM_questions().get(nGroupPosition);
    }

    private VotePlayerAnswer getChild(int nGroupPostion, int nChildPosition) {
        return (VotePlayerAnswer)((VotePlayerQuestion)this.mVoteGroup.getM_questions().get(nGroupPostion)).getM_answers().get(nChildPosition);
    }

    private class VoteChildHolder
    extends AbstractViewHolder {
        private LinearLayout lyQuestionNotText;
        private ImageView ivAnswerSuccess;
        private ImageView ivAnswerSingle;
        private ImageView ivAnswerMulti;
        private TextView tvAnswer;
        private LinearLayout lyQuesionText;
        private EditText edtAnswerText;
        private TextView tvVoteText;
        private LinearLayout lyProgressBar;
        private VoteProgressBar mVoteProgressBar;
        private TextView tvAnswerCount;
        private TextWatcher textWatcher;

        public VoteChildHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.lyQuestionNotText = (LinearLayout)view.findViewById(ResManager.getId("vote_not_text_ly"));
            this.ivAnswerSuccess = (ImageView)view.findViewById(ResManager.getId("vote_answer_success_iv"));
            this.ivAnswerSingle = (ImageView)view.findViewById(ResManager.getId("vote_answer_single_iv"));
            this.ivAnswerMulti = (ImageView)view.findViewById(ResManager.getId("vote_answer_multi_iv"));
            this.tvAnswer = (TextView)view.findViewById(ResManager.getId("vote_answer_tv"));
            this.lyQuesionText = (LinearLayout)view.findViewById(ResManager.getId("vote_text_ly"));
            this.edtAnswerText = (EditText)view.findViewById(ResManager.getId("vote_text_edt"));
            this.tvVoteText = (TextView)view.findViewById(ResManager.getId("vote_text_tv"));
            this.lyProgressBar = (LinearLayout)view.findViewById(ResManager.getId("vote_progress_ly"));
            this.mVoteProgressBar = (VoteProgressBar)view.findViewById(ResManager.getId("vote_progress_bar_pb"));
            this.tvAnswerCount = (TextView)view.findViewById(ResManager.getId("vote_progree_count_tv"));
        }

        public void initValue(int groupPosition, int childPosition) {
            final VotePlayerQuestion voteQuestion = VoteReceiverHolder.this.getGroup(groupPosition);
            if ("single".equals(voteQuestion.getM_strType())) {
                this.lyQuestionNotText.setVisibility(0);
                this.lyQuesionText.setVisibility(8);
                this.ivAnswerSingle.setVisibility(0);
                this.ivAnswerMulti.setVisibility(8);
            } else if ("multi".equals(voteQuestion.getM_strType())) {
                this.lyQuestionNotText.setVisibility(0);
                this.lyQuesionText.setVisibility(8);
                this.ivAnswerSingle.setVisibility(8);
                this.ivAnswerMulti.setVisibility(0);
            } else if ("text".equals(voteQuestion.getM_strType())) {
                this.lyQuestionNotText.setVisibility(8);
                this.lyQuesionText.setVisibility(0);
            }
            this.lyProgressBar.setVisibility(8);
            this.ivAnswerSuccess.setVisibility(8);
            this.ivAnswerSingle.setEnabled(true);
            this.ivAnswerMulti.setEnabled(true);
            this.edtAnswerText.setEnabled(true);
            if (VoteReceiverHolder.this.bVoteSubmmit || VoteReceiverHolder.this.mVoteGroup.isM_bPublishResult() || VoteReceiverHolder.this.mVoteGroup.isM_bDeadline()) {
                this.ivAnswerMulti.setEnabled(false);
                this.ivAnswerSingle.setEnabled(false);
                this.edtAnswerText.setEnabled(false);
            }
            if (!"text".equals(voteQuestion.getM_strType())) {
                final VotePlayerAnswer voteAnswer = VoteReceiverHolder.this.getChild(groupPosition, childPosition);
                int nValue = 65;
                if (VoteReceiverHolder.this.mVoteGroup.isM_bPublishResult() || VoteReceiverHolder.this.mVoteGroup.isM_bDeadline()) {
                    this.tvAnswer.setText((CharSequence)((char)(nValue + childPosition) + ""));
                    this.lyProgressBar.setVisibility(0);
                    int nAnswerCount = voteAnswer.getTotal();
                    int nQuestionCount = voteQuestion.getTotal();
                    this.tvAnswerCount.setText((CharSequence)(nAnswerCount + ""));
                    int nMax = nQuestionCount;
                    if (nMax <= 0) {
                        nMax = 100;
                    }
                    this.mVoteProgressBar.setMax(nMax);
                    this.mVoteProgressBar.setProgress(nAnswerCount);
                } else {
                    this.tvAnswer.setText((CharSequence)((char)(nValue + childPosition) + ".  " + voteAnswer.getM_strText()));
                }
                if (VoteReceiverHolder.this.bVoteSubmmit || VoteReceiverHolder.this.mVoteGroup.isM_bPublishResult() || VoteReceiverHolder.this.mVoteGroup.isM_bDeadline()) {
                    if (VoteReceiverHolder.this.isHaveCorrected()) {
                        this.ivAnswerSuccess.setVisibility(voteAnswer.isM_bCorrect() ? 0 : 4);
                        if ("single".equals(voteQuestion.getM_strType())) {
                            this.ivAnswerSingle.setVisibility(0);
                        } else {
                            this.ivAnswerMulti.setVisibility(0);
                        }
                    } else {
                        this.ivAnswerSuccess.setVisibility(voteAnswer.isM_bCorrect() ? 0 : 8);
                        if ("single".equals(voteQuestion.getM_strType())) {
                            this.ivAnswerSingle.setVisibility(8);
                        } else {
                            this.ivAnswerMulti.setVisibility(8);
                        }
                    }
                    if (VoteReceiverHolder.this.mVoteGroup.isM_bPublishResult() || VoteReceiverHolder.this.mVoteGroup.isM_bDeadline()) {
                        this.ivAnswerSingle.setVisibility(8);
                        this.ivAnswerMulti.setVisibility(8);
                    }
                }
                if ("single".equals(voteQuestion.getM_strType())) {
                    this.ivAnswerSingle.setSelected(voteAnswer.isM_bChoose());
                } else {
                    this.ivAnswerMulti.setSelected(voteAnswer.isM_bChoose());
                }
                this.ivAnswerSingle.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        for (VotePlayerAnswer voteAnswer1 : voteQuestion.getM_answers()) {
                            if (!voteAnswer1.isM_bChoose()) continue;
                            voteAnswer1.setM_bChoose(false);
                        }
                        VoteChildHolder.this.ivAnswerSingle.setSelected(!VoteChildHolder.this.ivAnswerSingle.isSelected());
                        voteAnswer.setM_bChoose(VoteChildHolder.this.ivAnswerSingle.isSelected());
                        VoteReceiverHolder.this.notifyData();
                        VoteReceiverHolder.this.check(VoteReceiverHolder.this.mVoteGroup);
                        VoteReceiverHolder.this.rootView.requestFocus();
                    }
                });
                this.ivAnswerMulti.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        VoteChildHolder.this.ivAnswerMulti.setSelected(!VoteChildHolder.this.ivAnswerMulti.isSelected());
                        voteAnswer.setM_bChoose(VoteChildHolder.this.ivAnswerMulti.isSelected());
                        VoteReceiverHolder.this.check(VoteReceiverHolder.this.mVoteGroup);
                    }
                });
            } else {
                if (null != this.textWatcher) {
                    this.edtAnswerText.removeTextChangedListener(this.textWatcher);
                }
                this.textWatcher = new TextWatcher(){

                    public void onTextChanged(CharSequence s, int start, int before, int count) {
                        voteQuestion.setM_strAnwser(s.toString());
                        VoteReceiverHolder.this.check(VoteReceiverHolder.this.mVoteGroup);
                    }

                    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                    }

                    public void afterTextChanged(Editable s) {
                    }
                };
                this.edtAnswerText.addTextChangedListener(this.textWatcher);
                this.edtAnswerText.setText((CharSequence)voteQuestion.getM_strAnwser());
                if (VoteReceiverHolder.this.mVoteGroup.isM_bPublishResult() || VoteReceiverHolder.this.mVoteGroup.isM_bDeadline()) {
                    this.edtAnswerText.setVisibility(8);
                    this.tvVoteText.setVisibility(0);
                    this.tvVoteText.setText((CharSequence)String.format(VoteReceiverHolder.this.getString(ResManager.getStringId("vote_text_join_count")), voteQuestion.getTotal()));
                } else {
                    this.edtAnswerText.setVisibility(0);
                    this.tvVoteText.setVisibility(8);
                }
            }
        }

        public void initValue(int positon) {
        }
    }

    private class VoteGroupHolder
    extends AbstractViewHolder {
        private TextView tvQuestionName;

        public VoteGroupHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.tvQuestionName = (TextView)view.findViewById(ResManager.getId("vote_question_name_tv"));
        }

        public void initValue(int nPosition) {
            VotePlayerQuestion voteQuestion = (VotePlayerQuestion)VoteReceiverHolder.this.mVoteGroup.getM_questions().get(nPosition);
            String type = "";
            if ("single".equals(voteQuestion.getM_strType())) {
                type = VoteReceiverHolder.this.getString(ResManager.getStringId("single_choice"));
            } else if ("multi".equals(voteQuestion.getM_strType())) {
                type = VoteReceiverHolder.this.getString(ResManager.getStringId("multi_choice"));
            } else if ("text".equals(voteQuestion.getM_strType())) {
                type = VoteReceiverHolder.this.getString(ResManager.getStringId("text_choice"));
            }
            String sName = nPosition + 1 + ".  " + type + "  " + voteQuestion.getM_strText();
            this.tvQuestionName.setText((CharSequence)sName);
        }
    }
}

