/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.holder.vote.impl;

import com.gensee.utils.GenseeLog;
import com.gensee.vote.OnVoteListener;
import com.gensee.vote.VotePlayerAnswer;
import com.gensee.vote.VotePlayerGroup;
import com.gensee.vote.VotePlayerQuestion;
import java.util.ArrayList;
import java.util.List;

public class VoteImpl
implements OnVoteListener {
    private static final String TAG = "VoteImpl";
    private List<VotePlayerGroup> voteGroupList = new ArrayList<VotePlayerGroup>();
    private Object object;
    private boolean bNeedPop = true;
    private OnVoteReceiverHolderListener onVoteReceiverHolderListener;
    private List<String> haveFinishList = new ArrayList<String>();
    private OnCardImplListener onCardImplListener;

    public void setOnVoteReceiverHolderListener(OnVoteReceiverHolderListener onVoteReceiverHolderListener) {
        this.onVoteReceiverHolderListener = onVoteReceiverHolderListener;
    }

    public VoteImpl() {
        this.object = new Object();
    }

    public boolean isVoteFinish(String votId) {
        return this.haveFinishList.contains(votId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addVoteGroup(VotePlayerGroup votePlayerGroup) {
        Object object = this.object;
        synchronized (object) {
            this.voteGroupList.add(votePlayerGroup);
            this._popVoteGroup();
        }
    }

    private void _popVoteGroup() {
        int nSize = this.voteGroupList.size();
        if (nSize > 0 && null != this.onVoteReceiverHolderListener && this.bNeedPop) {
            this.dismissPopMoreWindow();
            VotePlayerGroup mVoteGroup = this.voteGroupList.remove(0);
            this.onVoteReceiverHolderListener.onPopVoteGroup(mVoteGroup);
            this.bNeedPop = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void popNextVoteGroup(boolean bTrue) {
        Object object = this.object;
        synchronized (object) {
            this.bNeedPop = true;
            this._popVoteGroup();
        }
    }

    public void onVotePublish(VotePlayerGroup votePlayerGroup) {
        GenseeLog.i((String)TAG, (String)"onVotePublish");
        if (VoteImpl.isVoteCard(votePlayerGroup)) {
            if (null != this.onCardImplListener) {
                GenseeLog.i((String)TAG, (String)"onVotePublish card ");
                this.onCardImplListener.onCardPublish(votePlayerGroup);
            }
        } else {
            GenseeLog.i((String)TAG, (String)"onVotePublish vote");
            this.addVoteGroup(votePlayerGroup);
        }
    }

    public void onVotePublishResult(VotePlayerGroup votePlayerGroup) {
        GenseeLog.i((String)TAG, (String)"onVotePublishResult");
        if (!this.haveFinishList.contains(votePlayerGroup.getM_strId())) {
            this.haveFinishList.add(votePlayerGroup.getM_strId());
        }
        if (VoteImpl.isVoteCard(votePlayerGroup)) {
            GenseeLog.i((String)TAG, (String)"onVotePublishResult card result");
            if (null != this.onCardImplListener) {
                this.onCardImplListener.onCardResultPublish(votePlayerGroup);
            }
        } else {
            GenseeLog.i((String)TAG, (String)"onVotePublishResult vote result");
            this.addVoteGroup(votePlayerGroup);
        }
    }

    private boolean isHaveCorrected(VotePlayerGroup mVoteGroup) {
        boolean bTrue = false;
        List questionList = mVoteGroup.getM_questions();
        for (VotePlayerQuestion voteQuestion : questionList) {
            if (!"text".equals(voteQuestion.getM_strType())) {
                List answerList = voteQuestion.getM_answers();
                for (VotePlayerAnswer voteAnswer : answerList) {
                    if (!voteAnswer.isM_bCorrect()) continue;
                    bTrue = true;
                    break;
                }
            }
            if (!bTrue) continue;
            break;
        }
        return bTrue;
    }

    public void onVotePostUrl(String strURL, long optUser) {
    }

    public void onVoteSubmitRet(int result) {
    }

    public void setOnCardImplListener(OnCardImplListener onCardImplListener) {
        this.onCardImplListener = onCardImplListener;
    }

    private static boolean isVoteCard(VotePlayerGroup voteGroup) {
        if (voteGroup == null) {
            return false;
        }
        String voteType = voteGroup.getVoteType();
        return "publish_card".equals(voteType) || "publish_cardresult".equals(voteType);
    }

    private void dismissPopMoreWindow() {
    }

    public static interface OnCardImplListener {
        public void onCardPublish(VotePlayerGroup var1);

        public void onCardResultPublish(VotePlayerGroup var1);

        public void onCardSubmit(long var1, int[] var3);

        public void onCardEnd();
    }

    public static interface OnVoteReceiverHolderListener {
        public void onPopVoteGroup(VotePlayerGroup var1);
    }
}

