/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.gensee.fastsdk.util.ResManager;

public class LotteryImageView
extends View {
    private Bitmap mBitmap;
    private static final int ITEM_LENGHT = 36;
    int nLeft = 0;

    public LotteryImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init();
    }

    public LotteryImageView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LotteryImageView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        this.mBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)ResManager.getDrawableId("lottery_progress_item"));
        this.nLeft = -this.mBitmap.getWidth() - 36;
    }

    protected void onDraw(Canvas canvas) {
        if (this.nLeft >= this.getWidth()) {
            this.nLeft = -this.mBitmap.getWidth() - 36;
        }
        this.nLeft += 36;
        int nTop = (this.getHeight() - this.mBitmap.getHeight()) / 2;
        int nBottom = nTop + this.mBitmap.getHeight();
        int nRight = this.nLeft + this.mBitmap.getWidth();
        Rect rect = new Rect(this.nLeft, nTop, nRight, nBottom);
        canvas.drawBitmap(this.mBitmap, null, rect, null);
        this.postDelayed(new Runnable(){

            @Override
            public void run() {
                LotteryImageView.this.invalidate();
            }
        }, 50L);
    }
}

