/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.gensee.fastsdk.core.PlayerLive;
import com.gensee.fastsdk.entity.GSMoreItem;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import java.util.List;

public class PopMore
extends PopupWindow
implements View.OnClickListener {
    private List<GSMoreItem> GSMoreItems;
    private TextView tvNetSwitch;
    private LinearLayout lyNetSwitch;
    private OnMoreItemClick itemClick;
    private float density = 0.0f;

    public PopMore(Context context) {
        super(context);
    }

    public PopMore(Context context, OnMoreItemClick itemClick, List<GSMoreItem> GSMoreItems) {
        this(context);
        this.itemClick = itemClick;
        this.GSMoreItems = GSMoreItems;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        LinearLayout view = (LinearLayout)inflater.inflate(ResManager.getLayoutId("pop_more_layout"), null);
        LinearLayout viewCloseVideo = (LinearLayout)view.findViewById(ResManager.getId("txtCloseVideo"));
        viewCloseVideo.setVisibility(PlayerLive.getIns().isShowCloseVideo() ? 0 : 8);
        TextView tv = (TextView)viewCloseVideo.getChildAt(0);
        boolean isVideoClose = PreferUtil.getIns().getBoolean("KEY_VIDEO_CLOSED");
        viewCloseVideo.setSelected(isVideoClose);
        if (isVideoClose) {
            tv.setText(ResManager.getStringId("gs_open_video"));
        } else {
            tv.setText(ResManager.getStringId("gs_close_video"));
        }
        viewCloseVideo.setOnClickListener((View.OnClickListener)this);
        this.lyNetSwitch = (LinearLayout)view.findViewById(ResManager.getId("lyNetSwitch"));
        this.lyNetSwitch.setOnClickListener((View.OnClickListener)this);
        this.lyNetSwitch.setVisibility(PlayerLive.getIns().isShownetSwitch() ? 0 : 8);
        this.tvNetSwitch = (TextView)view.findViewById(ResManager.getId("tvNetSwitch"));
        view.findViewById(ResManager.getId("txtDiagnose")).setOnClickListener((View.OnClickListener)this);
        this.setContentView((View)view);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setBackgroundDrawable(context.getResources().getDrawable(17170445));
        this.setOutsideTouchable(false);
        this.setFocusable(true);
        this.setSoftInputMode(16);
    }

    private void addExtraItem(Context context, LinearLayout rootView, List<GSMoreItem> GSMoreItems) {
        for (int i = 0; i < GSMoreItems.size(); ++i) {
            GSMoreItem item = GSMoreItems.get(i);
            LinearLayout linearLayout = new LinearLayout(context);
            linearLayout.setGravity(17);
            int idly = GenseeUtils.generateViewId();
            linearLayout.setId(idly);
            GSMoreItems.get(i).setId(idly);
            TextView textView = new TextView(context);
            textView.setText((CharSequence)item.getText());
            textView.setCompoundDrawablePadding(context.getResources().getDimensionPixelSize(ResManager.getDimenId("pop_more_tv_drawable_padding")));
            textView.setGravity(16);
            textView.setTextColor(context.getResources().getColor(ResManager.getColorId("pop_more_text")));
            textView.setTextSize(0, (float)context.getResources().getDimensionPixelSize(ResManager.getDimenId("pop_more_tv_size")));
            textView.setBackgroundResource(ResManager.getDrawableId("selector_pop_more_tv"));
            int padding = context.getResources().getDimensionPixelSize(ResManager.getDimenId("pop_more_tv_padding"));
            textView.setPadding(padding, 0, padding, 0);
            textView.setCompoundDrawablesWithIntrinsicBounds(item.getIcon(), null, null, null);
            linearLayout.addView((View)textView, this.tvNetSwitch.getLayoutParams());
            linearLayout.setOnClickListener((View.OnClickListener)this);
            rootView.addView((View)linearLayout, this.lyNetSwitch.getLayoutParams());
        }
    }

    public void onClick(View v) {
        if (this.itemClick == null) {
            return;
        }
        if (v.getId() == ResManager.getId("lyNetSwitch")) {
            this.itemClick.onSelectIdc();
        } else if (v.getId() == ResManager.getId("txtDiagnose")) {
            this.itemClick.onItemSendErrorMsg();
        } else if (v.getId() == ResManager.getId("txtCloseVideo")) {
            this.itemClick.onSelectCloseVideo(v);
        }
        this.dismiss();
    }

    private float getDensity(Context context) {
        if (this.density == 0.0f) {
            this.density = context.getResources().getDisplayMetrics().density;
        }
        return this.density;
    }

    public void showWindow(View anchor, boolean isCasting) {
        this.showAsDropDown(anchor, anchor.getWidth() - this.getWidth(), (int)(-11.5 * (double)this.getDensity(anchor.getContext())));
    }

    public static interface OnMoreItemClick {
        public void onItemSendErrorMsg();

        public void onSelectIdc();

        public void onSelectCloseVideo(View var1);
    }
}

