/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.gensee.fastsdk.util.ResManager;

public class PopQuality
extends PopupWindow
implements View.OnClickListener {
    private boolean isHD = true;
    private TextView tvSd;
    private TextView tvHd;
    private OnQualityClick onQualityClick;
    private float density = 0.0f;

    public PopQuality(Context context) {
        super(context);
    }

    public PopQuality(Context context, OnQualityClick onQualityClick, boolean isHD) {
        this(context);
        this.onQualityClick = onQualityClick;
        this.isHD = isHD;
        LayoutInflater inflater = LayoutInflater.from((Context)context);
        View view = inflater.inflate(ResManager.getLayoutId("pop_quality_layout"), null);
        view.findViewById(ResManager.getId("ll_sd")).setOnClickListener((View.OnClickListener)this);
        view.findViewById(ResManager.getId("ll_hd")).setOnClickListener((View.OnClickListener)this);
        this.tvSd = (TextView)view.findViewById(ResManager.getId("tv_sd"));
        this.tvHd = (TextView)view.findViewById(ResManager.getId("tv_hd"));
        if (isHD) {
            this.tvHd.setTextColor(context.getResources().getColor(ResManager.getColorId("pop_quality_text_select")));
        } else {
            this.tvSd.setTextColor(context.getResources().getColor(ResManager.getColorId("pop_quality_text_select")));
        }
        this.setContentView(view);
        this.setWidth(-2);
        this.setHeight(-2);
        this.setBackgroundDrawable(context.getResources().getDrawable(17170445));
        this.setOutsideTouchable(false);
        this.setFocusable(true);
        this.setSoftInputMode(16);
    }

    public void onClick(View v) {
        if (this.onQualityClick == null) {
            return;
        }
        if (v.getId() == ResManager.getId("ll_sd")) {
            this.onQualityClick.onQuality(false);
        } else if (v.getId() == ResManager.getId("ll_hd")) {
            this.onQualityClick.onQuality(true);
        }
        this.dismiss();
    }

    private float getDensity(Context context) {
        if (this.density == 0.0f) {
            this.density = context.getResources().getDisplayMetrics().density;
        }
        return this.density;
    }

    public void showWindow(View anchor) {
        this.showAsDropDown(anchor, -anchor.getWidth(), (int)(-11.5 * (double)this.getDensity(anchor.getContext())));
    }

    public static interface OnQualityClick {
        public void onQuality(boolean var1);
    }
}

