/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.ui.view;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextPaint;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ImageSpan;
import com.gensee.fastsdk.util.GenseeUtils;
import com.gensee.fastsdk.util.ResManager;
import java.io.InputStream;
import java.util.HashMap;
import master.flame.danmaku.controller.DrawHandler;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.loader.ILoader;
import master.flame.danmaku.danmaku.loader.IllegalDataException;
import master.flame.danmaku.danmaku.loader.android.DanmakuLoaderFactory;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.android.BaseCacheStuffer;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.model.android.SpannedCacheStuffer;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.IDataSource;
import master.flame.danmaku.danmaku.parser.android.BiliDanmukuParser;

public class RewardDanmaku {
    private BaseDanmakuParser mParser;
    private IDanmakuView mDanmakuView;
    private DanmakuContext mDanmakuContext;
    private Context context;
    public static final int LEVEL_BRONZE = 1;
    public static final int LEVEL_SILVER = 2;
    public static final int LEVEL_GOLD = 3;
    private int pixelSizeFromDp14;
    private BaseCacheStuffer.Proxy mCacheStufferAdapter = new BaseCacheStuffer.Proxy(){
        private Drawable mDrawable;

        public void prepareDrawing(BaseDanmaku danmaku, boolean fromWorkerThread) {
        }

        public void releaseResource(BaseDanmaku danmaku) {
            if (danmaku.text instanceof Spanned) {
                danmaku.text = "";
            }
        }
    };

    public RewardDanmaku(Context context, IDanmakuView danmakuView) {
        this.context = context;
        this.mDanmakuView = danmakuView;
        this.initDanmaku();
    }

    private void initDanmaku() {
        this.mDanmakuContext = DanmakuContext.create();
        this.pixelSizeFromDp14 = GenseeUtils.dp2px(this.context, 14.0f);
        HashMap<Integer, Integer> maxLinesPair = new HashMap<Integer, Integer>();
        maxLinesPair.put(1, 3);
        HashMap<Integer, Boolean> overlappingEnablePair = new HashMap<Integer, Boolean>();
        overlappingEnablePair.put(1, true);
        overlappingEnablePair.put(4, true);
        this.mDanmakuContext.setDanmakuStyle(2, new float[]{3.0f}).setDuplicateMergingEnabled(false).setScrollSpeedFactor(1.0f).setScaleTextSize(0.8f).setCacheStuffer((BaseCacheStuffer)new BackgroundCacheStuffer(), null).setMaximumLines(maxLinesPair).preventOverlapping(overlappingEnablePair);
        if (this.mDanmakuView != null) {
            this.mParser = this.createParser(null);
            this.mDanmakuView.setCallback(new DrawHandler.Callback(){

                public void updateTimer(DanmakuTimer timer) {
                }

                public void drawingFinished() {
                }

                public void danmakuShown(BaseDanmaku danmaku) {
                }

                public void prepared() {
                    RewardDanmaku.this.mDanmakuView.start();
                }
            });
            this.mDanmakuView.prepare(this.mParser, this.mDanmakuContext);
            this.mDanmakuView.showFPS(false);
            this.mDanmakuView.enableDanmakuDrawingCache(true);
        }
    }

    private BaseDanmakuParser createParser(InputStream stream) {
        if (stream == null) {
            return new BaseDanmakuParser(){

                protected Danmakus parse() {
                    return new Danmakus();
                }
            };
        }
        ILoader loader = DanmakuLoaderFactory.create((String)DanmakuLoaderFactory.TAG_BILI);
        try {
            loader.load(stream);
        }
        catch (IllegalDataException e) {
            e.printStackTrace();
        }
        BiliDanmukuParser parser = new BiliDanmukuParser();
        IDataSource dataSource = loader.getDataSource();
        parser.load(dataSource);
        return parser;
    }

    private void addDanmaku(boolean islive) {
        BaseDanmaku danmaku = this.mDanmakuContext.mDanmakuFactory.createDanmaku(1);
        if (danmaku == null || this.mDanmakuView == null) {
            return;
        }
        danmaku.text = "\u8fd9\u662f\u4e00\u6761\u5f39\u5e55" + System.nanoTime();
        danmaku.padding = GenseeUtils.dp2px(this.context, 10.0f);
        danmaku.priority = 0;
        danmaku.isLive = islive;
        danmaku.time = this.mDanmakuView.getCurrentTime() + 1200L;
        danmaku.textSize = 25.0f * (this.mParser.getDisplayer().getDensity() - 0.6f);
        danmaku.textColor = -1;
        danmaku.textShadowColor = -1;
        danmaku.borderColor = -16711936;
        this.mDanmakuView.addDanmaku(danmaku);
    }

    public static int getLevelByTotalReword(long total) {
        if (total >= 10000L) {
            return 3;
        }
        if (total >= 1000L && total < 10000L) {
            return 2;
        }
        return 1;
    }

    public void addRewardDanmaku(int level, String danmakuText) {
        BaseDanmaku danmaku = this.mDanmakuContext.mDanmakuFactory.createDanmaku(1);
        Drawable drawable = null;
        if (1 == level) {
            drawable = this.context.getResources().getDrawable(ResManager.getDrawableId("gs_ic_danmu_bronze"));
        } else if (2 == level) {
            drawable = this.context.getResources().getDrawable(ResManager.getDrawableId("gs_ic_danmu_silver"));
        } else if (3 == level) {
            drawable = this.context.getResources().getDrawable(ResManager.getDrawableId("gs_ic_danmu_golden"));
        }
        drawable.setBounds(0, 0, drawable.getIntrinsicWidth(), drawable.getIntrinsicHeight());
        SpannableStringBuilder spannable = this.createSpannable(drawable, danmakuText);
        danmaku.userId = level;
        danmaku.text = spannable;
        danmaku.padding = (int)(15.0f * (this.mParser.getDisplayer().getDensity() - 0.6f));
        danmaku.priority = 0;
        danmaku.isLive = true;
        danmaku.time = this.mDanmakuView.getCurrentTime() + 500L;
        danmaku.textSize = this.pixelSizeFromDp14;
        danmaku.textColor = -1;
        danmaku.textShadowColor = 0;
        this.mDanmakuView.addDanmaku(danmaku);
    }

    private SpannableStringBuilder createSpannable(Drawable drawable, String danmakuText) {
        String text = "   b   ";
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)text);
        MyIm span = new MyIm(drawable, 1);
        spannableStringBuilder.setSpan((Object)span, 3, text.length() - 3, 17);
        spannableStringBuilder.append((CharSequence)("   " + danmakuText + "      "));
        spannableStringBuilder.setSpan((Object)new AlignmentSpan.Standard(Layout.Alignment.ALIGN_CENTER), 0, spannableStringBuilder.length(), 18);
        spannableStringBuilder.setSpan((Object)new BackgroundColorSpan(Color.parseColor((String)"#00ffffff")), 0, spannableStringBuilder.length(), 18);
        return spannableStringBuilder;
    }

    public void control(int control) {
        this.mDanmakuView.hide();
        this.mDanmakuView.show();
        if (this.mDanmakuView != null && this.mDanmakuView.isPrepared()) {
            this.mDanmakuView.pause();
        }
        if (this.mDanmakuView != null && this.mDanmakuView.isPrepared() && this.mDanmakuView.isPaused()) {
            this.mDanmakuView.resume();
        }
    }

    public void releaseDanmaku() {
        if (this.mDanmakuView != null) {
            this.mDanmakuView.release();
            this.mDanmakuView = null;
        }
    }

    public class MyIm
    extends ImageSpan {
        public MyIm(Context arg0, int arg1) {
            super(arg0, arg1);
        }

        public MyIm(Drawable d, int verticalAlignment) {
            super(d, verticalAlignment);
        }

        public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
            Drawable d = this.getDrawable();
            Rect rect = d.getBounds();
            if (fm != null) {
                Paint.FontMetricsInt fmPaint = paint.getFontMetricsInt();
                int fontHeight = fmPaint.bottom - fmPaint.top;
                int drHeight = rect.bottom - rect.top;
                int top = drHeight / 2 - fontHeight / 4;
                int bottom = drHeight / 2 + fontHeight / 4;
                fm.ascent = -bottom;
                fm.top = -bottom;
                fm.bottom = top;
                fm.descent = top;
            }
            return rect.right;
        }

        public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
            Drawable b = this.getDrawable();
            canvas.save();
            int transY = 0;
            transY = (bottom - top - b.getBounds().bottom) / 2 + top;
            canvas.translate(x, (float)transY);
            b.draw(canvas);
            canvas.restore();
        }
    }

    private class BackgroundCacheStuffer
    extends SpannedCacheStuffer {
        final Paint paint = new Paint();

        private BackgroundCacheStuffer() {
        }

        public void measure(BaseDanmaku danmaku, TextPaint paint, boolean fromWorkerThread) {
            super.measure(danmaku, paint, true);
        }

        public void drawBackground(BaseDanmaku danmaku, Canvas canvas, float left, float top) {
            this.paint.setColor(2437275);
            Bitmap bmp = null;
            if (1 == danmaku.userId) {
                bmp = BitmapFactory.decodeResource((Resources)RewardDanmaku.this.context.getResources(), (int)ResManager.getDrawableId("gs_ic_danmu_bronze_bg"));
            } else if (2 == danmaku.userId) {
                bmp = BitmapFactory.decodeResource((Resources)RewardDanmaku.this.context.getResources(), (int)ResManager.getDrawableId("gs_ic_danmu_silver_bg"));
            } else if (3 == danmaku.userId) {
                bmp = BitmapFactory.decodeResource((Resources)RewardDanmaku.this.context.getResources(), (int)ResManager.getDrawableId("gs_ic_danmu_golden_bg"));
            }
            Rect rect1 = new Rect((int)left - GenseeUtils.dp2px(RewardDanmaku.this.context, 30.0f), (int)top + (int)danmaku.paintHeight - GenseeUtils.dp2px(RewardDanmaku.this.context, 5.0f), (int)left + (int)danmaku.paintWidth + GenseeUtils.dp2px(RewardDanmaku.this.context, 60.0f), (int)top + (int)danmaku.paintHeight + GenseeUtils.dp2px(RewardDanmaku.this.context, 5.0f));
            Rect rect = new Rect((int)left + GenseeUtils.dp2px(RewardDanmaku.this.context, 0.0f), (int)top + GenseeUtils.dp2px(RewardDanmaku.this.context, 5.0f), (int)left + (int)danmaku.paintWidth - GenseeUtils.dp2px(RewardDanmaku.this.context, 15.0f), (int)top + (int)danmaku.paintHeight - GenseeUtils.dp2px(RewardDanmaku.this.context, 5.0f));
            canvas.drawBitmap(bmp, null, rect, new Paint());
        }

        public void drawStroke(BaseDanmaku danmaku, String lineText, Canvas canvas, float left, float top, Paint paint) {
        }
    }
}

