/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.util;

import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import java.util.Collections;
import java.util.List;

public class AnimationUtils {
    private static final int DURAION = 300;
    private static final int DURATION_200 = 100;

    public static void complexAnimation(List<View> left2RightViewList, List<View> right2LeftViewList, int nowIndex, View fadeView) {
        AnimationUtils.left2Right(left2RightViewList, right2LeftViewList, nowIndex, fadeView);
    }

    public static void left2Right(final List<View> left2RightViewList, final List<View> right2LeftViewList, final int nowIndex, final View fadeView) {
        if (left2RightViewList.size() <= 0) {
            return;
        }
        fadeView.setEnabled(false);
        if (nowIndex < left2RightViewList.size()) {
            View nowView = left2RightViewList.get(nowIndex);
            TranslateAnimation animation = new TranslateAnimation(0.0f, (float)nowView.getWidth(), 0.0f, 0.0f);
            animation.setDuration(100L);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    ((View)left2RightViewList.get(nowIndex)).setVisibility(8);
                    AnimationUtils.left2Right(left2RightViewList, right2LeftViewList, nowIndex + 1, fadeView);
                }
            });
            nowView.startAnimation((Animation)animation);
        } else {
            AnimationUtils.fadeOutAnim(right2LeftViewList, fadeView);
        }
    }

    private static void fadeOutAnim(final List<View> right2LeftViewList, final View fadeView) {
        AlphaAnimation alphaAnim = new AlphaAnimation(1.0f, 0.0f);
        alphaAnim.setDuration(100L);
        alphaAnim.setFillAfter(true);
        alphaAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                fadeView.setSelected(!fadeView.isSelected());
                AnimationUtils.fadeInAnim(right2LeftViewList, fadeView);
            }
        });
        fadeView.startAnimation((Animation)alphaAnim);
    }

    private static void fadeInAnim(final List<View> right2LeftViewList, final View fadeView) {
        AlphaAnimation alphaAnim = new AlphaAnimation(0.0f, 1.0f);
        alphaAnim.setDuration(100L);
        alphaAnim.setFillAfter(true);
        alphaAnim.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                Collections.reverse(right2LeftViewList);
                AnimationUtils.right2Left(right2LeftViewList, 0, fadeView);
            }
        });
        fadeView.startAnimation((Animation)alphaAnim);
    }

    public static void right2Left(final List<View> viewList, final int nowIndex, final View fadeView) {
        if (viewList.size() <= 0) {
            return;
        }
        if (nowIndex < viewList.size()) {
            View nowView = viewList.get(nowIndex);
            nowView.setVisibility(0);
            TranslateAnimation animation = new TranslateAnimation((float)nowView.getWidth(), 0.0f, 0.0f, 0.0f);
            animation.setDuration(100L);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    AnimationUtils.right2Left(viewList, nowIndex + 1, fadeView);
                }
            });
            nowView.startAnimation((Animation)animation);
        } else {
            fadeView.setEnabled(true);
        }
    }

    public static void enterRight2Left(View view) {
        TranslateAnimation animation = new TranslateAnimation((float)view.getWidth(), 0.0f, 0.0f, 0.0f);
        animation.setDuration(300L);
        view.startAnimation((Animation)animation);
    }

    public static void enterLeft2Right(final View view) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, (float)view.getWidth(), 0.0f, 0.0f);
        animation.setDuration(300L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }
        });
        view.startAnimation((Animation)animation);
    }

    public static void enterUp2Bottom(View view) {
        AnimationUtils.enterUp2Bottom(view, false);
    }

    public static void enterUp2Bottom(final View view, boolean bAnimationListener) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, (float)(-view.getHeight()), 0.0f);
        animation.setDuration(300L);
        if (bAnimationListener) {
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                public void onAnimationEnd(Animation animation) {
                    view.setVisibility(8);
                }
            });
        }
        view.startAnimation((Animation)animation);
    }

    public static void enterBottom2Up(final View view) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-view.getHeight()));
        animation.setDuration(300L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }
        });
        view.startAnimation((Animation)animation);
    }

    public static void enterBottom2Up(final View view, final View view1) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)(-view.getHeight()));
        animation.setDuration(300L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
                if (null != view1) {
                    view1.setVisibility(8);
                }
            }
        });
        view.startAnimation((Animation)animation);
    }

    public static void fromUpToBottom(final View view) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, 0.0f, (float)view.getHeight());
        animation.setDuration(300L);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                view.setVisibility(8);
            }
        });
        view.startAnimation((Animation)animation);
    }

    public static void fromBottomToUp(View view) {
        TranslateAnimation animation = new TranslateAnimation(0.0f, 0.0f, (float)view.getHeight(), 0.0f);
        animation.setDuration(300L);
        view.startAnimation((Animation)animation);
    }

    private static class MyAnimationListener
    implements Animation.AnimationListener {
        private View view;

        public MyAnimationListener(View view) {
            this.view = view;
        }

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            this.view.setVisibility(8);
        }

        public void onAnimationRepeat(Animation animation) {
        }
    }
}

