/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.fastsdk.util;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.ListAdapter;
import android.widget.ListView;
import com.gensee.common.RTSharedPref;
import com.gensee.common.ServiceType;
import com.gensee.fastsdk.ui.BaseActivity;
import com.gensee.fastsdk.util.GenseeToast;
import com.gensee.fastsdk.util.PreferUtil;
import com.gensee.fastsdk.util.ResManager;
import com.gensee.room.RTRoom;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.upload.LogProperty;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenseeUtils {
    protected static final String TAG = "GenseeUtils";
    public static final String ALIPAY_PKG_NAME = "com.eg.android.AlipayGphone";
    private static final AtomicInteger sNextGeneratedId = new AtomicInteger(1);

    public static boolean isAppInstalled(Context context, String packageName) {
        PackageManager packageManager = context.getPackageManager();
        List pinfo = packageManager.getInstalledPackages(0);
        ArrayList<String> pName = new ArrayList<String>();
        if (pinfo != null) {
            for (int i = 0; i < pinfo.size(); ++i) {
                String pn = ((PackageInfo)pinfo.get((int)i)).packageName;
                pName.add(pn);
            }
        }
        return pName.contains(packageName);
    }

    public static String getVersionName(Context context) {
        PackageManager packageManager = context.getPackageManager();
        PackageInfo packInfo = null;
        try {
            packInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int dp2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(scale * dpValue + 0.5f);
    }

    public static String filterNickName(String nickName) {
        String value = nickName;
        if (null != value && value.length() > 12) {
            value = value.substring(0, 12) + "...";
        }
        return value;
    }

    public static void hideSoftInputmethod(Context context) {
        Activity activity = (Activity)context;
        if (null != activity.getCurrentFocus()) {
            InputMethodManager im = (InputMethodManager)activity.getSystemService("input_method");
            im.hideSoftInputFromWindow(activity.getCurrentFocus().getApplicationWindowToken(), 2);
        }
    }

    public static String getTimeHHMMSS(int time) {
        int second = time;
        return String.format(Locale.CHINESE, "%02d:%02d:%02d", second / 3600, second / 60 % 60, second % 60);
    }

    public static void autoSendCrashLog(Context context) {
        if (GenseeLog.containsStackFile()) {
            int siteId = PreferUtil.getIns().getInt("site.id", 0);
            String liveId = PreferUtil.getIns().getString("training.class.id", "");
            String userId = PreferUtil.getIns().getString("training.user.my.id", "");
            String userNickName = PreferUtil.getIns().getString("training.user.my.name", "");
            GenseeUtils.sendLog(context, true, siteId <= 0 ? "" : siteId + "", liveId, userId, userNickName);
            PreferUtil.getIns().putInt("site.id", RTSharedPref.getIns().getInt("site.id", 0));
            PreferUtil.getIns().putString("training.class.id", RTSharedPref.getIns().getString("training.class.id", ""));
            PreferUtil.getIns().putString("training.user.my.id", RTSharedPref.getIns().getString("training.user.my.id", ""));
            PreferUtil.getIns().putString("training.user.my.name", RTSharedPref.getIns().getString("training.user.my.name", ""));
        }
    }

    public static void selfSendLog(Context context) {
        int siteId = RTSharedPref.getIns().getInt("site.id", 0);
        String liveId = RTSharedPref.getIns().getString("training.class.id", "");
        String userId = RTSharedPref.getIns().getString("training.user.my.id", "");
        String userNickName = RTSharedPref.getIns().getString("training.user.my.name", "");
        GenseeUtils.sendLog(context, false, siteId <= 0 ? "" : siteId + "", liveId, userId, userNickName);
    }

    public static void directSendLog(final Context context, final boolean isAuto) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Map texts;
                GenseeUtils.preSendLog(context, isAuto);
                boolean isZipCurLog = !isAuto;
                String siteId = "";
                String liveId = "";
                String userId = "";
                String nickName = "";
                Map datas = LogProperty.getIns().getPropertyList(context);
                if (null != datas) {
                    String string = siteId = null == datas.get("siteid") ? "" : (String)datas.get("siteid");
                    if (siteId.equals("0")) {
                        siteId = "";
                    }
                    String string2 = userId = null == datas.get("userid") ? "" : (String)datas.get("userid");
                    if (userId.equals("0")) {
                        userId = "";
                    }
                    String string3 = liveId = null == datas.get("confid") ? "" : (String)datas.get("confid");
                }
                if (null != (texts = LogProperty.getIns().getTextList(""))) {
                    nickName = null == texts.get("username") ? "" : (String)texts.get("username");
                }
                GenseeLog.zipFile((boolean)isZipCurLog, (String)siteId, (String)liveId, (String)userId, (String)nickName);
                String desc = null;
                if (isAuto) {
                    if (GenseeLog.containsZipStackFile()) {
                        desc = "Android GLive 1.2 stack log auto upload";
                    }
                } else {
                    desc = "Android GLive 1.2 upload by user";
                }
                String reportRet = null;
                if (desc != null) {
                    reportRet = GenseeLog.reportDiagonse((Context)context, (String)desc, (ServiceType)ServiceType.WEBCAST, (boolean)isZipCurLog, (boolean)false);
                }
                GenseeUtils.endSendLog(context, isAuto, reportRet);
            }
        }).start();
    }

    public static void sendLog(final Context context, final boolean isAuto, final String siteId, final String liveId, final String userId, final String userNickName) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                GenseeUtils.preSendLog(context, isAuto);
                boolean isZipCurLog = !isAuto;
                GenseeLog.zipFile((boolean)isZipCurLog, (String)siteId, (String)liveId, (String)userId, (String)userNickName);
                String desc = null;
                if (isAuto) {
                    if (GenseeLog.containsZipStackFile()) {
                        desc = "Android fastsdk 3.5 stack log auto upload";
                    }
                } else {
                    desc = "Android fastsdk 3.5 upload by user";
                }
                String reportRet = null;
                if (desc != null) {
                    reportRet = RTRoom.getIns().reportDiagonse(desc, isAuto, isZipCurLog);
                }
                GenseeUtils.endSendLog(context, isAuto, reportRet);
            }
        }).start();
    }

    private static void preSendLog(final Context context, boolean isAuto) {
        if (!isAuto) {
            ((Activity)context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ((BaseActivity)context).showProgressDialog(ResManager.getStringId("gs_diagnosis_ing"));
                }
            });
        }
    }

    private static void endSendLog(final Context context, boolean isAuto, final String reportRet) {
        if (!isAuto) {
            ((Activity)context).runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    ((BaseActivity)context).dismissProgressDialog();
                    boolean isOk = reportRet != null && reportRet.contains("<result>ok</result>");
                    GenseeToast.showToast(context, context.getString(isOk ? ResManager.getStringId("gs_diagnosis_end") : ResManager.getStringId("gs_diagnosis_fail")), true, ResManager.getDrawableId("gs_warming_bg"), isOk ? ResManager.getDrawableId("gs_diagnose_ok") : ResManager.getDrawableId("gs_diagnose_failure"));
                }
            });
        }
    }

    public static boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static boolean checkPackagePermission(Context context, String sType) {
        PackageManager pm = context.getPackageManager();
        boolean permission = 0 == pm.checkPermission(sType, "packageName");
        return permission;
    }

    public static String formatText(String name, int maxCNCount) {
        if (TextUtils.isEmpty((CharSequence)name) || maxCNCount < 1) {
            return null;
        }
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = null;
        int count = 0;
        for (int i = 0; i < name.length(); ++i) {
            String temp = name.substring(i, i + 1);
            m = p.matcher(temp);
            count = m.matches() ? (count += 2) : ++count;
            if (count <= maxCNCount * 2) continue;
            name = name.substring(0, i - 1) + "...";
            break;
        }
        return name;
    }

    public static void setListViewHeightBasedOnChildren(ListView listView, int itemCount) {
        ListAdapter listAdapter = listView.getAdapter();
        if (listAdapter == null) {
            return;
        }
        int totalHeight = 0;
        for (int i = 0; i < listAdapter.getCount() && i <= itemCount; ++i) {
            View listItem = listAdapter.getView(i, null, (ViewGroup)listView);
            if (null == listItem) continue;
            listItem.measure(0, 0);
            totalHeight += listItem.getMeasuredHeight();
        }
        ViewGroup.LayoutParams params = listView.getLayoutParams();
        params.height = totalHeight + listView.getDividerHeight() * (listAdapter.getCount() <= itemCount ? listAdapter.getCount() - 1 : itemCount - 1);
        listView.setLayoutParams(params);
    }

    public static String getRMBText(int centMoney) {
        double yuanMoney = (double)centMoney / 100.0;
        DecimalFormat format = new DecimalFormat("0.00");
        return format.format(yuanMoney);
    }

    public static Activity getActivityFromView(View view) {
        Context context = view.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static int getVideoCaptureOrientation(int screenOrientation) {
        boolean isPortraitUnCrop = PreferUtil.getIns().getBoolean("orientation.portrait.uncrop");
        return screenOrientation == 1 ? (isPortraitUnCrop ? 10 : 1) : 2;
    }

    public static boolean isNetEnable(Context context) {
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getNetworkInfo(0);
        NetworkInfo.State state = null;
        if (networkInfo != null && (state = networkInfo.getState()) == NetworkInfo.State.CONNECTED) {
            return true;
        }
        return GenseeUtils.isWifi(context);
    }

    public static boolean isWifi(Context context) {
        NetworkInfo.State state;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = manager.getNetworkInfo(1);
        return networkInfo != null && (state = networkInfo.getState()) == NetworkInfo.State.CONNECTED;
    }

    public static int generateViewId() {
        if (Build.VERSION.SDK_INT < 17) {
            int newValue;
            int result;
            do {
                if ((newValue = (result = sNextGeneratedId.get()) + 1) <= 0xFFFFFF) continue;
                newValue = 1;
            } while (!sNextGeneratedId.compareAndSet(result, newValue));
            return result;
        }
        return View.generateViewId();
    }
}

