/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.util.SystemClock;

public class DanmakuFilters {
    public static final int FILTER_TYPE_TYPE = 1;
    public static final int FILYER_TYPE_QUANTITY = 2;
    public static final int FILTER_TYPE_ELAPSED_TIME = 4;
    public static final int FILTER_TYPE_TEXTCOLOR = 8;
    public static final int FILTER_TYPE_USER_ID = 16;
    public static final int FILTER_TYPE_USER_HASH = 32;
    public static final int FILTER_TYPE_USER_GUEST = 64;
    public static final int FILTER_TYPE_DUPLICATE_MERGE = 128;
    public static final int FILTER_TYPE_MAXIMUM_LINES = 256;
    public static final int FILTER_TYPE_OVERLAPPING = 512;
    public static final String TAG_TYPE_DANMAKU_FILTER = "1010_Filter";
    public static final String TAG_QUANTITY_DANMAKU_FILTER = "1011_Filter";
    public static final String TAG_ELAPSED_TIME_FILTER = "1012_Filter";
    public static final String TAG_TEXT_COLOR_DANMAKU_FILTER = "1013_Filter";
    public static final String TAG_USER_ID_FILTER = "1014_Filter";
    public static final String TAG_USER_HASH_FILTER = "1015_Filter";
    public static final String TAG_GUEST_FILTER = "1016_Filter";
    public static final String TAG_DUPLICATE_FILTER = "1017_Filter";
    public static final String TAG_MAXIMUN_LINES_FILTER = "1018_Filter";
    public static final String TAG_OVERLAPPING_FILTER = "1019_Filter";
    public final Exception filterException = new Exception("not suuport this filter tag");
    private final Map<String, IDanmakuFilter<?>> filters = Collections.synchronizedSortedMap(new TreeMap());
    private final Map<String, IDanmakuFilter<?>> filtersSecondary = Collections.synchronizedSortedMap(new TreeMap());
    IDanmakuFilter<?>[] mFilterArray = new IDanmakuFilter[0];
    IDanmakuFilter<?>[] mFilterArraySecondary = new IDanmakuFilter[0];

    public void filter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext context) {
        IDanmakuFilter<?>[] iDanmakuFilterArray = this.mFilterArray;
        int n = this.mFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDanmakuFilter<?> f = iDanmakuFilterArray[n2];
            if (f != null) {
                boolean filtered = f.filter(danmaku, index, totalsizeInScreen, timer, fromCachingTask, context);
                danmaku.filterResetFlag = context.mGlobalFlagValues.FILTER_RESET_FLAG;
                if (filtered) break;
            }
            ++n2;
        }
    }

    public boolean filterSecondary(BaseDanmaku danmaku, int lines, int totalsizeInScreen, DanmakuTimer timer, boolean willHit, DanmakuContext context) {
        IDanmakuFilter<?>[] iDanmakuFilterArray = this.mFilterArraySecondary;
        int n = this.mFilterArraySecondary.length;
        int n2 = 0;
        while (n2 < n) {
            IDanmakuFilter<?> f = iDanmakuFilterArray[n2];
            if (f != null) {
                boolean filtered = f.filter(danmaku, lines, totalsizeInScreen, timer, willHit, context);
                danmaku.filterResetFlag = context.mGlobalFlagValues.FILTER_RESET_FLAG;
                if (filtered) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public IDanmakuFilter<?> get(String tag) {
        return this.get(tag, true);
    }

    public IDanmakuFilter<?> get(String tag, boolean primary) {
        IDanmakuFilter<?> f;
        IDanmakuFilter<?> iDanmakuFilter = f = primary ? this.filters.get(tag) : this.filtersSecondary.get(tag);
        if (f == null) {
            f = this.registerFilter(tag, primary);
        }
        return f;
    }

    public IDanmakuFilter<?> registerFilter(String tag) {
        return this.registerFilter(tag, true);
    }

    public IDanmakuFilter<?> registerFilter(String tag, boolean primary) {
        if (tag == null) {
            this.throwFilterException();
            return null;
        }
        BaseDanmakuFilter filter = this.filters.get(tag);
        if (filter == null) {
            if (TAG_TYPE_DANMAKU_FILTER.equals(tag)) {
                filter = new TypeDanmakuFilter();
            } else if (TAG_QUANTITY_DANMAKU_FILTER.equals(tag)) {
                filter = new QuantityDanmakuFilter();
            } else if (TAG_ELAPSED_TIME_FILTER.equals(tag)) {
                filter = new ElapsedTimeFilter();
            } else if (TAG_TEXT_COLOR_DANMAKU_FILTER.equals(tag)) {
                filter = new TextColorFilter();
            } else if (TAG_USER_ID_FILTER.equals(tag)) {
                filter = new UserIdFilter();
            } else if (TAG_USER_HASH_FILTER.equals(tag)) {
                filter = new UserHashFilter();
            } else if (TAG_GUEST_FILTER.equals(tag)) {
                filter = new GuestFilter();
            } else if (TAG_DUPLICATE_FILTER.equals(tag)) {
                filter = new DuplicateMergingFilter();
            } else if (TAG_MAXIMUN_LINES_FILTER.equals(tag)) {
                filter = new MaximumLinesFilter();
            } else if (TAG_OVERLAPPING_FILTER.equals(tag)) {
                filter = new OverlappingFilter();
            }
        }
        if (filter == null) {
            this.throwFilterException();
            return null;
        }
        filter.setData(null);
        if (primary) {
            this.filters.put(tag, filter);
            this.mFilterArray = this.filters.values().toArray(this.mFilterArray);
        } else {
            this.filtersSecondary.put(tag, filter);
            this.mFilterArraySecondary = this.filtersSecondary.values().toArray(this.mFilterArraySecondary);
        }
        return filter;
    }

    public void unregisterFilter(String tag) {
        this.unregisterFilter(tag, true);
    }

    public void unregisterFilter(String tag, boolean primary) {
        IDanmakuFilter<?> f;
        IDanmakuFilter<?> iDanmakuFilter = f = primary ? this.filters.remove(tag) : this.filtersSecondary.remove(tag);
        if (f != null) {
            f.clear();
            if (primary) {
                this.mFilterArray = this.filters.values().toArray(this.mFilterArray);
            } else {
                this.mFilterArraySecondary = this.filtersSecondary.values().toArray(this.mFilterArraySecondary);
            }
        }
    }

    public void clear() {
        IDanmakuFilter<?> f;
        IDanmakuFilter<?>[] iDanmakuFilterArray = this.mFilterArray;
        int n = this.mFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = iDanmakuFilterArray[n2];
            if (f != null) {
                f.clear();
            }
            ++n2;
        }
        iDanmakuFilterArray = this.mFilterArraySecondary;
        n = this.mFilterArraySecondary.length;
        n2 = 0;
        while (n2 < n) {
            f = iDanmakuFilterArray[n2];
            if (f != null) {
                f.clear();
            }
            ++n2;
        }
    }

    public void reset() {
        IDanmakuFilter<?> f;
        IDanmakuFilter<?>[] iDanmakuFilterArray = this.mFilterArray;
        int n = this.mFilterArray.length;
        int n2 = 0;
        while (n2 < n) {
            f = iDanmakuFilterArray[n2];
            if (f != null) {
                f.reset();
            }
            ++n2;
        }
        iDanmakuFilterArray = this.mFilterArraySecondary;
        n = this.mFilterArraySecondary.length;
        n2 = 0;
        while (n2 < n) {
            f = iDanmakuFilterArray[n2];
            if (f != null) {
                f.reset();
            }
            ++n2;
        }
    }

    public void release() {
        this.clear();
        this.filters.clear();
        this.mFilterArray = new IDanmakuFilter[0];
        this.filtersSecondary.clear();
        this.mFilterArraySecondary = new IDanmakuFilter[0];
    }

    private void throwFilterException() {
        try {
            throw this.filterException;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static abstract class BaseDanmakuFilter<T>
    implements IDanmakuFilter<T> {
        @Override
        public void clear() {
        }
    }

    public static class DuplicateMergingFilter
    extends BaseDanmakuFilter<Void> {
        protected final IDanmakus blockedDanmakus = new Danmakus(4);
        protected final LinkedHashMap<String, BaseDanmaku> currentDanmakus = new LinkedHashMap();
        private final IDanmakus passedDanmakus = new Danmakus(4);

        private final void removeTimeoutDanmakus(IDanmakus danmakus, long limitTime) {
            IDanmakuIterator it = danmakus.iterator();
            long startTime = SystemClock.uptimeMillis();
            while (it.hasNext()) {
                try {
                    BaseDanmaku item = it.next();
                    if (!item.isTimeOut()) break;
                    it.remove();
                }
                catch (Exception e) {
                    break;
                }
                if (SystemClock.uptimeMillis() - startTime > limitTime) break;
            }
        }

        private void removeTimeoutDanmakus(LinkedHashMap<String, BaseDanmaku> danmakus, int limitTime) {
            Iterator<Map.Entry<String, BaseDanmaku>> it = danmakus.entrySet().iterator();
            long startTime = SystemClock.uptimeMillis();
            while (it.hasNext()) {
                try {
                    Map.Entry<String, BaseDanmaku> entry = it.next();
                    BaseDanmaku item = entry.getValue();
                    if (!item.isTimeOut()) break;
                    it.remove();
                }
                catch (Exception e) {
                    break;
                }
                if (SystemClock.uptimeMillis() - startTime > (long)limitTime) break;
            }
        }

        public synchronized boolean needFilter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask) {
            this.removeTimeoutDanmakus(this.blockedDanmakus, 2L);
            this.removeTimeoutDanmakus(this.passedDanmakus, 2L);
            this.removeTimeoutDanmakus(this.currentDanmakus, 3);
            if (this.blockedDanmakus.contains(danmaku) && !danmaku.isOutside()) {
                return true;
            }
            if (this.passedDanmakus.contains(danmaku)) {
                return false;
            }
            if (this.currentDanmakus.containsKey(danmaku.text)) {
                this.currentDanmakus.put(String.valueOf(danmaku.text), danmaku);
                this.blockedDanmakus.removeItem(danmaku);
                this.blockedDanmakus.addItem(danmaku);
                return true;
            }
            this.currentDanmakus.put(String.valueOf(danmaku.text), danmaku);
            this.passedDanmakus.addItem(danmaku);
            return false;
        }

        @Override
        public boolean filter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered = this.needFilter(danmaku, index, totalsizeInScreen, timer, fromCachingTask);
            if (filtered) {
                danmaku.mFilterParam |= 0x80;
            }
            return filtered;
        }

        @Override
        public void setData(Void data) {
        }

        @Override
        public synchronized void reset() {
            this.passedDanmakus.clear();
            this.blockedDanmakus.clear();
            this.currentDanmakus.clear();
        }

        @Override
        public void clear() {
            this.reset();
        }
    }

    public static class ElapsedTimeFilter
    extends BaseDanmakuFilter<Object> {
        long mMaxTime = 20L;

        private synchronized boolean needFilter(BaseDanmaku danmaku, int orderInScreen, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask) {
            if (timer == null || !danmaku.isOutside()) {
                return false;
            }
            long elapsedTime = SystemClock.uptimeMillis() - timer.currMillisecond;
            return elapsedTime >= this.mMaxTime;
        }

        @Override
        public boolean filter(BaseDanmaku danmaku, int orderInScreen, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered = this.needFilter(danmaku, orderInScreen, totalsizeInScreen, timer, fromCachingTask);
            if (filtered) {
                danmaku.mFilterParam |= 4;
            }
            return filtered;
        }

        @Override
        public void setData(Object data) {
            this.reset();
        }

        @Override
        public synchronized void reset() {
        }

        @Override
        public void clear() {
            this.reset();
        }
    }

    public static class GuestFilter
    extends BaseDanmakuFilter<Boolean> {
        private Boolean mBlock = false;

        @Override
        public boolean filter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered;
            boolean bl = filtered = this.mBlock != false && danmaku.isGuest;
            if (filtered) {
                danmaku.mFilterParam |= 0x40;
            }
            return filtered;
        }

        @Override
        public void setData(Boolean data) {
            this.mBlock = data;
        }

        @Override
        public void reset() {
            this.mBlock = false;
        }
    }

    public static interface IDanmakuFilter<T> {
        public boolean filter(BaseDanmaku var1, int var2, int var3, DanmakuTimer var4, boolean var5, DanmakuContext var6);

        public void setData(T var1);

        public void reset();

        public void clear();
    }

    public static class MaximumLinesFilter
    extends BaseDanmakuFilter<Map<Integer, Integer>> {
        private Map<Integer, Integer> mMaximumLinesPairs;

        @Override
        public boolean filter(BaseDanmaku danmaku, int lines, int totalsizeInScreen, DanmakuTimer timer, boolean willHit, DanmakuContext config) {
            boolean filtered = false;
            if (this.mMaximumLinesPairs != null) {
                Integer maxLines = this.mMaximumLinesPairs.get(danmaku.getType());
                boolean bl = filtered = maxLines != null && lines >= maxLines;
                if (filtered) {
                    danmaku.mFilterParam |= 0x100;
                }
            }
            return filtered;
        }

        @Override
        public void setData(Map<Integer, Integer> data) {
            this.mMaximumLinesPairs = data;
        }

        @Override
        public void reset() {
            this.mMaximumLinesPairs = null;
        }
    }

    public static class OverlappingFilter
    extends BaseDanmakuFilter<Map<Integer, Boolean>> {
        private Map<Integer, Boolean> mEnabledPairs;

        @Override
        public boolean filter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean willHit, DanmakuContext config) {
            boolean filtered = false;
            if (this.mEnabledPairs != null) {
                Boolean enabledValue = this.mEnabledPairs.get(danmaku.getType());
                boolean bl = filtered = enabledValue != null && enabledValue != false && willHit;
                if (filtered) {
                    danmaku.mFilterParam |= 0x200;
                }
            }
            return filtered;
        }

        @Override
        public void setData(Map<Integer, Boolean> data) {
            this.mEnabledPairs = data;
        }

        @Override
        public void reset() {
            this.mEnabledPairs = null;
        }
    }

    public static class QuantityDanmakuFilter
    extends BaseDanmakuFilter<Integer> {
        protected int mMaximumSize = -1;
        protected BaseDanmaku mLastSkipped = null;

        private boolean needFilter(BaseDanmaku danmaku, int orderInScreen, int totalSizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext context) {
            if (this.mMaximumSize <= 0 || danmaku.getType() != 1) {
                return false;
            }
            if (totalSizeInScreen < this.mMaximumSize || danmaku.isShown() || this.mLastSkipped != null && danmaku.time - this.mLastSkipped.time > context.mDanmakuFactory.MAX_DANMAKU_DURATION / 20L) {
                this.mLastSkipped = danmaku;
                return false;
            }
            if (orderInScreen > this.mMaximumSize && !danmaku.isTimeOut()) {
                return true;
            }
            this.mLastSkipped = danmaku;
            return false;
        }

        @Override
        public synchronized boolean filter(BaseDanmaku danmaku, int orderInScreen, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered = this.needFilter(danmaku, orderInScreen, totalsizeInScreen, timer, fromCachingTask, config);
            if (filtered) {
                danmaku.mFilterParam |= 2;
            }
            return filtered;
        }

        @Override
        public void setData(Integer data) {
            this.reset();
            if (data == null) {
                return;
            }
            if (data != this.mMaximumSize) {
                this.mMaximumSize = data;
            }
        }

        @Override
        public synchronized void reset() {
            this.mLastSkipped = null;
        }

        @Override
        public void clear() {
            this.reset();
        }
    }

    public static class TextColorFilter
    extends BaseDanmakuFilter<List<Integer>> {
        public List<Integer> mWhiteList = new ArrayList<Integer>();

        private void addToWhiteList(Integer color) {
            if (!this.mWhiteList.contains(color)) {
                this.mWhiteList.add(color);
            }
        }

        @Override
        public boolean filter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered;
            boolean bl = filtered = danmaku != null && !this.mWhiteList.contains(danmaku.textColor);
            if (filtered) {
                danmaku.mFilterParam |= 8;
            }
            return filtered;
        }

        @Override
        public void setData(List<Integer> data) {
            this.reset();
            if (data != null) {
                for (Integer i : data) {
                    this.addToWhiteList(i);
                }
            }
        }

        @Override
        public void reset() {
            this.mWhiteList.clear();
        }
    }

    public static class TypeDanmakuFilter
    extends BaseDanmakuFilter<List<Integer>> {
        final List<Integer> mFilterTypes = Collections.synchronizedList(new ArrayList());

        public void enableType(Integer type) {
            if (!this.mFilterTypes.contains(type)) {
                this.mFilterTypes.add(type);
            }
        }

        public void disableType(Integer type) {
            if (this.mFilterTypes.contains(type)) {
                this.mFilterTypes.remove(type);
            }
        }

        @Override
        public boolean filter(BaseDanmaku danmaku, int orderInScreen, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered;
            boolean bl = filtered = danmaku != null && this.mFilterTypes.contains(danmaku.getType());
            if (filtered) {
                danmaku.mFilterParam |= 1;
            }
            return filtered;
        }

        @Override
        public void setData(List<Integer> data) {
            this.reset();
            if (data != null) {
                for (Integer i : data) {
                    this.enableType(i);
                }
            }
        }

        @Override
        public void reset() {
            this.mFilterTypes.clear();
        }
    }

    public static abstract class UserFilter<T>
    extends BaseDanmakuFilter<List<T>> {
        public List<T> mBlackList = new ArrayList<T>();

        private void addToBlackList(T id) {
            if (!this.mBlackList.contains(id)) {
                this.mBlackList.add(id);
            }
        }

        @Override
        public abstract boolean filter(BaseDanmaku var1, int var2, int var3, DanmakuTimer var4, boolean var5, DanmakuContext var6);

        @Override
        public void setData(List<T> data) {
            this.reset();
            if (data != null) {
                for (T i : data) {
                    this.addToBlackList(i);
                }
            }
        }

        @Override
        public void reset() {
            this.mBlackList.clear();
        }
    }

    public static class UserHashFilter
    extends UserFilter<String> {
        @Override
        public boolean filter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered;
            boolean bl = filtered = danmaku != null && this.mBlackList.contains(danmaku.userHash);
            if (filtered) {
                danmaku.mFilterParam |= 0x20;
            }
            return filtered;
        }
    }

    public static class UserIdFilter
    extends UserFilter<Integer> {
        @Override
        public boolean filter(BaseDanmaku danmaku, int index, int totalsizeInScreen, DanmakuTimer timer, boolean fromCachingTask, DanmakuContext config) {
            boolean filtered;
            boolean bl = filtered = danmaku != null && this.mBlackList.contains(danmaku.userId);
            if (filtered) {
                danmaku.mFilterParam |= 0x10;
            }
            return filtered;
        }
    }
}

