/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.danmaku.model;

import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDisplayer;

public class SpecialDanmaku
extends BaseDanmaku {
    public float beginX;
    public float beginY;
    public float endX;
    public float endY;
    public float deltaX;
    public float deltaY;
    public long translationDuration;
    public long translationStartDelay;
    public int beginAlpha;
    public int endAlpha;
    public int deltaAlpha;
    public long alphaDuration;
    public float rotateX;
    public float rotateZ;
    public float pivotX;
    public float pivotY;
    private float[] currStateValues = new float[4];
    public LinePath[] linePaths;

    @Override
    public void layout(IDisplayer displayer, float x, float y) {
        this.getRectAtTime(displayer, this.mTimer.currMillisecond);
    }

    @Override
    public float[] getRectAtTime(IDisplayer displayer, long currTime) {
        if (!this.isMeasured()) {
            return null;
        }
        long deltaTime = currTime - this.time;
        if (this.alphaDuration > 0L && this.deltaAlpha != 0) {
            if (deltaTime >= this.alphaDuration) {
                this.alpha = this.endAlpha;
            } else {
                float alphaProgress = (float)deltaTime / (float)this.alphaDuration;
                int vectorAlpha = (int)((float)this.deltaAlpha * alphaProgress);
                this.alpha = this.beginAlpha + vectorAlpha;
            }
        }
        float currX = this.beginX;
        float currY = this.beginY;
        long dtime = deltaTime - this.translationStartDelay;
        if (this.translationDuration > 0L && dtime >= 0L && dtime <= this.translationDuration) {
            float tranalationProgress = (float)dtime / (float)this.translationDuration;
            if (this.linePaths != null) {
                LinePath currentLinePath = null;
                LinePath[] linePathArray = this.linePaths;
                int n = this.linePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    LinePath line = linePathArray[n2];
                    if (dtime >= line.beginTime && dtime < line.endTime) {
                        currentLinePath = line;
                        break;
                    }
                    currX = line.pEnd.x;
                    currY = line.pEnd.y;
                    ++n2;
                }
                if (currentLinePath != null) {
                    float deltaX = currentLinePath.delatX;
                    float deltaY = currentLinePath.deltaY;
                    tranalationProgress = (float)(deltaTime - currentLinePath.beginTime) / (float)currentLinePath.duration;
                    float beginX = currentLinePath.pBegin.x;
                    float beginY = currentLinePath.pBegin.y;
                    if (deltaX != 0.0f) {
                        float vectorX = deltaX * tranalationProgress;
                        currX = beginX + vectorX;
                    }
                    if (deltaY != 0.0f) {
                        float vectorY = deltaY * tranalationProgress;
                        currY = beginY + vectorY;
                    }
                }
            } else {
                if (this.deltaX != 0.0f) {
                    float vectorX = this.deltaX * tranalationProgress;
                    currX = this.beginX + vectorX;
                }
                if (this.deltaY != 0.0f) {
                    float vectorY = this.deltaY * tranalationProgress;
                    currY = this.beginY + vectorY;
                }
            }
        } else if (dtime > this.translationDuration) {
            currX = this.endX;
            currY = this.endY;
        }
        this.currStateValues[0] = currX;
        this.currStateValues[1] = currY;
        this.currStateValues[2] = currX + this.paintWidth;
        this.currStateValues[3] = currY + this.paintHeight;
        this.setVisibility(!this.isOutside());
        return this.currStateValues;
    }

    @Override
    public float getLeft() {
        return this.currStateValues[0];
    }

    @Override
    public float getTop() {
        return this.currStateValues[1];
    }

    @Override
    public float getRight() {
        return this.currStateValues[2];
    }

    @Override
    public float getBottom() {
        return this.currStateValues[3];
    }

    @Override
    public int getType() {
        return 7;
    }

    public void setTranslationData(float beginX, float beginY, float endX, float endY, long translationDuration, long translationStartDelay) {
        this.beginX = beginX;
        this.beginY = beginY;
        this.endX = endX;
        this.endY = endY;
        this.deltaX = endX - beginX;
        this.deltaY = endY - beginY;
        this.translationDuration = translationDuration;
        this.translationStartDelay = translationStartDelay;
    }

    public void setAlphaData(int beginAlpha, int endAlpha, long alphaDuration) {
        this.beginAlpha = beginAlpha;
        this.endAlpha = endAlpha;
        this.deltaAlpha = endAlpha - beginAlpha;
        this.alphaDuration = alphaDuration;
        if (this.deltaAlpha != 0 && beginAlpha != AlphaValue.MAX) {
            this.alpha = beginAlpha;
        }
    }

    public void setLinePathData(float[][] points) {
        if (points != null) {
            int length = points.length;
            this.beginX = points[0][0];
            this.beginY = points[0][1];
            this.endX = points[length - 1][0];
            this.endY = points[length - 1][1];
            if (points.length > 1) {
                this.linePaths = new LinePath[points.length - 1];
                int i = 0;
                while (i < this.linePaths.length) {
                    this.linePaths[i] = new LinePath();
                    this.linePaths[i].setPoints(new Point(points[i][0], points[i][1]), new Point(points[i + 1][0], points[i + 1][1]));
                    ++i;
                }
                float totalDistance = 0.0f;
                LinePath[] linePathArray = this.linePaths;
                int n = this.linePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    LinePath line = linePathArray[n2];
                    totalDistance += line.getDistance();
                    ++n2;
                }
                LinePath lastLine = null;
                LinePath[] linePathArray2 = this.linePaths;
                int n3 = this.linePaths.length;
                n = 0;
                while (n < n3) {
                    LinePath line = linePathArray2[n];
                    line.duration = (long)(line.getDistance() / totalDistance * (float)this.translationDuration);
                    line.beginTime = lastLine == null ? 0L : lastLine.endTime;
                    line.endTime = line.beginTime + line.duration;
                    lastLine = line;
                    ++n;
                }
            }
        }
    }

    public void updateData(float scale) {
    }

    public class LinePath {
        Point pBegin;
        Point pEnd;
        public long duration;
        public long beginTime;
        public long endTime;
        float delatX;
        float deltaY;

        public void setPoints(Point pBegin, Point pEnd) {
            this.pBegin = pBegin;
            this.pEnd = pEnd;
            this.delatX = pEnd.x - pBegin.x;
            this.deltaY = pEnd.y - pBegin.y;
        }

        public float getDistance() {
            return this.pEnd.getDistance(this.pBegin);
        }

        public float[] getBeginPoint() {
            return new float[]{this.pBegin.x, this.pBegin.y};
        }

        public float[] getEndPoint() {
            return new float[]{this.pEnd.x, this.pEnd.y};
        }
    }

    private class Point {
        float x;
        float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public float getDistance(Point p) {
            float _x = Math.abs(this.x - p.x);
            float _y = Math.abs(this.y - p.y);
            return (float)Math.sqrt(_x * _x + _y * _y);
        }
    }
}

