/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.heartbeat;

import android.os.Process;
import com.gensee.heartbeat.IHeartBeat;
import com.gensee.taskret.IGSTask;
import com.gensee.utils.GenseeLog;
import java.util.LinkedList;
import java.util.Queue;

public abstract class AbsHeartBeat
implements IHeartBeat {
    private IHeartBeat.INativeHeartBeat mVodHeartbeat;
    private IHeartBeat.INativeHeartBeat castHearbeat;
    private Queue<IGSTask> tasks = new LinkedList<IGSTask>();
    private Object lock = new Object();
    private boolean isVodNeed = false;
    private boolean isCastNeed = false;
    public boolean isInited = false;
    private static final String TAG = "AbsHeartBeat";

    protected void setThreadPriority() {
        Process.setThreadPriority((int)-19);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doTasks() {
        IGSTask task = null;
        int ret = 0;
        Object object = this.lock;
        synchronized (object) {
            if (!this.tasks.isEmpty()) {
                task = this.tasks.poll();
            }
        }
        if (null != task) {
            try {
                ret = task.doTask();
            }
            catch (Throwable e) {
                GenseeLog.w((String)TAG, (String)e.getMessage());
            }
        }
        switch (ret) {
            case 1: {
                this.isVodNeed = true;
                break;
            }
            case 2: {
                this.isVodNeed = false;
                break;
            }
            case 4: {
                this.isCastNeed = false;
                break;
            }
            case 3: {
                this.isCastNeed = true;
                break;
            }
        }
        if (this.isVodNeed && null != this.mVodHeartbeat) {
            try {
                this.mVodHeartbeat.nativeHeartBeat();
            }
            catch (Throwable e) {
                GenseeLog.w((String)TAG, (String)e.getMessage());
            }
        }
        if (this.isCastNeed && this.castHearbeat != null) {
            try {
                this.castHearbeat.nativeHeartBeat();
            }
            catch (Throwable e) {
                GenseeLog.w((String)TAG, (String)e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addTask(IGSTask task) {
        Object object = this.lock;
        synchronized (object) {
            boolean ret = this.tasks.add(task);
            this.lock.notifyAll();
            return ret;
        }
    }

    @Override
    public void setCastHBeat(IHeartBeat.INativeHeartBeat beat) {
        this.castHearbeat = beat;
    }

    @Override
    public void setVodHBeat(IHeartBeat.INativeHeartBeat beat) {
        this.mVodHeartbeat = beat;
    }
}

