/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.adapter;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.gensee.adapter.AbstractAdapter;
import com.gensee.adapter.AbstractViewHolder;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.view.MyTextViewEx;

public abstract class AbsChatAdapter
extends AbstractAdapter {
    private Context mContext;
    public OnChatAdapterListener onChatAdapterListener;

    public void setOnChatAdapterListener(OnChatAdapterListener onChatAdapterListener) {
        this.onChatAdapterListener = onChatAdapterListener;
    }

    private long getSelfId() {
        if (null != this.onChatAdapterListener) {
            return this.onChatAdapterListener.getSelfId();
        }
        return -1L;
    }

    public AbsChatAdapter(Context context) {
        this.mContext = context;
    }

    protected abstract class AbsChatViewHolder
    extends AbstractViewHolder
    implements View.OnClickListener {
        private TextView mChatNameText;
        private TextView mChatTimeText;
        private MyTextViewEx mMyTextViewEx;
        private MyTextViewEx mMyTextViewConS;
        private ImageView mChatDeleteSysteContext;
        private long mCurrentTime;

        public AbsChatViewHolder(View view) {
            super(view);
        }

        public void initView(View view) {
            this.mChatNameText = (TextView)view.findViewById(this.getChatNameEdtid());
            this.mChatTimeText = (TextView)view.findViewById(this.getChatTimeTvid());
            this.mMyTextViewEx = (MyTextViewEx)view.findViewById(this.getChatContentTvId());
            this.mMyTextViewConS = (MyTextViewEx)view.findViewById(this.getChatSysTvId());
            this.mChatDeleteSysteContext = (ImageView)view.findViewById(this.getChatSysDelIvId());
        }

        public void initValue(final int positon) {
            final AbsChatMessage mAbsChatMessage = (AbsChatMessage)AbsChatAdapter.this.getItem(positon);
            if (mAbsChatMessage == null) {
                return;
            }
            int mSendNameSize = 0;
            int mReceiveNameSize = 0;
            this.mChatNameText.setTextColor(this.mChatNameText.getContext().getResources().getColor(17170444));
            this.mChatDeleteSysteContext.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AbsChatAdapter.this.objectList.remove(positon);
                    MsgQueue.getIns().deleteMsg(mAbsChatMessage);
                    AbsChatAdapter.this.notifyDataSetChanged();
                }
            });
            if (mAbsChatMessage instanceof SysMessage) {
                String mString = AbsChatAdapter.this.mContext.getResources().getString(this.getSysMsgTipId());
                int num = mString.length();
                mString = mString + mAbsChatMessage.getRich();
                SpannableStringBuilder style = new SpannableStringBuilder((CharSequence)mString);
                style.setSpan((Object)new ForegroundColorSpan(AbsChatAdapter.this.mContext.getResources().getColor(this.getSysMsgColorId())), 0, num, 33);
                this.mMyTextViewConS.setText((CharSequence)style);
                this.mChatNameText.setVisibility(8);
                this.mChatTimeText.setVisibility(8);
                this.mMyTextViewEx.setVisibility(8);
                this.mMyTextViewConS.setVisibility(0);
                this.mChatDeleteSysteContext.setVisibility(0);
            } else if (mAbsChatMessage instanceof PrivateMessage) {
                String mString;
                this.onTimeTextViewGoneVis();
                PrivateMessage mPrivateMessage = (PrivateMessage)mAbsChatMessage;
                if (mPrivateMessage.getSendUserId() == AbsChatAdapter.this.getSelfId()) {
                    mString = AbsChatAdapter.this.mContext.getResources().getString(this.getChatmeTipStrId());
                    mSendNameSize = mString.length();
                } else {
                    mString = mPrivateMessage.getSendUserName();
                    mSendNameSize = mString.length();
                }
                if (mPrivateMessage.getReceiveUserId() == AbsChatAdapter.this.getSelfId()) {
                    mString = mString + " " + AbsChatAdapter.this.mContext.getResources().getString(this.getChattoStrId()) + " " + AbsChatAdapter.this.mContext.getResources().getString(this.getChatmeTipStrId()) + " " + AbsChatAdapter.this.mContext.getResources().getString(this.getChatsayStrId());
                    mReceiveNameSize = AbsChatAdapter.this.mContext.getResources().getString(this.getChatmeTipStrId()).length();
                } else {
                    mString = mString + " " + AbsChatAdapter.this.mContext.getResources().getString(this.getChattoStrId()) + " " + mPrivateMessage.getReceiveName() + " " + AbsChatAdapter.this.mContext.getResources().getString(this.getChatsayStrId());
                    mReceiveNameSize = mPrivateMessage.getReceiveName().length();
                }
                int num = (" " + AbsChatAdapter.this.mContext.getResources().getString(this.getChattoStrId()) + " ").length();
                SpannableStringBuilder style = new SpannableStringBuilder((CharSequence)mString);
                style.setSpan((Object)new ForegroundColorSpan(AbsChatAdapter.this.mContext.getResources().getColor(this.getSysMsgColorId())), 0, mSendNameSize, 33);
                style.setSpan((Object)new ForegroundColorSpan(AbsChatAdapter.this.mContext.getResources().getColor(this.getSysMsgColorId())), mSendNameSize + num, mSendNameSize + num + mReceiveNameSize, 33);
                this.mChatNameText.setText((CharSequence)style);
                this.onTimeTextView(positon);
            } else if (mAbsChatMessage instanceof PublicMessage) {
                this.onTimeTextViewGoneVis();
                PublicMessage mPublicMessage = (PublicMessage)mAbsChatMessage;
                if (mPublicMessage.getSendUserId() == AbsChatAdapter.this.getSelfId()) {
                    this.mChatNameText.setText((CharSequence)AbsChatAdapter.this.mContext.getResources().getString(this.getChatmeTipStrId()));
                } else {
                    this.mChatNameText.setText((CharSequence)mPublicMessage.getSendUserName());
                }
                this.mChatNameText.setTextColor(AbsChatAdapter.this.mContext.getResources().getColor(this.getSysMsgColorId()));
                this.onTimeTextView(positon);
            }
        }

        public void onTimeTextView(int positon) {
            Object msg = AbsChatAdapter.this.getItem(positon);
            if (msg instanceof AbsChatMessage) {
                this.mCurrentTime = ((AbsChatMessage)msg).getTime() / 1000L;
                this.mChatTimeText.setText((CharSequence)(String.format("%02d", (this.mCurrentTime / 3600L % 24L + 8L) % 24L) + ":" + String.format("%02d", this.mCurrentTime % 3600L / 60L) + ":" + String.format("%02d", this.mCurrentTime % 3600L % 60L)));
                this.mMyTextViewEx.setRichText(((AbsChatMessage)msg).getRich());
            }
        }

        public void onTimeTextViewGoneVis() {
            this.mChatNameText.setVisibility(0);
            this.mChatTimeText.setVisibility(0);
            this.mMyTextViewEx.setVisibility(0);
            this.mMyTextViewConS.setVisibility(8);
            this.mChatDeleteSysteContext.setVisibility(8);
        }

        public void onClick(View v) {
            AbsChatAdapter.this.notifyDataSetChanged();
        }

        protected abstract int getChatNameEdtid();

        protected abstract int getChatTimeTvid();

        protected abstract int getChatContentTvId();

        protected abstract int getChatSysTvId();

        protected abstract int getChatSysDelIvId();

        protected abstract int getSysMsgTipId();

        protected abstract int getSysMsgColorId();

        protected abstract int getChatmeTipStrId();

        protected abstract int getChattoStrId();

        protected abstract int getChatsayStrId();
    }

    public static interface OnChatAdapterListener {
        public long getSelfId();
    }
}

