/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.player;

import android.content.Context;
import com.gensee.common.GenseeConfig;
import com.gensee.common.RTSharedPref;
import com.gensee.entity.BroadCastMsg;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.QAMsg;
import com.gensee.entity.RewardResult;
import com.gensee.entity.VoteMsg;
import com.gensee.entity.VoteQuest;
import com.gensee.entity.VoteQuestItem;
import com.gensee.media.AVConfig;
import com.gensee.media.BlueToother;
import com.gensee.media.RtmpPlayer;
import com.gensee.parse.RedbagTipParse;
import com.gensee.player.OnPlayListener;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.IGSTask;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.ILocalVideoView;
import com.gensee.vote.VotePlayerAnswer;
import com.gensee.vote.VotePlayerGroup;
import com.gensee.vote.VotePlayerQuestion;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NativePlayer
extends RtmpPlayer
implements IVideoCoreInterface {
    public static final int UT_ADD = 0;
    public static final int UT_REMOVE = 1;
    public static final int UT_MODIFY = 2;
    public static final int UT_SUBSCRIBE = 3;
    public static final int UT_UNSUBSCRIBE = 4;
    public static final int UT_REMOVE_GROUP = 5;
    private static final String TAG = "NativePlayer";
    private static long nativePlayer = 0L;
    private static long publisher = 0L;
    private Context context;
    private OnNativeListener mListener;
    private long lastTms = 0L;
    private boolean isMicOpen = false;
    private boolean isCameraOpen = false;
    private int mVideoW = -1;
    private int mVideoH = -1;
    private String idcId;
    private ILocalVideoView mLocalVideoView;
    private boolean bPublishInitSuccess = false;
    private Timer reConnectTimer = null;
    private static final int RECONNECT_TIMEOUT = 10000;
    private AtomicBoolean bReconnectTimeout = new AtomicBoolean(false);
    private AtomicBoolean bReconnecting = new AtomicBoolean(false);
    private AtomicBoolean isLiveDemanding = new AtomicBoolean(false);
    private int offUtc = Calendar.getInstance().get(15) + Calendar.getInstance().get(16);
    private static final int AVLOGTIMELONG = 10000;
    private AtomicBoolean bVideoRunning = new AtomicBoolean(false);
    private int nOpenMicVideoType = 0;
    long nStartAudioTime = Calendar.getInstance().getTimeInMillis();
    int nAudioCount = 0;
    private long nStartVideoTime = Calendar.getInstance().getTimeInMillis();
    private int nVideoCount = 0;

    protected NativePlayer() {
    }

    private void onJoin(int result, String curIdc) {
        this.lastTms = 0L;
        this.idcId = curIdc;
        switch (result) {
            case 6: {
                this.bReconnecting.set(false);
                this.isLiveDemanding.set(false);
                if (this.bReconnectTimeout.get()) {
                    this.bReconnectTimeout.set(false);
                    this.reconnectTimeOut();
                } else {
                    this.cancelReconnectTimer();
                }
                this.initAudioPlayer();
                break;
            }
            case 7: {
                break;
            }
        }
        if (this.mListener != null) {
            this.mListener.onJoin(result);
        }
    }

    private void checkTms(String type, long tms) {
        if (tms >= this.lastTms) {
            this.lastTms = tms;
        }
    }

    private void onAudio(int dwTimeStamp, byte[] data, int dwLen, final short audioLevel) {
        long nCurAudioTime = Calendar.getInstance().getTimeInMillis();
        ++this.nAudioCount;
        if (nCurAudioTime - this.nStartAudioTime > 10000L) {
            GenseeLog.d((String)TAG, (String)("onAudio dwTimeStamp = " + dwTimeStamp + " dwLen = " + dwLen + " audioLevel = " + audioLevel + " datalen = " + data.length + " nAudioCount = " + this.nAudioCount));
            this.nStartAudioTime = nCurAudioTime;
            this.nAudioCount = 0;
        }
        if (data != null) {
            this.checkTms("audio", dwTimeStamp);
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    if (NativePlayer.this.mListener != null) {
                        NativePlayer.this.mListener.onAudioLevel(audioLevel);
                    }
                }
            });
            this.audioDataPlay(data, dwLen);
        }
    }

    private void onVideoBegin() {
        GenseeLog.d((String)TAG, (String)"OnVideoBegin ");
        this.bVideoRunning.set(true);
        if (this.mListener != null) {
            this.mListener.onVideoBegin();
        }
    }

    private void onVideoEnd() {
        GenseeLog.d((String)TAG, (String)"OnVideoEnd");
        this.bVideoRunning.set(false);
        if (this.mListener != null) {
            this.mListener.onVideoEnd();
        }
    }

    private void onVideo(int dwTimeStamp, byte[] data, int dwLen, int w, int h, boolean isAs) {
        long nCurVideoTime = Calendar.getInstance().getTimeInMillis();
        ++this.nVideoCount;
        if (nCurVideoTime - this.nStartVideoTime > 10000L) {
            GenseeLog.d((String)TAG, (String)("onVideo dwTimeStamp = " + dwTimeStamp + " dwLen = " + dwLen + " isAs = " + isAs + " datalen = " + data.length + " nVideoCount = " + this.nVideoCount));
            this.nStartVideoTime = nCurVideoTime;
            this.nVideoCount = 0;
        }
        if (!this.bVideoRunning.get() && !GenseeConfig.isPVHardDecode) {
            GenseeLog.d((String)TAG, (String)("onVideo bVideoRunning = " + this.bVideoRunning));
            return;
        }
        this.checkTms("video", dwTimeStamp);
        if (w != this.mVideoW || h != this.mVideoH) {
            GenseeLog.d((String)TAG, (String)("onVideo t = " + dwTimeStamp + " w = " + w + " h = " + h + " as = " + isAs));
            this.setVideoSize(w, h, false);
            this.setVideoSize(w, h, true);
            this.mVideoW = w;
            this.mVideoH = h;
            if (this.mListener != null && w > 0) {
                this.mListener.onVideoSize(w, h, isAs);
            }
        }
        if (null != this.mListener) {
            this.mListener.onVideoDataNotify();
        }
        this.renderVideo(data);
    }

    private void onVideoParam(int dwTimeStamp, int w, int h, boolean isAs) {
        GenseeLog.d((String)TAG, (String)("onVideoParam t = " + dwTimeStamp + " w = " + w + " h = " + h + " as = " + isAs));
    }

    private void onPage(int dwTimeStamp, byte[] data, int dwLen, int dwPageW, int dwPageH) {
        this.renderPage(data, dwLen, dwPageW, dwPageH);
        if (this.mListener != null) {
            this.mListener.onPageSize(dwTimeStamp, dwPageW, dwPageH);
        }
    }

    private void onPage(int dwTimeStamp, String path, int dwPageW, int dwPageH) {
        GenseeLog.d((String)TAG, (String)("onPage png dwTimeStamp = " + dwTimeStamp + " path = " + path + " dwPageW = " + dwPageW + " dwPageH = " + dwPageH));
        this.renderPage(path, dwPageW, dwPageH);
        if (this.mListener != null) {
            this.mListener.onPageSize(dwTimeStamp, dwPageW, dwPageH);
        }
    }

    private void onPage(int dwTimeStamp, String swfPath, int dwPageW, int dwPageH, String animationPath) {
        GenseeLog.d((String)TAG, (String)("onPage swf dwTimeStamp = " + dwTimeStamp + " swfPath = " + swfPath + " dwPageW = " + dwPageW + " dwPageH = " + dwPageH + " animationPath = " + animationPath));
        this.renderPage(swfPath, dwPageW, dwPageH, animationPath);
        if (this.mListener != null) {
            this.mListener.onPageSize(dwTimeStamp, dwPageW, dwPageH);
        }
    }

    private void onAnnotaion(int dwTimeStamp, final String strAnnoXML) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                NativePlayer.this.renderAnno(strAnnoXML);
            }
        });
    }

    void onAnimation(int step) {
        GenseeLog.d((String)TAG, (String)("onAnimation step = " + step));
        this.renderPageAnimation(step);
    }

    private void onRoster(final long userId, final String name, final int notifytype, final int chatId, final int role) {
        GenseeLog.d((String)TAG, (String)("onRoster userId = " + userId + " name = " + name + " chatId = " + chatId + " role = " + role));
        if (this.mListener == null) {
            return;
        }
        this.postPool(new Runnable(){

            @Override
            public void run() {
                switch (notifytype) {
                    case 0: {
                        NativePlayer.this.mListener.onUserJoin(new UserInfo(userId, name, role, chatId));
                        break;
                    }
                    case 1: {
                        NativePlayer.this.mListener.onUserLeave(new UserInfo(userId, name, role, chatId));
                        break;
                    }
                    case 2: {
                        NativePlayer.this.mListener.onUserUpdate(new UserInfo(userId, name, role, chatId));
                        break;
                    }
                }
            }
        });
    }

    private void onRosterTotal(final int dwNum) {
        if (this.mListener == null) {
            return;
        }
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (NativePlayer.this.mListener != null) {
                    NativePlayer.this.mListener.onRosterTotal(dwNum);
                }
            }
        });
    }

    private void onChat(final long senderId, final String strSender, final long sendTime, final int role, final String strContent, final String richText, final int onChatID, final String msgId, final boolean isGroup) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (NativePlayer.this.mListener != null) {
                    String rich = StringUtil.isEmpty((String)richText) ? strContent : richText;
                    ChatMsg msg = new ChatMsg(strContent, rich, 0, msgId);
                    msg.setSenderId(senderId);
                    msg.setSender(strSender);
                    msg.setSenderRole(role);
                    msg.setChatId(onChatID);
                    msg.setTimeStamp(sendTime > 0L ? sendTime * 1000L : System.currentTimeMillis());
                    if (isGroup) {
                        NativePlayer.this.mListener.OnChatWithPublic(msg);
                    } else {
                        msg.setChatMsgType(2);
                        NativePlayer.this.mListener.OnChatWithPersion(msg);
                    }
                }
            }
        });
    }

    private void onChatcensor(final String type, final String id) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GenseeLog.d((String)NativePlayer.TAG, (String)("onChatcensor type = " + type + " id = " + id));
                if (NativePlayer.this.mListener != null) {
                    NativePlayer.this.mListener.onChatcensor(type, id);
                }
            }
        });
    }

    private void onChats(ChatMsg[] msg) {
    }

    private void onQas(QAMsg[] qas) {
    }

    private void onVote(String strVote) {
        GenseeLog.d((String)TAG, (String)("onVote strVote = " + strVote));
        try {
            String type;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(strVote.getBytes()));
            Element rootElement = doc.getDocumentElement();
            VoteMsg voteMsg = (VoteMsg)new VoteMsg().parseXml((Node)rootElement);
            if (null == voteMsg) {
                GenseeLog.d((String)TAG, (String)"onVote parse failure voteMsg null");
                return;
            }
            GenseeLog.d((String)TAG, (String)("onVote parse success voteMsg = " + voteMsg.toString()));
            VotePlayerGroup voteGroup = new VotePlayerGroup();
            voteGroup.setSiteId(voteMsg.getSiteId());
            voteGroup.setConfId(voteMsg.getConfId());
            voteGroup.setVoteType(voteMsg.getVoteType());
            try {
                voteGroup.setM_owner(Long.parseLong(voteMsg.getOwnerId()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            voteGroup.setM_strText(voteMsg.getSubject());
            voteGroup.setM_strId(voteMsg.getId());
            voteGroup.setTotal(voteMsg.getTotal());
            voteGroup.setM_bForce(!voteMsg.isSkip());
            List questList = voteMsg.getQuests();
            if (null != questList && questList.size() > 0) {
                for (int index = 0; index < questList.size(); ++index) {
                    List itemList;
                    VoteQuest quest = (VoteQuest)questList.get(index);
                    VotePlayerQuestion voteQuestion = new VotePlayerQuestion();
                    if ("multi".equals(quest.getType())) {
                        voteQuestion.setM_strType("multi");
                    } else if ("single".equals(quest.getType())) {
                        voteQuestion.setM_strType("single");
                    } else if ("text".equals(quest.getType())) {
                        voteQuestion.setM_strType("text");
                    }
                    voteQuestion.setM_strText(quest.getSubject());
                    voteQuestion.setM_strId(quest.getId());
                    voteQuestion.setM_nScore(quest.getScore());
                    voteQuestion.setTotal(quest.getTotal());
                    voteGroup.getM_questions().add(voteQuestion);
                    if ("text".equals(quest.getType()) || null == (itemList = quest.getQuestItems()) || itemList.size() <= 0) continue;
                    for (int itemIndex = 0; itemIndex < itemList.size(); ++itemIndex) {
                        VoteQuestItem item = (VoteQuestItem)itemList.get(itemIndex);
                        VotePlayerAnswer voteAnswer = new VotePlayerAnswer();
                        voteAnswer.setM_strText(item.getContent());
                        voteAnswer.setM_strId(item.getId());
                        voteAnswer.setM_bChoose(item.isSelected());
                        voteAnswer.setM_bCorrect(item.isCorrect());
                        voteAnswer.setTotal(item.getTotal());
                        voteQuestion.getM_answers().add(voteAnswer);
                    }
                }
            }
            if ("question".equals(type = voteMsg.getVoteType()) || "publish_card".equals(type)) {
                voteGroup.setM_bPublish(true);
                if (null != this.mListener) {
                    this.mListener.onVotePublish(voteGroup);
                }
            } else if ("publish".equals(type) || "publish_cardresult".equals(type)) {
                voteGroup.setM_bPublish(true);
                voteGroup.setM_bPublishResult(true);
                if (null != this.mListener) {
                    this.mListener.onVotePublishResult(voteGroup);
                }
            }
        }
        catch (Exception e) {
            GenseeLog.d((String)TAG, (String)("onVote parse Exception = " + e.getMessage()));
        }
    }

    private void onQa(final String questionId, final String question, final String questionOwner, final String answerId, final String answer, final String answerOwner, final int questionTime, final int answerTime, final long qaOwnerId, final boolean isCancel) {
        if ("".equals(question) && !isCancel) {
            return;
        }
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (NativePlayer.this.mListener != null) {
                    NativePlayer.this.mListener.onQa(questionId, question, questionOwner, answerId, answer, answerOwner, questionTime, answerTime, qaOwnerId, isCancel);
                }
            }
        });
    }

    private void onDocSwitch(int docType, String docName) {
        GenseeLog.d((String)TAG, (String)("onDocSwitch docType = " + docType + " docName = " + docName));
        if (this.mListener != null) {
            this.mListener.onDocSwitch(docType, docName);
        }
    }

    private void onMute(boolean isMute) {
        GenseeLog.d((String)TAG, (String)("onMute isMute = " + isMute));
        if (null != this.mListener) {
            this.mListener.onMute(isMute);
        }
    }

    private void onBuffer(boolean isCaching) {
        if (this.mListener != null) {
            this.mListener.onCaching(isCaching);
        }
    }

    private void startReconnectTimer() {
        GenseeLog.d((String)TAG, (String)("startReconnectTimer isMicOpen = " + this.isMicOpen + " isCameraOpen = " + this.isCameraOpen + " nOpenMicVideoType = " + this.nOpenMicVideoType));
        if ((this.nOpenMicVideoType & 2) == 2 || (this.nOpenMicVideoType & 1) == 1 || this.isMicOpen || this.isCameraOpen) {
            this.reConnectTimer = new Timer();
            this.reConnectTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    NativePlayer.this.bReconnectTimeout.set(true);
                    if (NativePlayer.this.mListener != null) {
                        NativePlayer.this.mListener.onInvite(1, false);
                        NativePlayer.this.mListener.onInvite(2, false);
                    }
                }
            }, 10000L);
        }
    }

    private synchronized void reconnectTimeOut() {
        if (this.reConnectTimer == null) {
            GenseeLog.d((String)TAG, (String)"reconnectTimeOut timer have cancel");
            return;
        }
        GenseeLog.d((String)TAG, (String)("reconnectTimeOut isMicOpen = " + this.isMicOpen + " isCameraOpen = " + this.isCameraOpen + " nOpenMicVideoType = " + this.nOpenMicVideoType));
        this.resetAv();
        this.cancelReconnectTimer();
    }

    private void resetAv() {
        if ((this.nOpenMicVideoType & 2) == 2) {
            this.handleInvite(2, false, null);
        }
        if ((this.nOpenMicVideoType & 1) == 1) {
            this.handleInvite(1, false, null);
        }
        if (this.isMicOpen) {
            this.openMic(this.context, !this.isMicOpen, null);
        }
        if (this.isCameraOpen) {
            this.openCamera(this.context, !this.isCameraOpen, null);
        }
    }

    private synchronized void cancelReconnectTimer() {
        if (null != this.reConnectTimer) {
            GenseeLog.d((String)TAG, (String)"cancelReconnectTimer");
            this.reConnectTimer.cancel();
            this.reConnectTimer = null;
        }
    }

    private void onReconnecting() {
        GenseeLog.d((String)TAG, (String)"onReconnecting");
        this.bReconnecting.set(true);
        this.bReconnectTimeout.set(false);
        this.mListener.onReconnecting();
        if (this.isRecording()) {
            this.stopRecording();
            this.mListener.onMicNotify(2);
        }
        this.bPublishInitSuccess = false;
        this.startReconnectTimer();
    }

    private void onStop(int reason) {
        if (this.mListener != null) {
            this.mListener.onLeave(reason);
        }
    }

    private void onChatEnable(boolean isEnable) {
        GenseeLog.d((String)TAG, (String)("onChatEnable isEnable = " + isEnable));
        if (this.mListener != null) {
            this.mListener.onChatEnable(isEnable);
        }
    }

    private void onQaEnable(boolean isEnable) {
        GenseeLog.d((String)TAG, (String)("onQaEnable isEnable = " + isEnable));
        if (this.mListener != null) {
            this.mListener.onQaEnable(isEnable);
        }
    }

    private int onGetAudioQueueLen() {
        return this.getAudioQueueLen();
    }

    private void onPublish(boolean isPlaying) {
        GenseeLog.d((String)TAG, (String)("onPublish isPlaying = " + isPlaying));
        if (this.mListener != null) {
            this.mListener.onPublish(isPlaying);
        }
    }

    private void onBroadCastMsg(BroadCastMsg msg) {
        GenseeLog.d((String)TAG, (String)("onBroadCastMsg " + msg));
        if (this.mListener != null) {
            this.mListener.onPublicMsg(msg);
        }
    }

    private void onLiveText(String language, String liveText) {
        GenseeLog.d((String)TAG, (String)("onLiveText lan = " + language + " text = " + liveText));
        if (this.mListener != null) {
            this.mListener.onLiveText(language, liveText);
        }
    }

    private void onRollcall(int timeOut) {
        GenseeLog.d((String)TAG, (String)("onRollcall timeOut = " + timeOut));
        if (this.mListener != null) {
            this.mListener.onRollcall(timeOut);
        }
    }

    private void onLottery(int cmd, String lotteryInfo) {
        GenseeLog.d((String)TAG, (String)("onLottery cmd = " + cmd + " info = " + lotteryInfo));
        if (this.mListener != null) {
            this.mListener.onLottery(cmd, lotteryInfo);
        }
    }

    private void onFileShare(int cmd, String fileName, String fileUrl) {
        GenseeLog.d((String)TAG, (String)("onFileShare cmd = " + cmd + " fileName = " + fileName + " url = " + fileUrl));
        if (this.mListener != null) {
            this.mListener.onFileShare(cmd, fileName, fileUrl);
        }
    }

    private void onFileShareDl(int ret, String fileUrl, String filePath) {
        GenseeLog.d((String)TAG, (String)("onFileShareDl ret = " + ret + " url = " + fileUrl + " path = " + filePath));
        if (this.mListener != null) {
            this.mListener.onFileShareDl(ret, fileUrl, filePath);
        }
    }

    private void onInvite(int type, boolean isOpen) {
        GenseeLog.d((String)TAG, (String)("onInvite nType = " + type + " isOpen = " + isOpen + " isLiveDemanding = " + this.isLiveDemanding));
        if (this.isLiveDemanding.get()) {
            this.handleInvite(type, false, null);
            return;
        }
        if (isOpen) {
            if ((this.nOpenMicVideoType & type) == type) {
                GenseeLog.w((String)("onInvite two times same type = " + type + " isOpen = " + isOpen));
                return;
            }
            this.nOpenMicVideoType |= type;
        } else {
            this.nOpenMicVideoType &= ~type;
        }
        if (this.mListener != null) {
            this.mListener.onInvite(type, isOpen);
        }
    }

    private void onModuleFocus(int focus) {
        GenseeLog.d((String)TAG, (String)("onModuleFocus focus = " + focus));
        if (this.mListener != null) {
            this.mListener.onModuleFocus(focus);
        }
    }

    private void onScreenStatus(boolean isOpen) {
        GenseeLog.d((String)TAG, (String)("onScreenStatus isOpen = " + isOpen));
        if (this.mListener != null) {
            this.mListener.onScreenStatus(isOpen);
        }
    }

    private void onThirdVote(String thirdUrl) {
        GenseeLog.d((String)TAG, (String)("onThirdVote url = " + thirdUrl));
        if (this.mListener != null) {
            this.mListener.onThirdVote(thirdUrl);
        }
    }

    private void onRedBagTipNotify(final String info) {
        GenseeLog.d((String)TAG, (String)("onRedBagTipNotify info = " + info));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                RewardResult reword = new RedbagTipParse().parseRedbagTipXml(info);
                OnNativeListener l = NativePlayer.this.mListener;
                if (l != null) {
                    l.onRedBagTip(reword);
                }
            }
        });
    }

    private void onLiveDemand(boolean isOpen) {
        GenseeLog.d((String)TAG, (String)("onLiveDemand isOpen = " + isOpen));
        this.isLiveDemanding.set(isOpen);
        if (!isOpen) {
            return;
        }
        if ((this.nOpenMicVideoType & 2) == 2 || this.isCameraOpen) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    OnNativeListener l = NativePlayer.this.mListener;
                    if (l != null) {
                        l.onInvite(2, false);
                    }
                }
            });
        }
        if ((this.nOpenMicVideoType & 1) == 1 || this.isMicOpen) {
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    OnNativeListener l = NativePlayer.this.mListener;
                    if (l != null) {
                        l.onInvite(1, false);
                    }
                }
            });
        }
        this.resetAv();
    }

    private void onGetUserInfoById(final UserInfo[] infos) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnNativeListener l = NativePlayer.this.mListener;
                if (l != null) {
                    l.onGetUserInfo(infos);
                }
            }
        });
    }

    private void onGetLog(final int type, final String param) {
        GenseeLog.d((String)TAG, (String)("onGetLog type = " + type + " param = " + param));
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnNativeListener l = NativePlayer.this.mListener;
                if (l != null) {
                    l.onGetLog(type, param);
                }
            }
        });
    }

    private void openMic() {
        int ret = this.initRecording(AVConfig.getAndroidSampleRate((Context)this.context));
        if (ret == 3) {
            this.onMicNotify(3);
        }
    }

    private void openCamera() {
        if (null != this.mLocalVideoView) {
            VideoParam p = new VideoParam(320, 240, 15, 1);
            this.mLocalVideoView.open((Object)p, (IVideoCoreInterface)this);
        } else {
            GenseeLog.e((String)TAG, (String)"openCamera mLocalVideoView is null");
        }
        OnNativeListener l = this.mListener;
        if (l != null) {
            l.onCameraNotify(1);
        }
    }

    private void onPublishInit(int result, boolean isAac) {
        GenseeLog.d((String)TAG, (String)(" onPublishInit  result = " + result + " isAac = " + isAac));
        boolean bl = this.bPublishInitSuccess = result == 6;
        if (result == 6) {
            if (this.isMicOpen && !this.isRecording()) {
                this.openMic();
            }
            if (this.isCameraOpen) {
                this.openCamera();
            }
        }
        GenseeLog.d((String)TAG, (String)" onPublishInit  end");
    }

    private void onPublishLeave(int reason) {
        this.stopRecording();
    }

    private void onPublishAudio(byte[] data, int dwLen, final short level) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (NativePlayer.this.mListener != null) {
                    NativePlayer.this.mListener.onAudioLevel(level);
                }
            }
        });
        this.audioDataPlay(data, dwLen);
    }

    public String getIdcId() {
        return this.idcId;
    }

    protected boolean setIdcId(final String idcId, final OnTaskRet taskRet) {
        GenseeLog.d((String)TAG, (String)("setIdcId new idcId = " + idcId + " oldIdc = " + this.idcId));
        if (idcId == null || idcId.equals(this.idcId)) {
            GenseeLog.w((String)TAG, (String)("setIdcId fail new idcId = " + idcId + " oldIdc = " + this.idcId));
            return false;
        }
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = nativePlayer;
                if (player != 0L) {
                    NativePlayer.this.idcId = idcId;
                    ret = NativePlayer.this.setIdcId(player, idcId);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "setIdcId");
                }
                return 0;
            }
        });
    }

    protected void join(long siteId, long userId, String nickName, String albAddress, int serviceType, String confId, String subject, String userAppData, OnNativeListener l, String cachDir, boolean httpMode, int rate) {
        this.mListener = l;
        if (nativePlayer == 0L) {
            nativePlayer = this.createRtmpPlayer(siteId, userId, nickName, albAddress, cachDir, false);
            GenseeLog.d((String)TAG, (String)(" player = " + nativePlayer + " siteId = " + siteId + " alb = " + albAddress + "httpmode = " + httpMode));
            if (nativePlayer == 0L) {
                if (this.mListener != null) {
                    this.mListener.onJoin(-1);
                }
            } else {
                this.cachDir = cachDir;
                this.join(nativePlayer, serviceType, confId, subject, userAppData, l, httpMode, rate);
            }
        } else {
            this.join(nativePlayer, serviceType, confId, subject, userAppData, l, httpMode, rate);
        }
    }

    private void join(long player, int serviceType, String confId, String name, String userAppData, OnPlayListener l, boolean httpMode, int rate) {
        int result = this.join(player, serviceType, confId, name, userAppData, httpMode, rate);
        GenseeLog.d((String)TAG, (String)(" join result = " + result));
        if (result != 0 && l != null) {
            l.onJoin(result);
        }
    }

    protected void leave(final OnTaskRet ret) {
        this.audioRelease();
        if (null != this.mLocalVideoView) {
            this.mLocalVideoView.close();
        }
        boolean alreadyLeave = false;
        if (nativePlayer == 0L && ret != null) {
            ret.onTaskRet(true, 0, "leave");
            alreadyLeave = true;
        }
        final boolean leaved = alreadyLeave;
        NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int result = 0;
                if (nativePlayer != 0L) {
                    result = NativePlayer.this.leave(nativePlayer, 1);
                }
                if (result != 0 && ret != null && !leaved) {
                    ret.onTaskRet(false, result, "leave");
                }
                return 0;
            }
        });
    }

    protected void release(final OnTaskRet ret) {
        this.mListener = null;
        this.context = null;
        this.mVideoH = -1;
        this.mVideoW = -1;
        this.isLiveDemanding.set(false);
        this.stopRecording();
        BlueToother.getIns().release(1);
        NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                NativePlayer.this.release();
                if (ret != null) {
                    ret.onTaskRet(true, 0, "release");
                }
                FileUtil.deleteFile((String)NativePlayer.this.cachDir);
                return 0;
            }
        });
    }

    public boolean release() {
        this.releaseNative();
        this.shutdownTreadPool();
        return super.release();
    }

    private void releaseNative() {
        if (publisher != 0L) {
            this.destroySpeaker(publisher, 0L);
            publisher = 0L;
        }
        if (nativePlayer != 0L) {
            GenseeLog.d((String)TAG, (String)("release player = " + nativePlayer));
            this.destroyRtmpPlayer(nativePlayer, this.nativeSink);
        } else {
            GenseeLog.w((String)TAG, (String)" -> release player = 0");
        }
        this.nativeSink = 0L;
        nativePlayer = 0L;
    }

    protected boolean chat(final String content, final String richtext, final int receiverId, final String msgId, final OnTaskRet ret) {
        GenseeLog.d((String)TAG, (String)("chat content = " + content + " richtext = " + richtext + " receiverId = " + receiverId));
        if (this.isEmpty(content) || this.isEmpty(richtext)) {
            return false;
        }
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int result = 0;
                if (nativePlayer != 0L) {
                    result = receiverId == 0 ? NativePlayer.this.chatToAll(nativePlayer, content, richtext, msgId) : NativePlayer.this.chat(nativePlayer, content, richtext, msgId, receiverId);
                }
                if (ret != null) {
                    ret.onTaskRet(result == 0, result, "chat");
                }
                return 0;
            }
        });
    }

    private boolean isEmpty(String str) {
        return str == null || "".equals(str);
    }

    protected boolean question(final String qId, final String content, final OnTaskRet ret) {
        GenseeLog.d((String)TAG, (String)("question qId = " + qId + " content = " + content));
        if (this.isEmpty(content)) {
            return false;
        }
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int result = 0;
                if (nativePlayer != 0L) {
                    result = NativePlayer.this.question(nativePlayer, qId, content);
                }
                if (ret != null) {
                    ret.onTaskRet(result == 0, result, "question");
                }
                return 0;
            }
        });
    }

    protected boolean sameQuestion(final String uuid, final OnTaskRet ret) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int result = 0;
                if (nativePlayer != 0L) {
                    result = NativePlayer.this.sameQuestion(nativePlayer, uuid);
                }
                if (ret != null) {
                    ret.onTaskRet(result == 0, result, "sameQuestion");
                }
                return 0;
            }
        });
    }

    protected boolean voteSubmit(VotePlayerGroup voteGroup, long userId, String userName, final OnTaskRet ret) {
        VoteMsg voteMsg = new VoteMsg();
        voteMsg.setConfId(voteGroup.getConfId());
        voteMsg.setSiteId(voteGroup.getSiteId());
        voteMsg.setOwnerId(voteGroup.getM_owner() + "");
        voteMsg.setVoteType(voteGroup.getVoteType());
        voteMsg.setUserId(userId + "");
        voteMsg.setName(userName);
        voteMsg.setId(voteGroup.getM_strId());
        voteMsg.setSubject(voteGroup.getM_strText());
        List<VotePlayerQuestion> voteQuestions = voteGroup.getM_questions();
        ArrayList<VoteQuest> questList = new ArrayList<VoteQuest>();
        if (null != voteQuestions && voteQuestions.size() > 0) {
            for (VotePlayerQuestion voteQuestion : voteQuestions) {
                VoteQuest voteQuest = new VoteQuest();
                voteQuest.setId(voteQuestion.getM_strId());
                if ("text".equals(voteQuestion.getM_strType())) {
                    voteQuest.setType("text");
                    voteQuest.setSubmitAnswer(voteQuestion.getM_strAnwser());
                } else {
                    if ("multi".equals(voteQuestion.getM_strType())) {
                        voteQuest.setType("multi");
                    } else if ("single".equals(voteQuestion.getM_strType())) {
                        voteQuest.setType("single");
                    }
                    ArrayList<VoteQuestItem> items = new ArrayList<VoteQuestItem>();
                    List<VotePlayerAnswer> answers = voteQuestion.getM_answers();
                    if (null != answers && answers.size() > 0) {
                        for (VotePlayerAnswer voteAnswer : answers) {
                            VoteQuestItem voteQuestItem = new VoteQuestItem();
                            voteQuestItem.setSelected(voteAnswer.isM_bChoose());
                            voteQuestItem.setId(voteAnswer.getM_strId());
                            items.add(voteQuestItem);
                        }
                    }
                    voteQuest.setQuestItems(items);
                }
                questList.add(voteQuest);
            }
            voteMsg.setQuests(questList);
        }
        final String strVote = voteMsg.getVoteSubmitXml();
        GenseeLog.d((String)TAG, (String)("voteSubmit strVote = " + strVote));
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int result = 0;
                if (nativePlayer != 0L) {
                    result = NativePlayer.this.voteSubmit(nativePlayer, strVote);
                }
                if (result != 0 && ret != null) {
                    ret.onTaskRet(false, result, "voteSubmit");
                }
                return 0;
            }
        });
    }

    protected boolean closeAudio(final boolean isClose, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = 0;
                if (nativePlayer != 0L) {
                    ret = NativePlayer.this.closeAudio(nativePlayer, isClose);
                }
                GenseeLog.d((String)NativePlayer.TAG, (String)("closeAudio isClose = " + isClose + " ret = " + ret));
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "closeAudio");
                }
                return 0;
            }
        });
    }

    protected boolean closeVideo(final boolean isClose, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = 0;
                if (nativePlayer != 0L) {
                    ret = NativePlayer.this.closeVideo(nativePlayer, isClose);
                }
                GenseeLog.d((String)NativePlayer.TAG, (String)("closeVideo isClose = " + isClose + " ret = " + ret));
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "closeVideo");
                }
                return 0;
            }
        });
    }

    protected boolean handleInvite(final int type, final boolean isAccept, final OnTaskRet taskRet) {
        this.nOpenMicVideoType &= ~type;
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = 0;
                long player = nativePlayer;
                if (player != 0L) {
                    GenseeLog.d((String)NativePlayer.TAG, (String)("handleInvite type = " + type + " isAccept = " + isAccept));
                    ret = NativePlayer.this.handleInvite(player, type, isAccept);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "handleInvite");
                }
                return 0;
            }
        });
    }

    protected boolean handleRollCall(final boolean isAccept, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = 0;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = NativePlayer.this.handleRollCall(player, isAccept);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "handleRollCall");
                }
                return 0;
            }
        });
    }

    protected boolean handUp(final boolean isHand, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = 0;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = NativePlayer.this.handUp(player, isHand);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "handUp");
                }
                return 0;
            }
        });
    }

    protected boolean dlFileShare(final String url, final String fileFullPath, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = 0;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = NativePlayer.this.dlFileShare(player, url, fileFullPath);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "handUp");
                }
                return 0;
            }
        });
    }

    protected boolean switchRate(final int rate, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = NativePlayer.this.switchRate(player, rate);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "switchRate");
                }
                return 0;
            }
        });
    }

    protected boolean getUserInfoById(final long[] userIds, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = NativePlayer.this.getUserInfoById(player, userIds);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "getUserInfoById");
                }
                return 0;
            }
        });
    }

    protected boolean reName(final String newNickName, final OnTaskRet taskRet) {
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = NativePlayer.this.reName(player, newNickName);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, ret, "reName");
                }
                return 0;
            }
        });
    }

    protected void onAuidoRecord(byte[] data, int readBytes) {
        long tmpPublisher = publisher;
        if (tmpPublisher != 0L && this.isMicOpen) {
            this.sendAudio(tmpPublisher, data, readBytes);
        }
    }

    protected void onMicNotify(int notify) {
        OnNativeListener l = this.mListener;
        if (l != null) {
            l.onMicNotify(notify);
        }
    }

    public void setLocalVideoView(ILocalVideoView localVideoView) {
        this.mLocalVideoView = localVideoView;
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.setVideoCore((IVideoCoreInterface)this);
        }
    }

    protected boolean openCamera(Context context, final boolean isCameraOpen, OnTaskRet taskRet) {
        GenseeLog.d((String)TAG, (String)("openCamera isCameraOpen = " + isCameraOpen + " bReconnecting = " + this.bReconnecting));
        if (this.bReconnecting.get()) {
            return false;
        }
        this.context = context.getApplicationContext();
        if (!isCameraOpen && null != this.mLocalVideoView) {
            this.mLocalVideoView.close();
        }
        this.isCameraOpen = isCameraOpen;
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                if (isCameraOpen) {
                    if (publisher == 0L) {
                        publisher = NativePlayer.this.createSpeakerQuick(NativePlayer.this.isVideoHardEncode() ? 255 : 6, 2, NativePlayer.this.mListener.getAudioCodec());
                        GenseeLog.e((String)NativePlayer.TAG, (String)("openCamera createSpeakerQuick publisher = " + publisher));
                    }
                    if (publisher != 0L && NativePlayer.this.bPublishInitSuccess) {
                        NativePlayer.this.openCamera();
                    } else {
                        GenseeLog.e((String)NativePlayer.TAG, (String)("openCamera publisher = " + publisher + " pubinited = " + NativePlayer.this.bPublishInitSuccess));
                        OnNativeListener l = NativePlayer.this.mListener;
                        if (l != null) {
                            l.onCameraNotify(3);
                        }
                    }
                } else {
                    if (null != NativePlayer.this.mLocalVideoView) {
                        NativePlayer.this.mLocalVideoView.close();
                    }
                    NativePlayer.this.destroySpeaker();
                    OnNativeListener l = NativePlayer.this.mListener;
                    if (l != null) {
                        l.onCameraNotify(2);
                    }
                }
                return 0;
            }
        });
    }

    protected boolean openMic(Context context, final boolean isOpen, OnTaskRet taskRet) {
        GenseeLog.d((String)TAG, (String)("openMic isOpen = " + isOpen + " bReconnecting = " + this.bReconnecting));
        if (this.bReconnecting.get()) {
            return false;
        }
        this.context = context.getApplicationContext();
        if (!isOpen) {
            this.stopRecording();
        }
        this.isMicOpen = isOpen;
        return NativePlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                if (isOpen) {
                    BlueToother.getIns().init(NativePlayer.this.context, 1);
                    if (publisher == 0L) {
                        publisher = NativePlayer.this.createSpeakerQuick(NativePlayer.this.isVideoHardEncode() ? 255 : 6, 1, NativePlayer.this.mListener.getAudioCodec());
                        GenseeLog.e((String)NativePlayer.TAG, (String)("openMic createSpeakerQuick publisher = " + publisher));
                    }
                    if (publisher != 0L) {
                        NativePlayer.this.audioQueueClear();
                        if (NativePlayer.this.bPublishInitSuccess) {
                            NativePlayer.this.openMic();
                        }
                    }
                } else {
                    BlueToother.getIns().release(1);
                    NativePlayer.this.destroySpeaker();
                    NativePlayer.this.audioQueueClear();
                    OnNativeListener l = NativePlayer.this.mListener;
                    if (l != null) {
                        l.onMicNotify(2);
                    }
                }
                return 0;
            }
        });
    }

    private void destroySpeaker() {
        if (!this.isMicOpen && !this.isCameraOpen) {
            this.bPublishInitSuccess = false;
            long tmp = publisher;
            publisher = 0L;
            GenseeLog.d((String)TAG, (String)"destroySpeaker");
            if (tmp != 0L) {
                this.destroySpeaker(tmp, 0L);
                GenseeLog.d((String)TAG, (String)"destroySpeaker end");
            }
        }
    }

    private boolean isVideoHardEncode() {
        return null != this.mLocalVideoView && this.mLocalVideoView.isVideoHardEncode();
    }

    private native long createRtmpPlayer(long var1, long var3, String var5, String var6, String var7, boolean var8);

    private native void destroyRtmpPlayer(long var1, long var3);

    private native int join(long var1, int var3, String var4, String var5, String var6, boolean var7, int var8);

    private native int leave(long var1, int var3);

    private native int chatToAll(long var1, String var3, String var4, String var5);

    private native int chat(long var1, String var3, String var4, String var5, int var6);

    private native int question(long var1, String var3, String var4);

    private native int sameQuestion(long var1, String var3);

    private native int voteSubmit(long var1, String var3);

    private native int closeAudio(long var1, boolean var3);

    private native int closeVideo(long var1, boolean var3);

    private native int handleInvite(long var1, int var3, boolean var4);

    private native int handleRollCall(long var1, boolean var3);

    private native int handUp(long var1, boolean var3);

    private native int dlFileShare(long var1, String var3, String var4);

    private native int switchRate(long var1, int var3);

    private native int setIdcId(long var1, String var3);

    private native int getUserInfoById(long var1, long[] var3);

    private native int reName(long var1, String var3);

    private native long createSpeaker(long var1, long var3, String var5, String var6, int var7, int var8, String var9);

    private native long createSpeakerQuick(int var1, int var2, String var3);

    private native void destroySpeaker(long var1, long var3);

    private native int sendAudio(long var1, byte[] var3, int var4);

    private native int sendVideo(long var1, byte[] var3, int var4, int var5, int var6);

    public int sendVideo(byte[] data, VideoParam videoParam) {
        if (publisher != 0L && this.bPublishInitSuccess) {
            return this.sendVideo(publisher, data, data.length, videoParam.width, videoParam.height);
        }
        return -1;
    }

    public void setVideoSize(Context c, int width, int height) {
        RTSharedPref pref = RTSharedPref.initPref((Context)c);
        if (pref != null && width > 0 && height > 0) {
            pref.putInt("save.video.height", height);
            pref.putInt("save.video.width", width);
        }
    }

    public int getCameraId() {
        return 1;
    }

    public void saveCameraId(int cameraId) {
    }

    public int sendVideoData(byte[] data, VideoParam videoParam) {
        return this.sendVideo(data, videoParam);
    }

    protected static interface OnNativeListener
    extends OnPlayListener {
        public void OnChatWithPersion(ChatMsg var1);

        public void OnChatWithPublic(ChatMsg var1);

        public void onChatcensor(String var1, String var2);

        public void onQa(String var1, String var2, String var3, String var4, String var5, String var6, int var7, int var8, long var9, boolean var11);

        public void onVotePublish(VotePlayerGroup var1);

        public void onVotePublishResult(VotePlayerGroup var1);

        public void onMute(boolean var1);

        public void onChatEnable(boolean var1);

        public void onQaEnable(boolean var1);

        public String getAudioCodec();

        public void onGetLog(int var1, String var2);
    }
}

