/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.player;

import android.content.Context;
import com.gensee.chatfilter.SensiviteWordFilter;
import com.gensee.common.GenseeConfig;
import com.gensee.common.PlayerEnv;
import com.gensee.common.ServiceType;
import com.gensee.db.PlayerQaDataBaseManager;
import com.gensee.entity.BroadCastMsg;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.InitParam;
import com.gensee.entity.LiveInfo;
import com.gensee.entity.LoginResEntity;
import com.gensee.entity.PayInfo;
import com.gensee.entity.PingEntity;
import com.gensee.entity.Reward;
import com.gensee.entity.RewardResult;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.holder.qa.impl.QaMsgQueue;
import com.gensee.media.AVConfig;
import com.gensee.media.IVideoIndication;
import com.gensee.net.RewardAction;
import com.gensee.net.RtmpReq;
import com.gensee.net.StringRes;
import com.gensee.pdu.GSDocView;
import com.gensee.player.IPlayerChat;
import com.gensee.player.IPlayerQA;
import com.gensee.player.IPlayerVote;
import com.gensee.player.NativePlayer;
import com.gensee.player.OnChatListener;
import com.gensee.player.OnPlayListener;
import com.gensee.player.OnQaListener;
import com.gensee.player.VideoRate;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.FileUtil;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.GSDocViewGx;
import com.gensee.view.GSQaView;
import com.gensee.view.GSVoteView;
import com.gensee.view.IChatView;
import com.gensee.view.ILocalVideoView;
import com.gensee.vote.OnVoteListener;
import com.gensee.vote.VotePlayerGroup;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Player
implements IPlayerChat,
IPlayerQA,
IPlayerVote {
    protected static final String TAG = "Player";
    private NativePlayer mPlayer;
    private OnPlayListener mListener;
    private OnChatListener onChatListener;
    private OnVoteListener voteCallback;
    private OnQaListener mQaListener;
    private IChatView mChatView;
    private GSQaView mQaView;
    private UserInfo selfInfo;
    private VideoRate rate = VideoRate.RATE_NORMAL;
    private LoginResEntity p;
    private HashMap<String, Long> mQaMap;
    private Set<String> selfChatMsgs;
    private SensiviteWordFilter mWordFilter;
    private Context mContext;
    private InitParam initParam;
    private RtmpReq req;
    private NativePlayer.OnNativeListener nativeCallback = new NativePlayer.OnNativeListener(){

        @Override
        public void onUserUpdate(UserInfo info) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onUserUpdate(info);
            }
            if (null != Player.this.mChatView) {
                Player.this.mChatView.updateChatTarget(info, false);
            }
        }

        @Override
        public void onUserLeave(UserInfo info) {
            if (null != Player.this.mChatView) {
                Player.this.mChatView.updateChatTarget(info, true);
            }
            if (Player.this.mListener != null) {
                Player.this.mListener.onUserLeave(info);
            }
        }

        @Override
        public void onUserJoin(UserInfo info) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onUserJoin(info);
            }
        }

        @Override
        public void onRosterTotal(int total) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onRosterTotal(total);
            }
        }

        @Override
        public void onReconnecting() {
            GenseeLog.d((String)Player.TAG, (String)"onReconnecting");
            QaMsgQueue.getIns().release();
            if (Player.this.mListener != null) {
                Player.this.mListener.onReconnecting();
            }
            if (null != Player.this.onChatListener) {
                Player.this.onChatListener.onReconnection();
            }
        }

        @Override
        public void onLeave(int reason) {
            GenseeLog.d((String)Player.TAG, (String)("onLeave reason = " + reason));
            if (Player.this.mListener != null) {
                Player.this.mListener.onLeave(reason);
            }
        }

        @Override
        public void onJoin(int result) {
            GenseeLog.d((String)Player.TAG, (String)("onJoin result = " + result));
            if (Player.this.mListener != null) {
                Player.this.mListener.onJoin(result);
            }
        }

        @Override
        public void onErr(int errCode) {
            GenseeLog.d((String)Player.TAG, (String)("onErr errCode = " + errCode));
            if (Player.this.mListener != null) {
                Player.this.mListener.onErr(errCode);
            }
        }

        @Override
        public void onCaching(boolean isCaching) {
            GenseeLog.d((String)Player.TAG, (String)("onCaching isCaching = " + isCaching));
            if (Player.this.mListener != null) {
                Player.this.mListener.onCaching(isCaching);
            }
        }

        @Override
        public void onQa(String questionId, String question, String questionOwner, String answerId, String answer, String answerOwner, int questionTime, int answerTime, long qaOwnerId, boolean isCancel) {
            if (Player.this.mQaListener != null) {
                if (!StringUtil.isEmpty((String)questionId)) {
                    HashMap cache = Player.this.getQaCache();
                    if (!isCancel && qaOwnerId == Player.this.selfInfo.getId() && answerTime <= 0 && StringUtil.isEmpty((String)answer) && cache.containsKey(questionId)) {
                        return;
                    }
                    if (qaOwnerId == 0L) {
                        qaOwnerId = (Long)cache.get(questionId);
                    } else {
                        cache.put(questionId, qaOwnerId);
                    }
                }
                Player.this.mQaListener.onQa(questionId, question, questionOwner, answerId, answer, answerOwner, questionTime, answerTime, qaOwnerId, isCancel);
            }
        }

        @Override
        public void OnChatWithPersion(ChatMsg msg) {
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onChatWithPerson(msg);
            }
        }

        @Override
        public void OnChatWithPublic(ChatMsg msg) {
            Set sets;
            String msgId = msg.getId();
            if (msgId != null && (sets = Player.this.getSelfChatMsgs()).contains(msgId)) {
                sets.remove(msgId);
                return;
            }
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onChatWithPublic(msg);
            }
        }

        @Override
        public void onMute(boolean isMute) {
            if (null != Player.this.onChatListener) {
                Player.this.onChatListener.onMute(isMute);
            }
            if (Player.this.mQaListener != null) {
                Player.this.mQaListener.onQaMute(isMute);
            }
        }

        @Override
        public void onVotePublish(VotePlayerGroup voteGroup) {
            GenseeLog.d((String)Player.TAG, (String)("onVotePublish voteGroup=" + voteGroup));
            if (null != Player.this.voteCallback) {
                Player.this.voteCallback.onVotePublish(voteGroup);
            }
        }

        @Override
        public void onVotePublishResult(VotePlayerGroup voteGroup) {
            GenseeLog.d((String)Player.TAG, (String)("onVotePublishResult voteGroup=" + voteGroup));
            if (null != Player.this.voteCallback) {
                Player.this.voteCallback.onVotePublishResult(voteGroup);
            }
        }

        @Override
        public void onDocSwitch(int docType, String docName) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onDocSwitch(docType, docName);
            }
        }

        @Override
        public void onVideoBegin() {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoBegin();
            }
        }

        @Override
        public void onVideoEnd() {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoEnd();
            }
        }

        @Override
        public void onVideoSize(int width, int height, boolean isAs) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoSize(width, height, isAs);
            }
        }

        @Override
        public void onAudioLevel(int level) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onAudioLevel(level);
            }
        }

        @Override
        public void onVideoDataNotify() {
            if (Player.this.mListener != null) {
                Player.this.mListener.onVideoDataNotify();
            }
        }

        @Override
        public void onChatEnable(boolean isEnable) {
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onRoomMute(!isEnable);
            }
        }

        @Override
        public void onQaEnable(boolean isEnable) {
            if (Player.this.mQaListener != null) {
                Player.this.mQaListener.onRoomMute(!isEnable);
            }
        }

        @Override
        public void onPublish(boolean isPlaying) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onPublish(isPlaying);
            }
            if (null != Player.this.onChatListener) {
                Player.this.onChatListener.onPublish(isPlaying);
            }
        }

        @Override
        public void onSubject(String subject) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onSubject(subject);
            }
        }

        @Override
        public void onPageSize(int pos, int width, int height) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onPageSize(pos, width, height);
            }
        }

        @Override
        public void onPublicMsg(BroadCastMsg msg) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onPublicMsg(msg);
            }
        }

        @Override
        public void onInvite(int type, boolean isOpen) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onInvite(type, isOpen);
            }
        }

        @Override
        public void onMicNotify(int notify) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onMicNotify(notify);
            }
        }

        @Override
        public void onCameraNotify(int notify) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onCameraNotify(notify);
            }
        }

        @Override
        public void onLiveText(String language, String text) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onLiveText(language, text);
            }
        }

        @Override
        public void onRollcall(int timeOut) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onRollcall(timeOut);
            }
        }

        @Override
        public void onLottery(int cmd, String lotteryInfo) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onLottery(cmd, lotteryInfo);
            }
        }

        @Override
        public void onFileShare(int cmd, String fileName, String fileUrl) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onFileShare(cmd, fileName, fileUrl);
            }
        }

        @Override
        public void onFileShareDl(int ret, String fileUrl, String filePath) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onFileShareDl(ret, fileUrl, filePath);
            }
        }

        @Override
        public void onScreenStatus(boolean isAs) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onScreenStatus(isAs);
            }
        }

        @Override
        public void onModuleFocus(int mode) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onModuleFocus(mode);
            }
        }

        @Override
        public void onIdcList(List<PingEntity> idcs) {
        }

        @Override
        public void onThirdVote(String url) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onThirdVote(url);
            }
        }

        @Override
        public void onRedBagTip(RewardResult reword) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onRedBagTip(reword);
            }
        }

        @Override
        public void onGotoPay(PayInfo info) {
        }

        @Override
        public void onRewordEnable(boolean isAliPay, boolean isWx) {
        }

        @Override
        public void onChatcensor(String type, String id) {
            if (Player.this.onChatListener != null) {
                Player.this.onChatListener.onChatcensor(type, id);
            }
        }

        @Override
        public void onGetUserInfo(UserInfo[] info) {
            if (Player.this.mListener != null) {
                Player.this.mListener.onGetUserInfo(info);
            }
        }

        @Override
        public String getAudioCodec() {
            LoginResEntity tmpEntity = Player.this.p;
            return tmpEntity != null ? Player.this.p.getAudioCodec() : "";
        }

        @Override
        public void onLiveInfo(LiveInfo info) {
        }

        @Override
        public void onGetLog(int type, String param) {
            UserInfo self = Player.this.getSelfInfo();
            if (self == null || StringUtil.isEmpty((String)param) || !param.equals(self.getName()) && !param.equals(String.valueOf(self.getId()))) {
                GenseeLog.w((String)Player.TAG, (String)("onGetLog it is not my log param " + param));
                return;
            }
            InitParam tmp = Player.this.initParam;
            Context c = Player.this.mContext;
            if (c != null && tmp != null) {
                GenseeLog.reportDiagonse((Context)c, (String)tmp.getDomain(), (ServiceType)tmp.getServiceType(), (String)("report onPlayerSDK ,by GetLog sdk version = " + GenseeConfig.getSDKVersion()), (boolean)true);
            } else {
                GenseeLog.w((String)Player.TAG, (String)("onGetLog can not send log context = " + c + " p = " + tmp));
            }
        }
    };

    public Player() {
        this.mPlayer = new NativePlayer();
    }

    public void setGSVideoView(IVideoIndication videoView) {
        this.mPlayer.setGSVideoView(videoView);
    }

    public void setGSDocView(GSDocView docView) {
        this.mPlayer.setGSDocView(docView);
    }

    public void setGSDocViewGx(GSDocViewGx docViewGx) {
        this.mPlayer.setGSDocViewGx(docViewGx);
    }

    public void setGSChatView(IChatView v) {
        if (v != null) {
            this.mChatView = v;
            this.setOnChatListener(v);
            v.setModuleHandle(this);
        }
    }

    public void setGSVoteView(GSVoteView v) {
        if (v != null) {
            this.setOnVoteListener(v);
            v.setModuleHandle(this);
        }
    }

    public void setGSQaView(GSQaView qaView) {
        if (qaView != null) {
            this.mQaView = qaView;
            qaView.setModuleHandle(this);
            this.setOnQaListener(qaView);
        }
    }

    public String getCurIdc() {
        return this.mPlayer.getIdcId();
    }

    public boolean setIdcId(String idcId, OnTaskRet taskRet) {
        return this.mPlayer.setIdcId(idcId, taskRet);
    }

    public void setOnQaListener(OnQaListener qaListener) {
        this.mQaListener = qaListener;
    }

    public void setOnChatListener(OnChatListener onChatListener) {
        this.onChatListener = onChatListener;
        this.notifySitePriChat(onChatListener, this.p);
    }

    private void notifySitePriChat(OnChatListener onChatListener, LoginResEntity p) {
        if (onChatListener != null && p != null) {
            onChatListener.onStuPriChat(p.isSiteSutChatEnable());
        }
    }

    public void setOnVoteListener(OnVoteListener voteListener) {
        this.voteCallback = voteListener;
    }

    public void join(Context context, InitParam p, OnPlayListener l) {
        if (context == null) {
            GenseeLog.w((String)TAG, (String)"join context = null");
            return;
        }
        this.mListener = l;
        this.initWithParam(context, p);
    }

    private void initDB(Context context) {
        PlayerQaDataBaseManager dbManager = new PlayerQaDataBaseManager(context);
        MsgQueue.getIns().initMsgDb(context);
        QaMsgQueue.getIns().initMsgDbHelper(dbManager);
    }

    protected void initWithParam(final Context context, final InitParam p) {
        if (this.req != null) {
            this.req.setCallback(null);
        }
        this.req = new RtmpReq(context, new RtmpReq.Callback(){

            @Override
            public void onResult(LoginResEntity loginResEntity) {
                if (Player.this.mListener != null) {
                    Player.this.mListener.onIdcList(loginResEntity.getPingArray());
                    boolean addr = StringUtil.isEmpty((String)loginResEntity.getPayNotifyUrl());
                    Player.this.mListener.onRewordEnable(!addr && loginResEntity.isAliPaySupport(), !addr && loginResEntity.isWxPaySupport());
                    Player.this.mListener.onLiveInfo((LiveInfo)loginResEntity);
                }
                Player.this.joinRoom(context, loginResEntity);
                Player.this.initParam = p;
            }

            public void onErr(int errCode) {
                if (Player.this.mListener != null) {
                    Player.this.mListener.onErr(errCode);
                }
            }
        });
        this.req.setbAttendeeOnly(true);
        this.req.initWithGensee(p);
    }

    public void leave() {
        if (this.req != null) {
            this.req.setCallback(null);
        }
        this.mPlayer.leave(new OnTaskRet(){

            public void onTaskRet(boolean arg0, int arg1, String arg2) {
            }
        });
    }

    public void release(Context context) {
        if (this.mChatView != null) {
            this.mChatView.release();
            this.mChatView = null;
        }
        if (null != this.mQaView) {
            this.mQaView.release();
            this.mQaView = null;
        }
        MsgQueue.getIns().clear();
        MsgQueue.getIns().closedb();
        QaMsgQueue.getIns().clear();
        this.mQaListener = null;
        this.onChatListener = null;
        this.voteCallback = null;
        this.mListener = null;
        this.rate = VideoRate.RATE_NORMAL;
        if (this.mQaMap != null) {
            this.mQaMap.clear();
        }
        if (this.selfChatMsgs != null) {
            this.selfChatMsgs.clear();
        }
        this.mPlayer.release(null);
        if (this.mWordFilter != null) {
            this.mWordFilter.release();
        }
        this.mContext = null;
    }

    private int getIntValue(String strValue) {
        try {
            return Integer.valueOf(strValue);
        }
        catch (Exception e) {
            GenseeLog.w((String)e.toString());
            return 0;
        }
    }

    protected void joinRoom(Context context, final LoginResEntity lEntity) {
        if (lEntity == null) {
            if (this.mListener != null) {
                this.mListener.onJoin(-2);
            }
            GenseeLog.w((String)"joinRoom the info is null");
            return;
        }
        final Context appCtx = context.getApplicationContext();
        this.initDB(appCtx);
        this.p = lEntity;
        this.mContext = appCtx;
        int serviceType = this.getIntValue(lEntity.getServicetype());
        int sampleSize = AVConfig.getSampleRate((Context)context);
        PlayerEnv.init((boolean)false, (int)serviceType, (int)sampleSize, (Context)context, (OnTaskRet)new OnTaskRet(){

            public void onTaskRet(boolean ret, int arg1, String arg2) {
                if (ret) {
                    if (null != Player.this.mListener) {
                        Player.this.mListener.onSubject(lEntity.getWebcastSubject());
                    }
                    Player.this.notifySitePriChat(Player.this.onChatListener, lEntity);
                    int siteId = (int)lEntity.getSiteId();
                    long userId = lEntity.getUserId();
                    String subject = lEntity.getWebcastSubject();
                    String albAddress = lEntity.getAlbServer();
                    albAddress = StringUtil.getHttpAlbAddr((String)albAddress);
                    int serviceType = Player.this.getIntValue(lEntity.getServicetype());
                    String confId = lEntity.getWebcastId();
                    String nickName = lEntity.getNickName();
                    String ud = lEntity.getUserData();
                    String userData = ud == null ? "" : ud;
                    String cachDir = FileUtil.getCachDir((Context)appCtx, (String)"rtmpplayer");
                    Player.this.selfInfo = new UserInfo(userId, nickName, 16, -1);
                    GenseeLog.d((String)Player.TAG, (String)("join room confId = " + confId + " cachDir = " + cachDir));
                    Player.this.mPlayer.join(siteId, userId, nickName, albAddress, serviceType, confId, subject, userData, Player.this.nativeCallback, cachDir, lEntity.isHttpMode(), Player.this.rate.getValue());
                } else if (Player.this.mListener != null) {
                    Player.this.mListener.onJoin(8);
                }
                String word = lEntity.getSensitiveWordUrl();
                if (!StringUtil.isEmpty((String)word)) {
                    if (Player.this.mWordFilter == null) {
                        Player.this.mWordFilter = new SensiviteWordFilter();
                    }
                    Player.this.mWordFilter.init(word);
                }
            }
        });
    }

    @Override
    public UserInfo getSelfInfo() {
        return this.selfInfo;
    }

    @Override
    public void voteSubmit(VotePlayerGroup voteGroup) {
        if (voteGroup == null || null == this.selfInfo) {
            return;
        }
        int ret = 0;
        if (voteGroup.isM_bForce()) {
            if (!voteGroup.haveAllAnswer()) {
                ret = 1;
            }
        } else if (!voteGroup.haveAnswer()) {
            ret = 2;
        }
        if (ret != 0) {
            if (this.voteCallback != null) {
                this.voteCallback.onVoteSubmitRet(ret);
            }
            return;
        }
        if (null != this.mPlayer) {
            if (this.p != null) {
                voteGroup.setSiteId(String.valueOf(this.p.getSiteId()));
                voteGroup.setConfId(this.p.getWebcastId());
            }
            this.mPlayer.voteSubmit(voteGroup, this.selfInfo.getUserId(), this.selfInfo.getName(), null);
        }
    }

    private HashMap<String, Long> getQaCache() {
        if (this.mQaMap == null) {
            this.mQaMap = new HashMap(1);
        }
        return this.mQaMap;
    }

    private Set<String> getSelfChatMsgs() {
        if (this.selfChatMsgs == null) {
            this.selfChatMsgs = new HashSet<String>();
        }
        return this.selfChatMsgs;
    }

    @Override
    public boolean question(String uuid, String question) {
        if (StringUtil.isEmpty((String)uuid) || StringUtil.isEmpty((String)question) || this.selfInfo == null) {
            return false;
        }
        HashMap<String, Long> cache = this.getQaCache();
        cache.put(uuid, this.selfInfo.getId());
        return this.mPlayer.question(uuid, question, null);
    }

    @Override
    public boolean sameQuestion(String uuid, OnTaskRet ret) {
        GenseeLog.d((String)TAG, (String)("sameQuestion uuid = " + uuid));
        if (StringUtil.isEmpty((String)uuid)) {
            return false;
        }
        return this.mPlayer.sameQuestion(uuid, ret);
    }

    private boolean chat(String content, String richtext, int receiverId, String msgId, OnTaskRet onTaskRet) {
        return this.mPlayer.chat(content, richtext, receiverId, msgId, onTaskRet);
    }

    @Override
    public boolean chatToPersion(ChatMsg msg, OnTaskRet taskRet) {
        if (msg == null || !msg.isPlayerPriValid()) {
            GenseeLog.w((String)TAG, (String)("chatToPersion msg is not valid msg " + msg));
            return false;
        }
        int receiverChatId = msg.getChatId();
        String content = msg.getContent();
        String richtext = msg.getRichText();
        String msgId = msg.getId();
        return this.chat(content, richtext, receiverChatId, msgId, taskRet);
    }

    @Override
    public boolean chatToPublic(ChatMsg msg, OnTaskRet taskRet) {
        String content = msg.getContent();
        String richtext = msg.getRichText();
        String msgId = msg.getId();
        this.getSelfChatMsgs().add(msgId);
        if (msg == null || !msg.isPubValid()) {
            GenseeLog.w((String)TAG, (String)("chatToPublic msg is not valid msg " + msg));
            return false;
        }
        return this.chat(content, richtext, 0, msgId, taskRet);
    }

    public void audioSet(boolean isClose) {
        this.mPlayer.closeAudio(isClose, null);
    }

    public void videoSet(boolean isClose) {
        this.mPlayer.closeVideo(isClose, null);
    }

    public void setLocalVideoView(ILocalVideoView localVideoView) {
        this.mPlayer.setLocalVideoView(localVideoView);
    }

    public boolean openCamera(Context context, boolean isOpen, OnTaskRet taskRet) {
        return this.mPlayer.openCamera(context, isOpen, taskRet);
    }

    public boolean openMic(Context context, boolean isOpen, OnTaskRet taskRet) {
        return this.mPlayer.openMic(context, isOpen, taskRet);
    }

    public boolean inviteAck(int type, boolean isAccept, OnTaskRet taskRet) {
        return this.mPlayer.handleInvite(type, isAccept, taskRet);
    }

    public boolean rollCallAck(boolean isAccept, OnTaskRet taskRet) {
        return this.mPlayer.handleRollCall(isAccept, taskRet);
    }

    public boolean handUp(boolean isHand, OnTaskRet taskRet) {
        return this.mPlayer.handUp(isHand, taskRet);
    }

    public boolean downloadShareFile(String url, String fileFullPath, OnTaskRet taskRet) {
        return this.mPlayer.dlFileShare(url, fileFullPath, taskRet);
    }

    public boolean switchRate(VideoRate rate, OnTaskRet taskRet) {
        GenseeLog.d((String)TAG, (String)("switchRate rate = " + rate.getValue()));
        if (rate == this.rate) {
            GenseeLog.w((String)TAG, (String)("switchRate rate = old = " + rate.getValue()));
            return false;
        }
        this.rate = rate;
        return this.mPlayer.switchRate(rate.getValue(), taskRet);
    }

    public int onVideoData(byte[] data, VideoParam videoParam) {
        return this.mPlayer.sendVideo(data, videoParam);
    }

    public boolean reward(Reward reward) {
        LoginResEntity entity = this.p;
        if (entity == null || !entity.isAliPaySupport()) {
            GenseeLog.w((String)TAG, (String)"reward alipay is not support,Asking for help from sales!");
            return false;
        }
        return new RewardAction().reward(reward, entity, new StringRes(){

            public void onConnectError(int errorType, String errorInfo) {
                this.pay(null);
            }

            public void onRes(String result) {
                this.pay(PayInfo.build((String)result));
            }

            private void pay(PayInfo info) {
                if (Player.this.mListener != null) {
                    Player.this.mListener.onGotoPay(info);
                }
            }
        });
    }

    public boolean getUserInfoById(long[] userId, OnTaskRet taskRet) {
        return this.mPlayer.getUserInfoById(userId, taskRet);
    }

    public boolean reName(String newNickName, OnTaskRet taskRet) {
        if (StringUtil.isEmpty((String)newNickName) || this.selfInfo != null && newNickName.endsWith(this.selfInfo.getName())) {
            GenseeLog.w((String)TAG, (String)("reName fail ,newNickName is " + newNickName));
            return false;
        }
        return this.mPlayer.reName(newNickName, taskRet);
    }

    @Override
    public String textFilter(String src) {
        SensiviteWordFilter f = this.mWordFilter;
        if (f != null) {
            return f.filter(src);
        }
        return src;
    }
}

