/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.PopupWindow;
import android.widget.TextView;
import com.gensee.routine.UserInfo;
import com.gensee.utils.GenseeLog;
import java.util.List;

public abstract class AbsChatToPopView
extends PopupWindow
implements View.OnClickListener {
    private final int MAX_SIZE = 5;
    private String TAG = "AbsChatToPopView";
    private ListView mListView;
    private List<UserInfo> mList;
    private PopChatAdapter mPopChatAdapter;
    private InterfaceSelarctorName mInterfaceSelarctorName;
    private boolean isOpenPop = false;

    public AbsChatToPopView(View parentView, InterfaceSelarctorName mInterfaceSelarctorName, List<UserInfo> mInfos) {
        this.mInterfaceSelarctorName = mInterfaceSelarctorName;
        LayoutInflater inflater = LayoutInflater.from((Context)parentView.getContext());
        View view = inflater.inflate(this.getPopChatLayoutId(), null);
        this.mListView = (ListView)view.findViewById(this.getPopChatLvId());
        this.mPopChatAdapter = new PopChatAdapter();
        this.mListView.setAdapter((ListAdapter)this.mPopChatAdapter);
        this.setContentView(view);
        this.setWidth((int)parentView.getContext().getResources().getDimension(this.getPopChatWidthId()));
        this.setHeight((int)parentView.getContext().getResources().getDimension(this.getPopChatHeightId()));
        this.setBackgroundDrawable(parentView.getContext().getResources().getDrawable(17170445));
        this.setFocusable(true);
        this.setOutsideTouchable(false);
        this.setOnDismissListener(new PopupWindow.OnDismissListener(){

            public void onDismiss() {
                AbsChatToPopView.this.isOpenPop = false;
                if (null != AbsChatToPopView.this.mInterfaceSelarctorName) {
                    AbsChatToPopView.this.mInterfaceSelarctorName.selectStatus(false);
                }
            }
        });
        this.mList = mInfos;
    }

    public void updateUserPopWindow(View parent) {
        if (this.isOpenPop) {
            int nSize = this.mList.size();
            if (nSize > 5) {
                nSize = 5;
            }
            int[] location = new int[2];
            parent.getLocationOnScreen(location);
            GenseeLog.i((String)this.TAG, (String)("location[0] " + location[0] + "Location[1] " + location[1]));
            GenseeLog.i((String)this.TAG, (String)("getHeight" + this.getHeight() + "parent.getHeight" + parent.getHeight()));
            this.showAtLocation(parent, 51, location[0], location[1] - this.getHeight());
            int nHeight = (int)parent.getContext().getResources().getDimension(this.getPopChatItemHeightId()) * nSize + (nSize - 1) + 4;
            this.update(location[0], location[1] - nHeight, parent.getWidth(), nHeight);
            this.mPopChatAdapter.notifyDataSetChanged();
        }
    }

    public void showPopWindow(View v) {
        if (this.mList.size() <= 0) {
            return;
        }
        GenseeLog.e((String)this.TAG, (String)("showPopWindow" + this.mList.toString()));
        this.mPopChatAdapter.notifyDataSetChanged();
        this.changePopState(v);
    }

    private void changePopState(View v) {
        boolean bl = this.isOpenPop = !this.isOpenPop;
        if (this.isOpenPop) {
            if (null != this.mInterfaceSelarctorName) {
                this.mInterfaceSelarctorName.selectStatus(true);
            }
            this.popAwindow(v);
        } else {
            if (null != this.mInterfaceSelarctorName) {
                this.mInterfaceSelarctorName.selectStatus(false);
            }
            this.dismiss();
        }
    }

    protected void popAwindow(View parent) {
        this.setWidth(parent.getWidth());
        int nSize = this.mList.size();
        if (nSize > 5) {
            nSize = 5;
        }
        this.setHeight((int)parent.getContext().getResources().getDimension(this.getPopChatItemHeightId()) * nSize + (nSize - 1) + 4);
        int[] location = new int[2];
        parent.getLocationOnScreen(location);
        GenseeLog.i((String)this.TAG, (String)("location[0] " + location[0] + "Location[1] " + location[1]));
        GenseeLog.i((String)this.TAG, (String)("getHeight" + this.getHeight() + "parent.getHeight" + parent.getHeight()));
        this.showAtLocation(parent, 51, location[0], location[1] - this.getHeight());
    }

    public void onClick(View v) {
    }

    protected abstract int getPopChatLayoutId();

    protected abstract int getPopChatLvId();

    protected abstract int getPopChatWidthId();

    protected abstract int getPopChatHeightId();

    protected abstract int getPopChatItemHeightId();

    protected abstract int getPopChatListItemLayoutId();

    protected abstract int getPopChatUserTitleTvId();

    public static interface InterfaceSelarctorName {
        public void sendToChatOther(int var1);

        public void selectStatus(boolean var1);
    }

    protected class PopChatAdapter
    extends BaseAdapter {
        protected PopChatAdapter() {
        }

        public int getCount() {
            if (AbsChatToPopView.this.mList == null) {
                GenseeLog.w((String)AbsChatToPopView.this.TAG, (String)"PopChatAdapter getCount 0");
                return 0;
            }
            return AbsChatToPopView.this.mList.size();
        }

        public Object getItem(int position) {
            return AbsChatToPopView.this.mList.get(position);
        }

        public long getItemId(int position) {
            return position;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewChatHolder mViewChatHolder = null;
            if (null == convertView) {
                LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
                convertView = inflater.inflate(AbsChatToPopView.this.getPopChatListItemLayoutId(), null);
                mViewChatHolder = new ViewChatHolder(convertView);
                convertView.setTag((Object)mViewChatHolder);
            } else {
                mViewChatHolder = (ViewChatHolder)convertView.getTag();
            }
            UserInfo mUserInfo = (UserInfo)AbsChatToPopView.this.mList.get(position);
            mViewChatHolder.init(mUserInfo, position);
            return convertView;
        }

        protected class ViewChatHolder {
            private TextView mTextView;

            public ViewChatHolder(View v) {
                this.mTextView = (TextView)v.findViewById(AbsChatToPopView.this.getPopChatUserTitleTvId());
            }

            public void init(UserInfo mUserInfo, final int position) {
                if (this.mTextView == null) {
                    GenseeLog.e((String)AbsChatToPopView.this.TAG, (String)"mTextView is null");
                }
                if (mUserInfo == null) {
                    GenseeLog.i((String)AbsChatToPopView.this.TAG, (String)"mUserInfo is null");
                }
                if (mUserInfo != null && this.mTextView != null) {
                    this.mTextView.setText((CharSequence)mUserInfo.getName());
                }
                this.mTextView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (null != AbsChatToPopView.this.mInterfaceSelarctorName) {
                            AbsChatToPopView.this.mInterfaceSelarctorName.sendToChatOther(position);
                            AbsChatToPopView.this.dismiss();
                        }
                    }
                });
            }
        }
    }
}

