/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.gensee.adapter.AbsChatAdapter;
import com.gensee.adapter.AbsGridViewAvatarAdapter;
import com.gensee.adapter.ChatViewPageAdapter;
import com.gensee.adapter.SelectAvatarInterface;
import com.gensee.chat.gif.SpanResource;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.SendText;
import com.gensee.entity.chat.AbsChatMessage;
import com.gensee.entity.chat.PrivateMessage;
import com.gensee.entity.chat.PublicMessage;
import com.gensee.entity.chat.SysMessage;
import com.gensee.holder.chat.impl.AbstractChatImpl;
import com.gensee.holder.chat.impl.MsgQueue;
import com.gensee.player.IPlayerChat;
import com.gensee.routine.UserInfo;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.ThreadPool;
import com.gensee.view.AbsChatToPopView;
import com.gensee.view.ChatEditText;
import com.gensee.view.ChatLvView;
import com.gensee.view.GsAbsView;
import com.gensee.view.IChatView;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class GSChatView
extends GsAbsView
implements SelectAvatarInterface,
ViewPager.OnPageChangeListener,
IChatView,
AbsChatAdapter.OnChatAdapterListener,
AbsChatToPopView.InterfaceSelarctorName,
ChatEditText.OnSensitiveWordFilter {
    private static final int ADD_PUBLIC_CHAT_USERS = 2000;
    private static final int ADD_PRIVATE_CHAT_USERS = 2001;
    private static final int LEAVE_CHAT_USERS = 2002;
    private static final int RECONNECTION_ROOM = 2003;
    private IPlayerChat mChatHandle;
    private TextView tvChatTo;
    private ImageButton btnSend;
    private ImageButton btnExpression;
    protected ChatEditText chatEditText;
    private LinearLayout lyExpression;
    private LinearLayout lyPageIndex;
    private ViewPager mViewPage;
    private int nCountPerPage;
    private UserInfo receiveUserInfo;
    private AtomicBoolean isMute = new AtomicBoolean(false);
    private AtomicBoolean isRoomMute = new AtomicBoolean(false);
    private AtomicBoolean isSitePriChatMute = new AtomicBoolean(false);
    private AbsChatToPopView mPopWindowsChatView;
    private List<UserInfo> mList;
    private static final int ADD_PUBLIC_USER_TYPE = 0;
    private static final int ADD_PRIVATE_USER_TYPE = 1;
    private static final int LEAVE_USER_TYPE = 2;
    private static final int RECONNECTION_ROOM_TYPE = 3;
    private static final String TAG = "GSChatView";
    private PublicChatLv mPublicChatLv;
    private SelfChatLv mSelfChatLv;
    private ChatImpl mChatImpl;
    Handler myHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 3: {
                    GSChatView.this.updateUsers(null, 3);
                    break;
                }
                case 2002: {
                    GSChatView.this.updateUsers((UserInfo)msg.obj, 2);
                    break;
                }
                case 2000: {
                    GSChatView.this.updateUsers((UserInfo)msg.obj, 0);
                    break;
                }
                case 2001: {
                    GSChatView.this.updateUsers((UserInfo)msg.obj, 1);
                }
            }
            super.handleMessage(msg);
        }
    };

    public GSChatView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public GSChatView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSChatView(Context context) {
        this(context, null);
    }

    @Override
    public void setModuleHandle(IPlayerChat chatHandle) {
        this.mChatHandle = chatHandle;
    }

    public void onClick(View v) {
        if (v.getId() == this.getSendBtnId()) {
            this.sendChatMsg(this.receiveUserInfo == null);
        } else if (v.getId() == this.getExpressionBtnId()) {
            this.expression();
        } else if (v.getId() == this.getQuerySelfTvId()) {
            this.select();
        } else if (v.getId() == this.getTvChatToId()) {
            this.selectChatTo();
        }
    }

    private void expression() {
        if (this.lyExpression.getVisibility() == 8) {
            this.lyExpression.setVisibility(0);
        } else {
            this.lyExpression.setVisibility(8);
        }
    }

    private void updateUsers(UserInfo newUser, int nType) {
        if (nType == 2003) {
            UserInfo first = this.mList.get(0);
            this.mList.clear();
            this.mList.add(first);
            this.updateChatTo();
            return;
        }
        if (null != newUser) {
            if (this.isSitePriChatMute.get() && !newUser.isAssistant() && !newUser.isPresenter() && !newUser.isHost()) {
                return;
            }
            UserInfo selectUser = null;
            for (UserInfo user : this.mList) {
                if (user.getUserId() != newUser.getUserId()) continue;
                selectUser = user;
                String newName = newUser.getName();
                if (newName == null || newName.equals(user.getName())) break;
                user.setName(newUser.getName());
                this.updateChatTo();
                break;
            }
            if (nType == 0) {
                if (null == selectUser) {
                    this.mList.add(newUser);
                    this.updateChatTo();
                }
            } else if (nType == 1) {
                if (null != selectUser) {
                    this.mList.remove(selectUser);
                }
                this.mList.add(1, newUser);
                this.updateChatTo();
            } else if (nType == 2 && null != selectUser) {
                this.mList.remove(selectUser);
                this.updateChatTo();
            }
        }
    }

    private void updateChatTo() {
        if (null != this.mPopWindowsChatView && this.mPopWindowsChatView.isShowing()) {
            this.mPopWindowsChatView.updateUserPopWindow((View)this.tvChatTo);
        }
    }

    private void selectChatTo() {
        if (null == this.mPopWindowsChatView) {
            this.mPopWindowsChatView = this.createChatToPopView(this.getRootView(), this, this.mList);
        }
        if (this.mPopWindowsChatView.isShowing()) {
            this.mPopWindowsChatView.updateUserPopWindow((View)this.tvChatTo);
        } else {
            this.mPopWindowsChatView.showPopWindow((View)this.tvChatTo);
        }
    }

    @Override
    public void sendToChatOther(int postion) {
        if (postion == 0) {
            this.receiveUserInfo = null;
            this.tvChatTo.setText((CharSequence)this.getContext().getResources().getString(this.getChatPublicTvId()));
        } else {
            UserInfo mUserInfo;
            this.receiveUserInfo = mUserInfo = this.mList.get(postion);
            this.tvChatTo.setText((CharSequence)mUserInfo.getName());
        }
    }

    @Override
    public void selectStatus(boolean bTrue) {
        this.tvChatTo.setSelected(bTrue);
    }

    @Override
    public void updateChatTarget(final UserInfo chatTo, final boolean bLeave) {
        this.post(new Runnable(){

            @Override
            public void run() {
                if (null != GSChatView.this.receiveUserInfo && GSChatView.this.receiveUserInfo.getUserId() == chatTo.getUserId()) {
                    if (!bLeave) {
                        GSChatView.this.receiveUserInfo.update(chatTo);
                    } else {
                        GSChatView.this.receiveUserInfo = null;
                    }
                }
            }
        });
    }

    protected void sendChatMsg(boolean isPublic) {
        if (this.isMute.get()) {
            return;
        }
        if (this.isRoomMute.get()) {
            if (isPublic) {
                this.sendPublicMsg(true);
            } else {
                this.sendPrivateMsg(true);
            }
        } else if (isPublic) {
            this.sendPublicMsg(false);
        } else {
            this.sendPrivateMsg(false);
        }
        this.chatEditText.setText((CharSequence)"");
        if (this.lyExpression.getVisibility() != 8) {
            this.lyExpression.setVisibility(8);
        }
        this.hideSoftInputmethod(this.getContext());
    }

    private boolean checkMsgInfo(UserInfo selfInfo, String content) {
        if (null == selfInfo) {
            Toast.makeText((Context)this.getContext(), (int)this.getSelfInfoNullId(), (int)0).show();
            return false;
        }
        if (null != this.receiveUserInfo && this.receiveUserInfo.getUserId() == selfInfo.getUserId()) {
            Toast.makeText((Context)this.getContext(), (int)this.getChatToSelfStrId(), (int)0).show();
            return false;
        }
        if ("".equals(content)) {
            Toast.makeText((Context)this.getContext(), (int)this.getSendMsgNotNullId(), (int)0).show();
            return false;
        }
        return true;
    }

    protected void sendPublicMsg(boolean onlyShowLocal) {
        SendText text;
        String content;
        IPlayerChat handle = this.mChatHandle;
        if (handle == null) {
            GenseeLog.d((String)TAG, (String)"sendPublicMsg");
            return;
        }
        UserInfo selfInfo = handle.getSelfInfo();
        if (!this.checkMsgInfo(selfInfo, content = this.onGetChatText((text = this.chatEditText.getSendText()).getChatText()))) {
            return;
        }
        String richText = this.onGetRichText(text.getRichText());
        long senderId = selfInfo.getUserId();
        String senderName = selfInfo.getName();
        int chatId = selfInfo.getChatId();
        int role = selfInfo.getRole();
        String msgId = UUID.randomUUID().toString();
        final ChatMsg msg = new ChatMsg(content, richText, 0, msgId);
        msg.setSender(senderName);
        msg.setSenderId(senderId);
        msg.setSenderRole(role);
        msg.setChatId(chatId);
        if (onlyShowLocal) {
            this.onChatWithPublic(msg);
        } else {
            handle.chatToPublic(msg, new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                    if (ret) {
                        GSChatView.this.onChatWithPublic(msg);
                    }
                }
            });
        }
    }

    protected String onGetChatText(String srcMsg) {
        return srcMsg;
    }

    protected String onGetRichText(String srcRichText) {
        return srcRichText;
    }

    protected void sendPrivateMsg(boolean onlyShowLocal) {
        SendText text;
        String content;
        IPlayerChat handle = this.mChatHandle;
        if (handle == null) {
            GenseeLog.d((String)TAG, (String)"sendPrivateMsg");
            return;
        }
        UserInfo selfInfo = handle.getSelfInfo();
        if (!this.checkMsgInfo(selfInfo, content = this.onGetChatText((text = this.chatEditText.getSendText()).getChatText()))) {
            return;
        }
        final String richText = this.onGetRichText(text.getRichText());
        final long receiverId = this.receiveUserInfo.getUserId();
        final String receiverName = this.receiveUserInfo.getName();
        String msgId = UUID.randomUUID().toString();
        if (onlyShowLocal) {
            this.onChatToPerson(receiverId, receiverName, content, richText);
        } else {
            ChatMsg msg = new ChatMsg(content, richText, 2, msgId);
            msg.setSender(selfInfo.getName());
            msg.setSenderId(selfInfo.getUserId());
            msg.setSenderRole(selfInfo.getRole());
            msg.setChatId(this.receiveUserInfo.getChatId());
            this.mChatHandle.chatToPersion(msg, new OnTaskRet(){

                public void onTaskRet(boolean ret, int id, String desc) {
                    if (ret) {
                        GSChatView.this.onChatToPerson(receiverId, receiverName, content, richText);
                    }
                }
            });
        }
    }

    private void select() {
        if (this.mChatHandle == null || this.mPublicChatLv == null || this.mSelfChatLv == null) {
            return;
        }
        TextView tvPublicQuerySelf = this.mPublicChatLv.tvQuerySelf;
        TextView tvSelfQuerySelf = this.mSelfChatLv.tvQuerySelf;
        tvPublicQuerySelf.setSelected(!tvPublicQuerySelf.isSelected());
        tvSelfQuerySelf.setSelected(!tvSelfQuerySelf.isSelected());
        this.mSelfChatLv.show(tvSelfQuerySelf.isSelected());
        if (tvSelfQuerySelf.isSelected()) {
            final UserInfo self = this.mChatHandle.getSelfInfo();
            if (null != self) {
                ThreadPool.getInstance().execute(new Runnable(){

                    @Override
                    public void run() {
                        MsgQueue.getIns().getSelfLatestMsg(self.getUserId());
                    }
                });
            }
        } else {
            MsgQueue.getIns().getMsgList();
            MsgQueue.getIns().resetSelfList();
        }
    }

    @Override
    protected void initView(View view) {
        this.tvChatTo = (TextView)view.findViewById(this.getTvChatToId());
        this.tvChatTo.setOnClickListener((View.OnClickListener)this);
        this.btnSend = (ImageButton)this.findViewById(this.getSendBtnId());
        this.btnSend.setOnClickListener((View.OnClickListener)this);
        this.btnExpression = (ImageButton)this.findViewById(this.getExpressionBtnId());
        this.btnExpression.setOnClickListener((View.OnClickListener)this);
        this.chatEditText = (ChatEditText)this.findViewById(this.getChatEditId());
        this.chatEditText.setOnSensitiveWordFilter((ChatEditText.OnSensitiveWordFilter)this);
        this.mPublicChatLv = new PublicChatLv();
        this.mPublicChatLv.initView(view);
        MsgQueue.getIns().setOnPublicChatHolderListener((MsgQueue.OnPublicChatHolderListener)this.mPublicChatLv);
        this.mChatImpl = new ChatImpl();
        this.mSelfChatLv = new SelfChatLv();
        this.mSelfChatLv.initView(view);
        this.mList = new ArrayList<UserInfo>();
        UserInfo mUserInfo = new UserInfo();
        mUserInfo.setUserId(-1000);
        mUserInfo.setName(this.getContext().getResources().getString(this.getChatPublicTvId()));
        this.mList.add(mUserInfo);
        this.mPopWindowsChatView = this.createChatToPopView(this.getRootView(), this, this.mList);
        this.initExpressionLayout();
    }

    public void hideSoftInputmethod(Context context) {
        Activity activity = (Activity)context;
        if (null != activity.getCurrentFocus()) {
            InputMethodManager im = (InputMethodManager)activity.getSystemService("input_method");
            im.hideSoftInputFromWindow(activity.getCurrentFocus().getApplicationWindowToken(), 2);
        }
    }

    private void initExpressionLayout() {
        this.lyExpression = (LinearLayout)this.findViewById(this.getExpressionLyId());
        this.lyPageIndex = (LinearLayout)this.findViewById(this.getExpressionIndexLyId());
        int nCount = SpanResource.getBrowMap((Context)this.getContext()).keySet().toArray().length;
        this.nCountPerPage = nCount % 18 == 0 ? nCount / 18 : nCount / 18 + 1;
        ArrayList<View> pagerList = new ArrayList<View>();
        for (int i = 0; i < this.nCountPerPage * 2; ++i) {
            View mPagerView = LayoutInflater.from((Context)this.getContext()).inflate(this.getExpressionPagerId(), null);
            if (i < this.nCountPerPage) {
                ImageView mImageView = new ImageView(this.getContext());
                if (i == 0) {
                    mImageView.setBackgroundResource(this.getExpressionIndexSelectIvId());
                } else {
                    mImageView.setBackgroundResource(this.getExpressionIndexUnSelectIvId());
                }
                LinearLayout.LayoutParams mPlayout = new LinearLayout.LayoutParams(-2, -2);
                mPlayout.setMargins(0, 10, 10, 10);
                mImageView.setLayoutParams((ViewGroup.LayoutParams)mPlayout);
                this.lyPageIndex.addView((View)mImageView);
            }
            int index = i % this.nCountPerPage;
            AbsGridViewAvatarAdapter mGridViewAvatarAdapter = this.getGvAvatarAdapter(this.getContext(), this, index * 18, 18 - index * 18);
            GridView mGridView = (GridView)mPagerView.findViewById(this.getExpressionGvId());
            mGridView.setAdapter((ListAdapter)mGridViewAvatarAdapter);
            pagerList.add(mPagerView);
        }
        ChatViewPageAdapter mChatViewPageAdapter = new ChatViewPageAdapter(pagerList);
        this.mViewPage = (ViewPager)this.findViewById(this.getExpressionVpId());
        this.mViewPage.setVisibility(0);
        this.mViewPage.setAdapter((PagerAdapter)mChatViewPageAdapter);
        this.mViewPage.setCurrentItem(pagerList.size() * 100);
        this.mViewPage.setOnPageChangeListener((ViewPager.OnPageChangeListener)this);
    }

    @Override
    public void selectAvatar(String sAvatar, Drawable resId) {
        this.chatEditText.getText().insert(this.chatEditText.getSelectionStart(), (CharSequence)SpanResource.convetToSpan((String)sAvatar.toString(), (Context)this.getContext()));
    }

    public void onPageScrollStateChanged(int arg0) {
    }

    public void onPageScrolled(int arg0, float arg1, int arg2) {
    }

    public void onPageSelected(int arg0) {
        for (int i = 0; i < this.lyPageIndex.getChildCount(); ++i) {
            ImageView mImageView = (ImageView)this.lyPageIndex.getChildAt(i);
            if (i == arg0 % this.nCountPerPage) {
                mImageView.setBackgroundResource(this.getExpressionIndexSelectIvId());
                continue;
            }
            mImageView.setBackgroundResource(this.getExpressionIndexUnSelectIvId());
        }
    }

    @Override
    public void onMute(boolean isMute) {
        this.isMute.set(isMute);
        if (!this.isRoomMute.get()) {
            this.onSysmessage(isMute ? this.getChatDisableStrId() : this.getChatEnableStrId());
        }
    }

    @Override
    public void onRoomMute(boolean isMute) {
        this.isRoomMute.set(isMute);
        if (!this.isMute.get()) {
            this.onSysmessage(isMute ? this.getChatDisableStrId() : this.getChatEnableStrId());
        }
    }

    @Override
    public void onStuPriChat(boolean isOpen) {
        this.isSitePriChatMute.set(!isOpen);
    }

    private void onSysmessage(int resStrId) {
        String sText = this.getContext().getResources().getString(resStrId);
        SysMessage message = new SysMessage();
        message.setRich(sText);
        message.setText(sText);
        message.setTime(Calendar.getInstance().getTimeInMillis());
        this.mChatImpl.updateMessage((AbsChatMessage)message);
    }

    @Override
    public void onChatWithPerson(ChatMsg msg) {
        if (msg == null) {
            return;
        }
        UserInfo self = this.mChatHandle.getSelfInfo();
        if (null != self) {
            long userId = msg.getSenderId();
            String sSendName = msg.getSender();
            int senderRole = msg.getSenderRole();
            String text = msg.getContent();
            String rich = msg.getRichText();
            int onChatID = msg.getChatId();
            GenseeLog.d((String)("GSChatView OnChatWithPersion userId = " + userId + " sSendName = " + sSendName + " rich = " + rich + " text = " + text));
            UserInfo newUser = new UserInfo(userId, sSendName, senderRole, onChatID);
            this.myHandler.sendMessage(this.myHandler.obtainMessage(2001, (Object)newUser));
            PrivateMessage privateMessage = new PrivateMessage();
            privateMessage.setReceiveName(self.getName());
            privateMessage.setReceiveUserId(self.getUserId());
            privateMessage.setRich(rich);
            privateMessage.setText(text);
            privateMessage.setSendUserId(userId);
            privateMessage.setSendUserName(sSendName);
            privateMessage.setTime(msg.getTimeStamp());
            privateMessage.setSenderRole(senderRole);
            privateMessage.setId(msg.getId());
            this.mChatImpl.updateMessage((AbsChatMessage)privateMessage);
        } else {
            GenseeLog.d((String)"GSChatView OnChatWithPersion getselfIno is null");
        }
    }

    public void onChatToPerson(long receiveUserId, String sReceiveName, String text, String rich) {
        UserInfo self = this.mChatHandle.getSelfInfo();
        if (null != self) {
            GenseeLog.d((String)("GSChatView OnChatToPerson receiveUserId = " + receiveUserId + " sReceiveName = " + sReceiveName + " rich = " + rich + " text = " + text));
            PrivateMessage privateMessage = new PrivateMessage();
            privateMessage.setReceiveName(sReceiveName);
            privateMessage.setReceiveUserId(receiveUserId);
            privateMessage.setRich(rich);
            privateMessage.setText(text);
            privateMessage.setSendUserId(self.getUserId());
            privateMessage.setSendUserName(self.getName());
            privateMessage.setTime(Calendar.getInstance().getTimeInMillis());
            privateMessage.setSenderRole(self.getRole());
            this.mChatImpl.updateMessage((AbsChatMessage)privateMessage);
        } else {
            GenseeLog.d((String)"GSChatView OnChatWithPersion getselfIno is null");
        }
    }

    @Override
    public void onChatWithPublic(ChatMsg msg) {
        UserInfo self;
        if (msg == null) {
            return;
        }
        long userId = msg.getSenderId();
        String sSendName = msg.getSender();
        int senderRole = msg.getSenderRole();
        String text = msg.getContent();
        String rich = msg.getRichText();
        int onChatID = msg.getChatId();
        if (msg.getSenderId() != this.getSelfId()) {
            UserInfo newUser = new UserInfo(userId, sSendName, senderRole, onChatID);
            this.myHandler.sendMessage(this.myHandler.obtainMessage(2000, (Object)newUser));
        }
        if (null != (self = this.mChatHandle.getSelfInfo())) {
            GenseeLog.d((String)("GSChatView OnChatWithPublic userId = " + userId + " sSendName = " + sSendName + " rich = " + rich + " text = " + text));
            PublicMessage publicMessage = new PublicMessage();
            publicMessage.setRich(rich);
            publicMessage.setText(text);
            publicMessage.setSendUserId(userId);
            publicMessage.setSendUserName(sSendName);
            publicMessage.setTime(msg.getTimeStamp());
            publicMessage.setSenderRole(senderRole);
            publicMessage.setId(msg.getId());
            this.mChatImpl.updateMessage((AbsChatMessage)publicMessage);
        } else {
            GenseeLog.d((String)"GSChatView OnChatWithPersion getselfIno is null");
        }
    }

    @Override
    public void onChatcensor(final String type, final String id) {
        ThreadPool.getInstance().execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if ("user".equals(type)) {
                        MsgQueue.getIns().removeMsg(Long.parseLong(id), "");
                    } else {
                        MsgQueue.getIns().removeMsg(0L, id);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    @Override
    public void onPublish(boolean isPlaying) {
        int resId = isPlaying ? this.getPublishPlayingStrId() : this.getPublishPauseStrId();
        this.onSysmessage(resId);
    }

    @Override
    public void onReconnection() {
        this.myHandler.sendMessage(this.myHandler.obtainMessage(2003));
    }

    @Override
    public long getSelfId() {
        UserInfo self;
        UserInfo userInfo = self = this.mChatHandle == null ? null : this.mChatHandle.getSelfInfo();
        if (null != self) {
            return self.getUserId();
        }
        return -1L;
    }

    public String onFilter(String src) {
        return this.mChatHandle == null ? src : this.mChatHandle.textFilter(src);
    }

    protected abstract int getSendBtnId();

    protected abstract int getExpressionBtnId();

    protected abstract int getChatEditId();

    protected abstract int getChatLvId();

    protected abstract int getSelfChatLvId();

    protected abstract int getSelfChatRlId();

    protected abstract int getChatLvHeadViewId();

    protected abstract int getQuerySelfTvId();

    protected abstract int getExpressionLyId();

    protected abstract int getExpressionIndexLyId();

    protected abstract int getExpressionPagerId();

    protected abstract int getExpressionIndexSelectIvId();

    protected abstract int getExpressionIndexUnSelectIvId();

    protected abstract int getExpressionGvId();

    protected abstract int getExpressionVpId();

    protected abstract int getSendMsgNotNullId();

    protected abstract int getSelfInfoNullId();

    protected abstract int getRelTipId();

    protected abstract int getRelTipStrId();

    protected abstract int getTvTipId();

    protected abstract AbsChatAdapter getChatAdapter(Context var1);

    protected abstract AbsGridViewAvatarAdapter getGvAvatarAdapter(Context var1, SelectAvatarInterface var2, int var3, int var4);

    protected abstract int getChatToSelfStrId();

    protected abstract int getTvChatToId();

    protected abstract int getChatPublicTvId();

    protected abstract AbsChatToPopView createChatToPopView(View var1, AbsChatToPopView.InterfaceSelarctorName var2, List<UserInfo> var3);

    protected abstract int getPublishPauseStrId();

    protected abstract int getPublishPlayingStrId();

    protected abstract int getChatDisableStrId();

    protected abstract int getChatEnableStrId();

    @Override
    public void release() {
        this.mChatImpl.release();
        this.isMute.set(false);
        this.isRoomMute.set(false);
        this.isSitePriChatMute.set(false);
    }

    protected class SelfChatLv
    extends ChatLvView {
        private TextView tvQuerySelf;
        private RelativeLayout rlQuerySelf;

        protected SelfChatLv() {
        }

        @Override
        protected void initView(View view) {
            super.initView(view);
            View headerView = LayoutInflater.from((Context)GSChatView.this.getContext()).inflate(GSChatView.this.getChatLvHeadViewId(), null);
            this.lvChat.addHeaderView(headerView);
            this.adapter = GSChatView.this.getChatAdapter(GSChatView.this.getContext());
            ((AbsChatAdapter)this.adapter).setOnChatAdapterListener(GSChatView.this);
            this.lvChat.setAdapter((ListAdapter)this.adapter);
            this.tvQuerySelf = (TextView)headerView.findViewById(GSChatView.this.getQuerySelfTvId());
            this.tvQuerySelf.setOnClickListener((View.OnClickListener)GSChatView.this);
            this.tvQuerySelf.setSelected(false);
            this.rlQuerySelf = (RelativeLayout)view.findViewById(GSChatView.this.getSelfChatRlId());
        }

        protected void show(boolean bVisible) {
            this.rlQuerySelf.setVisibility(bVisible ? 0 : 8);
        }

        public void refreshMsg(int what, List<AbsChatMessage> msgList, boolean bLatest) {
            Message message = new Message();
            message.obj = msgList;
            message.what = what;
            Bundle bundle = new Bundle();
            bundle.putBoolean("LATEST", bLatest);
            message.setData(bundle);
            this.sendMessage(message);
        }

        @Override
        public void refresh() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    UserInfo selfInfo = GSChatView.this.mChatHandle.getSelfInfo();
                    MsgQueue.getIns().onSelfMessageFresh(selfInfo == null ? -1L : selfInfo.getUserId());
                }
            });
        }

        @Override
        protected void loadMore() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    UserInfo selfInfo = GSChatView.this.mChatHandle.getSelfInfo();
                    MsgQueue.getIns().onSelfMessageLoadMore(selfInfo == null ? -1L : selfInfo.getUserId());
                }
            });
        }

        @Override
        protected int getLvId() {
            return GSChatView.this.getSelfChatLvId();
        }
    }

    protected class PublicChatLv
    extends ChatLvView
    implements MsgQueue.OnPublicChatHolderListener {
        private TextView tvQuerySelf;

        protected PublicChatLv() {
        }

        @Override
        protected void initView(View view) {
            super.initView(view);
            View headerView = LayoutInflater.from((Context)GSChatView.this.getContext()).inflate(GSChatView.this.getChatLvHeadViewId(), null);
            this.lvChat.addHeaderView(headerView);
            this.adapter = GSChatView.this.getChatAdapter(GSChatView.this.getContext());
            ((AbsChatAdapter)this.adapter).setOnChatAdapterListener(GSChatView.this);
            this.lvChat.setAdapter((ListAdapter)this.adapter);
            this.tvQuerySelf = (TextView)headerView.findViewById(GSChatView.this.getQuerySelfTvId());
            this.tvQuerySelf.setOnClickListener((View.OnClickListener)GSChatView.this);
            this.tvQuerySelf.setSelected(false);
        }

        @Override
        protected void refresh() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    MsgQueue.getIns().onMessageFresh();
                }
            });
        }

        @Override
        protected void loadMore() {
            ThreadPool.getInstance().execute(new Runnable(){

                @Override
                public void run() {
                    MsgQueue.getIns().onMessageLoadMore();
                }
            });
        }

        @Override
        protected int getLvId() {
            return GSChatView.this.getChatLvId();
        }

        public boolean isSelfLvBottom() {
            return null != GSChatView.this.mSelfChatLv && GSChatView.this.mSelfChatLv.getLvBottom();
        }

        public void refreshSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            if (null != GSChatView.this.mSelfChatLv) {
                GSChatView.this.mSelfChatLv.refreshMsg(10004, msgList, bLatest);
            }
        }

        public void onPullSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            if (null != GSChatView.this.mSelfChatLv) {
                GSChatView.this.mSelfChatLv.refreshMsg(10005, msgList, bLatest);
            }
        }

        public void onLoadSelfMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            if (null != GSChatView.this.mSelfChatLv) {
                GSChatView.this.mSelfChatLv.refreshMsg(10006, msgList, bLatest);
            }
        }

        public void onSelfCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            if (null != GSChatView.this.mSelfChatLv) {
                GSChatView.this.mSelfChatLv.refreshMsg(10007, msgList, bLatest);
            }
        }

        public boolean isLvBottom() {
            return this.getLvBottom();
        }

        public void onCancelMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            this.refreshMsg(10001, msgList, bLatest);
        }

        public void refreshMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            this.refreshMsg(10000, msgList, bLatest);
        }

        public void onPullMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            this.refreshMsg(10002, msgList, bLatest);
        }

        public void onLoadMsg(List<AbsChatMessage> msgList, boolean bLatest) {
            this.refreshMsg(10003, msgList, bLatest);
        }

        private void refreshMsg(int what, List<AbsChatMessage> msgList, boolean bLatest) {
            Message message = new Message();
            message.obj = msgList;
            message.what = what;
            Bundle bundle = new Bundle();
            bundle.putBoolean("LATEST", bLatest);
            message.setData(bundle);
            this.sendMessage(message);
        }

        public void onNewMsgCount(int nMsgCount) {
        }
    }

    private class ChatImpl
    extends AbstractChatImpl {
    }
}

