/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view.xlistview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

public abstract class XListViewHeader
extends LinearLayout {
    private LinearLayout mContainer;
    private ImageView mArrowImageView;
    private ProgressBar mProgressBar;
    private TextView mHintTextView;
    private int mState = 0;
    private Animation mRotateUpAnim;
    private Animation mRotateDownAnim;
    private final int ROTATE_ANIM_DURATION = 180;
    public static final int STATE_NORMAL = 0;
    public static final int STATE_READY = 1;
    public static final int STATE_REFRESHING = 2;

    public XListViewHeader(Context context) {
        super(context);
        this.initView(context);
    }

    public XListViewHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, 0);
        this.mContainer = (LinearLayout)LayoutInflater.from((Context)context).inflate(this.getHeaderViewLayoutId(), null);
        this.addView((View)this.mContainer, (ViewGroup.LayoutParams)lp);
        this.setGravity(80);
        this.mArrowImageView = (ImageView)this.findViewById(this.getHeaderArrowIvId());
        this.mHintTextView = (TextView)this.findViewById(this.getHeaderHintTvId());
        this.mProgressBar = (ProgressBar)this.findViewById(this.getHeaderProgressbarId());
        this.mRotateUpAnim = new RotateAnimation(0.0f, -180.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateUpAnim.setDuration(180L);
        this.mRotateUpAnim.setFillAfter(true);
        this.mRotateDownAnim = new RotateAnimation(-180.0f, 0.0f, 1, 0.5f, 1, 0.5f);
        this.mRotateDownAnim.setDuration(180L);
        this.mRotateDownAnim.setFillAfter(true);
    }

    public void setState(int state) {
        if (state == this.mState) {
            return;
        }
        if (state == 2) {
            this.mArrowImageView.clearAnimation();
            this.mArrowImageView.setVisibility(4);
            this.mProgressBar.setVisibility(0);
        } else {
            this.mArrowImageView.setVisibility(0);
            this.mProgressBar.setVisibility(0);
        }
        switch (state) {
            case 0: {
                if (this.mState == 1) {
                    this.mArrowImageView.startAnimation(this.mRotateDownAnim);
                }
                if (this.mState == 2) {
                    this.mArrowImageView.clearAnimation();
                }
                this.mHintTextView.setText(this.getHeaderHintNormalStrId());
                break;
            }
            case 1: {
                if (this.mState == 1) break;
                this.mArrowImageView.clearAnimation();
                this.mArrowImageView.startAnimation(this.mRotateUpAnim);
                this.mHintTextView.setText(this.getHeaderHintReadyStrId());
                break;
            }
            case 2: {
                this.mHintTextView.setText(this.getHeaderHintLoadingStrId());
                break;
            }
        }
        this.mState = state;
    }

    public void setVisiableHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)this.mContainer.getLayoutParams();
        lp.height = height;
        this.mContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    public int getVisiableHeight() {
        return this.mContainer.getHeight();
    }

    protected abstract int getHeaderViewLayoutId();

    protected abstract int getHeaderHintNormalStrId();

    protected abstract int getHeaderHintReadyStrId();

    protected abstract int getHeaderHintLoadingStrId();

    protected abstract int getHeaderArrowIvId();

    protected abstract int getHeaderHintTvId();

    protected abstract int getHeaderProgressbarId();
}

