/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.common;

public class RoleType {
    public static final int ROLE_HOST = 1;
    public static final int ROLE_PRESENT = 2;
    public static final int ROLE_PANELIST = 4;
    public static final int ROLE_ATTENDEE = 8;
    public static final int ROLE_ATTENDEE_WEB = 16;
    public static final int ROLE_LOD = 32;

    public static boolean isHost(int role) {
        return (role & 1) == 1;
    }

    public static boolean isPresentor(int role) {
        return (role & 2) == 2;
    }

    public static boolean isPanelist(int role) {
        return (role & 4) == 4;
    }

    public static boolean isAttendee(int role) {
        return (role & 8) == 8;
    }

    public static boolean isAttendeeWeb(int role) {
        return (role & 0x10) == 16;
    }

    public static boolean isLodUser(int role) {
        return (role & 0x20) == 32;
    }

    public static boolean isRoleGreater(int otherUserRole, int role) {
        for (int i = 0; i < 3; ++i) {
            int nMe = role >> i & 1;
            int nOther = otherUserRole >> i & 1;
            if (nMe == nOther) continue;
            return nMe > nOther;
        }
        return false;
    }
}

