/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.entity;

import android.content.Context;
import com.gensee.entity.BaseMsg;
import com.gensee.entity.EmsMsg;
import com.gensee.utils.StringUtil;
import org.w3c.dom.Node;

public class ChatMsg
extends EmsMsg {
    private static final long serialVersionUID = 808834629165790017L;
    public static final int CHAT_MSG_TYPE_PUBLIC = 0;
    public static final int CHAT_MSG_TYPE_PANELIST = 1;
    public static final int CHAT_MSG_TYPE_PRIVATE = 2;
    private boolean isGroup = false;
    private String groupId;
    private String content;
    private String richText;
    private long receiverId;
    private int chatId;
    private int chatMsgType = -1;
    private String id;
    private String censorType;
    private long timeStamp;

    public ChatMsg() {
        super("chat");
    }

    public ChatMsg(long senderId, String senderName, String text, String rich, boolean isGroup) {
        this();
        this.isGroup = isGroup;
        this.content = text;
        this.richText = rich;
        this.setSender(senderName);
        this.setSenderId(senderId);
        this.timeStamp = System.currentTimeMillis();
    }

    public ChatMsg(String content, String richText, int chatMsgType, String id) {
        this.content = content;
        this.richText = richText;
        this.chatMsgType = chatMsgType;
        this.id = id;
        this.timeStamp = System.currentTimeMillis();
    }

    public boolean isGroup() {
        return this.isGroup ? this.isGroup : this.chatMsgType == 0;
    }

    public void setGroup(boolean isGroup) {
        this.isGroup = isGroup;
    }

    public String getContent() {
        return this.content == null ? "" : this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getRichText() {
        return this.richText == null || "".equals(this.richText) ? this.getContent() : this.richText;
    }

    public void setRichText(String richText) {
        this.richText = richText;
    }

    public long getReceiverId() {
        return this.receiverId;
    }

    public void setReceiverId(long receiverId) {
        this.receiverId = receiverId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getChatId() {
        return this.chatId;
    }

    public void setChatId(int receiverChatId) {
        this.chatId = receiverChatId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String chatMsgId) {
        this.id = chatMsgId;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public int getChatMsgType() {
        return this.chatMsgType == -1 ? (this.isGroup ? 0 : 2) : this.chatMsgType;
    }

    public void setChatMsgType(int chatMsgType) {
        this.chatMsgType = chatMsgType;
    }

    public String getCensorType() {
        return this.censorType;
    }

    public void setCensorType(String censorType) {
        this.censorType = censorType;
    }

    @Override
    protected String getXml() {
        return "";
    }

    public boolean isPubValid() {
        String id = this.getId();
        return !StringUtil.isEmpty(id) && !StringUtil.isEmpty(this.content) && !StringUtil.isEmpty(this.richText);
    }

    public boolean isPriValid() {
        return this.receiverId != 0L && this.isPubValid();
    }

    public boolean isPlayerPriValid() {
        return this.chatId != 0 && this.isPubValid();
    }

    @Override
    protected BaseMsg onXmlNode(Context c, Node n) {
        return this;
    }

    @Override
    public String toString() {
        return "ChatMsg [content=" + this.content + ", richText=" + this.richText + ", receiverId=" + this.receiverId + ", chatId=" + this.chatId + ", chatMsgType=" + this.chatMsgType + ", id=" + this.id + "]";
    }
}

