/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.entity;

import com.gensee.entity.BaseMsg;
import com.gensee.entity.VoteQuestItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VoteQuest
implements Serializable {
    private static final long serialVersionUID = 4631616639131304932L;
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_SINGLE = "single";
    public static final String TYPE_MULTI = "multi";
    private String id;
    private String type;
    private int score;
    private String answer;
    private String subject;
    private int total;
    private List<VoteQuestItem> questItems;
    private String submitAnswer;

    public VoteQuest(Node node) {
        this.id = BaseMsg.getNodeAttrString(node, "id");
        this.type = BaseMsg.getNodeAttrString(node, "type");
        this.score = BaseMsg.getNodeAttrInt(node, "score");
        this.answer = BaseMsg.getNodeAttrString(node, "answer");
        this.total = BaseMsg.getNodeAttrInt(node, "total");
        NodeList nl = node.getChildNodes();
        if (nl != null) {
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                Node childNode = nl.item(i);
                if (childNode == null) continue;
                String nodeName = childNode.getNodeName();
                if ("item".equals(nodeName)) {
                    this.onItem(childNode);
                    continue;
                }
                if (!"subject".equals(nodeName)) continue;
                this.subject = childNode.getTextContent();
                this.subject = this.subject == null ? "" : this.subject.trim();
            }
        }
    }

    public VoteQuest() {
    }

    private void onItem(Node childNode) {
        if (this.questItems == null) {
            this.questItems = new ArrayList<VoteQuestItem>();
        }
        this.questItems.add(new VoteQuestItem(childNode));
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int score) {
        this.score = score;
    }

    public String getAnswer() {
        return this.answer;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public List<VoteQuestItem> getQuestItems() {
        return this.questItems;
    }

    public void setQuestItems(List<VoteQuestItem> questItems) {
        this.questItems = questItems;
    }

    public String getSubmitAnswer() {
        return this.submitAnswer;
    }

    public void setSubmitAnswer(String submitAnswer) {
        this.submitAnswer = submitAnswer;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    public String toString() {
        return "VoteQuest [id=" + this.id + ", type=" + this.type + ", score=" + this.score + ", answer=" + this.answer + ", subject=" + this.subject + ", total=" + this.total + ", questItems=" + this.questItems + ", submitAnswer=" + this.submitAnswer + "]";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getXml(StringBuilder xmlSb) {
        if (TYPE_TEXT.equals(this.type)) {
            String strsubmitAnswer = this.submitAnswer == null ? "" : this.submitAnswer;
            xmlSb.append("<question id=\"" + this.id + "\">" + "<item idx=\"0\">" + strsubmitAnswer + "</item>");
        } else if (TYPE_MULTI.equals(this.type)) {
            xmlSb.append("<question id=\"" + this.id + "\">");
            VoteQuestItem item = null;
            int size = this.questItems.size();
            for (int i = 0; i < size; ++i) {
                item = this.questItems.get(i);
                if (item == null) continue;
                item.getXml(xmlSb, i);
            }
        } else {
            if (!TYPE_SINGLE.equals(this.type)) return -1;
            xmlSb.append("<question id=\"" + this.id + "\">");
            VoteQuestItem item = null;
            VoteQuestItem selectedItem = null;
            int size = this.questItems.size();
            int index = -1;
            for (int i = 0; i < size; ++i) {
                item = this.questItems.get(i);
                if (item == null || !item.isSelected()) continue;
                if (index == -1) {
                    selectedItem = item;
                    index = i;
                    continue;
                }
                if (i != index) continue;
                return -1;
            }
            if (index == -1 || selectedItem == null) return -1;
            selectedItem.getXml(xmlSb, index);
        }
        xmlSb.append("</question>");
        return 0;
    }
}

