/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.net;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.SignalStrength;
import android.telephony.TelephonyManager;
import com.gensee.net.AbsHandler;
import com.gensee.net.OnNetChangeListener;
import com.gensee.utils.GenseeLog;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.List;

public class NetChange {
    private static final int MAXSIZE = 5;
    private static NetChange ins = new NetChange();
    private SoftReference<Context> app;
    private SoftReference<BroadcastReceiver> srReceiver = null;
    private List<OnNetChangeListener> changeListeners;
    private WifiManager wifiManager;
    private TelephonyManager gsmMgr;
    private SignalStrength gsm;
    private boolean isConnected = false;

    public static NetChange getIns() {
        return ins;
    }

    private NetChange() {
    }

    public void setUp(Context context) {
        Context appCtx = context.getApplicationContext();
        if (this.srReceiver == null && context != null) {
            this.isConnected = AbsHandler.isNetConneced(context);
            BroadcastReceiver receiver = new BroadcastReceiver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onReceive(Context context, Intent arg1) {
                    boolean connected = AbsHandler.isNetConneced(context);
                    if (NetChange.this.isConnected ^ connected && NetChange.this.changeListeners != null) {
                        NetChange.this.isConnected = connected;
                        List list = NetChange.this.changeListeners;
                        synchronized (list) {
                            for (OnNetChangeListener l : NetChange.this.changeListeners) {
                                l.onNetChange(context);
                            }
                        }
                    }
                }
            };
            appCtx.registerReceiver(receiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
            this.srReceiver = new SoftReference<1>(receiver);
            this.app = new SoftReference<Context>(appCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        try {
            if (this.changeListeners != null) {
                List<OnNetChangeListener> list = this.changeListeners;
                synchronized (list) {
                    this.changeListeners.clear();
                }
            }
            if (this.app != null) {
                Context ctx = this.app.get();
                this.app.clear();
                BroadcastReceiver br = this.srReceiver.get();
                this.srReceiver.clear();
                ctx.unregisterReceiver(br);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        finally {
            this.srReceiver = null;
            this.app = null;
            this.isConnected = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOnNetChangeListener(OnNetChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<OnNetChangeListener>(1);
        }
        List<OnNetChangeListener> list = this.changeListeners;
        synchronized (list) {
            if (this.changeListeners.size() > 5) {
                this.changeListeners.remove(5);
            }
            this.changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNetChangeListener(OnNetChangeListener listener) {
        if (this.changeListeners != null && listener != null) {
            List<OnNetChangeListener> list = this.changeListeners;
            synchronized (list) {
                this.changeListeners.remove(listener);
            }
        }
    }

    public void printSigalLevel() {
        WifiInfo info;
        WifiManager ma = this.wifiManager;
        int wifiLevel = 0;
        int wifiSignal = 0;
        if (ma != null && (info = ma.getConnectionInfo()) != null) {
            wifiSignal = info.getRssi();
            wifiLevel = WifiManager.calculateSignalLevel((int)wifiSignal, (int)6);
        }
        SignalStrength strength = this.gsm;
        int astSignal = 0;
        if (strength != null) {
            astSignal = strength.isGsm() ? -113 + 2 * strength.getGsmSignalStrength() : strength.getCdmaDbm();
        }
        GenseeLog.d("NetChange", String.format("NetChange printSigalLevel wifiSignal = %d level = %d gsmOrCdma signal = %d", wifiSignal, wifiLevel, astSignal));
    }
}

