/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.parse;

import com.gensee.entity.ChatMsg;
import com.gensee.entity.QAMsg;
import com.gensee.parse.PullBase;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;

public class MsgParse
extends PullBase {
    private List<QAMsg> qaMsgs;
    private List<ChatMsg> chatMsgs;
    private static final String TAG_QA = "qa";
    private static final String TAG_CHAT = "chat";
    private ChatMsg chatMsg;
    private int pageIndex = 1;
    private boolean more = false;

    public List<ChatMsg> getChatMsgs() {
        return this.chatMsgs;
    }

    public int getPageIndex() {
        return this.pageIndex;
    }

    public boolean isMore() {
        return this.more;
    }

    public List<QAMsg> parseQa(String xml) {
        this.more = false;
        XmlPullParser parser = this.builXmlPullParser(xml);
        if (parser != null) {
            this.parser(parser);
        }
        return this.qaMsgs;
    }

    @Override
    protected void onStartTag(String nodeName, XmlPullParser parser) {
        if (TAG_QA.equals(nodeName)) {
            QAMsg qa = new QAMsg(TAG_QA);
            qa.setQuestId(this.getAttrStrValue(parser, "id"));
            qa.setQuestion(this.getAttrStrValue(parser, "question"));
            qa.setQuestOwnerName(this.getAttrStrValue(parser, "questionowner"));
            qa.setQuestTimgstamp(this.getAttrLongValue(parser, "questiontimestamp"));
            qa.setQuestOwnerId(this.getAttrLongValue(parser, "questionownerid"));
            qa.setAnswer(this.getAttrStrValue(parser, "answer"));
            qa.setAnswerUser(this.getAttrStrValue(parser, "answerowner"));
            qa.setAnswerTimestamp(this.getAttrLongValue(parser, "qaanswertimestamp"));
            if (this.qaMsgs == null) {
                this.qaMsgs = new ArrayList<QAMsg>();
            }
            this.qaMsgs.add(qa);
        } else if (TAG_CHAT.equals(nodeName)) {
            this.chatMsg = new ChatMsg();
            this.chatMsg.setSender(this.getAttrStrValue(parser, "sender"));
            this.chatMsg.setTimeStamp(this.getAttrLongValue(parser, "time"));
            this.chatMsg.setSenderId(this.getAttrLongValue(parser, "senderId"));
            this.chatMsg.setContent(this.getAttrStrValue(parser, ""));
            int type = this.nextEventType(parser);
            if (4 == type) {
                String content = parser.getText();
                this.chatMsg.setContent(content == null ? "" : content.trim());
            }
            if (this.chatMsgs == null) {
                this.chatMsgs = new ArrayList<ChatMsg>();
            }
            this.chatMsgs.add(this.chatMsg);
        } else if ("qaHistoryResponse".equals(nodeName)) {
            this.pageIndex = this.getAttrIntValue(parser, "page");
            this.more = this.getAttrStrBoolValue(parser, "more");
        } else if ("chatlist".equals(nodeName)) {
            this.pageIndex = this.getAttrIntValue(parser, "page");
            this.more = this.getAttrStrBoolValue(parser, "more");
        }
    }

    @Override
    protected void onStartText(XmlPullParser parser) {
        super.onStartText(parser);
    }

    @Override
    protected void onEndTag(String nodeName, XmlPullParser parser) {
    }

    @Override
    protected void onEndDoc(XmlPullParser parser) {
    }

    @Override
    protected void onStartDoc(XmlPullParser parser) {
    }

    @Override
    public <T> T toParse(InputStream inputStream) {
        return null;
    }
}

