/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.parse;

import com.gensee.utils.GenseeLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.ParseException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public abstract class PullBase {
    private static final String TAG = "PullBase";

    protected abstract void onStartTag(String var1, XmlPullParser var2);

    protected abstract void onEndTag(String var1, XmlPullParser var2);

    protected abstract void onEndDoc(XmlPullParser var1);

    protected abstract void onStartDoc(XmlPullParser var1);

    public abstract <T> T toParse(InputStream var1);

    protected XmlPullParser parseXml(String xml) {
        XmlPullParser parser = this.builXmlPullParser(xml);
        if (parser != null) {
            this.parser(parser);
        }
        return parser;
    }

    protected XmlPullParser builXmlPullParser(InputStream inputStream) {
        XmlPullParser parser = null;
        try {
            parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput((Reader)new InputStreamReader(inputStream));
        }
        catch (XmlPullParserException e) {
            GenseeLog.e(TAG, e);
        }
        return parser;
    }

    protected XmlPullParser builXmlPullParser(String xml) {
        XmlPullParser parser = null;
        try {
            parser = XmlPullParserFactory.newInstance().newPullParser();
            parser.setInput((Reader)new StringReader(xml));
        }
        catch (XmlPullParserException e) {
            GenseeLog.e(TAG, e);
        }
        return parser;
    }

    protected void parser(XmlPullParser parser) {
        if (parser != null) {
            int eventType = this.getEventType(parser);
            while (eventType != 1) {
                String nodeName = parser.getName();
                switch (eventType) {
                    case 2: {
                        this.onStartTag(nodeName, parser);
                        break;
                    }
                    case 3: {
                        this.onEndTag(nodeName, parser);
                        break;
                    }
                    case 0: {
                        this.onStartDoc(parser);
                        break;
                    }
                    case 4: {
                        this.onStartText(parser);
                        break;
                    }
                    case 5: {
                        this.onCDATA(parser);
                        break;
                    }
                }
                eventType = this.nextEventType(parser);
            }
            this.onEndDoc(parser);
        }
    }

    protected void onCDATA(XmlPullParser parser) {
    }

    protected void onStartText(XmlPullParser parser) {
    }

    protected int getEventType(XmlPullParser parser) {
        if (parser != null) {
            try {
                return parser.getEventType();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    protected int nextEventType(XmlPullParser parser) {
        if (parser != null) {
            try {
                return parser.next();
            }
            catch (XmlPullParserException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return 1;
    }

    protected String getAttrStrValue(XmlPullParser parser, String name) {
        if (name == null) {
            GenseeLog.e(TAG, "getAttributeValue AttributeName  is null!");
            return null;
        }
        String value = name;
        try {
            value = parser.getAttributeValue(null, name);
        }
        catch (IndexOutOfBoundsException e) {
            GenseeLog.w(TAG, "getAttributeValue IndexOutOfBoundsException  that attr is " + name);
        }
        return value;
    }

    protected int getAttrIntValue(XmlPullParser parser, String name) {
        String str = this.getAttrStrValue(parser, name);
        if (str == null || "".equals(str)) {
            return 0;
        }
        try {
            return Integer.valueOf(str);
        }
        catch (NumberFormatException e) {
            GenseeLog.w(TAG, name + e);
            return 0;
        }
    }

    protected long getAttrLongMcValue(XmlPullParser parser, String name) {
        float f = this.getAttrFloatValue(parser, name);
        return (long)(f * 1000.0f);
    }

    protected long getAttrLongValue(XmlPullParser parser, String name) {
        String str = this.getAttrStrValue(parser, name);
        if (str == null || "".equals(str)) {
            return 0L;
        }
        try {
            return Long.valueOf(str);
        }
        catch (NumberFormatException e) {
            if (str.contains("E") || str.contains("e")) {
                try {
                    Number number = DecimalFormat.getInstance().parse(str);
                    if (number != null) {
                        return number.longValue();
                    }
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
            } else {
                GenseeLog.w(TAG, name + e);
            }
            return 0L;
        }
    }

    protected short getAttrShortValue(XmlPullParser parser, String name) {
        String str = this.getAttrStrValue(parser, name);
        if (str == null || "".equals(str)) {
            return -1;
        }
        try {
            return Short.valueOf(str);
        }
        catch (NumberFormatException e) {
            GenseeLog.w(TAG, name + e);
            return 0;
        }
    }

    protected byte getAttrByteValue(XmlPullParser parser, String name) {
        String str = this.getAttrStrValue(parser, name);
        if (str == null || "".equals(str)) {
            return -1;
        }
        try {
            return Byte.valueOf(str);
        }
        catch (NumberFormatException e) {
            GenseeLog.w(TAG, name + e);
            return 0;
        }
    }

    protected boolean getAttrBitBoolValue(XmlPullParser parser, String name) {
        byte b = this.getAttrByteValue(parser, name);
        return b > 0;
    }

    protected boolean getAttrStrBoolValue(XmlPullParser parser, String name) {
        String str = this.getAttrStrValue(parser, name);
        return "true".equalsIgnoreCase(str);
    }

    protected float getAttrFloatValue(XmlPullParser parser, String name) {
        String str = this.getAttrStrValue(parser, name);
        if (str == null || "".equals(str)) {
            return 0.0f;
        }
        try {
            return Float.valueOf(str).floatValue();
        }
        catch (NumberFormatException e) {
            GenseeLog.w(TAG, name + e);
            return 0.0f;
        }
    }
}

