/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils;

import android.net.Uri;
import com.gensee.common.GenseeConfig;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtil {
    private static final String mHexStr = "0123456789ABCDEF";

    public static boolean isEmpty(String string) {
        return null == string || "".equals(string);
    }

    public static String filtration(String str) {
        String regEx = "[`~!@#$%^&*()+=|{}:;\\\\[\\\\].<>/?~\uff01@#\uffe5%\u2026\u2026&*\uff08\uff09\u2014\u2014+|{}\u3010\u3011\u2018\uff1b\uff1a\u201d\u201c\u2019\u3002\uff0c\u3001\uff1f]";
        return Pattern.compile(regEx).matcher(str).replaceAll("").trim();
    }

    public static boolean isIPCorrect(String ip) {
        Pattern p = Pattern.compile("((?:(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d)\\.){3}(?:25[0-5]|2[0-4]\\d|[01]?\\d?\\d))");
        Matcher m = p.matcher(ip);
        return m.matches();
    }

    public static String str2HexStr(String str) {
        return str == null ? "" : StringUtil.bytesToHexString(str.getBytes());
    }

    public static String bytesToHexString(byte[] src) {
        if (src == null || src.length <= 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static String hexStr2Str(String hexStr) {
        hexStr = hexStr.trim().replace(" ", "").toUpperCase(Locale.US);
        char[] hexs = hexStr.toCharArray();
        byte[] bytes = new byte[hexStr.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            int iTmp = mHexStr.indexOf(hexs[2 * i]) << 4;
            bytes[i] = (byte)((iTmp |= mHexStr.indexOf(hexs[2 * i + 1])) & 0xFF);
        }
        return new String(bytes);
    }

    public static String urlEncode(String source) {
        if (source == null) {
            return "";
        }
        try {
            return URLEncoder.encode(source, "utf-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getHttpAlbAddr(String alb) {
        if (alb != null) {
            String http = "http://";
            if (alb.contains("://")) {
                return http + Uri.parse((String)alb).getHost();
            }
            int index = alb.indexOf(58);
            if (index > 0) {
                alb = alb.substring(0, index);
            }
            alb = http + alb;
        }
        return alb;
    }

    public static String urlRemovePortParam(String sourceUrl) {
        return StringUtil.urlRemovePort(sourceUrl, true);
    }

    public static String urlRemovePort(String sourceUrl, boolean isRemoveParam) {
        if (!StringUtil.isEmpty(sourceUrl)) {
            String param;
            Uri uri = Uri.parse((String)sourceUrl);
            String ret = GenseeConfig.getScheme() + uri.getHost() + uri.getPath();
            if (!isRemoveParam && !StringUtil.isEmpty(param = uri.getQuery())) {
                ret = ret + '?' + param;
            }
            return ret;
        }
        return sourceUrl;
    }

    public static String fixUrlScheme(String sourceUrl) {
        if (!StringUtil.isEmpty(sourceUrl)) {
            Uri uri = Uri.parse((String)sourceUrl);
            String ret = GenseeConfig.getScheme() + uri.getHost() + uri.getPath();
            String param = uri.getQuery();
            if (!StringUtil.isEmpty(param)) {
                ret = ret + '?' + param;
            }
            return ret;
        }
        return sourceUrl;
    }

    public static String fixScheme(String sourceUrl) {
        String sc;
        Uri uri;
        if (!StringUtil.isEmpty(sourceUrl) && (uri = Uri.parse((String)sourceUrl)) != null && (sc = uri.getScheme()) != null) {
            sourceUrl = GenseeConfig.getScheme() + sourceUrl.substring(sc.length() + 3, sourceUrl.length());
        }
        return sourceUrl;
    }
}

