/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.utils.upload;

import android.util.Log;
import android.util.Xml;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.utils.upload.UploadItem;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.xmlpull.v1.XmlSerializer;

public class UpLoadFileUtil {
    private static final int TIME_OUT = 10000;
    private static final String CHARSET = "utf-8";
    private static final String TAG = "UpLoadFile";
    String boundary = UUID.randomUUID().toString();
    String prefix = "--";
    String line_end = "\r\n";
    String content_type = "multipart/form-data";

    private String getStringValue(String name, String value) {
        StringBuffer str = new StringBuffer();
        str.append(this.prefix);
        str.append(this.boundary);
        str.append(this.line_end);
        str.append("Content-Disposition: form-data; name=\"" + name + "\"" + this.line_end);
        str.append(this.line_end);
        str.append(value);
        str.append(this.line_end);
        return str.toString();
    }

    private String getFileValue(String name, String fileName) {
        StringBuffer sFileValue = new StringBuffer();
        sFileValue.append(this.prefix);
        sFileValue.append(this.boundary);
        sFileValue.append(this.line_end);
        sFileValue.append("Content-Disposition: form-data; name=\"" + name + "\"; filename=\"" + fileName + "\"" + this.line_end);
        sFileValue.append("Content-Type: application/octet-stream; charset=utf-8" + this.line_end);
        sFileValue.append(this.line_end);
        return sFileValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String uploadFile(List<UploadItem> itemList, String requestURL) {
        String result;
        block19: {
            requestURL = StringUtil.fixScheme(requestURL);
            result = "";
            try {
                if (null == itemList || itemList.size() <= 0) {
                    return "";
                }
                URL url = new URL(requestURL);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(10000);
                conn.setConnectTimeout(10000);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Charset", CHARSET);
                conn.setRequestProperty("connection", "keep-alive");
                conn.setRequestProperty("Content-Type", this.content_type + ";boundary=" + this.boundary);
                File file = null;
                for (UploadItem uploadItem : itemList) {
                    if (!uploadItem.getType().equals("FILE_TYPE")) continue;
                    file = new File(uploadItem.getValue());
                    break;
                }
                if (file != null && file.exists()) {
                    Log.i((String)TAG, (String)"uploadfile start......");
                    String sTotalString = "";
                    for (UploadItem item : itemList) {
                        if (item.getType().equals("VALUE_TYPE")) {
                            sTotalString = sTotalString + this.getStringValue(item.getName(), item.getValue());
                            continue;
                        }
                        if (!item.getType().equals("FILE_TYPE")) continue;
                        String sName = file.getName();
                        sTotalString = sTotalString + this.getFileValue(item.getName(), sName);
                    }
                    byte[] byArray = (this.prefix + this.boundary + this.prefix + this.line_end).getBytes();
                    long contentLenght = (long)(sTotalString.getBytes().length + byArray.length) + file.length() + (long)this.line_end.getBytes().length;
                    conn.setRequestProperty("Content-Length", contentLenght + "");
                    DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
                    dos.write(sTotalString.toString().getBytes());
                    FileInputStream is = new FileInputStream(file);
                    byte[] bytes = new byte[1024];
                    int len = 0;
                    while ((len = ((InputStream)is).read(bytes)) != -1) {
                        dos.write(bytes, 0, len);
                    }
                    ((InputStream)is).close();
                    dos.write(this.line_end.getBytes());
                    dos.write(byArray);
                    dos.flush();
                    int res = conn.getResponseCode();
                    if (res == 200) {
                        InputStream input = null;
                        BufferedReader in = null;
                        InputStreamReader inputStreamReader = null;
                        try {
                            String line;
                            input = conn.getInputStream();
                            inputStreamReader = new InputStreamReader(input);
                            in = new BufferedReader(inputStreamReader);
                            StringBuffer sb1 = new StringBuffer();
                            while ((line = in.readLine()) != null) {
                                sb1.append(line);
                            }
                            result = sb1.toString();
                        }
                        finally {
                            if (null != in) {
                                in.close();
                            }
                            if (null != inputStreamReader) {
                                inputStreamReader.close();
                            }
                            if (null != input) {
                                input.close();
                            }
                        }
                        GenseeLog.i(TAG, "uploadfile result = " + result);
                        break block19;
                    }
                    GenseeLog.i(TAG, "uploadfile getResponseCode = " + res);
                    break block19;
                }
                GenseeLog.e(TAG, "uploadfile file is not exist! file:" + file + ",upload url:" + requestURL);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                GenseeLog.w(TAG, e);
            }
            catch (IOException e) {
                e.printStackTrace();
                GenseeLog.w(TAG, e);
            }
            catch (Exception e) {
                e.printStackTrace();
                GenseeLog.w(TAG, e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String notifyWeb(String webApiUrl, Map<String, String> propertyList, Map<String, String> textList) {
        String result;
        block11: {
            webApiUrl = StringUtil.fixScheme(webApiUrl);
            result = "";
            String sTotalString = this.writeXmlSerial(propertyList, textList);
            try {
                URL url = new URL(webApiUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setReadTimeout(10000);
                conn.setConnectTimeout(10000);
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Charset", CHARSET);
                conn.setRequestProperty("connection", "keep-alive");
                long contentLenght = sTotalString.getBytes().length;
                conn.setRequestProperty("Content-Length", contentLenght + "");
                DataOutputStream dos = new DataOutputStream(conn.getOutputStream());
                dos.write(sTotalString.toString().getBytes());
                dos.flush();
                int res = conn.getResponseCode();
                if (res == 200) {
                    InputStream input = null;
                    BufferedReader in = null;
                    InputStreamReader inputStreamReader = null;
                    try {
                        String ss;
                        input = conn.getInputStream();
                        inputStreamReader = new InputStreamReader(input);
                        in = new BufferedReader(inputStreamReader);
                        StringBuffer sb1 = new StringBuffer();
                        while ((ss = in.readLine()) != null) {
                            sb1.append(ss);
                        }
                        result = sb1.toString();
                    }
                    finally {
                        if (null != in) {
                            in.close();
                        }
                        if (null != inputStreamReader) {
                            inputStreamReader.close();
                        }
                        if (null != input) {
                            input.close();
                        }
                    }
                    Log.i((String)TAG, (String)("notifyWeb result = " + result));
                    break block11;
                }
                Log.w((String)TAG, (String)("notifyWeb responseCode = " + res));
            }
            catch (Exception e) {
                e.printStackTrace();
                GenseeLog.w(TAG, e);
            }
        }
        return result;
    }

    private String writeXmlSerial(Map<String, String> propertyList, Map<String, String> textList) {
        XmlSerializer serializer = Xml.newSerializer();
        StringWriter writer = new StringWriter();
        try {
            serializer.setOutput((Writer)writer);
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(null, "clientDiagnosis");
            for (Map.Entry<String, String> entry : propertyList.entrySet()) {
                serializer.attribute("", entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : textList.entrySet()) {
                String key = entry.getKey();
                serializer.startTag(null, key);
                if (key.equals("file")) {
                    serializer.attribute("", "type", "log");
                }
                serializer.cdsect(entry.getValue());
                serializer.endTag(null, key);
            }
            serializer.endTag(null, "clientDiagnosis");
            serializer.endDocument();
            return writer.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

