/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.SurfaceTexture;
import android.util.AttributeSet;
import android.view.Surface;
import android.view.TextureView;
import com.gensee.media.ISurfaceHolder;
import com.gensee.media.IVideoIndication;
import com.gensee.media.RenderMode;
import com.gensee.media.ViSoftRender;
import com.gensee.media.VideoData;
import com.gensee.utils.GenseeLog;

public class GSVideoViewEx
extends TextureView
implements IVideoIndication,
TextureView.SurfaceTextureListener,
ISurfaceHolder {
    private static final String TAG = "GSVideoViewEx";
    private ViSoftRender mRender;
    private Surface mSurface;
    private boolean mAttached;
    private boolean isRendering = false;

    public GSVideoViewEx(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public GSVideoViewEx(Context context) {
        this(context, null);
    }

    public GSVideoViewEx(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.setSurfaceTextureListener(this);
        this.mRender = new ViSoftRender(this);
    }

    public byte[] getData() {
        return this.mRender.getData();
    }

    public int getVideoWidth() {
        return this.mRender.getVideoWidth();
    }

    public int getVideoHeight() {
        return this.mRender.getVideoHeight();
    }

    @Override
    public void onReceiveFrame(final byte[] data, final int width, final int height) {
        if (this.mAttached && !this.isRendering) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    GSVideoViewEx.this.isRendering = true;
                    GSVideoViewEx.this.mRender.onReceiveFrame(data, width, height);
                    GSVideoViewEx.this.isRendering = false;
                }
            });
        } else {
            GenseeLog.d(TAG, "onReceiveFrame params3 mAttached = " + this.mAttached + " isRendering = " + this.isRendering);
        }
    }

    @Override
    public void onReceiveFrame(final VideoData data) {
        if (this.mAttached && !this.isRendering) {
            this.post(new Runnable(){

                @Override
                public void run() {
                    GSVideoViewEx.this.isRendering = true;
                    GSVideoViewEx.this.mRender.onReceiveFrame(data);
                    GSVideoViewEx.this.isRendering = false;
                }
            });
        } else {
            GenseeLog.d(TAG, "onReceiveFrame params1 mAttached = " + this.mAttached + " isRendering = " + this.isRendering);
        }
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
        GenseeLog.d(TAG, "onSurfaceTextureAvailable width = " + width + " height = " + height);
        this.mRender.surfaceCreated();
        this.mSurface = new Surface(surface);
        this.mRender.surfaceChanged(width, height);
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
        GenseeLog.d(TAG, "onSurfaceTextureSizeChanged width = " + width + " height = " + height);
        this.mRender.surfaceChanged(width, height);
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
        GenseeLog.d(TAG, "onSurfaceTextureDestroyed ");
        this.mRender.surfaceDestroyed();
        this.mSurface.release();
        this.mSurface = null;
        return true;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surface) {
    }

    public void renderDrawble(Bitmap defBitmap, boolean isFillXY) {
        this.mRender.renderDrawble(defBitmap, isFillXY);
    }

    @Override
    public void renderDefault() {
        this.mRender.renderDefault();
    }

    public void setBackgroundColor(int color) {
        this.setDefColor(color);
    }

    public void setDefColor(int defColor) {
        this.mRender.setDefColor(defColor);
    }

    public RenderMode getRenderMode() {
        return this.mRender.getRenderMode();
    }

    public void setRenderMode(RenderMode renderMode) {
        GenseeLog.d(TAG, "setRenderMode renderMode = " + (Object)((Object)renderMode));
        this.mRender.setRenderMode(renderMode);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttached = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttached = false;
    }
}

