/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter;

import android.graphics.Bitmap;
import com.gensee.beauty.GPUImageRenderer;
import com.gensee.beauty.filter.advanced.GPUBaseGroupFilter;
import com.gensee.beauty.filter.advanced.GPUImageNormalBlendFilter;
import com.gensee.beauty.filter.advanced.MagicBeautyFilter;
import com.gensee.beauty.filter.gpuimage.GPUImageFilter;
import com.gensee.utils.GenseeLog;
import java.util.ArrayList;

public class FilterSetting {
    private Bitmap mBlendSrcBitmap;
    private GPUImageNormalBlendFilter mBlendFilter;
    private GPUImageFilter mFilter;
    private boolean bBeautyOpen = true;
    private GPUImageRenderer mRenderer;
    private int nVideoLogoMarignTop;
    private int nVideoLogoMarginRight;

    public FilterSetting() {
        this.init();
    }

    private ArrayList<GPUImageFilter> init() {
        ArrayList<GPUImageFilter> filters = new ArrayList<GPUImageFilter>();
        filters.add(new MagicBeautyFilter());
        this.mFilter = new GPUBaseGroupFilter(filters);
        return filters;
    }

    public GPUImageFilter getFilter() {
        if (null == this.mFilter) {
            this.mFilter = new GPUImageFilter();
        }
        return this.mFilter;
    }

    public void setVideoDataPng(Bitmap mBitmap) {
        this.mBlendSrcBitmap = mBitmap;
    }

    public void setVideoDataPng(Bitmap mBitmap, int nVideoLogoMarginTop, int nVideoLogoMarginRight) {
        this.nVideoLogoMarginRight = nVideoLogoMarginRight;
        this.nVideoLogoMarignTop = nVideoLogoMarginTop;
        this.mBlendSrcBitmap = mBitmap;
        if (null != this.mBlendFilter) {
            this.mBlendFilter.setMarginTopAndRight(this.nVideoLogoMarignTop, nVideoLogoMarginRight);
        }
    }

    public void resolveVideoDataPng(int nWidth, int nHeight) {
        if (null != this.mBlendSrcBitmap && nWidth > 0 && nHeight > 0) {
            this.mBlendFilter = new GPUImageNormalBlendFilter();
            this.mBlendFilter.setBitmap(this.mBlendSrcBitmap);
            this.mBlendFilter.setMarginTopAndRight(this.nVideoLogoMarignTop, this.nVideoLogoMarginRight);
            ArrayList<GPUImageFilter> filters = this.init();
            if (!filters.contains(this.mBlendFilter)) {
                filters.add(this.mBlendFilter);
            }
            this.mRenderer.setFilter(this.mFilter);
        }
    }

    public void switchBeauty(boolean bOpen) {
        if (!bOpen) {
            if (null != this.mBlendSrcBitmap) {
                this.mBlendFilter = new GPUImageNormalBlendFilter();
                this.mBlendFilter.setBitmap(this.mBlendSrcBitmap);
                this.mBlendFilter.setMarginTopAndRight(this.nVideoLogoMarignTop, this.nVideoLogoMarginRight);
                this.mRenderer.setFilter(this.mBlendFilter);
            } else {
                this.mRenderer.setFilter(new GPUImageFilter());
            }
        } else {
            ArrayList<GPUImageFilter> filters = this.init();
            if (null != this.mBlendSrcBitmap) {
                this.mBlendFilter = new GPUImageNormalBlendFilter();
                this.mBlendFilter.setBitmap(this.mBlendSrcBitmap);
                this.mBlendFilter.setMarginTopAndRight(this.nVideoLogoMarignTop, this.nVideoLogoMarginRight);
                if (!filters.contains(this.mBlendFilter)) {
                    filters.add(this.mBlendFilter);
                }
            } else if (filters.contains(this.mBlendFilter)) {
                filters.remove(this.mBlendFilter);
            }
            this.mRenderer.setFilter(this.mFilter);
        }
        this.bBeautyOpen = bOpen;
    }

    public void release() {
        GenseeLog.i((String)"GPUImageRenderer release1");
        if (null != this.mBlendSrcBitmap) {
            this.mBlendSrcBitmap.recycle();
            this.mBlendSrcBitmap = null;
        }
    }

    public void setRenderer(GPUImageRenderer mRenderer) {
        this.mRenderer = mRenderer;
    }
}

