/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter.advanced;

import android.opengl.GLES20;
import com.gensee.beauty.filter.gpuimage.GPUImageFilter;

public class GPUImageGammaFilter
extends GPUImageFilter {
    public static final String GAMMA_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n \n uniform sampler2D inputImageTexture;\n uniform lowp float gamma;\n \n void main()\n {\n     lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n     \n     gl_FragColor = vec4(pow(textureColor.rgb, vec3(gamma)), textureColor.w);\n }";
    private int mGammaLocation;
    private float mGamma;

    public GPUImageGammaFilter() {
        this(0.7f);
    }

    public GPUImageGammaFilter(float gamma) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", GAMMA_FRAGMENT_SHADER);
        this.mGamma = gamma;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mGammaLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"gamma");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setGamma(this.mGamma);
    }

    public void setGamma(float gamma) {
        this.mGamma = gamma;
        this.setFloat(this.mGammaLocation, this.mGamma);
    }
}

