/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter.advanced;

import android.opengl.GLES20;
import com.gensee.beauty.filter.advanced.GPUImageTwoInputFilter;

public class GPUImageNormalBlendFilter
extends GPUImageTwoInputFilter {
    private int inputWHRatio;
    private int inputMarginTop;
    private int inputMarginRight;
    private static final String NORMAL_BLEND_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nattribute vec4 inputTextureCoordinate2;\n \nvarying vec2 textureCoordinate;\nvarying vec2 textureCoordinate2;\nvarying vec2 varyPosition;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n    textureCoordinate2 = inputTextureCoordinate2.xy;\n    varyPosition = position.xy;\n}";
    public static final String NORMAL_BLEND_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n varying highp vec2 textureCoordinate2;\nvarying highp vec2 varyPosition;\nuniform lowp float inputWHRatio;\nuniform lowp float inputMarginTop;\nuniform lowp float inputMarginRight;\n \n uniform sampler2D inputImageTexture;\n uniform sampler2D inputImageTexture2;\nconst lowp float X_VALUE = 0.6;\nconst lowp float wh = 2.0;\n \n void main()\n {\n     lowp float xvalue = X_VALUE -  inputMarginRight;\n     lowp float hValue = (1.0 - ((1.0 - X_VALUE) / wh) * inputWHRatio) - inputMarginTop;\n     if(varyPosition.x >= xvalue  &&  varyPosition.x  <= 1.0 - inputMarginRight&& \n         varyPosition.y >=  hValue  && varyPosition.y <= 1.0 - inputMarginTop){\n         lowp vec4 c2 = texture2D(inputImageTexture, textureCoordinate);\n         lowp float x1 = (varyPosition.x - xvalue) / (1.0 - xvalue - inputMarginRight);\n         lowp float y1 = 1.0 - ((varyPosition.y - hValue) / (1.0 - hValue - inputMarginTop));\n         lowp vec4 c1 = texture2D(inputImageTexture2, vec2(x1,y1));\n         \n         lowp vec4 outputColor;\n         \n         outputColor.r = c1.r + c2.r * c2.a * (1.0 - c1.a);\n        \n         outputColor.g = c1.g + c2.g * c2.a * (1.0 - c1.a);\n         \n         outputColor.b = c1.b + c2.b * c2.a * (1.0 - c1.a);\n         \n         outputColor.a = c1.a + c2.a * (1.0 - c1.a);\n         \n         gl_FragColor = outputColor;\n     }\n    else{\n        gl_FragColor = texture2D(inputImageTexture, textureCoordinate);\n    }\n }";

    public GPUImageNormalBlendFilter() {
        super(NORMAL_BLEND_VERTEX_SHADER, NORMAL_BLEND_FRAGMENT_SHADER);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.inputWHRatio = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputWHRatio");
        this.inputMarginRight = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputMarginRight");
        this.inputMarginTop = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"inputMarginTop");
    }

    @Override
    protected void onDrawArraysPre() {
        super.onDrawArraysPre();
    }

    @Override
    public void onDisplaySizeChanged(int width, int height) {
        super.onDisplaySizeChanged(width, height);
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1f((int)GPUImageNormalBlendFilter.this.inputWHRatio, (float)((float)GPUImageNormalBlendFilter.this.mOutputWidth / (float)GPUImageNormalBlendFilter.this.mOutputHeight));
            }
        });
    }

    public void setMarginTopAndRight(final int marginTop, final int marginRight) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glUniform1f((int)GPUImageNormalBlendFilter.this.inputMarginTop, (float)((float)marginTop / (float)GPUImageNormalBlendFilter.this.mOutputHeight * 2.0f));
                GLES20.glUniform1f((int)GPUImageNormalBlendFilter.this.inputMarginRight, (float)((float)marginRight / (float)GPUImageNormalBlendFilter.this.mOutputWidth * 2.0f));
            }
        });
    }
}

