/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.beauty.filter.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Calendar;

public class FileUtils {
    public static String saveBitmap(Bitmap bitmap) {
        File file;
        File fileRoot = new File(Environment.getExternalStorageDirectory().getAbsolutePath() + "/beauty2/");
        if (!fileRoot.exists()) {
            fileRoot.mkdirs();
        }
        if ((file = new File(fileRoot.getPath(), Calendar.getInstance().getTimeInMillis() + ".png")).exists()) {
            file.delete();
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            out.flush();
            out.close();
            bitmap.recycle();
            return file.toString();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String readAssetsTextFile(Context context, String filePath) {
        InputStream inputStream = null;
        try {
            inputStream = context.getResources().getAssets().open(filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FileUtils.getStringFromStream(inputStream);
    }

    private static String getStringFromStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            StringBuilder stringBuilder = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line).append("\n");
            }
            reader.close();
            return stringBuilder.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

