/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.hardware.Camera;
import com.gensee.common.GenseeConfig;
import com.gensee.utils.GenseeLog;
import com.gensee.view.VideoCapture;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class VideoCameraCapture
extends VideoCapture
implements Camera.PreviewCallback {
    protected static final String TAG = "VideoCameraCapture";
    protected Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
    private List<Camera.Area> mFocusArea;
    private List<Camera.Area> mMeteringArea;
    private boolean mFocusAreaSupported;
    private boolean mMeteringAreaSupported;
    protected Camera mCamera = null;
    private long nStartTime = Calendar.getInstance().getTimeInMillis();
    private int frameCount = 0;
    private int nBaseFrate = 15000;
    private final AutoFocusCallback mAutoFocusCallback = new AutoFocusCallback();

    public void onPreviewFrame(byte[] data, Camera camera) {
        ++this.frameCount;
        long nEndTime = Calendar.getInstance().getTimeInMillis();
        if (nEndTime - this.nStartTime >= 1000L) {
            this.nStartTime = nEndTime;
            GenseeLog.i((String)TAG, (String)("frameCount = " + this.frameCount));
            this.frameCount = 0;
        }
        if (!this.configer.isOnlyPreview()) {
            this.addData(data, this.mWidth, this.mHeight);
        }
    }

    @Override
    public void doCameraSwitch() {
        if (!this.mBeginPreviewRunning) {
            GenseeLog.w((String)"this divice didn't open camera");
            return;
        }
        int num = Camera.getNumberOfCameras();
        if (num < 2) {
            GenseeLog.w((String)"this divice can't switch camera");
            return;
        }
        this.releaseCamera();
        int index = (this.cameraIndex + 1) % num;
        Camera.getCameraInfo((int)index, (Camera.CameraInfo)this.cameraInfo);
        this.mCamera = this.openCamera(index);
        if (null != this.mCamera && !this.checkPermission(this.mCamera)) {
            if (null != this.onCameraPermissionListener && this.mCamera == null && this.isHolderCreated()) {
                this.onCameraPermissionListener.onCameraPermission();
            }
            return;
        }
        this.cameraIndex = index;
        if (null != this.mCamera && !this.startPreview(this.mWidth, this.mHeight)) {
            return;
        }
        if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
        }
    }

    private boolean checkPermission(Camera camera) {
        if (camera != null) {
            try {
                Field field = Camera.class.getDeclaredField("mNativeContext");
                field.setAccessible(true);
                Object object = field.get(camera);
                if (object instanceof Integer) {
                    return (Integer)object != 0;
                }
                if (object instanceof Long) {
                    return (Long)object != 0L;
                }
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public Camera getCamera() {
        return this.mCamera;
    }

    @Override
    public void setOrientation(int ortation) {
        GenseeLog.d((String)TAG, (String)("setOrientation ortation = " + ortation));
        int old = this.orientation;
        super.setOrientation(ortation);
        if (old != this.orientation && this.mPreviewRunning && this.mCamera != null) {
            this.caculateRotate();
            this.notifyPreviewSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void caculateRotate() {
        int rotation = 0;
        Object object = this.cameraLock;
        synchronized (object) {
            rotation = this.setDisplayRotation(this.mCamera, this.cameraInfo);
        }
        switch (this.orientation) {
            case 1: {
                this.videoParam.rotate = 1 == this.cameraInfo.facing ? rotation : (rotation + 180) % 360;
                break;
            }
            case 10: {
                this.videoParam.rotate = (1 == this.cameraInfo.facing ? rotation : (rotation + 180) % 360) + 1;
                break;
            }
            case 11: 
            case 13: {
                this.videoParam.rotate = (1 == this.cameraInfo.facing ? rotation : (rotation + 180) % 360) + 2;
                break;
            }
            case 2: {
                this.videoParam.rotate = rotation;
                break;
            }
            case 12: {
                this.videoParam.rotate = rotation + 1;
                break;
            }
        }
        GenseeLog.d((String)TAG, (String)("caculateRotate rotation = " + rotation + this.videoParam.toString() + "face = " + this.cameraInfo.facing));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Camera openCamera(int index) {
        Camera tmp = null;
        Object object = this.cameraLock;
        synchronized (object) {
            try {
                GenseeLog.i((String)("videocapture openCamera index = " + index));
                tmp = Camera.open((int)index);
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                GenseeLog.w((String)TAG, (String)("openCamera " + e.toString()));
            }
            GenseeLog.i((String)("videocapture openCamera isHardEncode = " + this.isHardEncoded + " index = " + index + " camera = " + (null == tmp ? "null" : tmp.toString())));
            if (null != this.onCameraInfoListener) {
                this.onCameraInfoListener.onCameraInfo(tmp, this.cameraInfo, index);
                this.onCameraInfoListener.onCameraOpen(null != tmp);
            }
            return tmp;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void rePreView() {
        if (this.mPreviewRunning && this.mCamera != null) {
            Object object = this.cameraLock;
            synchronized (object) {
                this.mCamera.setPreviewCallback(null);
                this.mCamera.stopPreview();
            }
        }
        this.startPreview(this.mWidth, this.mHeight);
    }

    private boolean startPreview(int width, int height) {
        if (this.isHolderCreated() && this.mCamera != null) {
            try {
                List focusModes;
                List sceneModes;
                List flashModes;
                Camera.Parameters p = this.mCamera.getParameters();
                List ss = p.getSupportedPreviewSizes();
                if (ss != null) {
                    for (Camera.Size s : ss) {
                        GenseeLog.d((String)TAG, (String)("Supported w = " + s.width + " h = " + s.height));
                    }
                }
                Camera.Size optimalSize = VideoCameraCapture.getOptimalPreviewSize(ss, width, height);
                this.mWidth = optimalSize.width;
                this.mHeight = optimalSize.height;
                p.setPreviewSize(optimalSize.width, optimalSize.height);
                this.notifyPreviewSize();
                p.setPreviewFormat(GenseeConfig.isTV ? 17 : 842094169);
                GenseeLog.d((String)TAG, (String)("startPreview optimalSize w =  " + optimalSize.width + " h = " + optimalSize.height));
                List modes = p.getSupportedSceneModes();
                if (null != modes && modes.contains("auto")) {
                    p.setWhiteBalance("auto");
                }
                if (null != (flashModes = p.getSupportedFlashModes()) && flashModes.contains("auto")) {
                    p.setFlashMode("auto");
                }
                if (null != (sceneModes = p.getSupportedSceneModes()) && sceneModes.contains("auto")) {
                    p.setSceneMode("auto");
                }
                if (null != (focusModes = p.getSupportedFocusModes()) && focusModes.contains("auto")) {
                    p.setFocusMode("auto");
                }
                List fpsRange = p.getSupportedPreviewFpsRange();
                int fpsMin = 0;
                int fpsMax = 0;
                if (null != fpsRange && fpsRange.size() > 0) {
                    for (int i = 0; i < fpsRange.size(); ++i) {
                        int[] fps = (int[])fpsRange.get(i);
                        if (this.nBaseFrate < fps[0] || this.nBaseFrate > fps[1]) continue;
                        if (fpsMin <= 0 || fpsMax <= 0) {
                            fpsMin = fps[0];
                            fpsMax = fps[1];
                            continue;
                        }
                        if (fps[1] > fpsMax) continue;
                        if (fps[1] == fpsMax) {
                            if (Math.abs(fps[0] - this.nBaseFrate) >= Math.abs(fpsMin - this.nBaseFrate)) continue;
                            fpsMin = fps[0];
                            fpsMax = fps[1];
                            continue;
                        }
                        fpsMin = fps[0];
                        fpsMax = fps[1];
                    }
                }
                if (fpsMin > 0 && fpsMax > 0) {
                    p.setPreviewFpsRange(fpsMin, fpsMax);
                    GenseeLog.i((String)TAG, (String)("camera fps fpsMin = " + fpsMin + " fpsMax = " + fpsMax));
                }
                this.mCamera.setParameters(p);
                this.caculateRotate();
                this.toStartPreview(this.mCamera, this.cameraIndex);
                this.mPreviewRunning = true;
                this.startSendThread();
                return true;
            }
            catch (Exception ex) {
                this.releaseCamera();
                GenseeLog.e((String)TAG, (String)"openCamera fail");
                GenseeLog.e((String)TAG, (Throwable)ex);
            }
        }
        return false;
    }

    protected void toStartPreview(Camera mCamera, int cameraId) throws Exception {
        mCamera.setPreviewCallback((Camera.PreviewCallback)this);
        this.setPreviewHolder(mCamera);
        mCamera.startPreview();
    }

    @Override
    protected boolean doCameraOpen() {
        if (null != this.mCamera) {
            this.caculateRotate();
            return true;
        }
        if (!this.initCamera() || !this.checkPermission(this.mCamera)) {
            if (null != this.onCameraPermissionListener && this.mCamera == null && this.isHolderCreated()) {
                this.onCameraPermissionListener.onCameraPermission();
            }
            return false;
        }
        return this.startPreview(this.mWidth, this.mHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean releaseCamera() {
        Object object = this.cameraLock;
        synchronized (object) {
            this.releaseSendThread();
            if (this.mCamera != null) {
                GenseeLog.i((String)"videocapture releaseCamera camera not null");
                if (this.mPreviewRunning) {
                    this.mCamera.setPreviewCallback(null);
                    this.mCamera.stopPreview();
                }
                this.mCamera.release();
            } else {
                GenseeLog.i((String)"videocapture releaseCamera camera null");
            }
            this.mCamera = null;
        }
        return true;
    }

    protected boolean initCamera() {
        GenseeLog.i((String)("videocapture isHolderCreated = " + this.isHolderCreated()));
        if (this.isHolderCreated()) {
            if (this.cameraIndex != -1) {
                Camera.getCameraInfo((int)this.cameraIndex, (Camera.CameraInfo)this.cameraInfo);
                this.mCamera = this.openCamera(this.cameraIndex);
            } else {
                int index;
                int cameraNum = Camera.getNumberOfCameras();
                if (cameraNum == 1) {
                    Camera.getCameraInfo((int)index, (Camera.CameraInfo)this.cameraInfo);
                    this.mCamera = this.openCamera(index);
                } else {
                    for (index = 0; index < cameraNum; ++index) {
                        Camera.getCameraInfo((int)index, (Camera.CameraInfo)this.cameraInfo);
                        if (1 != this.cameraInfo.facing) continue;
                        this.mCamera = this.openCamera(index);
                        if (this.mCamera == null) continue;
                        this.cameraIndex = index;
                        break;
                    }
                }
            }
        }
        GenseeLog.d((String)TAG, (String)("initCamera mCamera = " + this.mCamera));
        return this.mCamera != null;
    }

    protected boolean setPreviewHolder(Camera camera) throws IOException {
        return this.captureCallBack != null && this.captureCallBack.onSetPreviewHolder(camera);
    }

    private int setDisplayRotation(Camera camera, Camera.CameraInfo cameraInfo) {
        Context context = this.captureCallBack.getContext();
        int result = 0;
        if (context instanceof Activity) {
            result = VideoCameraCapture.getCameraDisplayOrientation((Activity)context, cameraInfo);
        } else {
            int n = result = 2 == this.orientation ? 0 : 90;
        }
        if (camera != null) {
            camera.setDisplayOrientation(result);
        }
        return result;
    }

    @Override
    public boolean isCameraSwitchEnable() {
        return Camera.getNumberOfCameras() > 1;
    }

    public static Camera.Size getOptimalPreviewSize(List<Camera.Size> sizes, int w, int h) {
        if (sizes == null) {
            return null;
        }
        double ASPECT_TOLERANCE = 0.05;
        double targetRatio = (double)w / (double)h;
        Camera.Size optimalSize = null;
        double minDiff = Double.MAX_VALUE;
        for (Camera.Size size : sizes) {
            double ratio;
            if (size.width < w || size.height < h || Math.abs((ratio = (double)size.width / (double)size.height) - targetRatio) > 0.05 || !((double)Math.abs(size.height - h) < minDiff)) continue;
            optimalSize = size;
            minDiff = Math.abs(size.height - h);
        }
        if (optimalSize == null) {
            minDiff = Double.MAX_VALUE;
            for (Camera.Size size : sizes) {
                if (!((double)Math.abs(size.height - h) < minDiff)) continue;
                optimalSize = size;
                minDiff = Math.abs(size.height - h);
            }
        }
        return optimalSize;
    }

    public static int getCameraDisplayOrientation(Activity activity, Camera.CameraInfo info) {
        int result;
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        int degrees = 0;
        switch (rotation) {
            case 0: {
                degrees = 0;
                break;
            }
            case 1: {
                degrees = 90;
                break;
            }
            case 2: {
                degrees = 180;
                break;
            }
            case 3: {
                degrees = 270;
            }
        }
        if (info.facing == 1) {
            result = (info.orientation + degrees) % 360;
            result = (360 - result) % 360;
        } else {
            result = (info.orientation - degrees + 360) % 360;
        }
        return result;
    }

    public boolean isSupportFlashOnOrOff() {
        if (null == this.mCamera) {
            return false;
        }
        Camera.Parameters parameters = null;
        try {
            parameters = this.mCamera.getParameters();
        }
        catch (Exception e) {
            this.mCamera = null;
        }
        if (parameters == null) {
            return false;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes == null) {
            return false;
        }
        return flashModes.contains("torch");
    }

    public void switchFlashOnOrOff(boolean bOpen) {
        if (this.mCamera == null) {
            return;
        }
        Camera.Parameters parameters = this.mCamera.getParameters();
        if (parameters == null) {
            return;
        }
        List flashModes = parameters.getSupportedFlashModes();
        if (flashModes == null) {
            return;
        }
        String flashMode = parameters.getFlashMode();
        if (bOpen) {
            if (!"torch".equals(flashMode) && flashModes.contains("torch")) {
                parameters.setFlashMode("torch");
                this.mCamera.setParameters(parameters);
            }
        } else if (!"off".equals(flashMode) && flashModes.contains("off")) {
            parameters.setFlashMode("off");
            this.mCamera.setParameters(parameters);
        }
    }

    public void focusOnTouch(double x1, double y1, int focusWidth, int focusHeight, int viewWidth, int viewHeight) {
        Camera.Parameters mInitialParams = this.mCamera.getParameters();
        this.mFocusAreaSupported = mInitialParams.getMaxNumFocusAreas() > 0 && VideoCameraCapture.isSupported("auto", mInitialParams.getSupportedFocusModes());
        this.mMeteringAreaSupported = mInitialParams.getMaxNumMeteringAreas() > 0;
        int x = (int)Math.round(x1);
        int y = (int)Math.round(y1);
        if (this.mFocusArea == null) {
            this.mFocusArea = new ArrayList<Camera.Area>();
            this.mFocusArea.add(new Camera.Area(new Rect(), 1));
            this.mMeteringArea = new ArrayList<Camera.Area>();
            this.mMeteringArea.add(new Camera.Area(new Rect(), 1));
        }
        Rect focusRect = VideoCameraCapture.calculateTapArea(x, y, 1.0f, viewWidth, viewHeight, focusWidth);
        Rect meteringRect = VideoCameraCapture.calculateTapArea(x, y, 1.5f, viewWidth, viewHeight, focusHeight);
        this.mFocusArea.clear();
        this.mFocusArea.add(new Camera.Area(focusRect, 1000));
        this.mMeteringArea.clear();
        this.mMeteringArea.add(new Camera.Area(meteringRect, 1000));
        try {
            this.setFocusParameters();
            this.mCamera.autoFocus((Camera.AutoFocusCallback)this.mAutoFocusCallback);
        }
        catch (Exception e) {
            GenseeLog.e((String)TAG, (String)("autoFocus exception e.msg = " + e.getMessage()));
        }
    }

    private static boolean isSupported(String value, List<String> supported) {
        return supported != null && supported.indexOf(value) >= 0;
    }

    private static Rect calculateTapArea(float x, float y, float coefficient, int previewWidth, int preiveHeight, int focusAreaSize) {
        GenseeLog.e((String)TAG, (String)("focus position : " + x + " : " + y));
        int areaSize = Float.valueOf((float)focusAreaSize * coefficient).intValue();
        int left = VideoCameraCapture.clamp(Float.valueOf(y / (float)preiveHeight * 2000.0f - 1000.0f).intValue(), areaSize);
        int top = VideoCameraCapture.clamp(Float.valueOf(((float)previewWidth - x) / (float)previewWidth * 2000.0f - 1000.0f).intValue(), areaSize);
        GenseeLog.d((String)TAG, (String)("previewArea:" + left + "  " + top + " " + (left + areaSize) + " " + (top + areaSize)));
        return new Rect(left, top, left + areaSize, top + areaSize);
    }

    private static int clamp(int touchCoordinateInCameraReper, int focusAreaSize) {
        int result = Math.abs(touchCoordinateInCameraReper) + focusAreaSize > 1000 ? (touchCoordinateInCameraReper > 0 ? 1000 - focusAreaSize : -1000 + focusAreaSize) : touchCoordinateInCameraReper - focusAreaSize / 2;
        return result;
    }

    private void setFocusParameters() throws Exception {
        Camera.Parameters mParameters = this.mCamera.getParameters();
        mParameters.setFlashMode("off");
        if (this.mFocusAreaSupported) {
            mParameters.setFocusAreas(this.mFocusArea);
        }
        if (this.mMeteringAreaSupported) {
            mParameters.setMeteringAreas(this.mMeteringArea);
        }
        this.mCamera.setParameters(mParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSupportFocusAuto() {
        Object object = this.cameraLock;
        synchronized (object) {
            if (null != this.mCamera) {
                Camera.Parameters parameters = this.mCamera.getParameters();
                List lists = parameters.getSupportedFocusModes();
                return VideoCameraCapture.isSupported("auto", lists);
            }
            return false;
        }
    }

    private final class AutoFocusCallback
    implements Camera.AutoFocusCallback {
        private AutoFocusCallback() {
        }

        public void onAutoFocus(boolean focused, Camera camera) {
            if (null != VideoCameraCapture.this.onCameraInfoListener) {
                VideoCameraCapture.this.onCameraInfoListener.onManualFocus(focused);
            }
            camera.cancelAutoFocus();
        }
    }
}

