/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.view;

import android.app.Activity;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.util.Log;
import com.gensee.common.RTSharedPref;
import com.gensee.convert.VideoCoreLibrary;
import com.gensee.media.ColorFormatConversion;
import com.gensee.media.MediaConfiger;
import com.gensee.utils.GenseeLog;
import com.gensee.videoparam.IVideoCoreInterface;
import com.gensee.videoparam.OnVideoHardEncodeDataCallback;
import com.gensee.videoparam.VideoParam;
import com.gensee.view.ILocalVideoView;
import com.gensee.view.VideoHardEncoded;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class VideoCapture
implements ILocalVideoView,
Runnable {
    protected static final String TAG = "VideoCapture";
    protected Object cameraLock = new Object();
    protected int orientation = 2;
    protected VideoParam videoParam;
    protected boolean mPreviewRunning = false;
    protected boolean mBeginPreviewRunning = false;
    protected int mWidth = 0;
    protected int mHeight = 0;
    protected int cameraIndex = -1;
    protected int mFps;
    protected int mBitRate;
    protected VideoHardEncoded mVideoHardEncoded;
    private OnVideoHardEncodeDataCallback dataCallback;
    protected boolean isHardEncoded = false;
    private ColorFormatConversion conversion;
    protected MediaConfiger configer = MediaConfiger.getConfiger();
    protected IVideoCoreInterface iVideoCoreInterface;
    protected ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener;
    protected ILocalVideoView.OnCameraInfoListener onCameraInfoListener;
    protected OnCaptureCallBack captureCallBack;
    protected VideoParam mSendVideoParam;
    private Object object = new Object();
    private Thread sendThread;
    private boolean bSendFlag = true;
    private List<VideoData> dataList = new ArrayList<VideoData>();
    private List<byte[]> recoverDataList = new ArrayList<byte[]>();

    public void setVideoCoreInterface(IVideoCoreInterface iVideoCoreInterface) {
        this.iVideoCoreInterface = iVideoCoreInterface;
    }

    public VideoCapture() {
        this.conversion = ColorFormatConversion.createConversion();
    }

    public void setHardEncode(boolean isHardEncode) {
        GenseeLog.d((String)TAG, (String)("setHardEncode isHardEncode " + isHardEncode));
        if (isHardEncode) {
            if (this.isPreviewing()) {
                this.initHardEncoder();
            }
        } else if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.release();
            this.mVideoHardEncoded = null;
        }
        this.isHardEncoded = isHardEncode;
    }

    public boolean isVideoHardEncode() {
        return this.isHardEncoded;
    }

    public void setVideoSize(int width, int height) {
        this.mHeight = height;
        this.mWidth = width;
    }

    public void setVideoSize(Context c, int width, int height) {
        GenseeLog.d((String)TAG, (String)("setVideoSize width = " + width + " height = " + height));
        if (null != this.iVideoCoreInterface) {
            this.iVideoCoreInterface.setVideoSize(c, width, height);
        }
        this.setVideoSize(width, height);
    }

    protected void caculateRotate() {
    }

    public boolean isCameraSwitchEnable() {
        return false;
    }

    public void doCameraSwitch() {
    }

    public int getOrientation() {
        return this.orientation;
    }

    public Camera getCamera() {
        return null;
    }

    public void setVideoParam(VideoParam param) {
        this.videoParam = param;
        int width = param.width;
        int height = param.height;
        if (null != RTSharedPref.getIns()) {
            width = RTSharedPref.getIns().getInt("save.video.width", 320);
            height = RTSharedPref.getIns().getInt("save.video.height", 240);
        }
        GenseeLog.d((String)TAG, (String)("setVideoParam param.width = " + param.width + " param.height = " + param.height + " width = " + width + " height = " + height));
        this.setVideoSize(width, height);
        if (this.iVideoCoreInterface != null) {
            this.cameraIndex = this.iVideoCoreInterface.getCameraId();
            if (this.cameraIndex == -1) {
                this.cameraIndex = this.videoParam.cameraIndex;
                this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
            }
        } else {
            this.cameraIndex = this.videoParam.cameraIndex;
        }
    }

    public void surfaceAvailable() {
        if (this.isBeginingPreviewing() || this.isPreviewing()) {
            this.cameraOpen();
        }
    }

    public boolean close() {
        this.mBeginPreviewRunning = false;
        GenseeLog.i((String)"videocapture close start");
        if (this.isHardEncoded && null != this.mVideoHardEncoded) {
            this.mVideoHardEncoded.release();
            this.mVideoHardEncoded = null;
        }
        if (null != RTSharedPref.getIns() && RTSharedPref.getIns().getInt("KEY_JOIN_STATUS", 0) == 1) {
            this.cameraIndex = -1;
            if (null != this.iVideoCoreInterface) {
                this.iVideoCoreInterface.saveCameraId(this.cameraIndex);
            }
        } else {
            GenseeLog.w((String)TAG, (String)"no switch camera index, RTSharePref getIns is null");
        }
        return this.doCameraClose();
    }

    private boolean doCameraClose() {
        boolean rel = this.closeCamera();
        return rel;
    }

    private boolean closeCamera() {
        boolean rel = this.releaseCamera();
        this.mPreviewRunning = false;
        return rel;
    }

    public boolean releaseCamera() {
        return false;
    }

    public boolean open(Object param, IVideoCoreInterface iVideoCoreInterface) {
        this.iVideoCoreInterface = iVideoCoreInterface;
        if (param instanceof VideoParam) {
            GenseeLog.i((String)"videocapture open start");
            this.setVideoParam((VideoParam)param);
            this.mBeginPreviewRunning = true;
            return true;
        }
        return false;
    }

    public boolean cameraOpen() {
        GenseeLog.d((String)("videocapture cameraOpen start isHardEncoded = " + this.isHardEncoded + " mWidth = " + this.mWidth + " mHeight = " + this.mHeight));
        if (this.isHardEncoded) {
            if (null != this.mVideoHardEncoded) {
                GenseeLog.d((String)"videocapture forceKeyFrame");
                this.mVideoHardEncoded.forceKeyFrame();
            } else {
                this.initHardEncoder();
            }
        } else if (null != this.mVideoHardEncoded) {
            this.mVideoHardEncoded.release();
            this.mVideoHardEncoded = null;
        }
        return this.doCameraOpen();
    }

    private void initHardEncoder() {
        if (null == this.mVideoHardEncoded) {
            this.mVideoHardEncoded = new VideoHardEncoded(this.mWidth, this.mHeight, this.iVideoCoreInterface);
            this.mVideoHardEncoded.setVideoCore(this.iVideoCoreInterface);
            this.mVideoHardEncoded.setHardEncodeDataCallback(this.dataCallback);
            this.mVideoHardEncoded.setBitRate(this.mBitRate);
            this.mVideoHardEncoded.setFps(this.mFps);
            this.mVideoHardEncoded.start();
        }
    }

    public boolean isPreviewing() {
        return this.mPreviewRunning;
    }

    protected boolean isBeginingPreviewing() {
        return this.mBeginPreviewRunning;
    }

    public void setOnCaptureCallBack(OnCaptureCallBack captureCallBack) {
        this.captureCallBack = captureCallBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.bSendFlag) {
            VideoData data = this.sendData();
            if (null == data || !data.isValidData()) continue;
            this.sendValidData(data);
            Object object = this.object;
            synchronized (object) {
                this.recoverDataList.add(data.getData());
                if (this.recoverDataList.size() > 5) {
                    GenseeLog.d((String)TAG, (String)("recoverDataList length = " + this.recoverDataList.size()));
                }
            }
        }
    }

    protected void sendValidData(VideoData data) {
        this.videoParam.fmt = 16;
        if (this.isHardEncoded) {
            VideoCoreLibrary.OnRotationCropData(data.getData(), this.videoParam.width, this.videoParam.height, this.videoParam.fmt, this.videoParam.rotate, this, this.mWidth, this.mHeight);
        } else {
            byte[] viData = this.conversion.convert(data.getData(), data.width, data.height);
            VideoCoreLibrary.OnRotationCropData(viData, this.videoParam.width, this.videoParam.height, this.videoParam.fmt, this.videoParam.rotate, this, this.mWidth, this.mHeight);
        }
    }

    protected void onSinkCropRotationData(byte[] data, int width, int height, int fmt, int rotate) {
        if (this.isHardEncoded) {
            if (null != this.mVideoHardEncoded) {
                this.mVideoHardEncoded.sendEncodeFrame(data, width, height, 0);
            }
        } else if (null != this.iVideoCoreInterface && data != null) {
            if (null == this.mSendVideoParam) {
                this.mSendVideoParam = new VideoParam();
            }
            this.mSendVideoParam.width = width;
            this.mSendVideoParam.height = height;
            this.mSendVideoParam.bitCount = this.videoParam.bitCount;
            this.mSendVideoParam.fmt = this.videoParam.fmt;
            this.iVideoCoreInterface.sendVideoData(data, this.mSendVideoParam);
        }
    }

    protected void addData(byte[] data, int width, int height) {
        byte[] saveData = null;
        if (this.recoverDataList.size() > 0) {
            saveData = this.recoverDataList.remove(0);
        }
        if (null == saveData || saveData.length != data.length) {
            saveData = new byte[data.length];
        }
        System.arraycopy(data, 0, saveData, 0, data.length);
        this.addData(new VideoData(saveData, width, height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addData(VideoData data) {
        if (null != data) {
            Object object = this.object;
            synchronized (object) {
                if (this.dataList.size() >= 2) {
                    GenseeLog.d((String)("videocapture sendData listSize = " + this.dataList.size()));
                    return;
                }
                this.dataList.add(data);
                this.object.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private VideoData sendData() {
        Object object = this.object;
        synchronized (object) {
            if (this.dataList.size() > 0) {
                return this.dataList.remove(0);
            }
            try {
                this.object.wait();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void startSendThread() {
        this.dataList.clear();
        this.recoverDataList.clear();
        this.bSendFlag = true;
        if (null == this.sendThread) {
            this.sendThread = new Thread((Runnable)this, TAG);
            this.sendThread.start();
        }
    }

    protected void releaseSendThread() {
        if (null != this.sendThread) {
            this.bSendFlag = false;
            try {
                this.sendThread.interrupt();
                this.sendThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.sendThread = null;
        }
    }

    public void setCameraPreviewFpsRange(Camera.Parameters paramParameters, int paramInt1, int paramInt2) {
        int j = 0;
        int i = 0;
        List localList = paramParameters.getSupportedPreviewFpsRange();
        Iterator localIterator = localList.iterator();
        while (true) {
            if (!localIterator.hasNext()) {
                Log.e((String)"MediaCamera", (String)("choose camera preview fps is min " + j + "  max  " + i + " input min:" + paramInt1 + "input max:" + paramInt2));
                if (localList.size() == 1) {
                    if (j >= paramInt1 || i <= paramInt2) break;
                    paramParameters.setPreviewFpsRange(paramInt1, paramInt2);
                }
                return;
            }
            int[] arrayOfInt = (int[])localIterator.next();
            Log.e((String)"MediaCamera", (String)("camera preview fps is min " + arrayOfInt[0] + "  max  " + arrayOfInt[1]));
            int k = j;
            if (j == 0) {
                k = arrayOfInt[0];
            }
            int n = i;
            if (i == 0) {
                n = arrayOfInt[1];
            }
            int m = k;
            if (k < 15000) {
                m = k;
                if (arrayOfInt[0] >= 15000) {
                    m = arrayOfInt[0];
                }
            }
            i = n;
            j = m;
            if (n < 15000) continue;
            i = n;
            j = m;
            if (arrayOfInt[1] >= n) continue;
            i = arrayOfInt[1];
            j = m;
        }
        GenseeLog.i((String)TAG, (String)("setCameraPreviewFpsRange min = " + j + " max = " + 24000));
        paramParameters.setPreviewFpsRange(j, 24000);
    }

    public void release() {
        this.setVideoCoreInterface(null);
        this.dataCallback = null;
    }

    public void setVideoCore(IVideoCoreInterface videoCoreInterface) {
        this.iVideoCoreInterface = videoCoreInterface;
        if (this.iVideoCoreInterface != null) {
            this.iVideoCoreInterface.setVideoSize(this.captureCallBack.getContext(), this.mWidth, this.mHeight);
        }
    }

    public void setBitRate(int bitRate) {
        GenseeLog.d((String)TAG, (String)("setBitRate bitRate = " + bitRate + " encoder = " + this.mVideoHardEncoded));
        this.mBitRate = bitRate;
        if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.setBitRate(bitRate);
        }
    }

    public void setFps(int fps) {
        GenseeLog.d((String)TAG, (String)("setFps fps = " + fps + " encoder = " + this.mVideoHardEncoded));
        this.mFps = fps;
        if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.setFps(fps);
        }
    }

    public void setHardEncodeDataCallback(OnVideoHardEncodeDataCallback callback) {
        this.dataCallback = callback;
        if (this.mVideoHardEncoded != null) {
            this.mVideoHardEncoded.setHardEncodeDataCallback(callback);
        }
    }

    protected boolean doCameraOpen() {
        return false;
    }

    protected void rePreView() {
    }

    public void setOnCameraPermissionListener(ILocalVideoView.OnCameraPermissionListener onCameraPermissionListener) {
        this.onCameraPermissionListener = onCameraPermissionListener;
    }

    public void setOnCameraInfoListener(ILocalVideoView.OnCameraInfoListener onCameraInfoListener) {
        this.onCameraInfoListener = onCameraInfoListener;
        if (onCameraInfoListener != null && this.mWidth > 0 && this.mHeight > 0) {
            onCameraInfoListener.onPreviewSize(this.mWidth, this.mHeight);
        }
    }

    public void setOrientation(int ortation) {
        GenseeLog.d((String)TAG, (String)("setOrientation ortation = " + ortation));
        if (ortation != 1 && ortation != 2 && ortation != 10 && ortation != 12 && ortation != 11 && ortation != 13) {
            return;
        }
        this.orientation = ortation;
    }

    public boolean isHolderCreated() {
        return this.captureCallBack != null && this.captureCallBack.isHolderCreated();
    }

    protected void notifyPreviewSize() {
        if (this.onCameraInfoListener != null) {
            if (this.orientation == 2) {
                this.onCameraInfoListener.onPreviewSize(this.mWidth, this.mHeight);
            } else {
                this.onCameraInfoListener.onPreviewSize(this.mHeight, this.mWidth);
            }
        }
    }

    public Matrix getConfigureMatrix(int mViewWidth, int mViewHeight) {
        GenseeLog.d((String)TAG, (String)"LocalTextureVideoView getConfigureMatrix 1");
        if (null != this.captureCallBack && null != this.captureCallBack.getContext()) {
            GenseeLog.d((String)TAG, (String)"LocalTextureVideoView getConfigureMatrix 2");
            int rotation = ((Activity)this.captureCallBack.getContext()).getWindowManager().getDefaultDisplay().getRotation();
            Matrix matrix = new Matrix();
            RectF viewRect = new RectF(0.0f, 0.0f, (float)mViewWidth, (float)mViewHeight);
            RectF bufferRect = new RectF(0.0f, 0.0f, (float)this.mHeight, (float)this.mWidth);
            float centerX = viewRect.centerX();
            float centerY = viewRect.centerY();
            GenseeLog.d((String)TAG, (String)("LocalTextureVideoView getConfigureMatrix mViewWidth = " + mViewWidth + " mViewHeight = " + mViewHeight + " rotation = " + rotation));
            if (1 == rotation || 3 == rotation) {
                bufferRect.offset(centerX - bufferRect.centerX(), centerY - bufferRect.centerY());
                matrix.setRectToRect(viewRect, bufferRect, Matrix.ScaleToFit.FILL);
                float scale = Math.max((float)mViewHeight / (float)this.mHeight, (float)mViewWidth / (float)this.mWidth);
                matrix.postScale(scale, scale, centerX, centerY);
                matrix.postRotate((float)(90 * (rotation - 2)), centerX, centerY);
            }
            return matrix;
        }
        return null;
    }

    public static boolean isUseCamera2() {
        return false;
    }

    protected class VideoData {
        private byte[] data;
        private int width;
        private int height;

        public VideoData(byte[] data, int width, int height) {
            this.data = data;
            this.width = width;
            this.height = height;
        }

        public byte[] getData() {
            return this.data;
        }

        public void setData(byte[] data) {
            this.data = data;
        }

        public int getWidth() {
            return this.width;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        public int getHeight() {
            return this.height;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public String toString() {
            return "VideoData [data=" + Arrays.toString(this.data) + ", width=" + this.width + ", height=" + this.height + "]";
        }

        public boolean isValidData() {
            return this.data != null && this.data.length > 0 && this.width > 0 && this.height > 0;
        }
    }

    public static interface OnCaptureCallBack {
        public boolean onSetPreviewHolder(Camera var1) throws IOException;

        public boolean isHolderCreated();

        public Context getContext();

        public SurfaceTexture getSurfaceTexTure();
    }
}

