/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.download;

import com.gensee.download.VodDownLoadCallback;
import com.gensee.download.VodDownLoadStatus;
import com.gensee.utils.GenseeLog;

public class VodDownLoadImpl {
    private static final int DS_DENY = 0;
    private static final int DS_BEGIN = 1;
    private static final int DS_FINISH = 2;
    private static final int DS_FAILED = 3;
    private static final int DS_FAILED_WRITE = 4;
    private static final int DS_ERROR_LICENSE = 12;
    private VodDownLoadCallback vodDownLoadCallback;
    private VodDownLoadImplInterface vodDownLoadImplInterface;

    public VodDownLoadImpl(VodDownLoadCallback vodDownLoadCallback, VodDownLoadImplInterface vodDownLoadImplInterface) {
        this.vodDownLoadCallback = vodDownLoadCallback;
        this.vodDownLoadImplInterface = vodDownLoadImplInterface;
    }

    public synchronized void onBegin(String downLoadId) {
        this.vodDownLoadCallback.onDLPrepare(downLoadId);
    }

    public synchronized void OnStatus(String downLoadId, int downLoadStatus) {
        GenseeLog.i((String)("VodDownLoadImpl OnStatus downLoadId = " + downLoadId + " downLoadStatus = " + downLoadStatus));
        if (downLoadStatus == this.vodDownLoadImplInterface.getVodDownLoadStatusByDlId(downLoadId)) {
            GenseeLog.w((String)("OnStatus downLoadId = " + downLoadId + " downLoadStatus = " + downLoadStatus));
            return;
        }
        if (downLoadStatus == 0) {
            this.vodDownLoadImplInterface.updateVodDownLoadStatus(downLoadId, VodDownLoadStatus.DENY.getStatus());
            this.vodDownLoadImplInterface.releaseDownloading();
            this.vodDownLoadImplInterface.nextVodDownloading();
        } else if (downLoadStatus == 1) {
            this.vodDownLoadImplInterface.updateVodDownLoadStatus(downLoadId, VodDownLoadStatus.BEGIN.getStatus());
            this.vodDownLoadCallback.onDLStart(downLoadId);
        } else if (downLoadStatus == 2) {
            this.vodDownLoadImplInterface.updateVodDownLoadStatus(downLoadId, VodDownLoadStatus.FINISH.getStatus());
            this.vodDownLoadCallback.onDLFinish(downLoadId);
            this.vodDownLoadImplInterface.releaseDownloading();
            this.vodDownLoadImplInterface.nextVodDownloading();
        } else if (downLoadStatus == 3) {
            this.vodDownLoadImplInterface.updateVodDownLoadStatus(downLoadId, VodDownLoadStatus.STOP.getStatus());
            this.vodDownLoadImplInterface.updateVodDownLoadStopStatus(downLoadId, 2);
            this.vodDownLoadCallback.onDLError(downLoadId, 7);
            this.vodDownLoadImplInterface.releaseDownloading();
            this.vodDownLoadImplInterface.nextVodDownloading();
        } else if (downLoadStatus == 12) {
            this.vodDownLoadImplInterface.updateVodDownLoadStatus(downLoadId, VodDownLoadStatus.STOP.getStatus());
            this.vodDownLoadImplInterface.releaseDownloading();
            this.vodDownLoadCallback.onDLError(downLoadId, 12);
        } else if (downLoadStatus == 4) {
            this.vodDownLoadImplInterface.updateVodDownLoadStatus(downLoadId, VodDownLoadStatus.STOP.getStatus());
            this.vodDownLoadImplInterface.releaseDownloading();
            this.vodDownLoadCallback.onDLError(downLoadId, 9);
        }
    }

    public void onStop(String downLoadId, int downLoadStatus) {
        this.vodDownLoadImplInterface.updateVodDownLoadStatus(downLoadId, downLoadStatus);
        this.vodDownLoadCallback.onDLStop(downLoadId);
        this.vodDownLoadImplInterface.releaseDownloading();
        this.vodDownLoadImplInterface.nextVodDownloading();
    }

    public void OnProcess(String downLoadId, int nPercent) {
        this.vodDownLoadImplInterface.updateVodDownLoadProgress(downLoadId, nPercent);
        if (null != this.vodDownLoadCallback) {
            this.vodDownLoadCallback.onDLPosition(downLoadId, nPercent);
        }
    }

    public static interface VodDownLoadImplInterface {
        public void nextVodDownloading();

        public void updateVodDownLoadStatus(String var1, int var2);

        public void updateVodDownLoadStopStatus(String var1, int var2);

        public void updateVodDownLoadProgress(String var1, int var2);

        public void stopDownLoading(String var1);

        public int getVodDownLoadStatusByDlId(String var1);

        public void releaseDownloading();
    }
}

