/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.download;

import android.content.Context;
import com.gensee.common.PlayerWork;
import com.gensee.download.IDownloadCallback;
import com.gensee.download.VodDownLoad;
import com.gensee.download.VodDownLoadCallback;
import com.gensee.download.VodDownLoadEntity;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import java.util.List;

public class VodDownLoader
extends PlayerWork
implements VodDownLoadCallback {
    private static final String TAG = "VodDownLoader";
    private static VodDownLoader downLoader;
    private VodDownLoad mDownLoad;
    private OnDownloadListener mListener;

    private VodDownLoader(Context context, String UUID, OnDownloadListener downloadListener, String fileDir) {
        this.mListener = downloadListener;
        this.mDownLoad = VodDownLoad.initVodDownLoad(context, UUID, this, fileDir);
    }

    public static VodDownLoader instance(Context context, OnDownloadListener downloadCallback, String fileDir) {
        return VodDownLoader.instance(context, "0", downloadCallback, fileDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VodDownLoader instance(Context context, String UUID, OnDownloadListener downloadListener, String fileDir) {
        Class<VodDownLoad> clazz = VodDownLoad.class;
        synchronized (VodDownLoad.class) {
            if (null == downLoader) {
                if (null == UUID || "".equals(UUID)) {
                    UUID = "0";
                }
                downLoader = new VodDownLoader(context, UUID, downloadListener, fileDir);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return downLoader;
        }
    }

    public void setAutoDownloadNext(boolean isAuto) {
        this.mDownLoad.setAutoDownloadNext(isAuto);
    }

    public void delete(String vodId) {
        GenseeLog.d((String)TAG, (String)("delete vodId = " + vodId));
        this.mDownLoad.delete(vodId);
    }

    public void delete(List<String> vodIds) {
        this.mDownLoad.delete(vodIds);
    }

    public void download() {
        GenseeLog.d((String)TAG, (String)"download autoStart");
        this.mDownLoad.autoStart();
    }

    public int download(String vodId) {
        GenseeLog.d((String)TAG, (String)("download vodId = " + vodId));
        return this.mDownLoad.download(vodId);
    }

    public void stop(String vodId) {
        GenseeLog.d((String)TAG, (String)("stop vodId = " + vodId));
        this.mDownLoad.setStopStatus(vodId, 1);
        this.mDownLoad.stop(vodId);
    }

    public List<VodDownLoadEntity> getDownloadList() {
        return this.mDownLoad.getVdlList();
    }

    public void release() {
        GenseeLog.d((String)TAG, (String)"release");
        VodDownLoad.releaseVodDownLoad();
        this.mDownLoad = null;
        downLoader = null;
    }

    public VodDownLoadEntity getDownload(String vodId) {
        GenseeLog.d((String)TAG, (String)("getDownload vodId = " + vodId));
        if (!StringUtil.isEmpty((String)vodId) && this.mDownLoad != null) {
            return this.mDownLoad.getVdlByDlId(vodId);
        }
        return null;
    }

    @Override
    public void onDLPrepare(String vodId) {
        if (this.mListener != null) {
            this.mListener.onDLPrepare(vodId);
        }
    }

    @Override
    public void onDLPosition(String downLoadId, int percent) {
        if (this.mListener != null) {
            this.mListener.onDLPosition(downLoadId, percent);
        }
    }

    @Override
    public void onDLStart(String downLoadId) {
        if (this.mListener != null) {
            this.mListener.onDLStart(downLoadId);
        }
    }

    @Override
    public void onDLStop(String vodId) {
        if (this.mListener != null) {
            this.mListener.onDLStop(vodId);
        }
    }

    @Override
    public void onDLError(String vodId, int errorCode) {
        if (this.mListener != null) {
            this.mListener.onDLError(vodId, errorCode);
        }
    }

    @Override
    public void onDLFinish(String vodId) {
        if (this.mListener != null) {
            this.mListener.onDLFinish(vodId, this.mDownLoad.getPlayUrl(vodId));
        }
    }

    public static interface OnDownloadListener
    extends IDownloadCallback {
        public void onDLFinish(String var1, String var2);
    }
}

