/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.download.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import com.gensee.download.VodDownLoadEntity;
import com.gensee.download.db.VodDataBaseHelper;
import java.util.ArrayList;
import java.util.List;

public class VodDataBaseManager {
    private VodDataBaseHelper dataBaseHelper;

    public VodDataBaseManager(Context context) {
        this.dataBaseHelper = new VodDataBaseHelper(context.getApplicationContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(VodDownLoadEntity entity) {
        try (SQLiteDatabase mDatabase = this.dataBaseHelper.getWritableDatabase();){
            ContentValues values = this._insert(entity);
            mDatabase.insert("table_vod_download", null, values);
        }
    }

    private ContentValues _insert(VodDownLoadEntity entity) {
        ContentValues values = new ContentValues();
        values.put("colDownLOADID", entity.getDownLoadId());
        values.put("colDownLoadURL", entity.getDownLoadUrl());
        values.put("colLength", Long.valueOf(entity.getnLength()));
        values.put("colPercent", Integer.valueOf(entity.getnPercent()));
        values.put("colReserved1", Integer.valueOf(entity.getnReserved1()));
        values.put("colReserved2", Integer.valueOf(entity.getnReserved2()));
        values.put("colReserved3", entity.getsReserved3());
        values.put("colReserved4", entity.getsReserved4());
        values.put("colStatus", Integer.valueOf(entity.getnStatus()));
        values.put("colStopStatus", Integer.valueOf(entity.getnStopStatus()));
        values.put("colUUID", entity.getUUID());
        values.put("colAddTime", entity.getsAddTime());
        values.put("colSubejct", entity.getVodSubject());
        values.put("colSiteId", Long.valueOf(entity.getSiteId()));
        values.put("colConnectSvr", entity.getConnectSvr());
        values.put("colNickName", entity.getNickName());
        values.put("colUserId", Long.valueOf(entity.getUserId()));
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertValues(List<VodDownLoadEntity> vodDownLoadList) {
        SQLiteDatabase mDatabase = this.dataBaseHelper.getWritableDatabase();
        try {
            mDatabase.beginTransaction();
            for (int i = 0; i < vodDownLoadList.size(); ++i) {
                VodDownLoadEntity entity = vodDownLoadList.get(i);
                ContentValues values = this._insert(entity);
                mDatabase.insert("table_vod_download", null, values);
            }
            mDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            mDatabase.endTransaction();
            mDatabase.close();
        }
    }

    private VodDownLoadEntity dataToObject(Cursor cursor) {
        VodDownLoadEntity vodEntity = new VodDownLoadEntity();
        vodEntity.setDownLoadId(cursor.getString(cursor.getColumnIndex("colDownLOADID")));
        vodEntity.setDownLoadUrl(cursor.getString(cursor.getColumnIndex("colDownLoadURL")));
        vodEntity.setnLength(cursor.getLong(cursor.getColumnIndex("colLength")));
        vodEntity.setnPercent(cursor.getInt(cursor.getColumnIndex("colPercent")));
        vodEntity.setnReserved1(cursor.getInt(cursor.getColumnIndex("colReserved1")));
        vodEntity.setnReserved2(cursor.getInt(cursor.getColumnIndex("colReserved2")));
        vodEntity.setnStatus(cursor.getInt(cursor.getColumnIndex("colStatus")));
        vodEntity.setnStopStatus(cursor.getInt(cursor.getColumnIndex("colStopStatus")));
        vodEntity.setsReserved3(cursor.getString(cursor.getColumnIndex("colReserved3")));
        vodEntity.setsReserved4(cursor.getString(cursor.getColumnIndex("colReserved4")));
        vodEntity.setUUID(cursor.getString(cursor.getColumnIndex("colUUID")));
        vodEntity.setVodSubject(cursor.getString(cursor.getColumnIndex("colSubejct")));
        vodEntity.setSiteId(cursor.getLong(cursor.getColumnIndex("colSiteId")));
        vodEntity.setUserId(cursor.getLong(cursor.getColumnIndex("colUserId")));
        vodEntity.setNickName(cursor.getString(cursor.getColumnIndex("colNickName")));
        vodEntity.setConnectSvr(cursor.getString(cursor.getColumnIndex("colConnectSvr")));
        return vodEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<VodDownLoadEntity> queryByUUID(String UUID) {
        SQLiteDatabase mDatabase = this.dataBaseHelper.getReadableDatabase();
        Cursor cursor = null;
        ArrayList<VodDownLoadEntity> downFileList = new ArrayList<VodDownLoadEntity>();
        try {
            String sql = "";
            sql = "select * from table_vod_download where colUUID=? order by colAddTime";
            cursor = mDatabase.rawQuery(sql, new String[]{UUID});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                VodDownLoadEntity entity = this.dataToObject(cursor);
                downFileList.add(entity);
                cursor.moveToNext();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
            mDatabase.close();
        }
        return downFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VodDownLoadEntity queryByDownLoadId(String UUID, String downLoadId) {
        SQLiteDatabase mDatabase = this.dataBaseHelper.getReadableDatabase();
        Cursor cursor = null;
        VodDownLoadEntity localDownFile = null;
        try {
            String sql = "";
            sql = "select * from table_vod_download where colUUID=? and colDownLOADID=? order by colAddTime limit ?";
            cursor = mDatabase.rawQuery(sql, new String[]{UUID, downLoadId, "1"});
            cursor.moveToFirst();
            while (!cursor.isAfterLast()) {
                localDownFile = this.dataToObject(cursor);
                cursor.moveToNext();
            }
        }
        finally {
            if (null != cursor) {
                cursor.close();
            }
            mDatabase.close();
        }
        return localDownFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeByUUID(String UUID) {
        Integer nReturnValue = 0;
        try (SQLiteDatabase mDatabase = this.dataBaseHelper.getWritableDatabase();){
            String sCondition = "colUUID=?";
            nReturnValue = mDatabase.delete("table_vod_download", sCondition, new String[]{UUID});
        }
        return nReturnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByDownLoadIds(String UUID, List<String> downLoadIds) {
        SQLiteDatabase mDatabase = this.dataBaseHelper.getWritableDatabase();
        try {
            mDatabase.beginTransaction();
            for (String downLoadId : downLoadIds) {
                String sCondition = "colUUID=? and colDownLOADID=?";
                mDatabase.delete("table_vod_download", sCondition, new String[]{UUID, downLoadId});
            }
            mDatabase.setTransactionSuccessful();
        }
        finally {
            mDatabase.endTransaction();
            mDatabase.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeByDownLoadId(String UUID, String downLoadId) {
        try (SQLiteDatabase mDatabase = this.dataBaseHelper.getWritableDatabase();){
            String sCondition = "colUUID=? and colDownLOADID=?";
            mDatabase.delete("table_vod_download", sCondition, new String[]{UUID, downLoadId});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateByDownLoadId(VodDownLoadEntity localDownFile) {
        int updateId = -1;
        try (SQLiteDatabase mDatabase = this.dataBaseHelper.getWritableDatabase();){
            ContentValues cv = this._insert(localDownFile);
            String[] args = new String[]{localDownFile.getUUID(), localDownFile.getDownLoadId()};
            updateId = mDatabase.update("table_vod_download", cv, "colUUID=? and colDownLOADID=?", args);
        }
        return updateId;
    }
}

