/*
 * Decompiled with CFR 0.152.
 */
package com.gensee.media;

import android.os.Environment;
import com.gensee.common.GenseeConfig;
import com.gensee.entity.BroadCastMsg;
import com.gensee.entity.ChatMsg;
import com.gensee.entity.DocInfo;
import com.gensee.entity.VodObject;
import com.gensee.entity.VodParam;
import com.gensee.entity.VodPlayParam;
import com.gensee.media.AbsPlayer;
import com.gensee.media.IOLPlayerCallback;
import com.gensee.media.PlaySpeed;
import com.gensee.parse.VodBroadCastParse;
import com.gensee.parse.VodChatParse;
import com.gensee.taskret.IGSTask;
import com.gensee.taskret.OnTaskRet;
import com.gensee.utils.GenseeLog;
import com.gensee.utils.StringUtil;
import com.gensee.view.GSVideoView;
import com.gensee.vod.VodMr;
import com.gensee.vod.VodSite;
import java.io.File;
import java.util.Arrays;
import java.util.List;

public class GSOLPlayer
extends AbsPlayer
implements IOLPlayerCallback {
    private static final String TAG = "GSOLPlayer";
    public static final String CATCH_DEF_DIR = Environment.getExternalStorageDirectory().getAbsolutePath() + "/GSVod/online/catch/";
    private static final byte S_ONLINE_PLAY = 1;
    protected static long nativePlayer;
    private OnOLPlayListener mListener;
    private String filePath;
    private boolean isVideoStart = false;
    private boolean isAudioStart = false;
    private byte status = 0;
    private int lastTms = -1;
    private PlaySpeed playSpeed = PlaySpeed.SPEED_NORMAL;

    public GSOLPlayer() {
    }

    private GSOLPlayer(long nativePlayer) {
        GSOLPlayer.nativePlayer = nativePlayer;
    }

    public GSOLPlayer(String filePath, OnOLPlayListener listener) {
        this();
        this.filePath = filePath;
        this.mListener = listener;
    }

    public boolean playOffline(String filePath, OnOLPlayListener listener) {
        return this.play(filePath, listener, "", "", "", false);
    }

    public boolean playOnline(VodPlayParam playParam, OnOLPlayListener listener, String cachDir, boolean isAudioOnly, boolean isFlv) {
        if (playParam instanceof VodParam) {
            VodParam param = (VodParam)playParam;
            String path = param.getXmlUrl();
            String vodId = param.getVodId();
            String tid = param.getTid();
            if (path == null || vodId == null || tid == null) {
                GenseeLog.w((String)("path = " + path + ",vodId = " + vodId + ",tid = " + tid));
                return false;
            }
            long siteId = this.getLongValue(param.getSiteId());
            long userId = this.getLongValue(param.getUserId());
            String alb = StringUtil.getHttpAlbAddr((String)param.getConnectSvr());
            String port = param.getAlbPort();
            if (port != null && !"".equals(port)) {
                alb = alb + ":" + port;
            }
            String clientApiUrl = VodMr.getClientApiUrl((VodObject)playParam);
            return this.play(siteId, userId, param.getNickName(), alb, path, listener, vodId, tid, cachDir, clientApiUrl, param.getHostId(), isAudioOnly, param.getCdnList(), isFlv);
        }
        return false;
    }

    public boolean play(String vodIdOrLocaPath, OnOLPlayListener listener, String cacheDir, boolean isAudioOnly) {
        GenseeLog.d((String)TAG, (String)("play vodIdOrLocaPath = " + vodIdOrLocaPath + " isAudioOnly = " + isAudioOnly));
        if (vodIdOrLocaPath == null || "".equals(vodIdOrLocaPath)) {
            if (listener != null) {
                listener.onError(6);
            }
            return false;
        }
        if (!vodIdOrLocaPath.endsWith(".xml")) {
            VodObject object = VodMr.getIns().getVodObjById(vodIdOrLocaPath);
            if (object != null) {
                boolean ret = this.playOnline((VodPlayParam)object, listener, cacheDir, isAudioOnly, GenseeConfig.isForceFlv);
                if (ret) {
                    this.status = (byte)(this.status | 1);
                }
                return ret;
            }
            if (listener != null) {
                listener.onError(-201);
            }
            return false;
        }
        this.play(vodIdOrLocaPath, listener, "", "", "", isAudioOnly);
        return true;
    }

    private boolean isOnLinePlay() {
        return (this.status & 1) == 1;
    }

    public boolean play(String filePath, OnOLPlayListener listener, String vodId, String tid, String cachDir, boolean isAudioOnly) {
        return this.play(0L, 0L, "", "", filePath, listener, vodId, tid, cachDir, "", 0L, isAudioOnly, "", false);
    }

    private boolean play(final long siteId, final long userId, final String nickName, final String albAddr, final String filePath, OnOLPlayListener listener, final String vodId, final String tid, final String cachDir, final String clientApi, final long hostId, final boolean isAudioOnly, final String cdnList, final boolean isFlv) {
        this.mListener = listener;
        this.isVideoStart = false;
        this.isAudioStart = false;
        this.filePath = filePath;
        this.lastTms = -1;
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                String strDir = null;
                if (this.isValidDir(cachDir)) {
                    strDir = cachDir;
                } else if (this.isValidDir(VodMr.getIns().getCachDir())) {
                    strDir = VodMr.getIns().getCachDir();
                } else {
                    strDir = CATCH_DEF_DIR;
                    File fCachDir = new File(strDir);
                    if (!fCachDir.exists()) {
                        boolean dirRet = fCachDir.mkdirs();
                        GenseeLog.d((String)GSOLPlayer.TAG, (String)("dir makes dirRet = " + dirRet));
                    }
                }
                if (0L == nativePlayer) {
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)("play player is 0,and will create, catch dir is " + strDir + " c-a-u = " + clientApi));
                    nativePlayer = GSOLPlayer.this.createOnlinePlayer(siteId, userId, nickName, albAddr, strDir, clientApi);
                }
                GenseeLog.d((String)GSOLPlayer.TAG, (String)("play player is  create " + nativePlayer));
                GSOLPlayer.this.startPlayer(nativePlayer, filePath, vodId, tid, hostId, isAudioOnly, cdnList, isFlv);
                return 0;
            }

            private boolean isValidDir(String path) {
                if (path == null || "".equals(path)) {
                    return false;
                }
                File f = new File(path);
                if (f.exists()) {
                    return true;
                }
                if (f.mkdirs()) {
                    return f.isDirectory();
                }
                return false;
            }
        });
    }

    private void startPlayer(long player, String filePath, String vodId, String tId, long hostId, boolean isAudioOnly, String cdnList, boolean isFlv) {
        int ret = -1;
        if (player != 0L) {
            this.initAudioPlayer();
            GenseeLog.d((String)TAG, (String)("startPlayer filePath = " + filePath + " vodId = " + vodId + " tId =  " + tId + " hostId = " + hostId + " list = " + cdnList));
            ret = this.nativePlay(player, filePath == null ? "" : filePath, this, false, vodId == null ? "" : vodId, tId == null ? "" : tId, hostId, isAudioOnly, cdnList == null ? "" : cdnList, isFlv);
        } else {
            GenseeLog.w((String)"GSOLPlayer -> startPlayer player is 0");
        }
        if (0 != ret && null != this.mListener) {
            this.mListener.onError(1);
        }
    }

    public boolean pause() {
        GenseeLog.d((String)TAG, (String)("pause nativePlayer = " + nativePlayer));
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                long player = nativePlayer;
                int ret = -1;
                if (player != 0L) {
                    ret = GSOLPlayer.this.nativePause(player);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)"pause nativePause()");
                }
                GSOLPlayer.this.audioPause();
                if (GSOLPlayer.this.mListener != null) {
                    if (0 != ret) {
                        GSOLPlayer.this.mListener.onError(2);
                    } else {
                        GSOLPlayer.this.mListener.onPlayPause();
                    }
                }
                return 0;
            }
        });
    }

    public boolean resume() {
        this.audioResume();
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = GSOLPlayer.this.nativeResume(player);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)"resume nativeResume");
                }
                if (GSOLPlayer.this.mListener != null) {
                    if (0 != ret) {
                        GSOLPlayer.this.mListener.onError(3);
                    } else {
                        GSOLPlayer.this.mListener.onPlayResume();
                    }
                }
                return 0;
            }
        });
    }

    public boolean stop() {
        this.audioStop();
        GenseeLog.d((String)TAG, (String)"stop");
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                long player = nativePlayer;
                if (player != 0L) {
                    ret = GSOLPlayer.this.nativeStop(player);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)("stop ret = " + ret));
                }
                GSOLPlayer.this.isVideoStart = false;
                GSOLPlayer.this.status = (byte)0;
                GSOLPlayer.this.playSpeed = PlaySpeed.SPEED_NORMAL;
                if (null != GSOLPlayer.this.mListener && 0 != ret) {
                    GSOLPlayer.this.mListener.onError(4);
                }
                return 0;
            }
        });
    }

    public boolean seekTo(final int position) {
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                GSOLPlayer.this.audioQueueClear();
                long player = nativePlayer;
                int ret = -1;
                if (player != 0L) {
                    ret = GSOLPlayer.this.seek(player, position);
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)("seekTo position = " + position + " ret = " + ret));
                    if (ret == 0) {
                        GSOLPlayer.this.audioAndAppResume();
                        GSOLPlayer.this.lastTms = position / 1000;
                    } else if (null != GSOLPlayer.this.mListener) {
                        GSOLPlayer.this.mListener.onError(5);
                    }
                } else {
                    GenseeLog.w((String)GSOLPlayer.TAG, (String)("player is 0 seekTo position = " + position));
                }
                return 0;
            }
        });
    }

    public boolean setSpeed(final PlaySpeed speed, final OnTaskRet ret) {
        if (speed == null) {
            GenseeLog.w((String)TAG, (String)("setSpeed speed = " + (Object)((Object)speed)));
            return false;
        }
        this.playSpeed = speed;
        if (nativePlayer == 0L) {
            GenseeLog.w((String)TAG, (String)"setSpeed player un init");
            return true;
        }
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                GSOLPlayer.this.audioQueueClear();
                int result = -1;
                if (nativePlayer != 0L) {
                    result = GSOLPlayer.this.setSpeed(nativePlayer, speed.getValue());
                }
                if (ret != null) {
                    ret.onTaskRet(result == 0, 0, "setSpeed");
                }
                return 0;
            }
        });
    }

    public boolean videoSet(final boolean isClose, final OnTaskRet taskRet) {
        if (nativePlayer == 0L) {
            GenseeLog.w((String)TAG, (String)"videoSet nativePlayer = 0");
            return false;
        }
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                int ret = -1;
                if (nativePlayer != 0L) {
                    ret = GSOLPlayer.this.closeVideo(nativePlayer, isClose);
                }
                if (taskRet != null) {
                    taskRet.onTaskRet(ret == 0, 0, "videoSet");
                }
                return 0;
            }
        });
    }

    public boolean release() {
        this.audioRelease();
        this.mListener = null;
        return GSOLPlayer.addTask((IGSTask)new IGSTask(){

            public int doTask() {
                long player = nativePlayer;
                if (player != 0L) {
                    GenseeLog.d((String)GSOLPlayer.TAG, (String)"release...");
                    if (GSOLPlayer.this.destroyOfflinePlayer(player) == 0) {
                        nativePlayer = 0L;
                        GenseeLog.d((String)GSOLPlayer.TAG, (String)"release end");
                    }
                }
                GSOLPlayer.this.playSpeed = PlaySpeed.SPEED_NORMAL;
                GSOLPlayer.this.isVideoStart = false;
                GSOLPlayer.this.isAudioStart = false;
                GSOLPlayer.this.status = (byte)0;
                GSOLPlayer.this.shutdownTreadPool();
                GSOLPlayer.super.release();
                return 0;
            }
        });
    }

    @Override
    public void onInit(int result, boolean haveVideo, int duration, DocInfo[] docs, int num, boolean isDocbySwf) {
        GenseeLog.d((String)TAG, (String)("onInit result = " + result + " hasVideo = " + haveVideo + " duration = " + duration + " docs = " + docs + " isDocbySwf = " + isDocbySwf));
        if (result == 0 && nativePlayer != 0L) {
            this.setSpeed(nativePlayer, this.playSpeed.getValue());
        } else {
            this.playSpeed = PlaySpeed.SPEED_NORMAL;
        }
        if (this.mListener != null) {
            if (result == 0) {
                this.mListener.onInit(result, haveVideo, duration, null == docs ? null : Arrays.asList(docs));
            } else {
                this.mListener.onError(result);
            }
        }
        if (null != this.mVideoView && this.mVideoView instanceof GSVideoView) {
            this.mVideoView.renderDefault();
        }
    }

    @Override
    public void onAudio(final int dwTimeStamp, byte[] data, int dwLen, final short nLevel) {
        this.audioDataPlay(data, dwLen);
        if (!this.isAudioStart) {
            this.isAudioStart = true;
            GenseeLog.d((String)TAG, (String)("onAudio first frame time = " + (System.currentTimeMillis() - VodSite.startTime)));
        }
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (GSOLPlayer.this.mListener != null) {
                    GSOLPlayer.this.mListener.onAudioLevel(nLevel);
                }
                GSOLPlayer.this.postionNotify(dwTimeStamp);
            }
        });
    }

    private void postionNotify(int dwTimeStamp) {
        int tmpTs = dwTimeStamp / 1000;
        if (this.lastTms != tmpTs) {
            int dlta = this.lastTms * 1000 - dwTimeStamp;
            if (dlta > 0 && dlta < 1000) {
                GenseeLog.w((String)("GSOLPlayer postionNotify dlta = " + dlta + " dwTimeStamp = " + dwTimeStamp + " lastTms = " + this.lastTms));
                return;
            }
            this.lastTms = tmpTs;
            if (this.mListener != null) {
                this.mListener.onPosition(dwTimeStamp);
            }
        }
    }

    @Override
    public void onVideo(final int dwTimeStamp, byte[] data, int dwLen) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GSOLPlayer.this.postionNotify(dwTimeStamp);
            }
        });
        this.renderVideo(data);
        if (!this.isVideoStart) {
            GenseeLog.d((String)TAG, (String)("onVideo first frame time = " + (System.currentTimeMillis() - VodSite.startTime)));
            this.isVideoStart = true;
            this.postPool(new Runnable(){

                @Override
                public void run() {
                    if (GSOLPlayer.this.mListener != null) {
                        GSOLPlayer.this.mListener.onVideoStart();
                    }
                }
            });
        }
    }

    @Override
    public void onVideoParam(int dwTimeStamp, int dwWidth, int dwHeight, boolean isReal) {
        GenseeLog.d((String)TAG, (String)("onVideoParam dwTimeStamp = " + dwTimeStamp + " dwHeight = " + dwHeight + " dwWidth = " + dwWidth + " real = " + isReal));
        this.setVideoSize(dwWidth, dwHeight, isReal);
        if (!isReal && this.mListener != null) {
            this.mListener.onVideoSize(dwTimeStamp, dwWidth, dwHeight);
        }
    }

    @Override
    public void onPage(int dwTimeStamp, byte[] data, int dwLen, int dwPageW, int dwPageH) {
        GenseeLog.d((String)TAG, (String)("onPage dwTimeStamp = " + dwTimeStamp + " dwLen = " + dwLen + " dwPageW = " + dwPageW + " dwPageH = " + dwPageH));
        if (this.mListener != null) {
            this.mListener.onPageSize(dwTimeStamp, dwPageW, dwPageH);
        }
        this.renderPage(data, dwLen, dwPageW, dwPageH);
    }

    @Override
    public void onPage(int dwTimeStamp, byte[] data, int dwLen, int dwPageW, int dwPageH, String sAnimationXml) {
        GenseeLog.d((String)TAG, (String)("onPage swf dwTimeStamp = " + dwTimeStamp + " dwLen = " + dwLen + " dwPageW = " + dwPageW + " dwPageH = " + dwPageH));
        if (this.mListener != null) {
            this.mListener.onPageSize(dwTimeStamp, dwPageW, dwPageH);
        }
        this.renderPage(data, dwLen, dwPageW, dwPageH, sAnimationXml);
    }

    @Override
    public void onAnimation(int nStep) {
        this.renderPageAnimation(nStep);
    }

    @Override
    public void onAnnotaion(int dwTimeStamp, final String strAnnoXML) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                GSOLPlayer.this.renderAnno(strAnnoXML);
            }
        });
    }

    @Override
    public void onSeek(int dwTimeStamp) {
        GenseeLog.d((String)TAG, (String)("onSeek dwTimeStamp = " + dwTimeStamp));
        if (this.mListener != null) {
            this.mListener.onSeek(dwTimeStamp);
        }
    }

    @Override
    public void onStop() {
        GenseeLog.d((String)TAG, (String)"onStop ");
        this.status = 0;
        this.playSpeed = PlaySpeed.SPEED_NORMAL;
        this.audioStop();
        if (this.mListener != null) {
            this.mListener.onPlayStop();
        }
    }

    @Override
    public void onBuffer(boolean isCaching) {
        GenseeLog.d((String)TAG, (String)("onBuffer isCaching = " + isCaching));
        if (this.mListener != null) {
            this.mListener.onCaching(isCaching);
        }
    }

    private void audioAndAppResume() {
        this.audioResume();
        if (this.mListener != null) {
            this.mListener.onPlayResume();
        }
    }

    @Override
    public void onChat(final String chatXml) {
        GenseeLog.d((String)TAG, (String)"onChat");
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnOLPlayListener l = GSOLPlayer.this.mListener;
                if (l != null) {
                    ChatMsg msg;
                    VodChatParse p = new VodChatParse();
                    p.parse(chatXml);
                    String type = p.getXmlType();
                    if ("chat".equals(type)) {
                        l.onChat(p.getChatMsgs());
                    } else if ("chatcensor".equals(type) && (msg = p.getCensor()) != null) {
                        l.onChatCensor(msg.getCensorType(), msg.getId());
                    }
                }
            }
        });
    }

    @Override
    public void onDocIndex(final DocInfo[] docs, int num) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                if (GSOLPlayer.this.mListener != null) {
                    GSOLPlayer.this.mListener.onDocInfo(null == docs ? null : Arrays.asList(docs));
                }
            }
        });
    }

    @Override
    public void onBroadCastMsg(final String broadCastXml) {
        this.postPool(new Runnable(){

            @Override
            public void run() {
                OnOLPlayListener l = GSOLPlayer.this.mListener;
                if (l != null) {
                    VodBroadCastParse p = new VodBroadCastParse();
                    p.parseXml(broadCastXml);
                    l.onBroadCastMsg(p.getMsgs());
                }
            }
        });
    }

    protected int onGetAudioQueueLen() {
        int nQueueLen = this.getAudioQueueLen();
        return nQueueLen;
    }

    protected void onRecordInfo(String startTime, String storage, String duration) {
        GenseeLog.d((String)TAG, (String)("onRecordInfo startTime = " + startTime + " storage = " + storage + " duration = " + duration));
    }

    private native long createOfflinePlayer();

    private native long createOnlinePlayer(long var1, long var3, String var5, String var6, String var7, String var8);

    private native int destroyOfflinePlayer(long var1);

    private native int nativePlay(long var1, String var3, IOLPlayerCallback var4, boolean var5, String var6, String var7, long var8, boolean var10, String var11, boolean var12);

    private native int nativePause(long var1);

    private native int nativeResume(long var1);

    private native int nativeStop(long var1);

    private native int seek(long var1, int var3);

    private native int setSpeed(long var1, int var3);

    private native int closeVideo(long var1, boolean var3);

    public static interface OnOLPlayListener {
        public static final String CHATCENSOR_MSG = "msg";
        public static final String CHATCENSOR_USER = "user";
        public static final int RESULT_OK = 0;
        public static final int RESULT_LICENSE = 12;
        public static final int RESULT_LOCAL_FILE_UNCOMPLETE = 10015;
        public static final int ERR_PLAY = 1;
        public static final int ERR_PAUSE = 2;
        public static final int ERR_RESUME = 3;
        public static final int ERR_STOP = 4;
        public static final int ERR_SEEK = 5;
        public static final int ERR_UN_INVOKE_GETOBJECT = -201;
        public static final int ERR_VODID_OR_LOCALPATH = 6;
        public static final int ERR_INIT_FAILURE = 7;

        public void onInit(int var1, boolean var2, int var3, List<DocInfo> var4);

        public void onPlayStop();

        public void onPlayPause();

        public void onPlayResume();

        public void onPosition(int var1);

        public void onVideoSize(int var1, int var2, int var3);

        public void onPageSize(int var1, int var2, int var3);

        public void onSeek(int var1);

        public void onAudioLevel(int var1);

        public void onCaching(boolean var1);

        public void onVideoStart();

        public void onChat(List<ChatMsg> var1);

        public void onDocInfo(List<DocInfo> var1);

        public void onChatCensor(String var1, String var2);

        public void onBroadCastMsg(List<BroadCastMsg> var1);

        public void onError(int var1);
    }
}

